/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.graphics.BlendMode;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.view.ActionProvider;
import android.view.ContextMenu;
import android.view.SubMenu;
import android.view.View;

public interface MenuItem {
    public static final int SHOW_AS_ACTION_NEVER = 0;
    public static final int SHOW_AS_ACTION_IF_ROOM = 1;
    public static final int SHOW_AS_ACTION_ALWAYS = 2;
    public static final int SHOW_AS_ACTION_WITH_TEXT = 4;
    public static final int SHOW_AS_ACTION_COLLAPSE_ACTION_VIEW = 8;

    public int getItemId();

    public int getGroupId();

    public int getOrder();

    @NonNull
    public MenuItem setTitle(@Nullable CharSequence var1);

    @NonNull
    public MenuItem setTitle(int var1);

    @Nullable
    public CharSequence getTitle();

    @NonNull
    public MenuItem setTitleCondensed(@Nullable CharSequence var1);

    @Nullable
    public CharSequence getTitleCondensed();

    @NonNull
    public MenuItem setIcon(@Nullable Drawable var1);

    @NonNull
    public MenuItem setIcon(int var1);

    @Nullable
    public Drawable getIcon();

    @NonNull
    default public MenuItem setIconTintList(@Nullable ColorStateList tint) {
        return this;
    }

    @Nullable
    default public ColorStateList getIconTintList() {
        return null;
    }

    @NonNull
    default public MenuItem setIconTintMode(@Nullable PorterDuff.Mode tintMode) {
        return this;
    }

    @NonNull
    default public MenuItem setIconTintBlendMode(@Nullable BlendMode blendMode) {
        PorterDuff.Mode mode = BlendMode.blendModeToPorterDuffMode(blendMode);
        if (mode != null) {
            return this.setIconTintMode(mode);
        }
        return this;
    }

    @Nullable
    default public PorterDuff.Mode getIconTintMode() {
        return null;
    }

    @Nullable
    default public BlendMode getIconTintBlendMode() {
        PorterDuff.Mode mode = this.getIconTintMode();
        if (mode != null) {
            return BlendMode.fromValue(mode.nativeInt);
        }
        return null;
    }

    @NonNull
    public MenuItem setIntent(@Nullable Intent var1);

    @Nullable
    public Intent getIntent();

    @NonNull
    public MenuItem setShortcut(char var1, char var2);

    @NonNull
    default public MenuItem setShortcut(char numericChar, char alphaChar, int numericModifiers, int alphaModifiers) {
        if ((alphaModifiers & 0x1100F) == 4096 && (numericModifiers & 0x1100F) == 4096) {
            return this.setShortcut(numericChar, alphaChar);
        }
        return this;
    }

    @NonNull
    public MenuItem setNumericShortcut(char var1);

    @NonNull
    default public MenuItem setNumericShortcut(char numericChar, int numericModifiers) {
        if ((numericModifiers & 0x1100F) == 4096) {
            return this.setNumericShortcut(numericChar);
        }
        return this;
    }

    public char getNumericShortcut();

    default public int getNumericModifiers() {
        return 4096;
    }

    @NonNull
    public MenuItem setAlphabeticShortcut(char var1);

    @NonNull
    default public MenuItem setAlphabeticShortcut(char alphaChar, int alphaModifiers) {
        if ((alphaModifiers & 0x1100F) == 4096) {
            return this.setAlphabeticShortcut(alphaChar);
        }
        return this;
    }

    public char getAlphabeticShortcut();

    default public int getAlphabeticModifiers() {
        return 4096;
    }

    @NonNull
    public MenuItem setCheckable(boolean var1);

    public boolean isCheckable();

    @NonNull
    public MenuItem setChecked(boolean var1);

    public boolean isChecked();

    @NonNull
    public MenuItem setVisible(boolean var1);

    public boolean isVisible();

    @NonNull
    public MenuItem setEnabled(boolean var1);

    public boolean isEnabled();

    public boolean hasSubMenu();

    @Nullable
    public SubMenu getSubMenu();

    @NonNull
    public MenuItem setOnMenuItemClickListener(@Nullable OnMenuItemClickListener var1);

    @Nullable
    public ContextMenu.ContextMenuInfo getMenuInfo();

    public void setShowAsAction(int var1);

    @NonNull
    public MenuItem setShowAsActionFlags(int var1);

    @NonNull
    public MenuItem setActionView(@Nullable View var1);

    @NonNull
    public MenuItem setActionView(int var1);

    @Nullable
    public View getActionView();

    @NonNull
    public MenuItem setActionProvider(@Nullable ActionProvider var1);

    @Nullable
    public ActionProvider getActionProvider();

    public boolean expandActionView();

    public boolean collapseActionView();

    public boolean isActionViewExpanded();

    @NonNull
    public MenuItem setOnActionExpandListener(@Nullable OnActionExpandListener var1);

    @NonNull
    default public MenuItem setContentDescription(@Nullable CharSequence contentDescription) {
        return this;
    }

    @Nullable
    default public CharSequence getContentDescription() {
        return null;
    }

    @NonNull
    default public MenuItem setTooltipText(@Nullable CharSequence tooltipText) {
        return this;
    }

    @Nullable
    default public CharSequence getTooltipText() {
        return null;
    }

    default public boolean requiresActionButton() {
        return false;
    }

    default public boolean requiresOverflow() {
        return true;
    }

    public static interface OnActionExpandListener {
        public boolean onMenuItemActionExpand(@NonNull MenuItem var1);

        public boolean onMenuItemActionCollapse(@NonNull MenuItem var1);
    }

    public static interface OnMenuItemClickListener {
        public boolean onMenuItemClick(@NonNull MenuItem var1);
    }
}

