/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class ListenerWrapper<T> {
    @NonNull
    private final Consumer<T> mConsumer;
    @NonNull
    private final Executor mExecutor;

    public ListenerWrapper(@NonNull Executor executor, @NonNull Consumer<T> consumer) {
        this.mExecutor = Objects.requireNonNull(executor);
        this.mConsumer = Objects.requireNonNull(consumer);
    }

    public void accept(@NonNull T value) {
        this.mExecutor.execute(() -> this.mConsumer.accept(value));
    }

    public boolean isConsumerSame(@NonNull Consumer<T> consumer) {
        return this.mConsumer.equals(consumer);
    }
}

