/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.view.ListenerWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class ListenerGroup<T> {
    private final List<ListenerWrapper<T>> mListeners = new ArrayList<ListenerWrapper<T>>();
    @NonNull
    private T mLastValue;

    public ListenerGroup(@NonNull T value) {
        this.mLastValue = value;
    }

    public void accept(@NonNull T value) {
        this.mLastValue = Objects.requireNonNull(value);
        for (int i = 0; i < this.mListeners.size(); ++i) {
            this.mListeners.get(i).accept(value);
        }
    }

    public void addListener(@NonNull Executor executor, @NonNull Consumer<T> consumer) {
        if (this.isConsumerPresent(consumer)) {
            return;
        }
        ListenerWrapper<T> listenerWrapper = new ListenerWrapper<T>(executor, consumer);
        this.mListeners.add(listenerWrapper);
        listenerWrapper.accept(this.mLastValue);
    }

    public void removeListener(@NonNull Consumer<T> consumer) {
        int index = this.computeIndex(consumer);
        if (index > -1) {
            this.mListeners.remove(index);
        }
    }

    public boolean isConsumerPresent(Consumer<T> consumer) {
        return this.computeIndex(consumer) > -1;
    }

    private int computeIndex(Consumer<T> consumer) {
        for (int i = 0; i < this.mListeners.size(); ++i) {
            if (!this.mListeners.get(i).isConsumerSame(consumer)) continue;
            return i;
        }
        return -1;
    }
}

