/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.Nullable;
import android.content.Context;
import android.graphics.Rect;
import android.os.Handler;
import android.view.GestureDetector;
import android.view.InputEvent;
import android.view.MotionEvent;
import com.android.internal.annotations.VisibleForTesting;
import com.android.layoutlib.androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class LetterboxScrollProcessor {
    @NonNull
    private LetterboxScrollState mState = LetterboxScrollState.AWAITING_GESTURE_START;
    @NonNull
    private final List<MotionEvent> mProcessedEvents = new ArrayList<MotionEvent>();
    @NonNull
    private final GestureDetector mScrollDetector;
    @NonNull
    private final Context mContext;
    private final Set<Integer> mGeneratedEventIds = new HashSet<Integer>();

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public LetterboxScrollProcessor(@NonNull Context context, @Nullable Handler handler) {
        this.mContext = context;
        this.mScrollDetector = new GestureDetector(context, new ScrollListener(), handler);
    }

    @Nullable
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public List<MotionEvent> processMotionEvent(@NonNull MotionEvent motionEvent) {
        if (!motionEvent.isFromSource(2)) {
            return null;
        }
        this.mProcessedEvents.clear();
        Rect appBounds = this.getAppBounds();
        if (motionEvent.getAction() == 0) {
            this.mState = this.isOutsideAppBounds(motionEvent, appBounds) ? LetterboxScrollState.GESTURE_STARTED_OUTSIDE_APP : LetterboxScrollState.GESTURE_STARTED_IN_APP;
        }
        boolean makeNoAdjustments = false;
        switch (this.mState.ordinal()) {
            case 0: 
            case 1: {
                makeNoAdjustments = true;
                break;
            }
            case 2: {
                this.applyOffset(motionEvent, appBounds);
                this.mScrollDetector.onTouchEvent(motionEvent);
                if (this.mState != LetterboxScrollState.SCROLLING_STARTED_OUTSIDE_APP) break;
                this.mProcessedEvents.add(motionEvent);
                break;
            }
            case 3: {
                if (this.isOutsideAppBounds(motionEvent, appBounds)) {
                    this.applyOffset(motionEvent, appBounds);
                } else {
                    this.mState = LetterboxScrollState.GESTURE_STARTED_IN_APP;
                }
                this.mProcessedEvents.add(motionEvent);
            }
        }
        if (motionEvent.getAction() == 1 || motionEvent.getAction() == 3) {
            this.mState = LetterboxScrollState.AWAITING_GESTURE_START;
        }
        return makeNoAdjustments ? null : this.mProcessedEvents;
    }

    @Nullable
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public InputEvent processMotionEventBeforeFinish(@NonNull MotionEvent motionEvent) {
        return this.mGeneratedEventIds.remove(motionEvent.getId()) ? null : motionEvent;
    }

    @NonNull
    private Rect getAppBounds() {
        return this.mContext.getResources().getConfiguration().windowConfiguration.getBounds();
    }

    private boolean isOutsideAppBounds(@NonNull MotionEvent motionEvent, @NonNull Rect appBounds) {
        return motionEvent.getRawX() < (float)appBounds.left || motionEvent.getRawX() >= (float)appBounds.right || motionEvent.getRawY() < (float)appBounds.top || motionEvent.getRawY() >= (float)appBounds.bottom;
    }

    private void applyOffset(@NonNull MotionEvent event, @NonNull Rect appBounds) {
        float horizontalOffset = this.calculateOffset(event.getX(), appBounds.width());
        float verticalOffset = this.calculateOffset(event.getY(), appBounds.height());
        event.offsetLocation(horizontalOffset, verticalOffset);
    }

    private float calculateOffset(float eventCoord, int appBoundary) {
        if (eventCoord < 0.0f) {
            return -eventCoord;
        }
        if (eventCoord >= (float)appBoundary) {
            return -(eventCoord - (float)appBoundary + 1.0f);
        }
        return 0.0f;
    }

    private static enum LetterboxScrollState {
        AWAITING_GESTURE_START,
        GESTURE_STARTED_IN_APP,
        GESTURE_STARTED_OUTSIDE_APP,
        SCROLLING_STARTED_OUTSIDE_APP;

    }

    private class ScrollListener
    extends GestureDetector.SimpleOnGestureListener {
        private ScrollListener() {
        }

        @Override
        public boolean onScroll(@Nullable MotionEvent actionDownEvent, @NonNull MotionEvent actionMoveEvent, float distanceX, float distanceY) {
            MotionEvent newActionDownEvent = MotionEvent.obtain(Objects.requireNonNull(actionDownEvent));
            Rect appBounds = LetterboxScrollProcessor.this.getAppBounds();
            LetterboxScrollProcessor.this.applyOffset(newActionDownEvent, appBounds);
            LetterboxScrollProcessor.this.mGeneratedEventIds.add(newActionDownEvent.getId());
            LetterboxScrollProcessor.this.mProcessedEvents.add(newActionDownEvent);
            LetterboxScrollProcessor.this.mState = LetterboxScrollState.SCROLLING_STARTED_OUTSIDE_APP;
            return super.onScroll(actionDownEvent, actionMoveEvent, distanceX, distanceY);
        }
    }
}

