/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Canvas;
import android.os.Handler;
import android.os.Message;
import android.os.StrictMode;
import android.os.Trace;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.util.Xml;
import android.view.ContextThemeWrapper;
import android.view.InflateException;
import android.view.LayoutInflater_Delegate;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewRootImpl;
import android.view.ViewStub;
import android.widget.FrameLayout;
import com.android.internal.R;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class LayoutInflater {
    private static final String TAG = LayoutInflater.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];
    @UnsupportedAppUsage(maxTargetSdk=28)
    protected final Context mContext;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private boolean mFactorySet;
    @UnsupportedAppUsage
    private Factory mFactory;
    @UnsupportedAppUsage
    private Factory2 mFactory2;
    @UnsupportedAppUsage
    private Factory2 mPrivateFactory;
    private Filter mFilter;
    @UnsupportedAppUsage(maxTargetSdk=28)
    final Object[] mConstructorArgs = new Object[2];
    @UnsupportedAppUsage
    static final Class<?>[] mConstructorSignature = new Class[]{Context.class, AttributeSet.class};
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=123769490L)
    private static final HashMap<String, Constructor<? extends View>> sConstructorMap = new HashMap();
    private HashMap<String, Boolean> mFilterMap;
    private TypedValue mTempValue;
    private static final String TAG_MERGE = "merge";
    private static final String TAG_INCLUDE = "include";
    private static final String TAG_1995 = "blink";
    private static final String TAG_REQUEST_FOCUS = "requestFocus";
    private static final String TAG_TAG = "tag";
    private static final String ATTR_LAYOUT = "layout";
    @UnsupportedAppUsage
    private static final int[] ATTRS_THEME = new int[]{0x1010000};
    private static final ClassLoader BOOT_CLASS_LOADER = LayoutInflater.class.getClassLoader();

    protected LayoutInflater(Context context) {
        StrictMode.assertConfigurationContext(context, "LayoutInflater");
        this.mContext = context;
    }

    protected LayoutInflater(LayoutInflater original, Context newContext) {
        StrictMode.assertConfigurationContext(newContext, "LayoutInflater");
        this.mContext = newContext;
        this.mFactory = original.mFactory;
        this.mFactory2 = original.mFactory2;
        this.mPrivateFactory = original.mPrivateFactory;
        this.setFilter(original.mFilter);
    }

    public static LayoutInflater from(Context context) {
        LayoutInflater LayoutInflater2 = (LayoutInflater)context.getSystemService("layout_inflater");
        if (LayoutInflater2 == null) {
            throw new AssertionError((Object)"LayoutInflater not found.");
        }
        return LayoutInflater2;
    }

    public abstract LayoutInflater cloneInContext(Context var1);

    public Context getContext() {
        return this.mContext;
    }

    public Factory getFactory() {
        return this.mFactory;
    }

    public Factory2 getFactory2() {
        return this.mFactory2;
    }

    public void setFactory(Factory factory) {
        if (this.mFactorySet) {
            throw new IllegalStateException("A factory has already been set on this LayoutInflater");
        }
        if (factory == null) {
            throw new NullPointerException("Given factory can not be null");
        }
        this.mFactorySet = true;
        this.mFactory = this.mFactory == null ? factory : new FactoryMerger(factory, null, this.mFactory, this.mFactory2);
    }

    public void setFactory2(Factory2 factory) {
        if (this.mFactorySet) {
            throw new IllegalStateException("A factory has already been set on this LayoutInflater");
        }
        if (factory == null) {
            throw new NullPointerException("Given factory can not be null");
        }
        this.mFactorySet = true;
        if (this.mFactory == null) {
            this.mFactory2 = factory;
            this.mFactory = this.mFactory2;
        } else {
            this.mFactory2 = new FactoryMerger(factory, factory, this.mFactory, this.mFactory2);
            this.mFactory = this.mFactory2;
        }
    }

    @UnsupportedAppUsage
    public void setPrivateFactory(Factory2 factory) {
        this.mPrivateFactory = this.mPrivateFactory == null ? factory : new FactoryMerger(factory, factory, this.mPrivateFactory, this.mPrivateFactory);
    }

    public Filter getFilter() {
        return this.mFilter;
    }

    public void setFilter(Filter filter) {
        this.mFilter = filter;
        if (filter != null) {
            this.mFilterMap = new HashMap();
        }
    }

    public View inflate(int resource, @Nullable ViewGroup root) {
        return this.inflate(resource, root, root != null);
    }

    public View inflate(XmlPullParser parser, @Nullable ViewGroup root) {
        return this.inflate(parser, root, root != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View inflate(int resource, @Nullable ViewGroup root, boolean attachToRoot) {
        Resources res = this.getContext().getResources();
        try (XmlResourceParser parser = res.getLayout(resource);){
            View view = this.inflate(parser, root, attachToRoot);
            return view;
        }
    }

    private void advanceToRootNode(XmlPullParser parser) throws InflateException, IOException, XmlPullParserException {
        int type;
        while ((type = parser.next()) != 2 && type != 1) {
        }
        if (type != 2) {
            throw new InflateException(parser.getPositionDescription() + ": No start tag found!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public View inflate(XmlPullParser parser, @Nullable ViewGroup root, boolean attachToRoot) {
        Object[] objectArray = this.mConstructorArgs;
        synchronized (this.mConstructorArgs) {
            ViewRootImpl viewRootImpl;
            Trace.traceBegin(8L, "inflate");
            Context inflaterContext = this.mContext;
            AttributeSet attrs = Xml.asAttributeSet(parser);
            Context lastContext = (Context)this.mConstructorArgs[0];
            this.mConstructorArgs[0] = inflaterContext;
            View result = root;
            ViewRootImpl viewRootImpl2 = viewRootImpl = root != null ? root.getViewRootImpl() : null;
            if (viewRootImpl != null) {
                viewRootImpl.notifyRendererOfExpensiveFrame();
            }
            try {
                this.advanceToRootNode(parser);
                String name = parser.getName();
                if (TAG_MERGE.equals(name)) {
                    if (root == null || !attachToRoot) {
                        throw new InflateException("<merge /> can be used only with a valid ViewGroup root and attachToRoot=true");
                    }
                    this.rInflate(parser, root, inflaterContext, attrs, false);
                } else {
                    View temp = this.createViewFromTag(root, name, inflaterContext, attrs);
                    if (root == null && temp != null && temp.getViewRootImpl() != null) {
                        temp.getViewRootImpl().notifyRendererOfExpensiveFrame();
                    }
                    ViewGroup.LayoutParams params = null;
                    if (root != null) {
                        params = root.generateLayoutParams(attrs);
                        if (!attachToRoot) {
                            temp.setLayoutParams(params);
                        }
                    }
                    this.rInflateChildren(parser, temp, attrs, true);
                    if (root != null && attachToRoot) {
                        root.addView(temp, params);
                    }
                    if (root == null || !attachToRoot) {
                        result = temp;
                    }
                }
            }
            catch (XmlPullParserException e) {
                InflateException ie = new InflateException(e.getMessage(), e);
                ie.setStackTrace(EMPTY_STACK_TRACE);
                throw ie;
            }
            catch (Exception e) {
                InflateException ie = new InflateException(LayoutInflater.getParserStateDescription(inflaterContext, attrs) + ": " + e.getMessage(), e);
                ie.setStackTrace(EMPTY_STACK_TRACE);
                throw ie;
            }
            finally {
                this.mConstructorArgs[0] = lastContext;
                this.mConstructorArgs[1] = null;
                Trace.traceEnd(8L);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return result;
        }
    }

    private static String getParserStateDescription(Context context, AttributeSet attrs) {
        int sourceResId = Resources.getAttributeSetSourceResId(attrs);
        if (sourceResId == 0) {
            return attrs.getPositionDescription();
        }
        return attrs.getPositionDescription() + " in " + context.getResources().getResourceName(sourceResId);
    }

    private boolean verifyClassLoader(Constructor<? extends View> constructor) {
        ClassLoader constructorLoader = constructor.getDeclaringClass().getClassLoader();
        if (constructorLoader == BOOT_CLASS_LOADER) {
            return true;
        }
        ClassLoader cl = this.mContext.getFrameworkClassLoader();
        do {
            if (constructorLoader != cl) continue;
            return true;
        } while ((cl = cl.getParent()) != null);
        return false;
    }

    public View createView(String name, String prefix, AttributeSet attrs) throws ClassNotFoundException, InflateException {
        Context context = (Context)this.mConstructorArgs[0];
        if (context == null) {
            context = this.mContext;
        }
        return this.createView(context, name, prefix, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public View createView(@NonNull Context viewContext, @NonNull String name, @Nullable String prefix, @Nullable AttributeSet attrs) throws ClassNotFoundException, InflateException {
        Objects.requireNonNull(viewContext);
        Objects.requireNonNull(name);
        Constructor<? extends View> constructor = sConstructorMap.get(name);
        if (constructor != null && !this.verifyClassLoader(constructor)) {
            constructor = null;
            sConstructorMap.remove(name);
        }
        Class<View> clazz = null;
        try {
            Trace.traceBegin(8L, name);
            if (constructor == null) {
                boolean allowed;
                clazz = Class.forName(prefix != null ? prefix + name : name, false, this.mContext.getFrameworkClassLoader()).asSubclass(View.class);
                if (this.mFilter != null && clazz != null && !(allowed = this.mFilter.onLoadClass(clazz))) {
                    this.failNotAllowed(name, prefix, viewContext, attrs);
                }
                constructor = clazz.getConstructor(mConstructorSignature);
                constructor.setAccessible(true);
                sConstructorMap.put(name, constructor);
            } else if (this.mFilter != null) {
                Boolean allowedState = this.mFilterMap.get(name);
                if (allowedState == null) {
                    clazz = Class.forName(prefix != null ? prefix + name : name, false, this.mContext.getFrameworkClassLoader()).asSubclass(View.class);
                    boolean allowed = clazz != null && this.mFilter.onLoadClass(clazz);
                    this.mFilterMap.put(name, allowed);
                    if (!allowed) {
                        this.failNotAllowed(name, prefix, viewContext, attrs);
                    }
                } else if (((Object)allowedState).equals(Boolean.FALSE)) {
                    this.failNotAllowed(name, prefix, viewContext, attrs);
                }
            }
            Object lastContext = this.mConstructorArgs[0];
            this.mConstructorArgs[0] = viewContext;
            Object[] args = this.mConstructorArgs;
            args[1] = attrs;
            try {
                View view = constructor.newInstance(args);
                if (view instanceof ViewStub) {
                    ViewStub viewStub = (ViewStub)view;
                    viewStub.setLayoutInflater(this.cloneInContext((Context)args[0]));
                }
                View view2 = view;
                this.mConstructorArgs[0] = lastContext;
                return view2;
            }
            catch (Throwable throwable) {
                InflateException ie;
                try {
                    this.mConstructorArgs[0] = lastContext;
                    throw throwable;
                }
                catch (NoSuchMethodException e) {
                    ie = new InflateException(LayoutInflater.getParserStateDescription(viewContext, attrs) + ": Error inflating class " + (prefix != null ? prefix + name : name), e);
                    ie.setStackTrace(EMPTY_STACK_TRACE);
                    throw ie;
                }
                catch (ClassCastException e) {
                    ie = new InflateException(LayoutInflater.getParserStateDescription(viewContext, attrs) + ": Class is not a View " + (prefix != null ? prefix + name : name), e);
                    ie.setStackTrace(EMPTY_STACK_TRACE);
                    throw ie;
                }
                catch (ClassNotFoundException e) {
                    throw e;
                }
                catch (Exception e) {
                    ie = new InflateException(LayoutInflater.getParserStateDescription(viewContext, attrs) + ": Error inflating class " + (clazz == null ? "<unknown>" : clazz.getName()), e);
                    ie.setStackTrace(EMPTY_STACK_TRACE);
                    throw ie;
                }
            }
        }
        finally {
            Trace.traceEnd(8L);
        }
    }

    private void failNotAllowed(String name, String prefix, Context context, AttributeSet attrs) {
        throw new InflateException(LayoutInflater.getParserStateDescription(context, attrs) + ": Class not allowed to be inflated " + (prefix != null ? prefix + name : name));
    }

    protected View onCreateView(String name, AttributeSet attrs) throws ClassNotFoundException {
        return this.createView(name, "android.view.", attrs);
    }

    protected View onCreateView(View parent, String name, AttributeSet attrs) throws ClassNotFoundException {
        return this.onCreateView(name, attrs);
    }

    @Nullable
    public View onCreateView(@NonNull Context viewContext, @Nullable View parent, @NonNull String name, @Nullable AttributeSet attrs) throws ClassNotFoundException {
        return this.onCreateView(parent, name, attrs);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private View createViewFromTag(View parent, String name, Context context, AttributeSet attrs) {
        return this.createViewFromTag(parent, name, context, attrs, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    View createViewFromTag(View parent, String name, Context context, AttributeSet attrs, boolean ignoreThemeAttr) {
        if (name.equals("view")) {
            name = attrs.getAttributeValue(null, "class");
        }
        if (!ignoreThemeAttr) {
            TypedArray ta = context.obtainStyledAttributes(attrs, ATTRS_THEME);
            int themeResId = ta.getResourceId(0, 0);
            if (themeResId != 0) {
                context = new ContextThemeWrapper(context, themeResId);
            }
            ta.recycle();
        }
        try {
            View view = this.tryCreateView(parent, name, context, attrs);
            if (view == null) {
                Object lastContext = this.mConstructorArgs[0];
                this.mConstructorArgs[0] = context;
                try {
                    view = -1 == name.indexOf(46) ? this.onCreateView(context, parent, name, attrs) : this.createView(context, name, null, attrs);
                }
                finally {
                    this.mConstructorArgs[0] = lastContext;
                }
            }
            return view;
        }
        catch (InflateException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            InflateException ie = new InflateException(LayoutInflater.getParserStateDescription(context, attrs) + ": Error inflating class " + name, e);
            ie.setStackTrace(EMPTY_STACK_TRACE);
            throw ie;
        }
        catch (Exception e) {
            InflateException ie = new InflateException(LayoutInflater.getParserStateDescription(context, attrs) + ": Error inflating class " + name, e);
            ie.setStackTrace(EMPTY_STACK_TRACE);
            throw ie;
        }
    }

    @UnsupportedAppUsage(trackingBug=122360734L)
    @Nullable
    public View tryCreateView(@Nullable View parent, @NonNull String name, @NonNull Context context, @NonNull AttributeSet attrs) {
        if (name.equals(TAG_1995)) {
            return new BlinkLayout(context, attrs);
        }
        View view = this.mFactory2 != null ? this.mFactory2.onCreateView(parent, name, context, attrs) : (this.mFactory != null ? this.mFactory.onCreateView(name, context, attrs) : null);
        if (view == null && this.mPrivateFactory != null) {
            view = this.mPrivateFactory.onCreateView(parent, name, context, attrs);
        }
        return view;
    }

    void rInflateChildren(XmlPullParser parser, View parent, AttributeSet attrs, boolean finishInflate) throws XmlPullParserException, IOException {
        this.rInflate(parser, parent, parent.getContext(), attrs, finishInflate);
    }

    void rInflate_Original(XmlPullParser parser, View parent, Context context, AttributeSet attrs, boolean finishInflate) throws XmlPullParserException, IOException {
        int type;
        int depth = parser.getDepth();
        boolean pendingRequestFocus = false;
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            String name = parser.getName();
            if (TAG_REQUEST_FOCUS.equals(name)) {
                pendingRequestFocus = true;
                LayoutInflater.consumeChildElements(parser);
                continue;
            }
            if (TAG_TAG.equals(name)) {
                this.parseViewTag(parser, parent, attrs);
                continue;
            }
            if (TAG_INCLUDE.equals(name)) {
                if (parser.getDepth() == 0) {
                    throw new InflateException("<include /> cannot be the root element");
                }
                this.parseInclude(parser, context, parent, attrs);
                continue;
            }
            if (TAG_MERGE.equals(name)) {
                throw new InflateException("<merge /> must be the root element");
            }
            View view = this.createViewFromTag(parent, name, context, attrs);
            ViewGroup viewGroup = (ViewGroup)parent;
            ViewGroup.LayoutParams params = viewGroup.generateLayoutParams(attrs);
            this.rInflateChildren(parser, view, attrs, true);
            viewGroup.addView(view, params);
        }
        if (pendingRequestFocus) {
            parent.restoreDefaultFocus();
        }
        if (finishInflate) {
            parent.onFinishInflate();
        }
    }

    @LayoutlibDelegate
    void rInflate(XmlPullParser xmlPullParser, View view, Context context, AttributeSet attributeSet, boolean bl) throws XmlPullParserException, IOException {
        LayoutInflater_Delegate.rInflate(this, xmlPullParser, view, context, attributeSet, bl);
    }

    private void parseViewTag(XmlPullParser parser, View view, AttributeSet attrs) throws XmlPullParserException, IOException {
        Context context = view.getContext();
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.ViewTag);
        int key = ta.getResourceId(1, 0);
        CharSequence value = ta.getText(0);
        view.setTag(key, value);
        ta.recycle();
        LayoutInflater.consumeChildElements(parser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    void parseInclude_Original(XmlPullParser parser, Context context, View parent, AttributeSet attrs) throws XmlPullParserException, IOException {
        block22: {
            String value;
            boolean hasThemeOverride;
            if (!(parent instanceof ViewGroup)) {
                throw new InflateException("<include /> can only be used inside of a ViewGroup");
            }
            TypedArray ta = context.obtainStyledAttributes(attrs, ATTRS_THEME);
            int themeResId = ta.getResourceId(0, 0);
            boolean bl = hasThemeOverride = themeResId != 0;
            if (hasThemeOverride) {
                context = new ContextThemeWrapper(context, themeResId);
            }
            ta.recycle();
            int layout2 = attrs.getAttributeResourceValue(null, ATTR_LAYOUT, 0);
            if (layout2 == 0) {
                value = attrs.getAttributeValue(null, ATTR_LAYOUT);
                if (value == null || value.length() <= 0) {
                    throw new InflateException("You must specify a layout in the include tag: <include layout=\"@layout/layoutID\" />");
                }
                layout2 = context.getResources().getIdentifier(value.substring(1), "attr", context.getPackageName());
            }
            if (this.mTempValue == null) {
                this.mTempValue = new TypedValue();
            }
            if (layout2 != 0 && context.getTheme().resolveAttribute(layout2, this.mTempValue, true)) {
                layout2 = this.mTempValue.resourceId;
            }
            if (layout2 == 0) {
                value = attrs.getAttributeValue(null, ATTR_LAYOUT);
                throw new InflateException("You must specify a valid layout reference. The layout ID " + value + " is not valid.");
            }
            try (XmlResourceParser childParser = context.getResources().getLayout(layout2);){
                int type;
                AttributeSet childAttrs = Xml.asAttributeSet(childParser);
                while ((type = childParser.next()) != 2 && type != 1) {
                }
                if (type != 2) {
                    throw new InflateException(LayoutInflater.getParserStateDescription(context, childAttrs) + ": No start tag found!");
                }
                String childName = childParser.getName();
                if (TAG_MERGE.equals(childName)) {
                    this.rInflate(childParser, parent, context, childAttrs, false);
                    break block22;
                }
                View view = this.createViewFromTag(parent, childName, context, childAttrs, hasThemeOverride);
                ViewGroup group = (ViewGroup)parent;
                TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Include);
                int id2 = a.getResourceId(0, -1);
                int visibility = a.getInt(1, -1);
                a.recycle();
                ViewGroup.LayoutParams params = null;
                try {
                    params = group.generateLayoutParams(attrs);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                if (params == null) {
                    params = group.generateLayoutParams(childAttrs);
                }
                view.setLayoutParams(params);
                this.rInflateChildren(childParser, view, childAttrs, true);
                if (id2 != -1) {
                    view.setId(id2);
                }
                switch (visibility) {
                    case 0: {
                        view.setVisibility(0);
                        break;
                    }
                    case 1: {
                        view.setVisibility(4);
                        break;
                    }
                    case 2: {
                        view.setVisibility(8);
                    }
                }
                group.addView(view);
            }
        }
        LayoutInflater.consumeChildElements(parser);
    }

    @LayoutlibDelegate
    private void parseInclude(XmlPullParser xmlPullParser, Context context, View view, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        LayoutInflater_Delegate.parseInclude(this, xmlPullParser, context, view, attributeSet);
    }

    static void consumeChildElements(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        int currentDepth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > currentDepth) && type != 1) {
        }
    }

    public static interface Factory {
        @Nullable
        public View onCreateView(@NonNull String var1, @NonNull Context var2, @NonNull AttributeSet var3);
    }

    public static interface Factory2
    extends Factory {
        @Nullable
        public View onCreateView(@Nullable View var1, @NonNull String var2, @NonNull Context var3, @NonNull AttributeSet var4);
    }

    public static interface Filter {
        public boolean onLoadClass(Class var1);
    }

    private static class FactoryMerger
    implements Factory2 {
        private final Factory mF1;
        private final Factory mF2;
        private final Factory2 mF12;
        private final Factory2 mF22;

        FactoryMerger(Factory f1, Factory2 f12, Factory f2, Factory2 f22) {
            this.mF1 = f1;
            this.mF2 = f2;
            this.mF12 = f12;
            this.mF22 = f22;
        }

        @Override
        @Nullable
        public View onCreateView(@NonNull String name, @NonNull Context context, @NonNull AttributeSet attrs) {
            View v = this.mF1.onCreateView(name, context, attrs);
            if (v != null) {
                return v;
            }
            return this.mF2.onCreateView(name, context, attrs);
        }

        @Override
        @Nullable
        public View onCreateView(@Nullable View parent, @NonNull String name, @NonNull Context context, @NonNull AttributeSet attrs) {
            View v;
            View view = v = this.mF12 != null ? this.mF12.onCreateView(parent, name, context, attrs) : this.mF1.onCreateView(name, context, attrs);
            if (v != null) {
                return v;
            }
            return this.mF22 != null ? this.mF22.onCreateView(parent, name, context, attrs) : this.mF2.onCreateView(name, context, attrs);
        }
    }

    private static class BlinkLayout
    extends FrameLayout {
        private static final int MESSAGE_BLINK = 66;
        private static final int BLINK_DELAY = 500;
        private boolean mBlink;
        private boolean mBlinkState;
        private final Handler mHandler = new Handler(new Handler.Callback(){

            @Override
            public boolean handleMessage(Message msg) {
                if (msg.what == 66) {
                    if (mBlink) {
                        mBlinkState = !mBlinkState;
                        this.makeBlink();
                    }
                    this.invalidate();
                    return true;
                }
                return false;
            }
        });

        public BlinkLayout(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        private void makeBlink() {
            Message message = this.mHandler.obtainMessage(66);
            this.mHandler.sendMessageDelayed(message, 500L);
        }

        @Override
        protected void onAttachedToWindow() {
            super.onAttachedToWindow();
            this.mBlink = true;
            this.mBlinkState = true;
            this.makeBlink();
        }

        @Override
        protected void onDetachedFromWindow() {
            super.onDetachedFromWindow();
            this.mBlink = false;
            this.mBlinkState = true;
            this.mHandler.removeMessages(66);
        }

        @Override
        protected void dispatchDraw(Canvas canvas) {
            if (this.mBlinkState) {
                super.dispatchDraw(canvas);
            }
        }
    }
}

