/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.Insets;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.proto.ProtoOutputStream;
import android.view.WindowInsets;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;

public class InsetsSource
implements Parcelable {
    static final int SIDE_NONE = 0;
    static final int SIDE_LEFT = 1;
    static final int SIDE_TOP = 2;
    static final int SIDE_RIGHT = 3;
    static final int SIDE_BOTTOM = 4;
    static final int SIDE_UNKNOWN = 5;
    public static final int ID_IME = InsetsSource.createId(null, 0, WindowInsets.Type.ime());
    public static final int ID_IME_CAPTION_BAR = InsetsSource.createId(null, 1, WindowInsets.Type.captionBar());
    public static final int FLAG_SUPPRESS_SCRIM = 1;
    public static final int FLAG_INSETS_ROUNDED_CORNER = 2;
    public static final int FLAG_FORCE_CONSUMING = 4;
    public static final int FLAG_ANIMATE_RESIZING = 8;
    public static final int FLAG_FORCE_CONSUMING_OPAQUE_CAPTION_BAR = 16;
    private static final Rect[] NO_BOUNDING_RECTS = new Rect[0];
    private int mFlags;
    private final int mId;
    private final int mType;
    private final Rect mFrame;
    @Nullable
    private Rect mVisibleFrame;
    @Nullable
    private Rect[] mBoundingRects;
    private boolean mVisible;
    private int mSideHint = 0;
    private final Rect mTmpFrame = new Rect();
    private final Rect mTmpBoundingRect = new Rect();
    @NonNull
    public static final Parcelable.Creator<InsetsSource> CREATOR = new Parcelable.Creator<InsetsSource>(){

        @Override
        public InsetsSource createFromParcel(Parcel in) {
            return new InsetsSource(in);
        }

        public InsetsSource[] newArray(int size) {
            return new InsetsSource[size];
        }
    };

    public InsetsSource(int id2, int type) {
        this.mId = id2;
        this.mType = type;
        this.mFrame = new Rect();
        this.mVisible = (WindowInsets.Type.defaultVisible() & type) != 0;
    }

    public InsetsSource(InsetsSource other) {
        this.mId = other.mId;
        this.mType = other.mType;
        this.mFrame = new Rect(other.mFrame);
        this.mVisible = other.mVisible;
        this.mVisibleFrame = other.mVisibleFrame != null ? new Rect(other.mVisibleFrame) : null;
        this.mFlags = other.mFlags;
        this.mSideHint = other.mSideHint;
        this.mBoundingRects = other.mBoundingRects != null ? (Rect[])other.mBoundingRects.clone() : null;
    }

    public void set(InsetsSource other) {
        this.mFrame.set(other.mFrame);
        this.mVisible = other.mVisible;
        this.mVisibleFrame = other.mVisibleFrame != null ? new Rect(other.mVisibleFrame) : null;
        this.mFlags = other.mFlags;
        this.mSideHint = other.mSideHint;
        this.mBoundingRects = other.mBoundingRects != null ? (Rect[])other.mBoundingRects.clone() : null;
    }

    public InsetsSource setFrame(int left, int top, int right, int bottom) {
        this.mFrame.set(left, top, right, bottom);
        return this;
    }

    public InsetsSource setFrame(Rect frame) {
        this.mFrame.set(frame);
        return this;
    }

    public InsetsSource setVisibleFrame(@Nullable Rect visibleFrame) {
        this.mVisibleFrame = visibleFrame != null ? new Rect(visibleFrame) : null;
        return this;
    }

    public InsetsSource setVisible(boolean visible) {
        this.mVisible = visible;
        return this;
    }

    public InsetsSource setFlags(int flags) {
        this.mFlags = flags;
        return this;
    }

    public InsetsSource setFlags(int flags, int mask) {
        this.mFlags = this.mFlags & ~mask | flags & mask;
        return this;
    }

    public InsetsSource updateSideHint(Rect bounds) {
        this.mSideHint = InsetsSource.getInsetSide(this.calculateInsets(bounds, this.mFrame, true));
        return this;
    }

    public InsetsSource setBoundingRects(@Nullable Rect[] rects) {
        this.mBoundingRects = rects != null ? (Rect[])rects.clone() : null;
        return this;
    }

    public int getId() {
        return this.mId;
    }

    public int getType() {
        return this.mType;
    }

    public Rect getFrame() {
        return this.mFrame;
    }

    @Nullable
    public Rect getVisibleFrame() {
        return this.mVisibleFrame;
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public boolean hasFlags(int flags) {
        return (this.mFlags & flags) == flags;
    }

    @Nullable
    public Rect[] getBoundingRects() {
        return this.mBoundingRects;
    }

    public Insets calculateInsets(Rect relativeFrame, boolean ignoreVisibility) {
        return this.calculateInsets(relativeFrame, this.mFrame, ignoreVisibility);
    }

    public Insets calculateVisibleInsets(Rect relativeFrame) {
        return this.calculateInsets(relativeFrame, this.mVisibleFrame != null ? this.mVisibleFrame : this.mFrame, false);
    }

    private Insets calculateInsets(Rect relativeFrame, Rect frame, boolean ignoreVisibility) {
        boolean hasIntersection;
        if (!ignoreVisibility && !this.mVisible) {
            return Insets.NONE;
        }
        if (this.getType() == WindowInsets.Type.captionBar()) {
            return this.getId() == ID_IME_CAPTION_BAR ? Insets.of(0, 0, 0, frame.height()) : Insets.of(0, frame.height(), 0, 0);
        }
        boolean bl = hasIntersection = relativeFrame.isEmpty() ? InsetsSource.getIntersection(frame, relativeFrame, this.mTmpFrame) : this.mTmpFrame.setIntersect(frame, relativeFrame);
        if (!hasIntersection) {
            return Insets.NONE;
        }
        if (this.getType() == WindowInsets.Type.ime()) {
            return Insets.of(0, 0, 0, this.mTmpFrame.height());
        }
        if (this.mTmpFrame.equals(relativeFrame)) {
            switch (this.mSideHint) {
                default: {
                    return Insets.of(this.mTmpFrame.width(), 0, 0, 0);
                }
                case 2: {
                    return Insets.of(0, this.mTmpFrame.height(), 0, 0);
                }
                case 3: {
                    return Insets.of(0, 0, this.mTmpFrame.width(), 0);
                }
                case 4: 
            }
            return Insets.of(0, 0, 0, this.mTmpFrame.height());
        }
        if (this.mTmpFrame.width() == relativeFrame.width()) {
            if (this.mTmpFrame.top == relativeFrame.top) {
                return Insets.of(0, this.mTmpFrame.height(), 0, 0);
            }
            if (this.mTmpFrame.bottom == relativeFrame.bottom) {
                return Insets.of(0, 0, 0, this.mTmpFrame.height());
            }
            if (this.mTmpFrame.top == 0) {
                return Insets.of(0, this.mTmpFrame.height(), 0, 0);
            }
        } else if (this.mTmpFrame.height() == relativeFrame.height()) {
            if (this.mTmpFrame.left == relativeFrame.left) {
                return Insets.of(this.mTmpFrame.width(), 0, 0, 0);
            }
            if (this.mTmpFrame.right == relativeFrame.right) {
                return Insets.of(0, 0, this.mTmpFrame.width(), 0);
            }
        } else {
            switch (this.mSideHint) {
                case 1: {
                    if (this.mTmpFrame.left != relativeFrame.left) break;
                    return Insets.of(this.mTmpFrame.width(), 0, 0, 0);
                }
                case 2: {
                    if (this.mTmpFrame.top != relativeFrame.top) break;
                    return Insets.of(0, this.mTmpFrame.height(), 0, 0);
                }
                case 3: {
                    if (this.mTmpFrame.right != relativeFrame.right) break;
                    return Insets.of(0, 0, this.mTmpFrame.width(), 0);
                }
                case 4: {
                    if (this.mTmpFrame.bottom != relativeFrame.bottom) break;
                    return Insets.of(0, 0, 0, this.mTmpFrame.height());
                }
            }
        }
        return Insets.NONE;
    }

    @NonNull
    public Rect[] calculateBoundingRects(Rect relativeFrame, boolean ignoreVisibility) {
        if (!ignoreVisibility && !this.mVisible) {
            return NO_BOUNDING_RECTS;
        }
        Rect frame = this.getFrame();
        if (this.mBoundingRects == null) {
            Rect[] rectArray;
            if (this.mTmpBoundingRect.setIntersect(frame, relativeFrame)) {
                Rect[] rectArray2 = new Rect[1];
                rectArray = rectArray2;
                rectArray2[0] = new Rect(this.mTmpBoundingRect.left - relativeFrame.left, this.mTmpBoundingRect.top - relativeFrame.top, this.mTmpBoundingRect.right - relativeFrame.left, this.mTmpBoundingRect.bottom - relativeFrame.top);
            } else {
                rectArray = NO_BOUNDING_RECTS;
            }
            return rectArray;
        }
        if (this.getType() == WindowInsets.Type.captionBar()) {
            ArrayList<Rect> validBoundingRects = new ArrayList<Rect>();
            for (Rect boundingRect : this.mBoundingRects) {
                int frameHeight = frame.height();
                this.mTmpBoundingRect.set(boundingRect);
                if (this.getId() == ID_IME_CAPTION_BAR) {
                    this.mTmpBoundingRect.offset(0, relativeFrame.height() - frameHeight);
                }
                validBoundingRects.add(new Rect(this.mTmpBoundingRect));
            }
            return validBoundingRects.toArray(new Rect[validBoundingRects.size()]);
        }
        ArrayList<Rect> validBoundingRects = new ArrayList<Rect>();
        for (Rect boundingRect : this.mBoundingRects) {
            Rect absBoundingRect = new Rect(boundingRect.left + frame.left, boundingRect.top + frame.top, boundingRect.right + frame.left, boundingRect.bottom + frame.top);
            if (!this.mTmpBoundingRect.setIntersect(absBoundingRect, relativeFrame)) continue;
            validBoundingRects.add(new Rect(this.mTmpBoundingRect.left - relativeFrame.left, this.mTmpBoundingRect.top - relativeFrame.top, this.mTmpBoundingRect.right - relativeFrame.left, this.mTmpBoundingRect.bottom - relativeFrame.top));
        }
        if (validBoundingRects.isEmpty()) {
            return NO_BOUNDING_RECTS;
        }
        return validBoundingRects.toArray(new Rect[validBoundingRects.size()]);
    }

    private static boolean getIntersection(@NonNull Rect a, @NonNull Rect b, @NonNull Rect out) {
        if (a.left <= b.right && b.left <= a.right && a.top <= b.bottom && b.top <= a.bottom) {
            out.left = Math.max(a.left, b.left);
            out.top = Math.max(a.top, b.top);
            out.right = Math.min(a.right, b.right);
            out.bottom = Math.min(a.bottom, b.bottom);
            return true;
        }
        out.setEmpty();
        return false;
    }

    static int getInsetSide(Insets insets) {
        if (Insets.NONE.equals(insets)) {
            return 0;
        }
        if (insets.left != 0) {
            return 1;
        }
        if (insets.top != 0) {
            return 2;
        }
        if (insets.right != 0) {
            return 3;
        }
        if (insets.bottom != 0) {
            return 4;
        }
        return 5;
    }

    static String sideToString(int side) {
        switch (side) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "LEFT";
            }
            case 2: {
                return "TOP";
            }
            case 3: {
                return "RIGHT";
            }
            case 4: {
                return "BOTTOM";
            }
        }
        return "UNKNOWN:" + side;
    }

    public static int createId(Object owner, int index, int type) {
        if (index < 0 || index >= 2048) {
            throw new IllegalArgumentException();
        }
        return (System.identityHashCode(owner) % 65536 << 16) + (index << 5) + WindowInsets.Type.indexOf(type);
    }

    public static int getIndex(int id2) {
        return (id2 & 0xFFFF) >> 5;
    }

    public static int getType(int id2) {
        return 1 << (id2 & 0x1F);
    }

    public static String flagsToString(int flags) {
        StringJoiner joiner = new StringJoiner("|");
        if ((flags & 1) != 0) {
            joiner.add("SUPPRESS_SCRIM");
        }
        if ((flags & 2) != 0) {
            joiner.add("INSETS_ROUNDED_CORNER");
        }
        if ((flags & 4) != 0) {
            joiner.add("FORCE_CONSUMING");
        }
        if ((flags & 8) != 0) {
            joiner.add("ANIMATE_RESIZING");
        }
        if ((flags & 0x10) != 0) {
            joiner.add("FORCE_CONSUMING_OPAQUE_CAPTION_BAR");
        }
        return ((Object)joiner).toString();
    }

    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        if (!com.android.internal.hidden_from_bootclasspath.android.os.Flags.androidOsBuildVanillaIceCream()) {
            proto.write(0x10900000001L, WindowInsets.Type.toString(this.mType));
        }
        this.mFrame.dumpDebug(proto, 1146756268034L);
        if (this.mVisibleFrame != null) {
            this.mVisibleFrame.dumpDebug(proto, 1146756268035L);
        }
        proto.write(1133871366148L, this.mVisible);
        proto.write(0x10500000005L, this.mType);
        proto.end(token);
    }

    public void dump(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("InsetsSource id=");
        pw.print(Integer.toHexString(this.mId));
        pw.print(" type=");
        pw.print(WindowInsets.Type.toString(this.mType));
        pw.print(" frame=");
        pw.print(this.mFrame.toShortString());
        if (this.mVisibleFrame != null) {
            pw.print(" visibleFrame=");
            pw.print(this.mVisibleFrame.toShortString());
        }
        pw.print(" visible=");
        pw.print(this.mVisible);
        pw.print(" flags=");
        pw.print(InsetsSource.flagsToString(this.mFlags));
        pw.print(" sideHint=");
        pw.print(InsetsSource.sideToString(this.mSideHint));
        pw.print(" boundingRects=");
        pw.print(Arrays.toString(this.mBoundingRects));
        pw.println();
    }

    public boolean equals(@Nullable Object o) {
        return this.equals(o, false);
    }

    public boolean equals(@Nullable Object o, boolean excludeInvisibleImeFrames) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsetsSource that = (InsetsSource)o;
        if (this.mId != that.mId) {
            return false;
        }
        if (this.mType != that.mType) {
            return false;
        }
        if (this.mVisible != that.mVisible) {
            return false;
        }
        if (this.mFlags != that.mFlags) {
            return false;
        }
        if (this.mSideHint != that.mSideHint) {
            return false;
        }
        if (excludeInvisibleImeFrames && !this.mVisible && this.mType == WindowInsets.Type.ime()) {
            return true;
        }
        if (!Objects.equals(this.mVisibleFrame, that.mVisibleFrame)) {
            return false;
        }
        if (!this.mFrame.equals(that.mFrame)) {
            return false;
        }
        return Arrays.equals(this.mBoundingRects, that.mBoundingRects);
    }

    public int hashCode() {
        return Objects.hash(this.mId, this.mType, this.mFrame, this.mVisibleFrame, this.mVisible, this.mFlags, this.mSideHint, Arrays.hashCode(this.mBoundingRects));
    }

    public InsetsSource(Parcel in) {
        this.mId = in.readInt();
        this.mType = in.readInt();
        this.mFrame = Rect.CREATOR.createFromParcel(in);
        this.mVisibleFrame = in.readInt() != 0 ? Rect.CREATOR.createFromParcel(in) : null;
        this.mVisible = in.readBoolean();
        this.mFlags = in.readInt();
        this.mSideHint = in.readInt();
        this.mBoundingRects = in.createTypedArray(Rect.CREATOR);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mId);
        dest.writeInt(this.mType);
        this.mFrame.writeToParcel(dest, 0);
        if (this.mVisibleFrame != null) {
            dest.writeInt(1);
            this.mVisibleFrame.writeToParcel(dest, 0);
        } else {
            dest.writeInt(0);
        }
        dest.writeBoolean(this.mVisible);
        dest.writeInt(this.mFlags);
        dest.writeInt(this.mSideHint);
        dest.writeTypedArray(this.mBoundingRects, flags);
    }

    public String toString() {
        return "InsetsSource: {" + Integer.toHexString(this.mId) + " mType=" + WindowInsets.Type.toString(this.mType) + " mFrame=" + this.mFrame.toShortString() + " mVisible=" + this.mVisible + " mFlags=" + InsetsSource.flagsToString(this.mFlags) + " mSideHint=" + InsetsSource.sideToString(this.mSideHint) + " mBoundingRects=" + Arrays.toString(this.mBoundingRects) + "}";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InternalInsetsSide {
    }
}

