/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityThread;
import android.content.Context;
import android.content.res.CompatibilityInfo;
import android.graphics.Insets;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.IBinder;
import android.os.Trace;
import android.util.IntArray;
import android.util.Log;
import android.util.Pair;
import android.util.SparseArray;
import android.util.proto.ProtoOutputStream;
import android.view.ImeInsetsSourceConsumer;
import android.view.InsetsAnimationControlCallbacks;
import android.view.InsetsAnimationControlImpl;
import android.view.InsetsAnimationControlRunner;
import android.view.InsetsAnimationSpec;
import android.view.InsetsAnimationThreadControlRunner;
import android.view.InsetsResizeAnimationRunner;
import android.view.InsetsSource;
import android.view.InsetsSourceConsumer;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.InternalInsetsAnimationController;
import android.view.SurfaceControl;
import android.view.SyncRtSurfaceTransactionApplier;
import android.view.ViewProtoLogGroups;
import android.view.WindowInsets;
import android.view.WindowInsetsAnimation;
import android.view.WindowInsetsAnimationControlListener;
import android.view.WindowInsetsAnimationController;
import android.view.WindowInsetsController;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.PathInterpolator;
import android.view.inputmethod.Flags;
import android.view.inputmethod.ImeTracker;
import android.view.inputmethod.InputMethodManager;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.inputmethod.ImeTracing;
import com.android.internal.protolog.ProtoLog;
import com.android.internal.util.function.TriFunction;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class InsetsController
implements WindowInsetsController,
InsetsAnimationControlCallbacks,
InsetsAnimationControlRunner.SurfaceParamsApplier {
    private int mTypesBeingCancelled;
    private static final String TAG = "InsetsController";
    private static final int ANIMATION_DURATION_MOVE_IN_MS = 275;
    private static final int ANIMATION_DURATION_MOVE_OUT_MS = 340;
    private static final int ANIMATION_DURATION_FADE_IN_MS = 500;
    private static final int ANIMATION_DURATION_FADE_OUT_MS = 1500;
    public static final int ANIMATION_DURATION_RESIZE = 300;
    private static final int ANIMATION_DELAY_DIM_MS = 500;
    static final int ANIMATION_DURATION_SYNC_IME_MS = 285;
    static final int ANIMATION_DURATION_UNSYNC_IME_MS = 200;
    private static final int PENDING_CONTROL_TIMEOUT_MS = 2000;
    private static final Interpolator SYSTEM_BARS_INSETS_INTERPOLATOR = new PathInterpolator(0.4f, 0.0f, 0.2f, 1.0f);
    private static final Interpolator SYSTEM_BARS_ALPHA_INTERPOLATOR = new PathInterpolator(0.3f, 0.0f, 1.0f, 1.0f);
    private static final Interpolator SYSTEM_BARS_DIM_INTERPOLATOR = alphaFraction -> {
        float fraction2 = 1.0f - alphaFraction;
        float fractionDelay = 0.33333334f;
        if (fraction2 <= 0.33333334f) {
            return 1.0f;
        }
        float innerFraction = (fraction2 - 0.33333334f) / 0.6666666f;
        return 1.0f - SYSTEM_BARS_ALPHA_INTERPOLATOR.getInterpolation(innerFraction);
    };
    static final Interpolator SYNC_IME_INTERPOLATOR = new PathInterpolator(0.2f, 0.0f, 0.0f, 1.0f);
    private static final Interpolator LINEAR_OUT_SLOW_IN_INTERPOLATOR = new PathInterpolator(0.0f, 0.0f, 0.2f, 1.0f);
    static final Interpolator FAST_OUT_LINEAR_IN_INTERPOLATOR = new PathInterpolator(0.4f, 0.0f, 1.0f, 1.0f);
    public static final Interpolator RESIZE_INTERPOLATOR = new LinearInterpolator();
    private static final int FLOATING_IME_BOTTOM_INSET_DP = -80;
    private static final int ID_CAPTION_BAR = InsetsSource.createId(null, 0, WindowInsets.Type.captionBar());
    static final boolean DEBUG = false;
    static final boolean WARN = false;
    public static final int LAYOUT_INSETS_DURING_ANIMATION_SHOWN = 0;
    public static final int LAYOUT_INSETS_DURING_ANIMATION_HIDDEN = 1;
    public static final int ANIMATION_TYPE_NONE = -1;
    public static final int ANIMATION_TYPE_SHOW = 0;
    public static final int ANIMATION_TYPE_HIDE = 1;
    public static final int ANIMATION_TYPE_USER = 2;
    public static final int ANIMATION_TYPE_RESIZE = 3;
    private static TypeEvaluator<Insets> sEvaluator = (fraction2, startValue, endValue) -> Insets.of((int)((float)startValue.left + fraction2 * (float)(endValue.left - startValue.left)), (int)((float)startValue.top + fraction2 * (float)(endValue.top - startValue.top)), (int)((float)startValue.right + fraction2 * (float)(endValue.right - startValue.right)), (int)((float)startValue.bottom + fraction2 * (float)(endValue.bottom - startValue.bottom)));
    private WindowInsetsAnimationControlListener mLoggingListener;
    private final ImeTracker.InputMethodJankContext mJankContext = new ImeTracker.InputMethodJankContext(){

        @Override
        public Context getDisplayContext() {
            return InsetsController.this.mHost != null ? InsetsController.this.mHost.getRootViewContext() : null;
        }

        @Override
        public SurfaceControl getTargetSurfaceControl() {
            InsetsSourceControl imeSourceControl = InsetsController.this.getImeSourceConsumer().getControl();
            return imeSourceControl != null ? imeSourceControl.getLeash() : null;
        }

        @Override
        public String getHostPackageName() {
            return InsetsController.this.mHost != null ? InsetsController.this.mHost.getRootViewContext().getPackageName() : null;
        }
    };
    private final InsetsState mState = new InsetsState();
    private final InsetsState mLastDispatchedState = new InsetsState();
    private final Rect mFrame = new Rect();
    private final TriFunction<InsetsController, Integer, Integer, InsetsSourceConsumer> mConsumerCreator;
    private final SparseArray<InsetsSourceConsumer> mSourceConsumers = new SparseArray();
    private final InsetsSourceConsumer mImeSourceConsumer;
    private final Host mHost;
    private final Handler mHandler;
    private final SparseArray<InsetsSourceControl> mTmpControlArray = new SparseArray();
    private final ArrayList<RunningAnimation> mRunningAnimations = new ArrayList();
    private WindowInsets mLastInsets;
    private boolean mAnimCallbackScheduled;
    private final Runnable mAnimCallback;
    @Nullable
    private PendingControlRequest mPendingImeControlRequest;
    private int mWindowType;
    private int mLastLegacySoftInputMode;
    private int mLastLegacyWindowFlags;
    private int mLastLegacySystemUiFlags;
    private int mLastActivityType;
    private boolean mStartingAnimation;
    private int mCaptionInsetsHeight = 0;
    private int mImeCaptionBarInsetsHeight = 0;
    private boolean mAnimationsDisabled;
    private boolean mCompatSysUiVisibilityStaled;
    private int mAppearanceControlled;
    private int mAppearanceFromResource;
    private boolean mBehaviorControlled;
    private boolean mIsPredictiveBackImeHideAnimInProgress;
    private final Runnable mPendingControlTimeout = this::abortPendingImeControlRequest;
    private final ArrayList<WindowInsetsController.OnControllableInsetsChangedListener> mControllableInsetsChangedListeners = new ArrayList();
    private int mLastStartedAnimTypes;
    private int mExistingTypes = 0;
    private int mVisibleTypes = WindowInsets.Type.defaultVisible();
    private int mRequestedVisibleTypes = WindowInsets.Type.defaultVisible();
    private int mReportedRequestedVisibleTypes = WindowInsets.Type.defaultVisible();
    private int mAnimatingTypes = 0;
    private int mControllableTypes;
    private int mCancelledForNewAnimationTypes;
    private final InsetsState.OnTraverseCallbacks mRemoveGoneSources = new InsetsState.OnTraverseCallbacks(this){
        private final IntArray mPendingRemoveIndexes = new IntArray();

        @Override
        public void onIdNotFoundInState2(int index1, InsetsSource source1) {
            if (source1.getId() == InsetsSource.ID_IME_CAPTION_BAR) {
                return;
            }
            this.mPendingRemoveIndexes.add(index1);
        }

        @Override
        public void onFinish(InsetsState state1, InsetsState state2) {
            for (int i = this.mPendingRemoveIndexes.size() - 1; i >= 0; --i) {
                state1.removeSourceAt(this.mPendingRemoveIndexes.get(i));
            }
            this.mPendingRemoveIndexes.clear();
        }
    };
    private final InsetsState.OnTraverseCallbacks mStartResizingAnimationIfNeeded = new InsetsState.OnTraverseCallbacks(){
        private int mTypes;
        private InsetsState mFromState;
        private InsetsState mToState;

        @Override
        public void onStart(InsetsState state1, InsetsState state2) {
            this.mTypes = 0;
            this.mFromState = null;
            this.mToState = null;
        }

        @Override
        public void onIdMatch(InsetsSource source1, InsetsSource source2) {
            Rect frame1 = source1.getFrame();
            Rect frame2 = source2.getFrame();
            if (!source1.hasFlags(8) || !source2.hasFlags(8) || !source1.isVisible() || !source2.isVisible() || frame1.equals(frame2) || frame1.isEmpty() || frame2.isEmpty() || !Rect.intersects(InsetsController.this.mFrame, source1.getFrame()) && !Rect.intersects(InsetsController.this.mFrame, source2.getFrame())) {
                return;
            }
            this.mTypes |= source1.getType();
            if (this.mFromState == null) {
                this.mFromState = new InsetsState();
            }
            if (this.mToState == null) {
                this.mToState = new InsetsState();
            }
            this.mFromState.addSource(new InsetsSource(source1));
            this.mToState.addSource(new InsetsSource(source2));
        }

        @Override
        public void onFinish(InsetsState state1, InsetsState state2) {
            if (this.mTypes == 0) {
                return;
            }
            InsetsController.this.cancelExistingControllers(this.mTypes);
            InsetsResizeAnimationRunner runner = new InsetsResizeAnimationRunner(InsetsController.this.mFrame, this.mFromState, this.mToState, RESIZE_INTERPOLATOR, 300L, this.mTypes, InsetsController.this);
            if (InsetsController.this.mRunningAnimations.isEmpty()) {
                InsetsController.this.mHost.updateAnimatingTypes(runner.getTypes(), runner.getAnimationType() == 1 ? runner.getStatsToken() : null);
            }
            InsetsController.this.mRunningAnimations.add(new RunningAnimation(runner, runner.getAnimationType()));
            InsetsController.this.mAnimatingTypes |= runner.getTypes();
        }
    };

    public InsetsController(Host host) {
        this(host, (controller, id2, type) -> {
            if (!Flags.refactorInsetsController() && type == WindowInsets.Type.ime()) {
                return new ImeInsetsSourceConsumer((int)id2, controller.mState, (InsetsController)controller);
            }
            return new InsetsSourceConsumer((int)id2, (int)type, controller.mState, (InsetsController)controller);
        }, host.getHandler());
    }

    @VisibleForTesting
    public InsetsController(Host host, TriFunction<InsetsController, Integer, Integer, InsetsSourceConsumer> consumerCreator, Handler handler) {
        this.mHost = host;
        this.mConsumerCreator = consumerCreator;
        this.mHandler = handler;
        this.mAnimCallback = () -> {
            this.mAnimCallbackScheduled = false;
            if (this.mRunningAnimations.isEmpty()) {
                return;
            }
            ArrayList<WindowInsetsAnimation> runningAnimations = new ArrayList<WindowInsetsAnimation>();
            ArrayList<WindowInsetsAnimation> finishedAnimations = new ArrayList<WindowInsetsAnimation>();
            InsetsState state = new InsetsState(this.mState, true);
            for (int i = this.mRunningAnimations.size() - 1; i >= 0; --i) {
                RunningAnimation runningAnimation = this.mRunningAnimations.get(i);
                InsetsAnimationControlRunner runner = runningAnimation.runner;
                if (!(runner instanceof WindowInsetsAnimationController)) continue;
                if (runningAnimation.startDispatched) {
                    runningAnimations.add(runner.getAnimation());
                }
                if (!((InternalInsetsAnimationController)((Object)runner)).applyChangeInsets(state)) continue;
                finishedAnimations.add(runner.getAnimation());
            }
            WindowInsets insets = state.calculateInsets(this.mFrame, this.mState, this.mLastInsets.isRound(), this.mLastLegacySoftInputMode, this.mLastLegacyWindowFlags, this.mLastLegacySystemUiFlags, this.mWindowType, this.mLastActivityType, null);
            this.mHost.dispatchWindowInsetsAnimationProgress(insets, Collections.unmodifiableList(runningAnimations));
            for (int i = finishedAnimations.size() - 1; i >= 0; --i) {
                this.dispatchAnimationEnd((WindowInsetsAnimation)finishedAnimations.get(i));
            }
        };
        this.mImeSourceConsumer = this.getSourceConsumer(InsetsSource.ID_IME, WindowInsets.Type.ime());
    }

    @VisibleForTesting
    public void onFrameChanged(Rect frame) {
        if (this.mFrame.equals(frame)) {
            return;
        }
        if (this.mImeCaptionBarInsetsHeight != 0) {
            this.setImeCaptionBarInsetsHeight(this.mImeCaptionBarInsetsHeight);
        }
        this.mHost.notifyInsetsChanged();
        this.mFrame.set(frame);
    }

    @Override
    public InsetsState getState() {
        return this.mState;
    }

    @Override
    public int getRequestedVisibleTypes() {
        return this.mRequestedVisibleTypes;
    }

    public InsetsState getLastDispatchedState() {
        return this.mLastDispatchedState;
    }

    public boolean onStateChanged(InsetsState state) {
        boolean stateChanged;
        boolean bl = stateChanged = !this.mState.equals(state, false, false);
        if (!stateChanged && this.mLastDispatchedState.equals(state)) {
            return false;
        }
        InsetsState lastState = new InsetsState(this.mState, true);
        this.updateState(state);
        this.applyLocalVisibilityOverride();
        this.updateCompatSysUiVisibility();
        if (!this.mState.equals(lastState, false, true)) {
            this.mHost.notifyInsetsChanged();
            if (this.mLastDispatchedState.getDisplayFrame().equals(state.getDisplayFrame())) {
                InsetsState.traverse(this.mLastDispatchedState, state, this.mStartResizingAnimationIfNeeded);
            }
        }
        this.mLastDispatchedState.set(state, true);
        return true;
    }

    private void updateState(InsetsState newState) {
        this.mState.set(newState, 0);
        int existingTypes = 0;
        int visibleTypes = 0;
        int[] cancelledUserAnimationTypes = new int[]{0};
        int size = newState.sourceSize();
        for (int i = 0; i < size; ++i) {
            InsetsSource source = new InsetsSource(newState.sourceAt(i));
            int type = source.getType();
            int animationType = this.getAnimationType(type);
            InsetsSourceConsumer consumer = this.mSourceConsumers.get(source.getId());
            if (consumer != null) {
                consumer.updateSource(source, animationType);
            } else {
                this.mState.addSource(source);
            }
            existingTypes |= type;
            if (!source.isVisible()) continue;
            visibleTypes |= type;
        }
        if (this.mVisibleTypes != (visibleTypes |= WindowInsets.Type.defaultVisible() & ~existingTypes)) {
            if (WindowInsets.Type.hasCompatSystemBars(this.mVisibleTypes ^ visibleTypes)) {
                this.mCompatSysUiVisibilityStaled = true;
            }
            this.mVisibleTypes = visibleTypes;
        }
        if (this.mExistingTypes != existingTypes) {
            if (WindowInsets.Type.hasCompatSystemBars(this.mExistingTypes ^ existingTypes)) {
                this.mCompatSysUiVisibilityStaled = true;
            }
            this.mExistingTypes = existingTypes;
        }
        InsetsState.traverse(this.mState, newState, this.mRemoveGoneSources);
        if (cancelledUserAnimationTypes[0] != 0) {
            this.mHandler.post(() -> this.show(cancelledUserAnimationTypes[0]));
        }
    }

    @VisibleForTesting
    public WindowInsets calculateInsets(boolean isScreenRound, int windowType, int activityType, int legacySoftInputMode, int legacyWindowFlags, int legacySystemUiFlags) {
        this.mWindowType = windowType;
        this.mLastActivityType = activityType;
        this.mLastLegacySoftInputMode = legacySoftInputMode;
        this.mLastLegacyWindowFlags = legacyWindowFlags;
        this.mLastLegacySystemUiFlags = legacySystemUiFlags;
        this.mLastInsets = this.mState.calculateInsets(this.mFrame, null, isScreenRound, legacySoftInputMode, legacyWindowFlags, legacySystemUiFlags, windowType, activityType, null);
        return this.mLastInsets;
    }

    public Insets calculateVisibleInsets(int windowType, int activityType, int softInputMode, int windowFlags) {
        return this.mState.calculateVisibleInsets(this.mFrame, windowType, activityType, softInputMode, windowFlags);
    }

    public void onControlsChanged(InsetsSourceControl[] activeControls) {
        int i;
        if (activeControls != null) {
            for (InsetsSourceControl activeControl : activeControls) {
                if (activeControl == null) continue;
                this.mTmpControlArray.put(activeControl.getId(), activeControl);
            }
        }
        int controllableTypes = 0;
        int consumedControlCount = 0;
        int[] showTypes = new int[1];
        int[] hideTypes = new int[1];
        int[] cancelTypes = new int[1];
        int[] transientTypes = new int[1];
        ImeTracker.Token statsToken = null;
        for (i = this.mSourceConsumers.size() - 1; i >= 0; --i) {
            InsetsSourceConsumer consumer = this.mSourceConsumers.valueAt(i);
            if (consumer.getId() == InsetsSource.ID_IME_CAPTION_BAR) continue;
            InsetsSourceControl control = this.mTmpControlArray.get(consumer.getId());
            if (control != null) {
                controllableTypes |= control.getType();
                ++consumedControlCount;
                if (Flags.refactorInsetsController() && control.getId() == InsetsSource.ID_IME) {
                    statsToken = control.getImeStatsToken();
                }
            }
            consumer.setControl(control, showTypes, hideTypes, cancelTypes, transientTypes);
        }
        if (consumedControlCount != this.mTmpControlArray.size()) {
            for (i = this.mTmpControlArray.size() - 1; i >= 0; --i) {
                InsetsSourceControl control = this.mTmpControlArray.valueAt(i);
                this.getSourceConsumer(control.getId(), control.getType()).setControl(control, showTypes, hideTypes, cancelTypes, transientTypes);
            }
        }
        if (this.mTmpControlArray.size() > 0) {
            for (i = this.mRunningAnimations.size() - 1; i >= 0; --i) {
                this.mRunningAnimations.get((int)i).runner.updateSurfacePosition(this.mTmpControlArray);
            }
        }
        this.mTmpControlArray.clear();
        if (cancelTypes[0] != 0) {
            this.cancelExistingControllers(cancelTypes[0]);
        }
        int animatingTypes = this.invokeControllableInsetsChangedListeners();
        showTypes[0] = showTypes[0] & ~animatingTypes;
        hideTypes[0] = hideTypes[0] & ~animatingTypes;
        if (Flags.refactorInsetsController()) {
            if (this.mPendingImeControlRequest != null && this.getImeSourceConsumer().getControl() != null && this.getImeSourceConsumer().getControl().getLeash() != null) {
                this.handlePendingControlRequest(statsToken);
            } else {
                if (showTypes[0] != 0) {
                    if ((showTypes[0] & WindowInsets.Type.ime()) != 0) {
                        ImeTracker.forLogging().onProgress(statsToken, 76);
                    }
                    this.applyAnimation(showTypes[0], true, false, false, statsToken);
                }
                if (hideTypes[0] != 0) {
                    if ((hideTypes[0] & WindowInsets.Type.ime()) != 0) {
                        ImeTracker.forLogging().onProgress(statsToken, 76);
                    }
                    this.applyAnimation(hideTypes[0], false, false, (hideTypes[0] & ~transientTypes[0]) == 0, statsToken);
                }
                if ((showTypes[0] & WindowInsets.Type.ime()) == 0 && (hideTypes[0] & WindowInsets.Type.ime()) == 0) {
                    ImeTracker.forLogging().onCancelled(statsToken, 76);
                }
            }
        } else {
            ImeTracker.Token newStatsToken;
            if (showTypes[0] != 0) {
                newStatsToken = (showTypes[0] & WindowInsets.Type.ime()) == 0 ? null : ImeTracker.forLogging().onStart(1, 5, 46, this.mHost.isHandlingPointerEvent());
                this.applyAnimation(showTypes[0], true, false, false, newStatsToken);
            }
            if (hideTypes[0] != 0) {
                newStatsToken = (hideTypes[0] & WindowInsets.Type.ime()) == 0 ? null : ImeTracker.forLogging().onStart(2, 5, 46, this.mHost.isHandlingPointerEvent());
                this.applyAnimation(hideTypes[0], false, false, (hideTypes[0] & ~transientTypes[0]) == 0, newStatsToken);
            }
        }
        if (this.mControllableTypes != controllableTypes) {
            if (WindowInsets.Type.hasCompatSystemBars(this.mControllableTypes ^ controllableTypes)) {
                this.mCompatSysUiVisibilityStaled = true;
            }
            this.mControllableTypes = controllableTypes;
        }
        if (Flags.refactorInsetsController()) {
            this.applyLocalVisibilityOverride();
        }
        this.reportRequestedVisibleTypes(null);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void setPredictiveBackImeHideAnimInProgress(boolean isInProgress) {
        this.mIsPredictiveBackImeHideAnimInProgress = isInProgress;
        if (isInProgress) {
            for (int i = this.mRunningAnimations.size() - 1; i >= 0; --i) {
                InsetsAnimationControlRunner runner = this.mRunningAnimations.get((int)i).runner;
                if ((runner.getTypes() & WindowInsets.Type.ime()) == 0) continue;
                runner.updateLayoutInsetsDuringAnimation(1);
                break;
            }
        }
    }

    public boolean isPredictiveBackImeHideAnimInProgress() {
        return this.mIsPredictiveBackImeHideAnimInProgress;
    }

    @Override
    public void show(int types) {
        this.show(types, false, null);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void show(int types, boolean fromIme, @Nullable ImeTracker.Token statsToken) {
        if ((types & WindowInsets.Type.ime()) != 0) {
            Log.d(TAG, "show(ime(), fromIme=" + fromIme + ")");
            if (statsToken == null) {
                statsToken = ImeTracker.forLogging().onStart(1, 5, 26, this.mHost.isHandlingPointerEvent());
            }
        }
        if (fromIme) {
            ImeTracing.getInstance().triggerClientDump("InsetsController#show", this.mHost.getInputMethodManager(), null);
            Trace.asyncTraceEnd(8L, "IC.showRequestFromApiToImeReady", 0);
            Trace.asyncTraceBegin(8L, "IC.showRequestFromIme", 0);
        } else {
            Trace.asyncTraceBegin(8L, "IC.showRequestFromApi", 0);
            Trace.asyncTraceBegin(8L, "IC.showRequestFromApiToImeReady", 0);
        }
        if (!Flags.refactorInsetsController() && fromIme && this.mPendingImeControlRequest != null) {
            if ((types & WindowInsets.Type.ime()) != 0) {
                ImeTracker.forLatency().onShown(statsToken, ActivityThread::currentApplication);
            }
            this.handlePendingControlRequest(statsToken);
            return;
        }
        int typesReady = 0;
        boolean imeVisible = this.mState.isSourceOrDefaultVisible(this.mImeSourceConsumer.getId(), WindowInsets.Type.ime());
        for (int type = 1; type <= 512; type <<= 1) {
            boolean alreadyAnimatingShow;
            if ((types & type) == 0) continue;
            int animationType = this.getAnimationType(type);
            boolean requestedVisible = (type & this.mRequestedVisibleTypes) != 0;
            boolean isIme = type == WindowInsets.Type.ime();
            boolean alreadyVisible = requestedVisible && (!isIme || imeVisible) && animationType == -1;
            boolean bl = alreadyAnimatingShow = animationType == 0;
            if (alreadyVisible || alreadyAnimatingShow) {
                if (!isIme) continue;
                ImeTracker.forLogging().onCancelled(statsToken, 32);
                continue;
            }
            if (!Flags.refactorInsetsController() && fromIme && animationType == 2 && !this.mIsPredictiveBackImeHideAnimInProgress) {
                if (!isIme) continue;
                ImeTracker.forLogging().onFailed(statsToken, 32);
                continue;
            }
            if (isIme) {
                ImeTracker.forLogging().onProgress(statsToken, 32);
            }
            typesReady |= type;
        }
        if ((Flags.refactorInsetsController() || fromIme) && (typesReady & WindowInsets.Type.ime()) != 0) {
            ImeTracker.forLatency().onShown(statsToken, ActivityThread::currentApplication);
        }
        this.applyAnimation(typesReady, true, fromIme, false, statsToken);
    }

    private void handlePendingControlRequest(@Nullable ImeTracker.Token statsToken) {
        PendingControlRequest pendingRequest = this.mPendingImeControlRequest;
        this.mPendingImeControlRequest = null;
        this.mHandler.removeCallbacks(this.mPendingControlTimeout);
        this.controlAnimationUnchecked(pendingRequest.types, pendingRequest.cancellationSignal, pendingRequest.listener, null, true, pendingRequest.mInsetsAnimationSpec, pendingRequest.animationType, pendingRequest.layoutInsetsDuringAnimation, pendingRequest.useInsetsAnimationThread, statsToken, false);
    }

    @Override
    public void hide(int types) {
        this.hide(types, false, null);
    }

    @VisibleForTesting
    public void hide(int types, boolean fromIme, @Nullable ImeTracker.Token statsToken) {
        if ((types & WindowInsets.Type.ime()) != 0) {
            Log.d(TAG, "hide(ime(), fromIme=" + fromIme + ")");
            if (statsToken == null) {
                statsToken = ImeTracker.forLogging().onStart(2, 5, 28, this.mHost.isHandlingPointerEvent());
            }
        }
        if (fromIme) {
            ImeTracing.getInstance().triggerClientDump("InsetsController#hide", this.mHost.getInputMethodManager(), null);
            Trace.asyncTraceBegin(8L, "IC.hideRequestFromIme", 0);
        } else {
            Trace.asyncTraceBegin(8L, "IC.hideRequestFromApi", 0);
        }
        int typesReady = 0;
        boolean hasImeRequestedHidden = false;
        boolean hadPendingImeControlRequest = this.mPendingImeControlRequest != null;
        for (int type = 1; type <= 512; type <<= 1) {
            boolean requestedVisible;
            boolean isImeAnimation;
            if ((types & type) == 0) continue;
            boolean bl = isImeAnimation = type == WindowInsets.Type.ime();
            if (Flags.refactorInsetsController() && isImeAnimation && (this.mRequestedVisibleTypes & WindowInsets.Type.ime()) == 0) {
                ImeTracker.forLogging().onCancelled(statsToken, 65);
                continue;
            }
            int animationType = this.getAnimationType(type);
            boolean bl2 = requestedVisible = (type & this.mRequestedVisibleTypes) != 0;
            if (this.mPendingImeControlRequest != null && !requestedVisible) {
                this.mPendingImeControlRequest.types &= ~type;
                if (this.mPendingImeControlRequest.types == 0) {
                    this.abortPendingImeControlRequest();
                }
            }
            if (!Flags.refactorInsetsController() && isImeAnimation && !requestedVisible && animationType == -1) {
                hasImeRequestedHidden = true;
                if (hadPendingImeControlRequest || this.getImeSourceConsumer().isRequestedVisibleAwaitingControl()) {
                    this.getImeSourceConsumer().requestHide(fromIme, statsToken);
                }
            }
            if (!requestedVisible && animationType == -1 || animationType == 1 || animationType == 2 && this.mIsPredictiveBackImeHideAnimInProgress) {
                if (!isImeAnimation) continue;
                ImeTracker.forLogging().onCancelled(statsToken, 32);
                continue;
            }
            if (isImeAnimation) {
                ImeTracker.forLogging().onProgress(statsToken, 32);
            }
            typesReady |= type;
        }
        if (hasImeRequestedHidden && this.mPendingImeControlRequest != null) {
            this.handlePendingControlRequest(statsToken);
            if (!Flags.refactorInsetsController()) {
                this.getImeSourceConsumer().removeSurface();
            }
        }
        this.applyAnimation(typesReady, false, fromIme, false, statsToken);
    }

    @Override
    public void controlWindowInsetsAnimation(int types, long durationMillis, @Nullable Interpolator interpolator2, @Nullable CancellationSignal cancellationSignal, @NonNull WindowInsetsAnimationControlListener listener) {
        this.controlWindowInsetsAnimation(types, cancellationSignal, listener, false, durationMillis, interpolator2, 2, false);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void controlWindowInsetsAnimation(int types, @Nullable CancellationSignal cancellationSignal, WindowInsetsAnimationControlListener listener, boolean fromIme, final long durationMs, final @Nullable Interpolator interpolator2, int animationType, boolean fromPredictiveBack) {
        if ((this.mState.calculateUncontrollableInsetsFromFrame(this.mFrame) & types) != 0 || fromPredictiveBack && (this.mRequestedVisibleTypes & WindowInsets.Type.ime()) == 0) {
            listener.onCancelled(null);
            return;
        }
        if (fromIme) {
            ImeTracing.getInstance().triggerClientDump("InsetsController#controlWindowInsetsAnimation", this.mHost.getInputMethodManager(), null);
        }
        InsetsAnimationSpec spec = new InsetsAnimationSpec(){

            @Override
            public long getDurationMs(boolean hasZeroInsetsIme) {
                return durationMs;
            }

            @Override
            public Interpolator getInsetsInterpolator(boolean hasZeroInsetsIme) {
                return interpolator2;
            }
        };
        this.controlAnimationUnchecked(types, cancellationSignal, listener, this.mFrame, fromIme, spec, animationType, this.getLayoutInsetsDuringAnimationMode(types, fromPredictiveBack), false, null, fromPredictiveBack);
    }

    private void controlAnimationUnchecked(int types, @Nullable CancellationSignal cancellationSignal, WindowInsetsAnimationControlListener listener, @Nullable Rect frame, boolean fromIme, InsetsAnimationSpec insetsAnimationSpec, int animationType, int layoutInsetsDuringAnimation, boolean useInsetsAnimationThread, @Nullable ImeTracker.Token statsToken, boolean fromPredictiveBack) {
        boolean visible;
        boolean bl = visible = layoutInsetsDuringAnimation == 0;
        if (Flags.refactorInsetsController() && !fromPredictiveBack && !visible && (types & WindowInsets.Type.ime()) != 0 && (this.mRequestedVisibleTypes & WindowInsets.Type.ime()) != 0) {
            this.mHost.getInputMethodManager().getImeOnBackInvokedDispatcher().preliminaryClear();
        }
        this.setRequestedVisibleTypes(visible ? types : 0, types);
        this.controlAnimationUncheckedInner(types, cancellationSignal, listener, frame, fromIme, insetsAnimationSpec, animationType, layoutInsetsDuringAnimation, useInsetsAnimationThread, statsToken, fromPredictiveBack);
        this.reportRequestedVisibleTypes(statsToken);
    }

    private void controlAnimationUncheckedInner(int types, @Nullable CancellationSignal cancellationSignal, WindowInsetsAnimationControlListener listener, @Nullable Rect frame, boolean fromIme, InsetsAnimationSpec insetsAnimationSpec, int animationType, int layoutInsetsDuringAnimation, boolean useInsetsAnimationThread, @Nullable ImeTracker.Token statsToken, boolean fromPredictiveBack) {
        int typesReady;
        Pair<Integer, Constable> typesReadyPair;
        if ((types & this.mTypesBeingCancelled) != 0) {
            boolean monitoredAnimation;
            boolean bl = monitoredAnimation = animationType == 0 || animationType == 1;
            if (monitoredAnimation && (types & WindowInsets.Type.ime()) != 0) {
                if (animationType == 0) {
                    ImeTracker.forLatency().onShowCancelled(statsToken, 40, ActivityThread::currentApplication);
                } else {
                    ImeTracker.forLatency().onHideCancelled(statsToken, 40, ActivityThread::currentApplication);
                }
                ImeTracker.forLogging().onCancelled(statsToken, 33);
            }
            throw new IllegalStateException("Cannot start a new insets animation of " + WindowInsets.Type.toString(types) + " while an existing " + WindowInsets.Type.toString(this.mTypesBeingCancelled) + " is being cancelled.");
        }
        ImeTracker.forLogging().onProgress(statsToken, 33);
        if (types == 0) {
            listener.onCancelled(null);
            Trace.asyncTraceEnd(8L, "IC.showRequestFromApi", 0);
            Trace.asyncTraceEnd(8L, "IC.showRequestFromApiToImeReady", 0);
            ImeTracker.forLogging().onFailed(statsToken, 33);
            return;
        }
        this.mLastStartedAnimTypes |= types;
        SparseArray<InsetsSourceControl> controls = new SparseArray<InsetsSourceControl>();
        if (Flags.refactorInsetsController()) {
            typesReadyPair = this.collectSourceControlsV2(types, controls);
            typesReady = (Integer)typesReadyPair.first;
            if (animationType == 2) {
                int typesWithoutLeash = (Integer)typesReadyPair.second;
                if ((types & WindowInsets.Type.ime()) != 0 && (types & typesWithoutLeash) != 0) {
                    PendingControlRequest request;
                    this.mPendingImeControlRequest = request = new PendingControlRequest(types, listener, insetsAnimationSpec, animationType, 0, cancellationSignal, false);
                    this.mHandler.postDelayed(this.mPendingControlTimeout, 2000L);
                    if (cancellationSignal != null) {
                        cancellationSignal.setOnCancelListener(() -> {
                            if (this.mPendingImeControlRequest == request) {
                                this.abortPendingImeControlRequest();
                            }
                        });
                    }
                }
                if (typesReady != types) {
                    return;
                }
            }
        } else {
            typesReadyPair = this.collectSourceControls(fromIme, types, controls, animationType, statsToken, fromPredictiveBack);
            typesReady = (Integer)typesReadyPair.first;
            boolean imeReady = (Boolean)typesReadyPair.second;
            if (!imeReady) {
                PendingControlRequest request;
                this.abortPendingImeControlRequest();
                this.mPendingImeControlRequest = request = new PendingControlRequest(types, listener, insetsAnimationSpec, animationType, layoutInsetsDuringAnimation, cancellationSignal, useInsetsAnimationThread);
                this.mHandler.postDelayed(this.mPendingControlTimeout, 2000L);
                if (cancellationSignal != null) {
                    cancellationSignal.setOnCancelListener(() -> {
                        if (this.mPendingImeControlRequest == request) {
                            this.abortPendingImeControlRequest();
                        }
                    });
                }
                InsetsController.releaseControls(controls);
                this.setRequestedVisibleTypes(this.mReportedRequestedVisibleTypes, types);
                Trace.asyncTraceEnd(8L, "IC.showRequestFromApi", 0);
                if (!fromIme) {
                    Trace.asyncTraceEnd(8L, "IC.showRequestFromApiToImeReady", 0);
                }
                return;
            }
        }
        if (typesReady == 0) {
            if (Flags.refactorInsetsController()) {
                Trace.asyncTraceEnd(8L, "IC.showRequestFromApi", 0);
                listener.onCancelled(null);
            } else {
                listener.onCancelled(null);
                Trace.asyncTraceEnd(8L, "IC.showRequestFromApi", 0);
                if (!fromIme) {
                    Trace.asyncTraceEnd(8L, "IC.showRequestFromApiToImeReady", 0);
                }
            }
            return;
        }
        if (Flags.refactorInsetsController()) {
            this.mCancelledForNewAnimationTypes = typesReady;
            this.cancelExistingControllers(typesReady);
            this.mCancelledForNewAnimationTypes = 0;
        } else {
            this.cancelExistingControllers(typesReady);
        }
        InsetsAnimationControlRunner runner = useInsetsAnimationThread ? new InsetsAnimationThreadControlRunner(controls, frame, this.mState, listener, typesReady, this, insetsAnimationSpec, animationType, layoutInsetsDuringAnimation, this.mHost.getTranslator(), this.mHost.getHandler(), statsToken) : new InsetsAnimationControlImpl(controls, frame, this.mState, listener, typesReady, this, this, insetsAnimationSpec, animationType, layoutInsetsDuringAnimation, this.mHost.getTranslator(), statsToken);
        for (int i = controls.size() - 1; i >= 0; --i) {
            InsetsSourceConsumer consumer = this.mSourceConsumers.get(controls.keyAt(i));
            if (consumer == null) continue;
            consumer.setSurfaceParamsApplier(runner.getSurfaceParamsApplier());
        }
        if ((typesReady & WindowInsets.Type.ime()) != 0) {
            ImeTracing.getInstance().triggerClientDump("InsetsAnimationControlImpl", this.mHost.getInputMethodManager(), null);
            if (animationType == 1) {
                ImeTracker.forLatency().onHidden(statsToken, ActivityThread::currentApplication);
            }
        }
        ImeTracker.forLogging().onProgress(statsToken, 39);
        this.mAnimatingTypes |= runner.getTypes();
        this.mHost.updateAnimatingTypes(this.mAnimatingTypes, null);
        this.mRunningAnimations.add(new RunningAnimation(runner, animationType));
        if (cancellationSignal != null) {
            cancellationSignal.setOnCancelListener(() -> this.cancelAnimation(runner, true));
        } else {
            Trace.asyncTraceBegin(8L, "IC.pendingAnim", 0);
        }
        this.onAnimationStateChanged(types, true);
        if (fromIme) {
            switch (animationType) {
                case 0: {
                    Trace.asyncTraceEnd(8L, "IC.showRequestFromIme", 0);
                    break;
                }
                case 1: {
                    Trace.asyncTraceEnd(8L, "IC.hideRequestFromIme", 0);
                }
            }
        } else if (animationType == 1) {
            Trace.asyncTraceEnd(8L, "IC.hideRequestFromApi", 0);
        }
    }

    static void releaseControls(SparseArray<InsetsSourceControl> controls) {
        for (int i = controls.size() - 1; i >= 0; --i) {
            controls.valueAt(i).release(SurfaceControl::release);
        }
    }

    @Override
    public void setSystemDrivenInsetsAnimationLoggingListener(@Nullable WindowInsetsAnimationControlListener listener) {
        this.mLoggingListener = listener;
    }

    private Pair<Integer, Boolean> collectSourceControls(boolean fromIme, int types, SparseArray<InsetsSourceControl> controls, int animationType, @Nullable ImeTracker.Token statsToken, boolean fromPredictiveBack) {
        ImeTracker.forLogging().onProgress(statsToken, 35);
        int typesReady = 0;
        boolean imeReady = true;
        for (int i = this.mSourceConsumers.size() - 1; i >= 0; --i) {
            InsetsSourceConsumer consumer = this.mSourceConsumers.valueAt(i);
            if ((consumer.getType() & types) == 0) continue;
            boolean show = animationType == 0 || animationType == 2 && (!fromPredictiveBack || !this.mHost.hasAnimationCallbacks());
            boolean canRun = true;
            if (show) {
                switch (consumer.requestShow(fromIme, statsToken)) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        imeReady = false;
                        break;
                    }
                    case 2: {
                        canRun = false;
                        this.setRequestedVisibleTypes(0, consumer.getType());
                    }
                }
            } else {
                consumer.requestHide(fromIme || fromPredictiveBack && this.mHost.hasAnimationCallbacks(), statsToken);
            }
            if (!canRun) continue;
            InsetsSourceControl control = consumer.getControl();
            if (control != null && (control.getLeash() != null || control.getId() == InsetsSource.ID_IME_CAPTION_BAR)) {
                controls.put(control.getId(), new InsetsSourceControl(control));
                typesReady |= consumer.getType();
                continue;
            }
            if (!fromIme) continue;
            Log.w(TAG, "collectSourceControls can't continue for type: ime, fromIme: true requires a control with a leash but we have " + (control == null ? "control: null" : "control: non-null and control.getLeash(): null"));
            ImeTracker.forLogging().onFailed(statsToken, 35);
        }
        return new Pair<Integer, Boolean>(typesReady, imeReady);
    }

    private Pair<Integer, Integer> collectSourceControlsV2(int types, SparseArray<InsetsSourceControl> controls) {
        int typesReady = 0;
        int typesWithoutLeash = 0;
        for (int i = this.mSourceConsumers.size() - 1; i >= 0; --i) {
            InsetsSourceControl control;
            InsetsSourceConsumer consumer = this.mSourceConsumers.valueAt(i);
            if ((consumer.getType() & types) == 0 || (control = consumer.getControl()) == null) continue;
            if (control.getLeash() != null || control.getId() == InsetsSource.ID_IME_CAPTION_BAR) {
                controls.put(control.getId(), new InsetsSourceControl(control));
                typesReady |= consumer.getType();
                continue;
            }
            typesWithoutLeash |= consumer.getType();
        }
        return new Pair<Integer, Integer>(typesReady, typesWithoutLeash);
    }

    private int getLayoutInsetsDuringAnimationMode(int types, boolean fromPredictiveBack) {
        if (fromPredictiveBack && !this.mHost.hasAnimationCallbacks()) {
            return 0;
        }
        return (this.mRequestedVisibleTypes & types) != types ? 0 : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelExistingControllers(int types) {
        int originalmTypesBeingCancelled = this.mTypesBeingCancelled;
        this.mTypesBeingCancelled |= types;
        try {
            for (int i = this.mRunningAnimations.size() - 1; i >= 0; --i) {
                InsetsAnimationControlRunner runner = this.mRunningAnimations.get((int)i).runner;
                if ((runner.getTypes() & types) == 0) continue;
                this.cancelAnimation(runner, true);
            }
            if ((types & WindowInsets.Type.ime()) != 0) {
                this.abortPendingImeControlRequest();
            }
        }
        finally {
            this.mTypesBeingCancelled = originalmTypesBeingCancelled;
        }
    }

    private void abortPendingImeControlRequest() {
        if (this.mPendingImeControlRequest != null) {
            this.mPendingImeControlRequest.listener.onCancelled(null);
            this.mPendingImeControlRequest = null;
            this.mHandler.removeCallbacks(this.mPendingControlTimeout);
        }
    }

    @Override
    @VisibleForTesting
    public void notifyFinished(InsetsAnimationControlRunner runner, boolean shown) {
        this.setRequestedVisibleTypes(shown ? runner.getTypes() : 0, runner.getTypes());
        this.cancelAnimation(runner, false);
        if (runner.getAnimationType() == 3) {
            return;
        }
        ImeTracker.Token statsToken = runner.getStatsToken();
        if (runner.getAnimationType() == 2) {
            ImeTracker.forLogging().onUserFinished(statsToken, shown);
        } else if (shown) {
            ImeTracker.forLogging().onProgress(statsToken, 41);
            ImeTracker.forLogging().onShown(statsToken);
        } else if (!Flags.refactorInsetsController()) {
            ImeTracker.forLogging().onProgress(statsToken, 42);
            ImeTracker.forLogging().onHidden(statsToken);
        }
        this.reportRequestedVisibleTypes(null);
    }

    @Override
    public void applySurfaceParams(SyncRtSurfaceTransactionApplier.SurfaceParams ... params) {
        this.mHost.applySurfaceParams(params);
    }

    void notifyControlRevoked(InsetsSourceConsumer consumer) {
        int type = consumer.getType();
        for (int i = this.mRunningAnimations.size() - 1; i >= 0; --i) {
            InsetsAnimationControlRunner runner = this.mRunningAnimations.get((int)i).runner;
            runner.notifyControlRevoked(type);
            if (runner.getControllingTypes() != 0) continue;
            this.cancelAnimation(runner, true);
        }
        if (type == WindowInsets.Type.ime()) {
            this.abortPendingImeControlRequest();
        }
        if (consumer.getType() != WindowInsets.Type.ime()) {
            this.mSourceConsumers.remove(consumer.getId());
        }
    }

    private void cancelAnimation(InsetsAnimationControlRunner runner, boolean invokeCallback) {
        if (invokeCallback) {
            ImeTracker.forLogging().onCancelled(runner.getStatsToken(), 40);
            runner.cancel();
        } else {
            ImeTracker.forLogging().onProgress(runner.getStatsToken(), 40);
        }
        int removedTypes = 0;
        for (int i = this.mRunningAnimations.size() - 1; i >= 0; --i) {
            RunningAnimation runningAnimation = this.mRunningAnimations.get(i);
            if (runningAnimation.runner != runner) continue;
            this.mRunningAnimations.remove(i);
            removedTypes = runner.getTypes();
            if (invokeCallback) {
                this.dispatchAnimationEnd(runningAnimation.runner.getAnimation());
                break;
            }
            if (!Flags.refactorInsetsController() || (removedTypes & WindowInsets.Type.ime()) == 0 || runner.getAnimationType() != 1 || this.mHost == null) break;
            this.reportRequestedVisibleTypes(!Flags.reportAnimatingInsetsTypes() ? runner.getStatsToken() : null);
            this.mHost.getInputMethodManager().removeImeSurface(this.mHost.getWindowToken());
            break;
        }
        if (removedTypes > 0) {
            this.mAnimatingTypes &= ~removedTypes;
            if (this.mHost != null) {
                boolean dispatchStatsToken = Flags.reportAnimatingInsetsTypes() && (removedTypes & WindowInsets.Type.ime()) != 0 && runner.getAnimationType() == 1;
                this.mHost.updateAnimatingTypes(this.mAnimatingTypes, dispatchStatsToken ? runner.getStatsToken() : null);
            }
        }
        this.onAnimationStateChanged(removedTypes, false);
    }

    void onAnimationStateChanged(int types, boolean running) {
        boolean insetsChanged = false;
        for (int i = this.mSourceConsumers.size() - 1; i >= 0; --i) {
            InsetsSourceConsumer consumer = this.mSourceConsumers.valueAt(i);
            if ((consumer.getType() & types) == 0) continue;
            insetsChanged |= consumer.onAnimationStateChanged(running);
        }
        if (insetsChanged) {
            this.notifyVisibilityChanged();
        }
    }

    private void applyLocalVisibilityOverride() {
        for (int i = this.mSourceConsumers.size() - 1; i >= 0; --i) {
            InsetsSourceConsumer consumer = this.mSourceConsumers.valueAt(i);
            consumer.applyLocalVisibilityOverride();
        }
    }

    int getCancelledForNewAnimationTypes() {
        return this.mCancelledForNewAnimationTypes;
    }

    @VisibleForTesting
    @NonNull
    public InsetsSourceConsumer getSourceConsumer(int id2, int type) {
        InsetsSourceConsumer consumer = this.mSourceConsumers.get(id2);
        if (consumer != null) {
            return consumer;
        }
        if (type == WindowInsets.Type.ime() && this.mImeSourceConsumer != null) {
            this.mSourceConsumers.remove(this.mImeSourceConsumer.getId());
            consumer = this.mImeSourceConsumer;
            consumer.setId(id2);
        } else {
            consumer = this.mConsumerCreator.apply(this, id2, type);
        }
        this.mSourceConsumers.put(id2, consumer);
        return consumer;
    }

    @VisibleForTesting
    @NonNull
    public InsetsSourceConsumer getImeSourceConsumer() {
        return this.mImeSourceConsumer;
    }

    void notifyVisibilityChanged() {
        this.mHost.notifyInsetsChanged();
    }

    public void updateCompatSysUiVisibility() {
        if (this.mCompatSysUiVisibilityStaled) {
            this.mCompatSysUiVisibilityStaled = false;
            this.mHost.updateCompatSysUiVisibility(this.mVisibleTypes, this.mRequestedVisibleTypes, this.mControllableTypes | ~this.mExistingTypes);
        }
    }

    public void onWindowFocusGained(boolean hasViewFocused) {
        this.mImeSourceConsumer.onWindowFocusGained(hasViewFocused);
    }

    public void onWindowFocusLost() {
        this.mImeSourceConsumer.onWindowFocusLost();
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public int getAnimationType(int type) {
        for (int i = this.mRunningAnimations.size() - 1; i >= 0; --i) {
            InsetsAnimationControlRunner runner = this.mRunningAnimations.get((int)i).runner;
            if (!runner.controlsType(type)) continue;
            return this.mRunningAnimations.get((int)i).type;
        }
        return -1;
    }

    boolean hasSurfaceAnimation(int type) {
        for (int i = this.mRunningAnimations.size() - 1; i >= 0; --i) {
            InsetsAnimationControlRunner runner = this.mRunningAnimations.get((int)i).runner;
            if (!runner.controlsType(type) || !runner.willUpdateSurface()) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void setRequestedVisibleTypes(int visibleTypes, int mask) {
        int requestedVisibleTypes = this.mRequestedVisibleTypes & ~mask | visibleTypes & mask;
        if (this.mRequestedVisibleTypes != requestedVisibleTypes) {
            if (Flags.refactorInsetsController() && (this.mRequestedVisibleTypes & WindowInsets.Type.ime()) == 0 && (requestedVisibleTypes & WindowInsets.Type.ime()) != 0) {
                this.getHost().getInputMethodManager().getImeOnBackInvokedDispatcher().undoPreliminaryClear();
            }
            ProtoLog.d(ViewProtoLogGroups.IME_INSETS_CONTROLLER, "Setting requestedVisibleTypes to %d (was %d)", requestedVisibleTypes, this.mRequestedVisibleTypes);
            this.mRequestedVisibleTypes = requestedVisibleTypes;
        }
    }

    public int computeUserAnimatingTypes() {
        int animatingTypes = 0;
        for (int i = 0; i < this.mRunningAnimations.size(); ++i) {
            if (this.mRunningAnimations.get((int)i).runner.getAnimationType() != 2) continue;
            animatingTypes |= this.mRunningAnimations.get((int)i).runner.getTypes();
        }
        return animatingTypes;
    }

    private void reportRequestedVisibleTypes(@Nullable ImeTracker.Token statsToken) {
        InsetsSourceControl control;
        int typesToReport = Flags.refactorInsetsController() ? (Flags.reportAnimatingInsetsTypes() ? this.mRequestedVisibleTypes : this.mRequestedVisibleTypes | this.mAnimatingTypes & WindowInsets.Type.ime()) : this.mRequestedVisibleTypes;
        if (typesToReport != this.mReportedRequestedVisibleTypes) {
            int diff = typesToReport ^ this.mReportedRequestedVisibleTypes;
            if (WindowInsets.Type.hasCompatSystemBars(diff)) {
                this.mCompatSysUiVisibilityStaled = true;
            }
            if (Flags.refactorInsetsController()) {
                ImeTracker.forLogging().onProgress(statsToken, 48);
                if (Flags.reportAnimatingInsetsTypes() && (typesToReport & WindowInsets.Type.ime()) == 0) {
                    statsToken = null;
                }
            }
            this.mReportedRequestedVisibleTypes = this.mRequestedVisibleTypes;
            this.mHost.updateRequestedVisibleTypes(this.mReportedRequestedVisibleTypes, statsToken);
        } else if (Flags.refactorInsetsController() && (typesToReport & WindowInsets.Type.ime()) != 0 && this.mImeSourceConsumer != null && ((control = this.mImeSourceConsumer.getControl()) == null || control.getLeash() == null)) {
            ImeTracker.forLogging().onCancelled(statsToken, 48);
        }
        this.updateCompatSysUiVisibility();
    }

    @VisibleForTesting
    public void applyAnimation(int types, boolean show, boolean fromIme, boolean skipsCallbacks, @Nullable ImeTracker.Token statsToken) {
        InsetsSourceControl imeControl;
        boolean skipsAnim = false;
        if ((types & WindowInsets.Type.ime()) != 0 && (imeControl = this.mImeSourceConsumer.getControl()) != null) {
            skipsAnim = imeControl.getAndClearSkipAnimationOnce() && show && this.mImeSourceConsumer.hasViewFocusWhenWindowFocusGain();
        }
        this.applyAnimation(types, show, fromIme, skipsAnim, skipsCallbacks, statsToken);
    }

    @VisibleForTesting
    public void applyAnimation(int types, boolean show, boolean fromIme, boolean skipsAnim, boolean skipsCallbacks, @Nullable ImeTracker.Token statsToken) {
        if (types == 0) {
            Trace.asyncTraceEnd(8L, "IC.showRequestFromApi", 0);
            if (!Flags.refactorInsetsController() && !fromIme) {
                Trace.asyncTraceEnd(8L, "IC.showRequestFromApiToImeReady", 0);
            }
            return;
        }
        boolean hasAnimationCallbacks = this.mHost.hasAnimationCallbacks();
        InternalAnimationControlListener listener = new InternalAnimationControlListener(show, hasAnimationCallbacks, types, this.mHost.getSystemBarsBehavior(), skipsAnim || this.mAnimationsDisabled, this.mHost.dipToPx(-80), this.mLoggingListener, this.mJankContext);
        this.controlAnimationUnchecked(types, null, listener, null, fromIme, listener, show ? 0 : 1, show ? 0 : 1, !hasAnimationCallbacks || skipsCallbacks, statsToken, false);
    }

    @VisibleForTesting
    public void cancelExistingAnimations() {
        this.cancelExistingControllers(WindowInsets.Type.all());
    }

    void dump(String prefix, PrintWriter pw) {
        String innerPrefix = prefix + "    ";
        pw.println(prefix + "InsetsController:");
        this.mState.dump(innerPrefix, pw);
        pw.println(innerPrefix + "mIsPredictiveBackImeHideAnimInProgress=" + this.mIsPredictiveBackImeHideAnimInProgress);
    }

    void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        this.mState.dumpDebug(proto, 0x10B00000001L);
        for (int i = this.mRunningAnimations.size() - 1; i >= 0; --i) {
            InsetsAnimationControlRunner runner = this.mRunningAnimations.get((int)i).runner;
            runner.dumpDebug(proto, 0x20B00000002L);
        }
        proto.end(token);
    }

    @Override
    @VisibleForTesting
    public <T extends InsetsAnimationControlRunner & InternalInsetsAnimationController> void startAnimation(T runner, WindowInsetsAnimationControlListener listener, int types, WindowInsetsAnimation animation, WindowInsetsAnimation.Bounds bounds) {
        this.mHost.dispatchWindowInsetsAnimationPrepare(animation);
        this.mHost.addOnPreDrawRunnable(() -> {
            if (((WindowInsetsAnimationController)((Object)runner)).isCancelled()) {
                return;
            }
            Trace.asyncTraceBegin(8L, "InsetsAnimation: " + WindowInsets.Type.toString(types), types);
            for (int i = this.mRunningAnimations.size() - 1; i >= 0; --i) {
                RunningAnimation runningAnimation = this.mRunningAnimations.get(i);
                if (runningAnimation.runner != runner) continue;
                runningAnimation.startDispatched = true;
            }
            Trace.asyncTraceEnd(8L, "IC.pendingAnim", 0);
            this.mHost.dispatchWindowInsetsAnimationStart(animation, bounds);
            this.mStartingAnimation = true;
            if (runner.getAnimationType() == 2) {
                ImeTracker.forLogging().onDispatched(runner.getStatsToken());
            }
            ((InternalInsetsAnimationController)((Object)runner)).setReadyDispatched(true);
            listener.onReady((WindowInsetsAnimationController)((Object)runner), types);
            this.mStartingAnimation = false;
        });
    }

    @VisibleForTesting
    public void dispatchAnimationEnd(WindowInsetsAnimation animation) {
        Trace.asyncTraceEnd(8L, "InsetsAnimation: " + WindowInsets.Type.toString(animation.getTypeMask()), animation.getTypeMask());
        this.mHost.dispatchWindowInsetsAnimationEnd(animation);
    }

    @Override
    @VisibleForTesting
    public void scheduleApplyChangeInsets(InsetsAnimationControlRunner runner) {
        if (this.mStartingAnimation || runner.getAnimationType() == 2) {
            this.mAnimCallback.run();
            this.mAnimCallbackScheduled = false;
            return;
        }
        if (!this.mAnimCallbackScheduled) {
            this.mHost.postInsetsAnimationCallback(this.mAnimCallback);
            this.mAnimCallbackScheduled = true;
        }
    }

    @Override
    public void setSystemBarsAppearance(int appearance, int mask) {
        this.mAppearanceControlled |= mask;
        this.mHost.setSystemBarsAppearance(appearance, mask);
    }

    @Override
    public void setSystemBarsAppearanceFromResource(int appearance, int mask) {
        this.mAppearanceFromResource = this.mAppearanceFromResource & ~mask | appearance & mask;
        this.mHost.setSystemBarsAppearance(appearance, mask & ~this.mAppearanceControlled);
    }

    @Override
    public int getSystemBarsAppearance() {
        return this.mHost.getSystemBarsAppearance() & this.mAppearanceControlled | this.mAppearanceFromResource & ~this.mAppearanceControlled;
    }

    public int getAppearanceControlled() {
        return this.mAppearanceControlled;
    }

    @Override
    public void setImeCaptionBarInsetsHeight(int height) {
        Rect newFrame = new Rect(this.mFrame.left, this.mFrame.bottom - height, this.mFrame.right, this.mFrame.bottom);
        InsetsSource source = this.mState.peekSource(InsetsSource.ID_IME_CAPTION_BAR);
        if (this.mImeCaptionBarInsetsHeight != height || source != null && !newFrame.equals(source.getFrame())) {
            this.mImeCaptionBarInsetsHeight = height;
            if (this.mImeCaptionBarInsetsHeight != 0) {
                this.mState.getOrCreateSource(InsetsSource.ID_IME_CAPTION_BAR, WindowInsets.Type.captionBar()).setFrame(newFrame);
                this.getSourceConsumer(InsetsSource.ID_IME_CAPTION_BAR, WindowInsets.Type.captionBar()).setControl(new InsetsSourceControl(InsetsSource.ID_IME_CAPTION_BAR, WindowInsets.Type.captionBar(), null, false, new Point(), Insets.NONE), new int[1], new int[1], new int[1], new int[1]);
            } else {
                this.mState.removeSource(InsetsSource.ID_IME_CAPTION_BAR);
                InsetsSourceConsumer sourceConsumer = this.mSourceConsumers.get(InsetsSource.ID_IME_CAPTION_BAR);
                if (sourceConsumer != null) {
                    sourceConsumer.setControl(null, new int[1], new int[1], new int[1], new int[1]);
                }
            }
            this.mHost.notifyInsetsChanged();
        }
    }

    @Override
    public void setSystemBarsBehavior(int behavior) {
        this.mBehaviorControlled = true;
        this.mHost.setSystemBarsBehavior(behavior);
    }

    @Override
    public int getSystemBarsBehavior() {
        if (!this.mBehaviorControlled) {
            return 1;
        }
        return this.mHost.getSystemBarsBehavior();
    }

    public boolean isBehaviorControlled() {
        return this.mBehaviorControlled;
    }

    @Override
    public void setAnimationsDisabled(boolean disable) {
        this.mAnimationsDisabled = disable;
    }

    private int calculateControllableTypes() {
        int result = 0;
        for (int i = this.mSourceConsumers.size() - 1; i >= 0; --i) {
            InsetsSourceConsumer consumer = this.mSourceConsumers.valueAt(i);
            InsetsSource source = this.mState.peekSource(consumer.getId());
            if (consumer.getControl() == null || source == null) continue;
            result |= consumer.getType();
        }
        return result & ~this.mState.calculateUncontrollableInsetsFromFrame(this.mFrame);
    }

    private int invokeControllableInsetsChangedListeners() {
        this.mLastStartedAnimTypes = 0;
        int types = this.calculateControllableTypes();
        int size = this.mControllableInsetsChangedListeners.size();
        for (int i = 0; i < size; ++i) {
            this.mControllableInsetsChangedListeners.get(i).onControllableInsetsChanged(this, types);
        }
        return this.mLastStartedAnimTypes;
    }

    @Override
    public void addOnControllableInsetsChangedListener(WindowInsetsController.OnControllableInsetsChangedListener listener) {
        Objects.requireNonNull(listener);
        this.mControllableInsetsChangedListeners.add(listener);
        listener.onControllableInsetsChanged(this, this.calculateControllableTypes());
    }

    @Override
    public void removeOnControllableInsetsChangedListener(WindowInsetsController.OnControllableInsetsChangedListener listener) {
        Objects.requireNonNull(listener);
        this.mControllableInsetsChangedListeners.remove(listener);
    }

    @Override
    public void releaseSurfaceControlFromRt(SurfaceControl sc) {
        this.mHost.releaseSurfaceControlFromRt(sc);
    }

    @Override
    public void reportPerceptible(int types, boolean perceptible) {
        int size = this.mSourceConsumers.size();
        for (int i = 0; i < size; ++i) {
            InsetsSourceConsumer consumer = this.mSourceConsumers.valueAt(i);
            if ((consumer.getType() & types) == 0) continue;
            consumer.onPerceptible(perceptible);
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public Host getHost() {
        return this.mHost;
    }

    public static interface Host {
        public Handler getHandler();

        public void notifyInsetsChanged();

        public void dispatchWindowInsetsAnimationPrepare(@NonNull WindowInsetsAnimation var1);

        public WindowInsetsAnimation.Bounds dispatchWindowInsetsAnimationStart(@NonNull WindowInsetsAnimation var1, @NonNull WindowInsetsAnimation.Bounds var2);

        public WindowInsets dispatchWindowInsetsAnimationProgress(@NonNull WindowInsets var1, @NonNull List<WindowInsetsAnimation> var2);

        public void dispatchWindowInsetsAnimationEnd(@NonNull WindowInsetsAnimation var1);

        public void applySurfaceParams(SyncRtSurfaceTransactionApplier.SurfaceParams ... var1);

        default public void updateCompatSysUiVisibility(int visibleTypes, int requestedVisibleTypes, int controllableTypes) {
        }

        public void updateRequestedVisibleTypes(int var1, @Nullable ImeTracker.Token var2);

        public boolean hasAnimationCallbacks();

        public void setSystemBarsAppearance(int var1, int var2);

        public int getSystemBarsAppearance();

        public void setSystemBarsBehavior(int var1);

        public int getSystemBarsBehavior();

        public void releaseSurfaceControlFromRt(SurfaceControl var1);

        public void addOnPreDrawRunnable(Runnable var1);

        public void postInsetsAnimationCallback(Runnable var1);

        public InputMethodManager getInputMethodManager();

        @Nullable
        public String getRootViewTitle();

        @Nullable
        default public Context getRootViewContext() {
            return null;
        }

        public int dipToPx(int var1);

        @Nullable
        public IBinder getWindowToken();

        @Nullable
        default public CompatibilityInfo.Translator getTranslator() {
            return null;
        }

        default public void updateAnimatingTypes(int animatingTypes, @Nullable ImeTracker.Token statsToken) {
        }

        default public boolean isHandlingPointerEvent() {
            return false;
        }
    }

    private static class RunningAnimation {
        final InsetsAnimationControlRunner runner;
        final int type;
        boolean startDispatched;

        RunningAnimation(InsetsAnimationControlRunner runner, int type) {
            this.runner = runner;
            this.type = type;
        }
    }

    private static class PendingControlRequest {
        int types;
        final WindowInsetsAnimationControlListener listener;
        final InsetsAnimationSpec mInsetsAnimationSpec;
        final int animationType;
        final int layoutInsetsDuringAnimation;
        final CancellationSignal cancellationSignal;
        final boolean useInsetsAnimationThread;

        PendingControlRequest(int types, WindowInsetsAnimationControlListener listener, InsetsAnimationSpec insetsAnimationSpec, int animationType, int layoutInsetsDuringAnimation, CancellationSignal cancellationSignal, boolean useInsetsAnimationThread) {
            this.types = types;
            this.listener = listener;
            this.mInsetsAnimationSpec = insetsAnimationSpec;
            this.animationType = animationType;
            this.layoutInsetsDuringAnimation = layoutInsetsDuringAnimation;
            this.cancellationSignal = cancellationSignal;
            this.useInsetsAnimationThread = useInsetsAnimationThread;
        }
    }

    public static class InternalAnimationControlListener
    implements WindowInsetsAnimationControlListener,
    InsetsAnimationSpec {
        private WindowInsetsAnimationController mController;
        private ValueAnimator mAnimator;
        private final boolean mShow;
        private final boolean mHasAnimationCallbacks;
        private final int mRequestedTypes;
        private final int mBehavior;
        private final boolean mDisable;
        private final int mFloatingImeBottomInset;
        private final WindowInsetsAnimationControlListener mLoggingListener;
        private final ImeTracker.InputMethodJankContext mInputMethodJankContext;

        public InternalAnimationControlListener(boolean show, boolean hasAnimationCallbacks, int requestedTypes, int behavior, boolean disable, int floatingImeBottomInset, WindowInsetsAnimationControlListener loggingListener, @Nullable ImeTracker.InputMethodJankContext jankContext) {
            this.mShow = show;
            this.mHasAnimationCallbacks = hasAnimationCallbacks;
            this.mRequestedTypes = requestedTypes;
            this.mBehavior = behavior;
            this.mDisable = disable;
            this.mFloatingImeBottomInset = floatingImeBottomInset;
            this.mLoggingListener = loggingListener;
            this.mInputMethodJankContext = jankContext;
        }

        @Override
        public void onReady(WindowInsetsAnimationController controller, int types) {
            this.mController = controller;
            if (this.mLoggingListener != null) {
                this.mLoggingListener.onReady(controller, types);
            }
            if (this.mDisable) {
                this.onAnimationFinish();
                return;
            }
            boolean hasZeroInsetsIme = controller.hasZeroInsetsIme();
            this.mAnimator = ValueAnimator.ofFloat(0.0f, 1.0f);
            this.mAnimator.setDuration(controller.getDurationMs());
            this.mAnimator.setInterpolator(new LinearInterpolator());
            Insets hiddenInsets = controller.getHiddenStateInsets();
            hiddenInsets = hasZeroInsetsIme ? Insets.of(hiddenInsets.left, hiddenInsets.top, hiddenInsets.right, this.mFloatingImeBottomInset) : hiddenInsets;
            Insets start = this.mShow ? hiddenInsets : controller.getShownStateInsets();
            Insets end = this.mShow ? controller.getShownStateInsets() : hiddenInsets;
            Interpolator insetsInterpolator = controller.getInsetsInterpolator();
            Interpolator alphaInterpolator = this.getAlphaInterpolator();
            this.mAnimator.addUpdateListener(animation -> {
                float rawFraction = animation.getAnimatedFraction();
                float alphaFraction = this.mShow ? rawFraction : 1.0f - rawFraction;
                float insetsFraction = insetsInterpolator.getInterpolation(rawFraction);
                controller.setInsetsAndAlpha(sEvaluator.evaluate(insetsFraction, start, end), alphaInterpolator.getInterpolation(alphaFraction), rawFraction);
            });
            this.mAnimator.addListener(new AnimatorListenerAdapter(){

                @Override
                public void onAnimationStart(Animator animation) {
                    if (mInputMethodJankContext == null) {
                        return;
                    }
                    ImeTracker.forJank().onRequestAnimation(mInputMethodJankContext, this.getAnimationType(), !mHasAnimationCallbacks);
                }

                @Override
                public void onAnimationCancel(Animator animation) {
                    if (mInputMethodJankContext == null) {
                        return;
                    }
                    ImeTracker.forJank().onCancelAnimation(this.getAnimationType());
                }

                @Override
                public void onAnimationEnd(Animator animation) {
                    this.onAnimationFinish();
                    if (mInputMethodJankContext == null) {
                        return;
                    }
                    ImeTracker.forJank().onFinishAnimation(this.getAnimationType());
                }
            });
            this.mAnimator.start();
        }

        @Override
        public void onFinished(WindowInsetsAnimationController controller) {
            if (this.mLoggingListener != null) {
                this.mLoggingListener.onFinished(controller);
            }
        }

        @Override
        public void onCancelled(WindowInsetsAnimationController controller) {
            if (this.mAnimator != null) {
                this.mAnimator.cancel();
            }
            if (this.mLoggingListener != null) {
                this.mLoggingListener.onCancelled(controller);
            }
        }

        @Override
        public Interpolator getInsetsInterpolator(boolean hasZeroInsetsIme) {
            if ((this.mRequestedTypes & WindowInsets.Type.ime()) != 0) {
                if (this.mHasAnimationCallbacks && !hasZeroInsetsIme) {
                    return SYNC_IME_INTERPOLATOR;
                }
                if (this.mShow) {
                    return LINEAR_OUT_SLOW_IN_INTERPOLATOR;
                }
                return FAST_OUT_LINEAR_IN_INTERPOLATOR;
            }
            if (this.mBehavior == 2) {
                return SYSTEM_BARS_INSETS_INTERPOLATOR;
            }
            return input -> this.mShow ? 1.0f : 0.0f;
        }

        Interpolator getAlphaInterpolator() {
            if ((this.mRequestedTypes & WindowInsets.Type.ime()) != 0) {
                if (this.mHasAnimationCallbacks && !this.mController.hasZeroInsetsIme()) {
                    return input -> 1.0f;
                }
                if (this.mShow) {
                    return input -> Math.min(1.0f, 2.0f * input);
                }
                return FAST_OUT_LINEAR_IN_INTERPOLATOR;
            }
            if (this.mBehavior == 2) {
                return input -> 1.0f;
            }
            if (this.mShow) {
                return SYSTEM_BARS_ALPHA_INTERPOLATOR;
            }
            return SYSTEM_BARS_DIM_INTERPOLATOR;
        }

        protected void onAnimationFinish() {
            this.mController.finish(this.mShow);
        }

        @Override
        public long getDurationMs(boolean hasZeroInsetsIme) {
            if ((this.mRequestedTypes & WindowInsets.Type.ime()) != 0) {
                if (this.mHasAnimationCallbacks && !hasZeroInsetsIme) {
                    return 285L;
                }
                return 200L;
            }
            if (this.mBehavior == 2) {
                return this.mShow ? 275L : 340L;
            }
            return this.mShow ? 500L : 1500L;
        }

        private int getAnimationType() {
            return this.mShow ? 0 : 1;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AnimationType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface LayoutInsetsDuringAnimation {
    }
}

