/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.IBinder;
import android.os.Trace;
import android.util.proto.ProtoOutputStream;
import android.view.InsetsController;
import android.view.InsetsSourceConsumer;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.WindowInsets;
import android.view.inputmethod.Flags;
import android.view.inputmethod.ImeTracker;
import android.view.inputmethod.InputMethodManager;
import com.android.internal.inputmethod.ImeTracing;

public class ImeInsetsSourceConsumer
extends InsetsSourceConsumer {
    private boolean mHasPendingRequest;
    private boolean mIsRequestedVisibleAwaitingLeash;

    public ImeInsetsSourceConsumer(int id2, InsetsState state, InsetsController controller) {
        super(id2, WindowInsets.Type.ime(), state, controller);
    }

    @Override
    public boolean onAnimationStateChanged(boolean running) {
        if (Flags.refactorInsetsController()) {
            return super.onAnimationStateChanged(running);
        }
        if (!running) {
            ImeTracing.getInstance().triggerClientDump("ImeInsetsSourceConsumer#onAnimationFinished", this.mController.getHost().getInputMethodManager(), null);
        }
        boolean insetsChanged = false;
        if (Flags.predictiveBackIme() && !running && this.isShowRequested() && this.mAnimationState == 2) {
            insetsChanged |= this.applyLocalVisibilityOverride();
        }
        insetsChanged |= super.onAnimationStateChanged(running);
        if (running && !this.isShowRequested() && this.mController.isPredictiveBackImeHideAnimInProgress()) {
            insetsChanged |= this.applyLocalVisibilityOverride();
        }
        if (!this.isShowRequested()) {
            this.mIsRequestedVisibleAwaitingLeash = false;
            if (!running && !this.mHasPendingRequest) {
                ImeTracker.Token statsToken = ImeTracker.forLogging().onStart(2, 5, 51, this.mController.getHost().isHandlingPointerEvent());
                this.notifyHidden(statsToken);
                this.removeSurface();
            }
        }
        this.mHasPendingRequest = false;
        return insetsChanged;
    }

    @Override
    public void onWindowFocusGained(boolean hasViewFocus) {
        super.onWindowFocusGained(hasViewFocus);
        if (!Flags.refactorInsetsController()) {
            this.getImm().registerImeConsumer(this);
            if ((this.mController.getRequestedVisibleTypes() & this.getType()) != 0 && !this.hasLeash()) {
                this.mIsRequestedVisibleAwaitingLeash = true;
            }
        }
    }

    @Override
    public void onWindowFocusLost() {
        super.onWindowFocusLost();
        if (!Flags.refactorInsetsController()) {
            this.getImm().unregisterImeConsumer(this);
            this.mIsRequestedVisibleAwaitingLeash = false;
        }
    }

    @Override
    public boolean applyLocalVisibilityOverride() {
        if (!Flags.refactorInsetsController()) {
            ImeTracing.getInstance().triggerClientDump("ImeInsetsSourceConsumer#applyLocalVisibilityOverride", this.mController.getHost().getInputMethodManager(), null);
        }
        return super.applyLocalVisibilityOverride();
    }

    @Override
    public int requestShow(boolean fromIme, @Nullable ImeTracker.Token statsToken) {
        if (!Flags.refactorInsetsController()) {
            if (fromIme) {
                ImeTracing.getInstance().triggerClientDump("ImeInsetsSourceConsumer#requestShow", this.mController.getHost().getInputMethodManager(), null);
            }
            this.onShowRequested();
            ImeTracker.forLogging().onProgress(statsToken, 36);
            if (!this.hasLeash()) {
                this.mIsRequestedVisibleAwaitingLeash = true;
            }
            if (fromIme || this.mState.isSourceOrDefaultVisible(this.getId(), this.getType()) && this.hasLeash()) {
                return 0;
            }
            return this.getImm().requestImeShow(this.mController.getHost().getWindowToken(), statsToken) ? 1 : 2;
        }
        return 2;
    }

    @Override
    void requestHide(boolean fromIme, @Nullable ImeTracker.Token statsToken) {
        if (!Flags.refactorInsetsController()) {
            if (!fromIme) {
                ImeTracker.Token notifyStatsToken = this.hasLeash() ? ImeTracker.forLogging().onStart(2, 5, 52, this.mController.getHost().isHandlingPointerEvent()) : statsToken;
                this.notifyHidden(notifyStatsToken);
            }
            if (this.mAnimationState == 1) {
                this.mHasPendingRequest = true;
            }
        }
    }

    private void notifyHidden(@NonNull ImeTracker.Token statsToken) {
        if (!Flags.refactorInsetsController()) {
            ImeTracker.forLogging().onProgress(statsToken, 38);
            this.getImm().notifyImeHidden(this.mController.getHost().getWindowToken(), statsToken);
            this.mIsRequestedVisibleAwaitingLeash = false;
            Trace.asyncTraceEnd(8L, "IC.hideRequestFromApi", 0);
        }
    }

    @Override
    public void removeSurface() {
        if (Flags.refactorInsetsController()) {
            super.removeSurface();
        } else {
            IBinder window = this.mController.getHost().getWindowToken();
            if (window != null) {
                this.getImm().removeImeSurface(window);
            }
        }
    }

    @Override
    public boolean setControl(@Nullable InsetsSourceControl control, int[] showTypes, int[] hideTypes, int[] cancelTypes, int[] transientTypes) {
        boolean hasLeash;
        if (Flags.refactorInsetsController()) {
            return super.setControl(control, showTypes, hideTypes, cancelTypes, transientTypes);
        }
        ImeTracing.getInstance().triggerClientDump("ImeInsetsSourceConsumer#setControl", this.mController.getHost().getInputMethodManager(), null);
        if (!super.setControl(control, showTypes, hideTypes, cancelTypes, transientTypes)) {
            return false;
        }
        if (control == null && !this.mIsRequestedVisibleAwaitingLeash) {
            this.mController.setRequestedVisibleTypes(0, this.getType());
            this.removeSurface();
        }
        boolean bl = hasLeash = control != null && control.getLeash() != null;
        if (hasLeash) {
            this.mIsRequestedVisibleAwaitingLeash = false;
        }
        return true;
    }

    @Override
    protected boolean isRequestedVisibleAwaitingControl() {
        return super.isRequestedVisibleAwaitingControl() || this.mIsRequestedVisibleAwaitingLeash;
    }

    private boolean hasLeash() {
        InsetsSourceControl control = this.getControl();
        return control != null && control.getLeash() != null;
    }

    @Override
    public void onPerceptible(boolean perceptible) {
        IBinder window;
        super.onPerceptible(perceptible);
        if (!Flags.refactorInsetsController() && (window = this.mController.getHost().getWindowToken()) != null) {
            this.getImm().reportPerceptible(window, perceptible);
        }
    }

    @Override
    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        super.dumpDebug(proto, 0x10B00000001L);
        proto.write(1133871366147L, this.mIsRequestedVisibleAwaitingLeash);
        proto.write(1133871366150L, this.mHasPendingRequest);
        proto.end(token);
    }

    public void onShowRequested() {
        if (this.mAnimationState == 2 || this.mController.isPredictiveBackImeHideAnimInProgress()) {
            this.mHasPendingRequest = true;
        }
    }

    private InputMethodManager getImm() {
        return this.mController.getHost().getInputMethodManager();
    }
}

