/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.Insets;
import android.util.Log;
import android.view.InsetsController;
import android.view.ViewRootImpl;
import android.view.WindowInsets;
import android.view.WindowInsetsAnimationControlListener;
import android.view.WindowInsetsAnimationController;
import android.view.animation.BackGestureInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.PathInterpolator;
import android.view.inputmethod.Flags;
import android.view.inputmethod.ImeTracker;
import android.window.BackEvent;
import android.window.OnBackAnimationCallback;
import java.io.PrintWriter;

public class ImeBackAnimationController
implements OnBackAnimationCallback {
    private static final String TAG = "ImeBackAnimationController";
    private static final int POST_COMMIT_DURATION_MS = 200;
    private static final int POST_COMMIT_CANCEL_DURATION_MS = 50;
    private static final float PEEK_FRACTION = 0.1f;
    private static final Interpolator BACK_GESTURE = new BackGestureInterpolator();
    private static final Interpolator EMPHASIZED_DECELERATE = new PathInterpolator(0.05f, 0.7f, 0.1f, 1.0f);
    private final InsetsController mInsetsController;
    private final ViewRootImpl mViewRoot;
    private WindowInsetsAnimationController mWindowInsetsAnimationController = null;
    private ValueAnimator mPostCommitAnimator = null;
    private float mLastProgress = 0.0f;
    private boolean mTriggerBack = false;
    private boolean mIsPreCommitAnimationInProgress = false;
    private int mStartRootScrollY = 0;

    public ImeBackAnimationController(ViewRootImpl viewRoot, InsetsController insetsController) {
        this.mInsetsController = insetsController;
        this.mViewRoot = viewRoot;
    }

    @Override
    public void onBackStarted(@NonNull BackEvent backEvent) {
        if (!this.isBackAnimationAllowed()) {
            Log.d(TAG, "onBackStarted -> not playing predictive back animation due to softinput mode adjustResize AND no animation callback registered");
            return;
        }
        if (this.isHideAnimationInProgress()) {
            return;
        }
        this.mIsPreCommitAnimationInProgress = true;
        if (this.mWindowInsetsAnimationController != null) {
            this.resetPostCommitAnimator();
            this.setPreCommitProgress(0.0f);
            return;
        }
        this.mInsetsController.controlWindowInsetsAnimation(WindowInsets.Type.ime(), null, new WindowInsetsAnimationControlListener(){

            @Override
            public void onReady(@NonNull WindowInsetsAnimationController controller, int types) {
                ImeBackAnimationController.this.mWindowInsetsAnimationController = controller;
                if (ImeBackAnimationController.this.isAdjustPan()) {
                    ImeBackAnimationController.this.mStartRootScrollY = ImeBackAnimationController.this.mViewRoot.mScrollY;
                }
                if (ImeBackAnimationController.this.mIsPreCommitAnimationInProgress) {
                    ImeBackAnimationController.this.setPreCommitProgress(ImeBackAnimationController.this.mLastProgress);
                } else {
                    ImeBackAnimationController.this.startPostCommitAnim(ImeBackAnimationController.this.mTriggerBack);
                }
            }

            @Override
            public void onFinished(@NonNull WindowInsetsAnimationController controller) {
                ImeBackAnimationController.this.reset();
            }

            @Override
            public void onCancelled(@Nullable WindowInsetsAnimationController controller) {
                ImeBackAnimationController.this.reset();
            }
        }, false, -1L, null, 2, true);
    }

    @Override
    public void onBackProgressed(@NonNull BackEvent backEvent) {
        this.mLastProgress = backEvent.getProgress();
        this.setPreCommitProgress(this.mLastProgress);
    }

    @Override
    public void onBackCancelled() {
        if (!this.isBackAnimationAllowed()) {
            return;
        }
        this.startPostCommitAnim(false);
    }

    @Override
    public void onBackInvoked() {
        if (!this.isBackAnimationAllowed() || !this.mIsPreCommitAnimationInProgress) {
            this.notifyHideIme();
        } else {
            this.startPostCommitAnim(true);
        }
        if (Flags.refactorInsetsController()) {
            this.mInsetsController.getHost().getInputMethodManager().getImeOnBackInvokedDispatcher().preliminaryClear();
        }
    }

    private void setPreCommitProgress(float progress) {
        if (this.isHideAnimationInProgress()) {
            return;
        }
        this.setInterpolatedProgress(BACK_GESTURE.getInterpolation(progress) * 0.1f);
    }

    private void setInterpolatedProgress(float progress) {
        if (this.mWindowInsetsAnimationController != null) {
            float hiddenY = this.mWindowInsetsAnimationController.getHiddenStateInsets().bottom;
            float shownY = this.mWindowInsetsAnimationController.getShownStateInsets().bottom;
            float imeHeight = shownY - hiddenY;
            int newY = (int)(imeHeight - progress * imeHeight);
            if (this.mStartRootScrollY != 0) {
                this.mViewRoot.setScrollY((int)((float)this.mStartRootScrollY * (1.0f - progress)));
            }
            this.mWindowInsetsAnimationController.setInsetsAndAlpha(Insets.of(0, 0, 0, newY), 1.0f, progress);
        }
    }

    private void startPostCommitAnim(final boolean triggerBack) {
        long duration;
        Interpolator interpolator2;
        this.mIsPreCommitAnimationInProgress = false;
        if (this.mWindowInsetsAnimationController == null || this.isHideAnimationInProgress()) {
            this.mTriggerBack = triggerBack;
            return;
        }
        this.mTriggerBack = triggerBack;
        float targetProgress = triggerBack ? 1.0f : 0.0f;
        this.mPostCommitAnimator = ValueAnimator.ofFloat(BACK_GESTURE.getInterpolation(this.mLastProgress) * 0.1f, targetProgress);
        if (triggerBack && this.mViewRoot.mView.hasWindowInsetsAnimationCallback() && this.mWindowInsetsAnimationController.getShownStateInsets().bottom != 0) {
            interpolator2 = InsetsController.SYNC_IME_INTERPOLATOR;
            duration = 285L;
        } else if (triggerBack) {
            interpolator2 = InsetsController.FAST_OUT_LINEAR_IN_INTERPOLATOR;
            duration = 200L;
        } else {
            interpolator2 = EMPHASIZED_DECELERATE;
            duration = 50L;
        }
        this.mPostCommitAnimator.setInterpolator(interpolator2);
        this.mPostCommitAnimator.setDuration(duration);
        this.mPostCommitAnimator.addUpdateListener(animation -> {
            if (this.mWindowInsetsAnimationController != null) {
                this.setInterpolatedProgress(((Float)animation.getAnimatedValue()).floatValue());
            } else {
                this.reset();
            }
        });
        this.mPostCommitAnimator.addListener(new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator animator2) {
                if (ImeBackAnimationController.this.mIsPreCommitAnimationInProgress) {
                    return;
                }
                if (ImeBackAnimationController.this.mWindowInsetsAnimationController != null) {
                    ImeBackAnimationController.this.mWindowInsetsAnimationController.finish(!triggerBack);
                }
                ImeBackAnimationController.this.reset();
            }
        });
        this.mPostCommitAnimator.start();
        if (triggerBack) {
            this.mInsetsController.setPredictiveBackImeHideAnimInProgress(true);
            this.notifyHideIme();
            this.mInsetsController.setRequestedVisibleTypes(0, WindowInsets.Type.ime());
            this.mInsetsController.onAnimationStateChanged(WindowInsets.Type.ime(), true);
        }
    }

    private void notifyHideIme() {
        ImeTracker.Token statsToken = ImeTracker.forLogging().onStart(2, 5, 52, true);
        this.mInsetsController.getHost().getInputMethodManager().notifyImeHidden(this.mInsetsController.getHost().getWindowToken(), statsToken);
    }

    private void reset() {
        this.mWindowInsetsAnimationController = null;
        this.resetPostCommitAnimator();
        this.mLastProgress = 0.0f;
        this.mTriggerBack = false;
        this.mIsPreCommitAnimationInProgress = false;
        this.mInsetsController.setPredictiveBackImeHideAnimInProgress(false);
        this.mStartRootScrollY = 0;
    }

    private void resetPostCommitAnimator() {
        if (this.mPostCommitAnimator != null) {
            this.mPostCommitAnimator.cancel();
            this.mPostCommitAnimator = null;
        }
    }

    private boolean isBackAnimationAllowed() {
        if (this.mViewRoot.mContext.getResources().getConfiguration().windowConfiguration.getWindowingMode() == 6) {
            return false;
        }
        return (this.mViewRoot.mWindowAttributes.softInputMode & 0xF0) != 16 || this.mViewRoot.mView != null && this.mViewRoot.mView.hasWindowInsetsAnimationCallback() || this.mViewRoot.mAttachInfo.mContentOnApplyWindowInsetsListener == null;
    }

    private boolean isAdjustPan() {
        return (this.mViewRoot.mWindowAttributes.softInputMode & 0xF0) == 32;
    }

    private boolean isHideAnimationInProgress() {
        return this.mPostCommitAnimator != null && this.mTriggerBack;
    }

    boolean isAnimationInProgress() {
        return this.mIsPreCommitAnimationInProgress || this.mWindowInsetsAnimationController != null;
    }

    public void dump(String prefix, PrintWriter writer) {
        String innerPrefix = prefix + "    ";
        writer.println(prefix + "ImeBackAnimationController:");
        writer.println(innerPrefix + "mLastProgress=" + this.mLastProgress);
        writer.println(innerPrefix + "mTriggerBack=" + this.mTriggerBack);
        writer.println(innerPrefix + "mIsPreCommitAnimationInProgress=" + this.mIsPreCommitAnimationInProgress);
        writer.println(innerPrefix + "mStartRootScrollY=" + this.mStartRootScrollY);
        writer.println(innerPrefix + "isBackAnimationAllowed=" + this.isBackAnimationAllowed());
        writer.println(innerPrefix + "isAdjustPan=" + this.isAdjustPan());
        writer.println(innerPrefix + "isHideAnimationInProgress=" + this.isHideAnimationInProgress());
    }
}

