/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IDisplayWindowListener
extends IInterface {
    public static final String DESCRIPTOR = "android.view.IDisplayWindowListener";

    public void onDisplayAdded(int var1) throws RemoteException;

    public void onDisplayConfigurationChanged(int var1, Configuration var2) throws RemoteException;

    public void onDisplayRemoved(int var1) throws RemoteException;

    public void onFixedRotationStarted(int var1, int var2) throws RemoteException;

    public void onFixedRotationFinished(int var1) throws RemoteException;

    public void onKeepClearAreasChanged(int var1, List<Rect> var2, List<Rect> var3) throws RemoteException;

    public void onDesktopModeEligibleChanged(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDisplayWindowListener {
        static final int TRANSACTION_onDisplayAdded = 1;
        static final int TRANSACTION_onDisplayConfigurationChanged = 2;
        static final int TRANSACTION_onDisplayRemoved = 3;
        static final int TRANSACTION_onFixedRotationStarted = 4;
        static final int TRANSACTION_onFixedRotationFinished = 5;
        static final int TRANSACTION_onKeepClearAreasChanged = 6;
        static final int TRANSACTION_onDesktopModeEligibleChanged = 7;

        public Stub() {
            this.attachInterface(this, IDisplayWindowListener.DESCRIPTOR);
        }

        public static IDisplayWindowListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IDisplayWindowListener.DESCRIPTOR);
            if (iin != null && iin instanceof IDisplayWindowListener) {
                return (IDisplayWindowListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onDisplayAdded";
                }
                case 2: {
                    return "onDisplayConfigurationChanged";
                }
                case 3: {
                    return "onDisplayRemoved";
                }
                case 4: {
                    return "onFixedRotationStarted";
                }
                case 5: {
                    return "onFixedRotationFinished";
                }
                case 6: {
                    return "onKeepClearAreasChanged";
                }
                case 7: {
                    return "onDesktopModeEligibleChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IDisplayWindowListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onDisplayAdded(_arg0);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    Configuration _arg1 = data.readTypedObject(Configuration.CREATOR);
                    data.enforceNoDataAvail();
                    this.onDisplayConfigurationChanged(_arg0, _arg1);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onDisplayRemoved(_arg0);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onFixedRotationStarted(_arg0, _arg1);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onFixedRotationFinished(_arg0);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    ArrayList<Rect> _arg1 = data.createTypedArrayList(Rect.CREATOR);
                    ArrayList<Rect> _arg2 = data.createTypedArrayList(Rect.CREATOR);
                    data.enforceNoDataAvail();
                    this.onKeepClearAreasChanged(_arg0, _arg1, _arg2);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onDesktopModeEligibleChanged(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 6;
        }

        private static class Proxy
        implements IDisplayWindowListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IDisplayWindowListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDisplayAdded(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDisplayWindowListener.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDisplayConfigurationChanged(int displayId, Configuration newConfig) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDisplayWindowListener.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeTypedObject(newConfig, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDisplayRemoved(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDisplayWindowListener.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFixedRotationStarted(int displayId, int newRotation) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDisplayWindowListener.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(newRotation);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFixedRotationFinished(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDisplayWindowListener.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onKeepClearAreasChanged(int displayId, List<Rect> restricted, List<Rect> unrestricted) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDisplayWindowListener.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeTypedList(restricted, 0);
                    _data.writeTypedList(unrestricted, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDesktopModeEligibleChanged(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDisplayWindowListener.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IDisplayWindowListener {
        @Override
        public void onDisplayAdded(int displayId) throws RemoteException {
        }

        @Override
        public void onDisplayConfigurationChanged(int displayId, Configuration newConfig) throws RemoteException {
        }

        @Override
        public void onDisplayRemoved(int displayId) throws RemoteException {
        }

        @Override
        public void onFixedRotationStarted(int displayId, int newRotation) throws RemoteException {
        }

        @Override
        public void onFixedRotationFinished(int displayId) throws RemoteException {
        }

        @Override
        public void onKeepClearAreasChanged(int displayId, List<Rect> restricted, List<Rect> unrestricted) throws RemoteException {
        }

        @Override
        public void onDesktopModeEligibleChanged(int displayId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

