/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.PointerIcon;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.inputmethod.ConnectionlessHandwritingCallback;
import android.view.inputmethod.CursorAnchorInfo;
import android.view.inputmethod.Flags;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;

public class HandwritingInitiator {
    private final int mHandwritingSlop;
    private final long mHandwritingTimeoutInMillis;
    private State mState;
    private final HandwritingAreaTracker mHandwritingAreasTracker = new HandwritingAreaTracker();
    @Nullable
    @VisibleForTesting
    public WeakReference<View> mConnectedView = null;
    private int mConnectionCount = 0;
    @Nullable
    @VisibleForTesting
    public WeakReference<View> mFocusedView = null;
    private final InputMethodManager mImm;
    private final int[] mTempLocation = new int[2];
    private final Rect mTempRect = new Rect();
    private final RectF mTempRectF = new RectF();
    private final Region mTempRegion = new Region();
    private final Matrix mTempMatrix = new Matrix();
    @Nullable
    private WeakReference<View> mCachedHoverTarget = null;
    private boolean mShowHoverIconForConnectedView = true;
    private final boolean mInitiateWithoutConnection = Flags.initiationWithoutInputConnection();

    @VisibleForTesting
    public HandwritingInitiator(@NonNull ViewConfiguration viewConfiguration, @NonNull InputMethodManager inputMethodManager) {
        this.mHandwritingSlop = viewConfiguration.getScaledHandwritingSlop();
        this.mHandwritingTimeoutInMillis = ViewConfiguration.getLongPressTimeout();
        this.mImm = inputMethodManager;
    }

    @VisibleForTesting
    public boolean onTouchEvent(@NonNull MotionEvent motionEvent) {
        int maskedAction = motionEvent.getActionMasked();
        switch (maskedAction) {
            case 0: 
            case 5: {
                this.mState = null;
                if (!motionEvent.isStylusPointer()) {
                    return false;
                }
                this.mState = new State(motionEvent);
                break;
            }
            case 6: {
                int pointerId = motionEvent.getPointerId(motionEvent.getActionIndex());
                if (this.mState == null || pointerId != this.mState.mStylusPointerId) {
                    return false;
                }
            }
            case 1: 
            case 3: {
                if (this.mState != null) {
                    this.mState.mShouldInitHandwriting = false;
                    if (!this.mState.mHandled) {
                        this.mShowHoverIconForConnectedView = true;
                    }
                }
                return false;
            }
            case 2: {
                float y;
                if (this.mState == null) {
                    return false;
                }
                if (!this.mState.mShouldInitHandwriting || this.mState.mExceedHandwritingSlop) {
                    return this.mState.mHandled;
                }
                long timeElapsed = motionEvent.getEventTime() - this.mState.mStylusDownTimeInMillis;
                if (timeElapsed > this.mHandwritingTimeoutInMillis) {
                    this.mState.mShouldInitHandwriting = false;
                    return this.mState.mHandled;
                }
                int pointerIndex = motionEvent.findPointerIndex(this.mState.mStylusPointerId);
                float x = motionEvent.getX(pointerIndex);
                if (this.largerThanTouchSlop(x, y = motionEvent.getY(pointerIndex), this.mState.mStylusDownX, this.mState.mStylusDownY)) {
                    this.mState.mExceedHandwritingSlop = true;
                    View candidateView = this.findBestCandidateView(this.mState.mStylusDownX, this.mState.mStylusDownY, false);
                    if (candidateView != null && candidateView.isEnabled()) {
                        boolean candidateHasFocus = candidateView.hasFocus();
                        if (!candidateView.isStylusHandwritingAvailable()) {
                            this.mState.mShouldInitHandwriting = false;
                            return false;
                        }
                        if (HandwritingInitiator.shouldShowHandwritingUnavailableMessageForView(candidateView)) {
                            TextView tv;
                            int messagesResId = candidateView instanceof TextView && (tv = (TextView)candidateView).isAnyPasswordInputType() ? 17040298 : 17040297;
                            Toast.makeText(candidateView.getContext(), messagesResId, 0).show();
                            if (!candidateView.hasFocus()) {
                                this.requestFocusWithoutReveal(candidateView);
                            }
                            if (!com.android.text.flags.Flags.handwritingUnsupportedShowSoftInputFix() || candidateView instanceof TextView && (tv = (TextView)candidateView).getShowSoftInputOnFocus()) {
                                this.mImm.showSoftInput(candidateView, 0);
                            }
                            this.mState.mHandled = true;
                            this.mState.mShouldInitHandwriting = false;
                            motionEvent.setAction(motionEvent.getAction() & 0xFF00 | 3);
                            candidateView.getRootView().dispatchTouchEvent(motionEvent);
                        } else if (candidateView == this.getConnectedOrFocusedView()) {
                            if (!candidateHasFocus) {
                                this.requestFocusWithoutReveal(candidateView);
                            }
                            this.startHandwriting(candidateView);
                        } else if (candidateView.getHandwritingDelegatorCallback() != null) {
                            this.prepareDelegation(candidateView);
                        } else if (this.mInitiateWithoutConnection) {
                            if (!candidateHasFocus) {
                                this.mState.mPendingFocusedView = new WeakReference<View>(candidateView);
                                this.requestFocusWithoutReveal(candidateView);
                            }
                        } else {
                            this.mState.mPendingConnectedView = new WeakReference<View>(candidateView);
                            if (!candidateHasFocus) {
                                this.requestFocusWithoutReveal(candidateView);
                            }
                        }
                    }
                }
                return this.mState.mHandled;
            }
        }
        return false;
    }

    @Nullable
    private View getConnectedView() {
        if (this.mConnectedView == null) {
            return null;
        }
        return (View)this.mConnectedView.get();
    }

    private void clearConnectedView() {
        this.mConnectedView = null;
        this.mConnectionCount = 0;
    }

    public void onDelegateViewFocused(@NonNull View view) {
        if (this.mInitiateWithoutConnection) {
            this.onEditorFocused(view);
        }
        if (view == this.getConnectedView()) {
            this.tryAcceptStylusHandwritingDelegation(view);
        }
    }

    public void onInputConnectionCreated(@NonNull View view) {
        if (this.mInitiateWithoutConnection && !view.isHandwritingDelegate()) {
            return;
        }
        if (!view.isAutoHandwritingEnabled()) {
            this.clearConnectedView();
            return;
        }
        View connectedView = this.getConnectedView();
        if (connectedView == view) {
            ++this.mConnectionCount;
        } else {
            this.mConnectedView = new WeakReference<View>(view);
            this.mConnectionCount = 1;
            this.mShowHoverIconForConnectedView = true;
            if (view.isHandwritingDelegate() && this.tryAcceptStylusHandwritingDelegation(view)) {
                this.mShowHoverIconForConnectedView = false;
                return;
            }
            if (!this.mInitiateWithoutConnection && this.mState != null && this.mState.mPendingConnectedView != null && this.mState.mPendingConnectedView.get() == view) {
                this.startHandwriting(view);
            }
        }
    }

    @VisibleForTesting
    public void onEditorFocused(@NonNull View view) {
        if (!this.mInitiateWithoutConnection) {
            return;
        }
        View focusedView = this.getFocusedView();
        if (!com.android.text.flags.Flags.handwritingTrackDisabled() && !view.isAutoHandwritingEnabled()) {
            this.clearFocusedView(focusedView);
            return;
        }
        if (focusedView == view) {
            return;
        }
        this.updateFocusedView(view);
        if (this.mState != null && this.mState.mPendingFocusedView != null && this.mState.mPendingFocusedView.get() == view && (!com.android.text.flags.Flags.handwritingTrackDisabled() || view.isAutoHandwritingEnabled())) {
            this.startHandwriting(view);
        }
    }

    public void onInputConnectionClosed(@NonNull View view) {
        if (this.mInitiateWithoutConnection && !view.isHandwritingDelegate()) {
            return;
        }
        View connectedView = this.getConnectedView();
        if (connectedView == null) {
            return;
        }
        if (connectedView == view) {
            --this.mConnectionCount;
            if (this.mConnectionCount == 0) {
                this.clearConnectedView();
            }
        } else {
            this.clearConnectedView();
        }
    }

    @Nullable
    private View getFocusedView() {
        if (this.mFocusedView == null) {
            return null;
        }
        return (View)this.mFocusedView.get();
    }

    public void clearFocusedView(View view) {
        if (view == null || this.mFocusedView == null) {
            return;
        }
        if (this.mFocusedView.get() == view) {
            this.mFocusedView = null;
        }
    }

    @VisibleForTesting
    public boolean updateFocusedView(@NonNull View view) {
        if (!com.android.text.flags.Flags.handwritingTrackDisabled() && !view.shouldInitiateHandwriting()) {
            this.mFocusedView = null;
            return false;
        }
        View focusedView = this.getFocusedView();
        if (focusedView != view) {
            this.mFocusedView = new WeakReference<View>(view);
            if (!com.android.text.flags.Flags.handwritingTrackDisabled() || view.shouldInitiateHandwriting()) {
                this.mShowHoverIconForConnectedView = true;
            }
        }
        return true;
    }

    @VisibleForTesting
    public void startHandwriting(@NonNull View view) {
        this.mImm.startStylusHandwriting(view);
        this.mState.mHandled = true;
        this.mState.mShouldInitHandwriting = false;
        this.mShowHoverIconForConnectedView = false;
        if (view instanceof TextView) {
            ((TextView)view).hideHint();
        }
    }

    private void prepareDelegation(View view) {
        String delegatePackageName = view.getAllowedHandwritingDelegatePackageName();
        if (delegatePackageName == null) {
            delegatePackageName = view.getContext().getOpPackageName();
        }
        if (this.mImm.isConnectionlessStylusHandwritingAvailable()) {
            view.getViewRootImpl().getView().clearFocus();
            this.mImm.startConnectionlessStylusHandwritingForDelegation(view, this.getCursorAnchorInfoForConnectionless(view), delegatePackageName, view::post, new DelegationCallback(view, delegatePackageName));
            this.mState.mShouldInitHandwriting = false;
        } else {
            this.mImm.prepareStylusHandwritingDelegation(view, delegatePackageName);
            view.getHandwritingDelegatorCallback().run();
        }
        this.mState.mHandled = true;
    }

    @VisibleForTesting
    public boolean tryAcceptStylusHandwritingDelegation(@NonNull View view) {
        if (!Flags.useZeroJankProxy()) {
            return this.tryAcceptStylusHandwritingDelegationInternal(view);
        }
        this.tryAcceptStylusHandwritingDelegationAsync(view);
        return false;
    }

    private boolean tryAcceptStylusHandwritingDelegationInternal(@NonNull View view) {
        String delegatorPackageName = view.getAllowedHandwritingDelegatorPackageName();
        if (delegatorPackageName == null) {
            delegatorPackageName = view.getContext().getOpPackageName();
        }
        if (this.mImm.acceptStylusHandwritingDelegation(view, delegatorPackageName)) {
            this.onDelegationAccepted(view);
            return true;
        }
        return false;
    }

    @FlaggedApi(value="android.view.inputmethod.use_zero_jank_proxy")
    private void tryAcceptStylusHandwritingDelegationAsync(@NonNull View view) {
        String delegatorPackageName = view.getAllowedHandwritingDelegatorPackageName();
        if (delegatorPackageName == null) {
            delegatorPackageName = view.getContext().getOpPackageName();
        }
        WeakReference<View> viewRef = new WeakReference<View>(view);
        Consumer<Boolean> consumer = delegationAccepted -> {
            if (delegationAccepted.booleanValue()) {
                this.onDelegationAccepted((View)viewRef.get());
            }
        };
        this.mImm.acceptStylusHandwritingDelegation(view, delegatorPackageName, view::post, consumer);
    }

    private void onDelegationAccepted(View view) {
        if (this.mState != null) {
            this.mState.mHandled = true;
            this.mState.mShouldInitHandwriting = false;
        }
        if (view == null) {
            return;
        }
        if (view instanceof TextView) {
            ((TextView)view).hideHint();
        }
        this.mShowHoverIconForConnectedView = false;
    }

    public void updateHandwritingAreasForView(@NonNull View view) {
        this.mHandwritingAreasTracker.updateHandwritingAreaForView(view);
    }

    private static boolean shouldTriggerStylusHandwritingForView(@NonNull View view) {
        if (!view.shouldInitiateHandwriting()) {
            return false;
        }
        return view.isStylusHandwritingAvailable();
    }

    private static boolean shouldShowHandwritingUnavailableMessageForView(@NonNull View view) {
        return view instanceof TextView && !HandwritingInitiator.shouldTriggerStylusHandwritingForView(view);
    }

    private static boolean shouldTriggerHandwritingOrShowUnavailableMessageForView(@NonNull View view) {
        return view instanceof TextView || HandwritingInitiator.shouldTriggerStylusHandwritingForView(view);
    }

    public PointerIcon onResolvePointerIcon(Context context, MotionEvent event) {
        View hoverView = this.findHoverView(event);
        if (hoverView == null || !HandwritingInitiator.shouldTriggerStylusHandwritingForView(hoverView)) {
            return null;
        }
        if (this.mShowHoverIconForConnectedView) {
            return PointerIcon.getSystemIcon(context, 1022);
        }
        if (hoverView != this.getConnectedOrFocusedView()) {
            this.mShowHoverIconForConnectedView = true;
            return PointerIcon.getSystemIcon(context, 1022);
        }
        return null;
    }

    private View getConnectedOrFocusedView() {
        if (this.mInitiateWithoutConnection) {
            return this.mFocusedView == null ? null : (View)this.mFocusedView.get();
        }
        return this.mConnectedView == null ? null : (View)this.mConnectedView.get();
    }

    private View getCachedHoverTarget() {
        if (this.mCachedHoverTarget == null) {
            return null;
        }
        return (View)this.mCachedHoverTarget.get();
    }

    private View findHoverView(MotionEvent event) {
        if (!event.isStylusPointer() || !event.isHoverEvent()) {
            return null;
        }
        if (event.getActionMasked() == 9 || event.getActionMasked() == 7) {
            Rect handwritingArea;
            float hoverX = event.getX(event.getActionIndex());
            float hoverY = event.getY(event.getActionIndex());
            View cachedHoverTarget = this.getCachedHoverTarget();
            if (cachedHoverTarget != null && HandwritingInitiator.getViewHandwritingArea(cachedHoverTarget, handwritingArea = this.mTempRect) && this.isInHandwritingArea(handwritingArea, hoverX, hoverY, cachedHoverTarget, true) && HandwritingInitiator.shouldTriggerStylusHandwritingForView(cachedHoverTarget)) {
                return cachedHoverTarget;
            }
            View candidateView = this.findBestCandidateView(hoverX, hoverY, true);
            if (candidateView != null) {
                if (!com.android.text.flags.Flags.handwritingUnsupportedMessage()) {
                    this.mCachedHoverTarget = new WeakReference<View>(candidateView);
                }
                return candidateView;
            }
        }
        this.mCachedHoverTarget = null;
        return null;
    }

    private void requestFocusWithoutReveal(View view) {
        EditText editText;
        if (!com.android.text.flags.Flags.handwritingCursorPosition() && view instanceof EditText) {
            editText = (EditText)view;
            if (!this.mState.mStylusDownWithinEditorBounds) {
                view.getLocationInWindow(this.mTempLocation);
                int offset = editText.getOffsetForPosition(this.mState.mStylusDownX - (float)this.mTempLocation[0], this.mState.mStylusDownY - (float)this.mTempLocation[1]);
                editText.setSelection(offset);
            }
        }
        if (view.getRevealOnFocusHint()) {
            view.setRevealOnFocusHint(false);
            view.requestFocus();
            view.setRevealOnFocusHint(true);
        } else {
            view.requestFocus();
        }
        if (com.android.text.flags.Flags.handwritingCursorPosition() && view instanceof EditText) {
            editText = (EditText)view;
            view.getLocationInWindow(this.mTempLocation);
            int line = editText.getLineAtCoordinate(this.mState.mStylusDownY - (float)this.mTempLocation[1]);
            int paragraphEnd = TextUtils.indexOf((CharSequence)editText.getText(), '\n', editText.getLayout().getLineStart(line));
            if (paragraphEnd < 0) {
                paragraphEnd = editText.getText().length();
            }
            editText.setSelection(paragraphEnd);
        }
    }

    @Nullable
    private View findBestCandidateView(float x, float y, boolean isHover) {
        Rect handwritingArea;
        View connectedOrFocusedView = this.getConnectedOrFocusedView();
        if (connectedOrFocusedView != null && HandwritingInitiator.getViewHandwritingArea(connectedOrFocusedView, handwritingArea = this.mTempRect) && this.isInHandwritingArea(handwritingArea, x, y, connectedOrFocusedView, isHover) && HandwritingInitiator.shouldTriggerHandwritingOrShowUnavailableMessageForView(connectedOrFocusedView)) {
            if (!isHover && this.mState != null) {
                this.mState.mStylusDownWithinEditorBounds = HandwritingInitiator.contains(handwritingArea, x, y, 0.0f, 0.0f, 0.0f, 0.0f);
            }
            return connectedOrFocusedView;
        }
        float minDistance = Float.MAX_VALUE;
        View bestCandidate = null;
        List<HandwritableViewInfo> handwritableViewInfos = this.mHandwritingAreasTracker.computeViewInfos();
        for (HandwritableViewInfo viewInfo : handwritableViewInfos) {
            View view = viewInfo.getView();
            Rect handwritingArea2 = viewInfo.getHandwritingArea();
            if (!this.isInHandwritingArea(handwritingArea2, x, y, view, isHover) || !HandwritingInitiator.shouldTriggerHandwritingOrShowUnavailableMessageForView(view)) continue;
            float distance = HandwritingInitiator.distance(handwritingArea2, x, y);
            if (distance == 0.0f) {
                if (!isHover && this.mState != null) {
                    this.mState.mStylusDownWithinEditorBounds = true;
                }
                return view;
            }
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            bestCandidate = view;
        }
        return bestCandidate;
    }

    private static float distance(@NonNull Rect rect, float x, float y) {
        if (HandwritingInitiator.contains(rect, x, y, 0.0f, 0.0f, 0.0f, 0.0f)) {
            return 0.0f;
        }
        float xDistance = x >= (float)rect.left && x < (float)rect.right ? 0.0f : (x < (float)rect.left ? (float)rect.left - x : x - (float)rect.right);
        float yDistance = y >= (float)rect.top && y < (float)rect.bottom ? 0.0f : (y < (float)rect.top ? (float)rect.top - y : y - (float)rect.bottom);
        return xDistance * xDistance + yDistance * yDistance;
    }

    private static boolean getViewHandwritingArea(@NonNull View view, @NonNull Rect rect) {
        ViewParent viewParent = view.getParent();
        if (viewParent != null && view.isAttachedToWindow() && view.isAggregatedVisible()) {
            Rect localHandwritingArea = view.getHandwritingArea();
            if (localHandwritingArea != null) {
                rect.set(localHandwritingArea);
            } else {
                rect.set(0, 0, view.getWidth(), view.getHeight());
            }
            return viewParent.getChildVisibleRect(view, rect, null);
        }
        return false;
    }

    private boolean isInHandwritingArea(@Nullable Rect handwritingArea, float x, float y, View view, boolean isHover) {
        if (handwritingArea == null) {
            return false;
        }
        if (!HandwritingInitiator.contains(handwritingArea, x, y, view.getHandwritingBoundsOffsetLeft(), view.getHandwritingBoundsOffsetTop(), view.getHandwritingBoundsOffsetRight(), view.getHandwritingBoundsOffsetBottom())) {
            return false;
        }
        ViewParent parent = view.getParent();
        if (parent == null) {
            return true;
        }
        Region region = this.mTempRegion;
        this.mTempRegion.set(0, 0, view.getWidth(), view.getHeight());
        Matrix matrix = this.mTempMatrix;
        matrix.reset();
        if (!parent.getChildLocalHitRegion(view, region, matrix, isHover)) {
            return false;
        }
        float left = x - view.getHandwritingBoundsOffsetRight();
        float top = y - view.getHandwritingBoundsOffsetBottom();
        float right = Math.max(x + view.getHandwritingBoundsOffsetLeft(), left + 1.0f);
        float bottom = Math.max(y + view.getHandwritingBoundsOffsetTop(), top + 1.0f);
        RectF rectF = this.mTempRectF;
        rectF.set(left, top, right, bottom);
        matrix.mapRect(rectF);
        return region.op(Math.round(rectF.left), Math.round(rectF.top), Math.round(rectF.right), Math.round(rectF.bottom), Region.Op.INTERSECT);
    }

    private static boolean contains(@NonNull Rect rect, float x, float y, float offsetLeft, float offsetTop, float offsetRight, float offsetBottom) {
        return x >= (float)rect.left - offsetLeft && x < (float)rect.right + offsetRight && y >= (float)rect.top - offsetTop && y < (float)rect.bottom + offsetBottom;
    }

    private boolean largerThanTouchSlop(float x1, float y1, float x2, float y2) {
        float dx = x1 - x2;
        float dy = y1 - y2;
        return dx * dx + dy * dy > (float)(this.mHandwritingSlop * this.mHandwritingSlop);
    }

    private static boolean isViewActive(@Nullable View view) {
        return view != null && view.isAttachedToWindow() && view.isAggregatedVisible() && view.shouldTrackHandwritingArea();
    }

    private CursorAnchorInfo getCursorAnchorInfoForConnectionless(View view) {
        CursorAnchorInfo.Builder builder = new CursorAnchorInfo.Builder();
        TextView textView = HandwritingInitiator.findFirstTextViewDescendent(view);
        if (textView != null) {
            textView.getCursorAnchorInfo(0, builder, this.mTempMatrix);
            if (textView.getSelectionStart() < 0) {
                float bottom = textView.getHeight() - textView.getExtendedPaddingBottom();
                builder.setInsertionMarkerLocation(textView.getCompoundPaddingStart(), textView.getExtendedPaddingTop(), bottom, bottom, 0);
            }
        } else {
            this.mTempMatrix.reset();
            view.transformMatrixToGlobal(this.mTempMatrix);
            builder.setMatrix(this.mTempMatrix);
            builder.setInsertionMarkerLocation(view.isLayoutRtl() ? (float)view.getWidth() : 0.0f, 0.0f, view.getHeight(), view.getHeight(), 0);
        }
        return builder.build();
    }

    @Nullable
    private static TextView findFirstTextViewDescendent(View view) {
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                TextView tv;
                TextView textView;
                View child = viewGroup.getChildAt(i);
                TextView textView2 = textView = child instanceof TextView ? (tv = (TextView)child) : HandwritingInitiator.findFirstTextViewDescendent(viewGroup.getChildAt(i));
                if (textView == null || !textView.isAggregatedVisible() || TextUtils.isEmpty(textView.getText()) && TextUtils.isEmpty(textView.getHint())) continue;
                return textView;
            }
        }
        return null;
    }

    @VisibleForTesting
    public static class HandwritingAreaTracker {
        private final List<HandwritableViewInfo> mHandwritableViewInfos = new ArrayList<HandwritableViewInfo>();

        public void updateHandwritingAreaForView(@NonNull View view) {
            Iterator<HandwritableViewInfo> iterator = this.mHandwritableViewInfos.iterator();
            boolean found = false;
            while (iterator.hasNext()) {
                HandwritableViewInfo handwritableViewInfo = iterator.next();
                View curView = handwritableViewInfo.getView();
                if (!HandwritingInitiator.isViewActive(curView)) {
                    iterator.remove();
                }
                if (curView != view) continue;
                found = true;
                handwritableViewInfo.mIsDirty = true;
            }
            if (!found && HandwritingInitiator.isViewActive(view)) {
                this.mHandwritableViewInfos.add(new HandwritableViewInfo(view));
            }
        }

        @NonNull
        public List<HandwritableViewInfo> computeViewInfos() {
            this.mHandwritableViewInfos.removeIf(viewInfo -> !viewInfo.update());
            return this.mHandwritableViewInfos;
        }
    }

    private static class State {
        private boolean mShouldInitHandwriting;
        private boolean mHandled;
        private boolean mExceedHandwritingSlop;
        private boolean mStylusDownWithinEditorBounds;
        private WeakReference<View> mPendingConnectedView = null;
        private WeakReference<View> mPendingFocusedView = null;
        private final int mStylusPointerId;
        private final long mStylusDownTimeInMillis;
        private final float mStylusDownX;
        private final float mStylusDownY;

        private State(MotionEvent motionEvent) {
            int actionIndex = motionEvent.getActionIndex();
            this.mStylusPointerId = motionEvent.getPointerId(actionIndex);
            this.mStylusDownTimeInMillis = motionEvent.getEventTime();
            this.mStylusDownX = motionEvent.getX(actionIndex);
            this.mStylusDownY = motionEvent.getY(actionIndex);
            this.mShouldInitHandwriting = true;
            this.mHandled = false;
            this.mExceedHandwritingSlop = false;
        }
    }

    private class DelegationCallback
    implements ConnectionlessHandwritingCallback {
        private final View mView;
        private final String mDelegatePackageName;

        private DelegationCallback(View view, String delegatePackageName) {
            this.mView = view;
            this.mDelegatePackageName = delegatePackageName;
        }

        @Override
        public void onResult(@NonNull CharSequence text) {
            this.mView.getHandwritingDelegatorCallback().run();
        }

        @Override
        public void onError(int errorCode) {
            switch (errorCode) {
                case 0: {
                    this.mView.getHandwritingDelegatorCallback().run();
                    break;
                }
                case 1: {
                    HandwritingInitiator.this.mImm.prepareStylusHandwritingDelegation(this.mView, this.mDelegatePackageName);
                    this.mView.getHandwritingDelegatorCallback().run();
                }
            }
        }
    }

    @VisibleForTesting
    public static class HandwritableViewInfo {
        final WeakReference<View> mViewRef;
        Rect mHandwritingArea = null;
        @VisibleForTesting
        public boolean mIsDirty = true;

        @VisibleForTesting
        public HandwritableViewInfo(@NonNull View view) {
            this.mViewRef = new WeakReference<View>(view);
        }

        @Nullable
        public View getView() {
            return (View)this.mViewRef.get();
        }

        @Nullable
        public Rect getHandwritingArea() {
            return this.mHandwritingArea;
        }

        public boolean update() {
            View view = this.getView();
            if (!HandwritingInitiator.isViewActive(view)) {
                return false;
            }
            if (!this.mIsDirty) {
                return true;
            }
            Rect handwritingArea = view.getHandwritingArea();
            if (handwritingArea == null) {
                return false;
            }
            ViewParent parent = view.getParent();
            if (parent != null) {
                if (this.mHandwritingArea == null) {
                    this.mHandwritingArea = new Rect();
                }
                this.mHandwritingArea.set(handwritingArea);
                if (!parent.getChildVisibleRect(view, this.mHandwritingArea, null)) {
                    this.mHandwritingArea = null;
                }
            }
            this.mIsDirty = false;
            return true;
        }
    }
}

