/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.Nullable;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Matrix;
import android.graphics.Path;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.DisplayUtils;
import android.util.PathParser;
import android.util.RotationUtils;
import android.view.RoundedCorners;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.layoutlib.androidx.annotation.NonNull;
import java.util.Objects;

public class DisplayShape
implements Parcelable {
    public static final DisplayShape NONE = new DisplayShape("", 0, 0, 0.0f, 0);
    @VisibleForTesting
    public final String mDisplayShapeSpec;
    private final float mPhysicalPixelDisplaySizeRatio;
    private final int mDisplayWidth;
    private final int mDisplayHeight;
    private final int mRotation;
    private final int mOffsetX;
    private final int mOffsetY;
    private final float mScale;
    @NonNull
    public static final Parcelable.Creator<DisplayShape> CREATOR = new Parcelable.Creator<DisplayShape>(){

        @Override
        public DisplayShape createFromParcel(Parcel in) {
            String spec = in.readString8();
            int displayWidth = in.readInt();
            int displayHeight = in.readInt();
            float ratio = in.readFloat();
            int rotation = in.readInt();
            int offsetX = in.readInt();
            int offsetY = in.readInt();
            float scale = in.readFloat();
            return new DisplayShape(spec, displayWidth, displayHeight, ratio, rotation, offsetX, offsetY, scale);
        }

        public DisplayShape[] newArray(int size) {
            return new DisplayShape[size];
        }
    };

    private DisplayShape(@NonNull String displayShapeSpec, int displayWidth, int displayHeight, float physicalPixelDisplaySizeRatio, int rotation) {
        this(displayShapeSpec, displayWidth, displayHeight, physicalPixelDisplaySizeRatio, rotation, 0, 0, 1.0f);
    }

    private DisplayShape(@NonNull String displayShapeSpec, int displayWidth, int displayHeight, float physicalPixelDisplaySizeRatio, int rotation, int offsetX, int offsetY, float scale) {
        this.mDisplayShapeSpec = displayShapeSpec;
        this.mDisplayWidth = displayWidth;
        this.mDisplayHeight = displayHeight;
        this.mPhysicalPixelDisplaySizeRatio = physicalPixelDisplaySizeRatio;
        this.mRotation = rotation;
        this.mOffsetX = offsetX;
        this.mOffsetY = offsetY;
        this.mScale = scale;
    }

    @NonNull
    public static DisplayShape fromResources(@NonNull Resources res, @NonNull String displayUniqueId, int physicalDisplayWidth, int physicalDisplayHeight, int displayWidth, int displayHeight) {
        boolean isScreenRound = RoundedCorners.getBuiltInDisplayIsRound(res, displayUniqueId);
        String spec = DisplayShape.getSpecString(res, displayUniqueId);
        if (spec == null || spec.isEmpty()) {
            return DisplayShape.createDefaultDisplayShape(displayWidth, displayHeight, isScreenRound);
        }
        float physicalPixelDisplaySizeRatio = DisplayUtils.getPhysicalPixelDisplaySizeRatio(physicalDisplayWidth, physicalDisplayHeight, displayWidth, displayHeight);
        return DisplayShape.fromSpecString(spec, physicalPixelDisplaySizeRatio, displayWidth, displayHeight);
    }

    @NonNull
    public static DisplayShape createDefaultDisplayShape(int displayWidth, int displayHeight, boolean isScreenRound) {
        return DisplayShape.fromSpecString(DisplayShape.createDefaultSpecString(displayWidth, displayHeight, isScreenRound), 1.0f, displayWidth, displayHeight);
    }

    @NonNull
    public static DisplayShape fromSpecString(@NonNull String spec, float physicalPixelDisplaySizeRatio, int displayWidth, int displayHeight) {
        return Cache.getDisplayShape(spec, physicalPixelDisplaySizeRatio, displayWidth, displayHeight);
    }

    private static String createDefaultSpecString(int displayWidth, int displayHeight, boolean isCircular) {
        String spec;
        if (isCircular) {
            float xRadius = (float)displayWidth / 2.0f;
            float yRadius = (float)displayHeight / 2.0f;
            spec = "M0," + yRadius + " A" + xRadius + "," + yRadius + " 0 1,1 " + displayWidth + "," + yRadius + " A" + xRadius + "," + yRadius + " 0 1,1 0," + yRadius + " Z";
        } else {
            spec = "M0,0 L" + displayWidth + ",0 L" + displayWidth + "," + displayHeight + " L0," + displayHeight + " Z";
        }
        return spec;
    }

    public static String getSpecString(Resources res, String displayUniqueId) {
        int index = DisplayUtils.getDisplayUniqueIdConfigIndex(res, displayUniqueId);
        TypedArray array2 = res.obtainTypedArray(17236051);
        String spec = index >= 0 && index < array2.length() ? array2.getString(index) : res.getString(17040020);
        array2.recycle();
        return spec;
    }

    public DisplayShape setRotation(int rotation) {
        return new DisplayShape(this.mDisplayShapeSpec, this.mDisplayWidth, this.mDisplayHeight, this.mPhysicalPixelDisplaySizeRatio, rotation, this.mOffsetX, this.mOffsetY, this.mScale);
    }

    public DisplayShape setOffset(int offsetX, int offsetY) {
        return new DisplayShape(this.mDisplayShapeSpec, this.mDisplayWidth, this.mDisplayHeight, this.mPhysicalPixelDisplaySizeRatio, this.mRotation, offsetX, offsetY, this.mScale);
    }

    public DisplayShape setScale(float scale) {
        return new DisplayShape(this.mDisplayShapeSpec, this.mDisplayWidth, this.mDisplayHeight, this.mPhysicalPixelDisplaySizeRatio, this.mRotation, this.mOffsetX, this.mOffsetY, scale);
    }

    public int hashCode() {
        return Objects.hash(this.mDisplayShapeSpec, this.mDisplayWidth, this.mDisplayHeight, Float.valueOf(this.mPhysicalPixelDisplaySizeRatio), this.mRotation, this.mOffsetX, this.mOffsetY, Float.valueOf(this.mScale));
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DisplayShape) {
            DisplayShape ds = (DisplayShape)o;
            return Objects.equals(this.mDisplayShapeSpec, ds.mDisplayShapeSpec) && this.mDisplayWidth == ds.mDisplayWidth && this.mDisplayHeight == ds.mDisplayHeight && this.mPhysicalPixelDisplaySizeRatio == ds.mPhysicalPixelDisplaySizeRatio && this.mRotation == ds.mRotation && this.mOffsetX == ds.mOffsetX && this.mOffsetY == ds.mOffsetY && this.mScale == ds.mScale;
        }
        return false;
    }

    public String toString() {
        return "DisplayShape{ spec=" + this.mDisplayShapeSpec.hashCode() + " displayWidth=" + this.mDisplayWidth + " displayHeight=" + this.mDisplayHeight + " physicalPixelDisplaySizeRatio=" + this.mPhysicalPixelDisplaySizeRatio + " rotation=" + this.mRotation + " offsetX=" + this.mOffsetX + " offsetY=" + this.mOffsetY + " scale=" + this.mScale + "}";
    }

    @NonNull
    public Path getPath() {
        return Cache.getPath(this);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString8(this.mDisplayShapeSpec);
        dest.writeInt(this.mDisplayWidth);
        dest.writeInt(this.mDisplayHeight);
        dest.writeFloat(this.mPhysicalPixelDisplaySizeRatio);
        dest.writeInt(this.mRotation);
        dest.writeInt(this.mOffsetX);
        dest.writeInt(this.mOffsetY);
        dest.writeFloat(this.mScale);
    }

    private static class Cache {
        private static final Object CACHE_LOCK = new Object();
        @GuardedBy(value={"CACHE_LOCK"})
        private static String sCachedSpec;
        @GuardedBy(value={"CACHE_LOCK"})
        private static int sCachedDisplayWidth;
        @GuardedBy(value={"CACHE_LOCK"})
        private static int sCachedDisplayHeight;
        @GuardedBy(value={"CACHE_LOCK"})
        private static float sCachedPhysicalPixelDisplaySizeRatio;
        @GuardedBy(value={"CACHE_LOCK"})
        private static DisplayShape sCachedDisplayShape;
        @GuardedBy(value={"CACHE_LOCK"})
        private static DisplayShape sCacheForPath;
        @GuardedBy(value={"CACHE_LOCK"})
        private static Path sCachedPath;

        private Cache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static DisplayShape getDisplayShape(String spec, float physicalPixelDisplaySizeRatio, int displayWidth, int displayHeight) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (spec.equals(sCachedSpec) && sCachedDisplayWidth == displayWidth && sCachedDisplayHeight == displayHeight && sCachedPhysicalPixelDisplaySizeRatio == physicalPixelDisplaySizeRatio) {
                    return sCachedDisplayShape;
                }
            }
            DisplayShape shape = new DisplayShape(spec, displayWidth, displayHeight, physicalPixelDisplaySizeRatio, 0);
            Object object2 = CACHE_LOCK;
            synchronized (object2) {
                sCachedSpec = spec;
                sCachedDisplayWidth = displayWidth;
                sCachedDisplayHeight = displayHeight;
                sCachedPhysicalPixelDisplaySizeRatio = physicalPixelDisplaySizeRatio;
                sCachedDisplayShape = shape;
            }
            return shape;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Path getPath(@NonNull DisplayShape shape) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (shape.equals(sCacheForPath)) {
                    return sCachedPath;
                }
            }
            Path path = PathParser.createPathFromPathData(shape.mDisplayShapeSpec);
            if (!path.isEmpty()) {
                Matrix matrix = new Matrix();
                if (shape.mRotation != 0) {
                    RotationUtils.transformPhysicalToLogicalCoordinates(shape.mRotation, shape.mDisplayWidth, shape.mDisplayHeight, matrix);
                }
                if (shape.mPhysicalPixelDisplaySizeRatio != 1.0f) {
                    matrix.preScale(shape.mPhysicalPixelDisplaySizeRatio, shape.mPhysicalPixelDisplaySizeRatio);
                }
                if (shape.mOffsetX != 0 || shape.mOffsetY != 0) {
                    matrix.postTranslate(shape.mOffsetX, shape.mOffsetY);
                }
                if (shape.mScale != 1.0f) {
                    matrix.postScale(shape.mScale, shape.mScale);
                }
                path.transform(matrix);
            }
            Object object2 = CACHE_LOCK;
            synchronized (object2) {
                sCacheForPath = shape;
                sCachedPath = path;
            }
            return path;
        }
    }
}

