/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.hardware.display.DeviceProductInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.ArraySet;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.util.proto.ProtoOutputStream;
import android.view.Display;
import android.view.DisplayAddress;
import android.view.DisplayAdjustments;
import android.view.DisplayCutout;
import android.view.DisplayShape;
import android.view.FrameRateCategoryRate;
import android.view.RoundedCorners;
import android.view.Surface;
import android.view.SurfaceControl;
import com.android.internal.display.BrightnessSynchronizer;
import com.android.server.display.feature.flags.Flags;
import java.util.Arrays;
import java.util.Objects;

@RavenwoodKeepWholeClass
public class DisplayInfo
implements Parcelable {
    public int layerStack;
    public int flags;
    public int type;
    public int displayId;
    public int displayGroupId;
    public DisplayAddress address;
    public DeviceProductInfo deviceProductInfo;
    public String name;
    public String uniqueId;
    public int appWidth;
    public int appHeight;
    public int smallestNominalAppWidth;
    public int smallestNominalAppHeight;
    public int largestNominalAppWidth;
    public int largestNominalAppHeight;
    @UnsupportedAppUsage
    public int logicalWidth;
    @UnsupportedAppUsage
    public int logicalHeight;
    @Nullable
    @UnsupportedAppUsage(maxTargetSdk=28)
    public DisplayCutout displayCutout;
    @UnsupportedAppUsage
    public int rotation;
    public int modeId;
    public float renderFrameRate;
    public boolean hasArrSupport;
    public FrameRateCategoryRate frameRateCategoryRate;
    public float[] supportedRefreshRates = new float[0];
    public int defaultModeId;
    public int userPreferredModeId = -1;
    public Display.Mode[] supportedModes = Display.Mode.EMPTY_ARRAY;
    public Display.Mode[] appsSupportedModes = Display.Mode.EMPTY_ARRAY;
    public int colorMode;
    public int[] supportedColorModes = new int[]{0};
    public Display.HdrCapabilities hdrCapabilities;
    public int[] userDisabledHdrTypes = new int[0];
    public boolean isForceSdr;
    public boolean minimalPostProcessingSupported;
    public int logicalDensityDpi;
    public float physicalXDpi;
    public float physicalYDpi;
    public long appVsyncOffsetNanos;
    public long presentationDeadlineNanos;
    public int state;
    public int committedState;
    public int ownerUid;
    public String ownerPackageName;
    public float refreshRateOverride;
    public int removeMode = 0;
    public float brightnessMinimum;
    public float brightnessMaximum;
    public float brightnessDefault;
    public float brightnessDim;
    @Nullable
    public RoundedCorners roundedCorners;
    public int installOrientation;
    @Nullable
    public DisplayShape displayShape;
    @Nullable
    public SurfaceControl.RefreshRateRange layoutLimitedRefreshRate;
    public float hdrSdrRatio = Float.NaN;
    @NonNull
    public SparseArray<SurfaceControl.RefreshRateRange> thermalRefreshRateThrottling = new SparseArray();
    @Nullable
    public String thermalBrightnessThrottlingDataId;
    public boolean canHostTasks;
    @NonNull
    public static final Parcelable.Creator<DisplayInfo> CREATOR = new Parcelable.Creator<DisplayInfo>(){

        @Override
        public DisplayInfo createFromParcel(Parcel source) {
            return new DisplayInfo(source);
        }

        public DisplayInfo[] newArray(int size) {
            return new DisplayInfo[size];
        }
    };

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=123769467L)
    public DisplayInfo() {
    }

    public DisplayInfo(DisplayInfo other) {
        this.copyFrom(other);
    }

    private DisplayInfo(Parcel source) {
        this.readFromParcel(source);
    }

    public boolean equals(@Nullable Object o) {
        return o instanceof DisplayInfo && this.equals((DisplayInfo)o);
    }

    public boolean equals(DisplayInfo other) {
        return this.equals(other, false);
    }

    public boolean equals(DisplayInfo other, boolean compareOnlyBasicChanges) {
        boolean isEqualWithOnlyBasicChanges;
        boolean bl = isEqualWithOnlyBasicChanges = other != null && this.layerStack == other.layerStack && this.flags == other.flags && this.type == other.type && this.displayId == other.displayId && this.displayGroupId == other.displayGroupId && Objects.equals(this.address, other.address) && Objects.equals(this.deviceProductInfo, other.deviceProductInfo) && Objects.equals(this.uniqueId, other.uniqueId) && this.appWidth == other.appWidth && this.appHeight == other.appHeight && this.smallestNominalAppWidth == other.smallestNominalAppWidth && this.smallestNominalAppHeight == other.smallestNominalAppHeight && this.largestNominalAppWidth == other.largestNominalAppWidth && this.largestNominalAppHeight == other.largestNominalAppHeight && this.logicalWidth == other.logicalWidth && this.logicalHeight == other.logicalHeight && Objects.equals(this.displayCutout, other.displayCutout) && this.rotation == other.rotation && this.hasArrSupport == other.hasArrSupport && Objects.equals(this.frameRateCategoryRate, other.frameRateCategoryRate) && Arrays.equals(this.supportedRefreshRates, other.supportedRefreshRates) && this.defaultModeId == other.defaultModeId && this.userPreferredModeId == other.userPreferredModeId && Arrays.equals(this.supportedModes, other.supportedModes) && Arrays.equals(this.appsSupportedModes, other.appsSupportedModes) && this.colorMode == other.colorMode && Arrays.equals(this.supportedColorModes, other.supportedColorModes) && Objects.equals(this.hdrCapabilities, other.hdrCapabilities) && this.isForceSdr == other.isForceSdr && Arrays.equals(this.userDisabledHdrTypes, other.userDisabledHdrTypes) && this.minimalPostProcessingSupported == other.minimalPostProcessingSupported && this.logicalDensityDpi == other.logicalDensityDpi && this.physicalXDpi == other.physicalXDpi && this.physicalYDpi == other.physicalYDpi && this.state == other.state && this.ownerUid == other.ownerUid && Objects.equals(this.ownerPackageName, other.ownerPackageName) && this.removeMode == other.removeMode && this.brightnessMinimum == other.brightnessMinimum && this.brightnessMaximum == other.brightnessMaximum && this.brightnessDefault == other.brightnessDefault && this.brightnessDim == other.brightnessDim && Objects.equals(this.roundedCorners, other.roundedCorners) && this.installOrientation == other.installOrientation && Objects.equals(this.displayShape, other.displayShape) && Objects.equals(this.layoutLimitedRefreshRate, other.layoutLimitedRefreshRate) && BrightnessSynchronizer.floatEquals(this.hdrSdrRatio, other.hdrSdrRatio) && this.thermalRefreshRateThrottling.contentEquals(other.thermalRefreshRateThrottling) && Objects.equals(this.thermalBrightnessThrottlingDataId, other.thermalBrightnessThrottlingDataId) && this.canHostTasks == other.canHostTasks;
        if (!Flags.committedStateSeparateEvent()) {
            boolean bl2 = isEqualWithOnlyBasicChanges = isEqualWithOnlyBasicChanges && this.committedState == other.committedState;
        }
        if (!compareOnlyBasicChanges) {
            return isEqualWithOnlyBasicChanges && this.getRefreshRate() == other.getRefreshRate() && this.appVsyncOffsetNanos == other.appVsyncOffsetNanos && this.presentationDeadlineNanos == other.presentationDeadlineNanos && this.modeId == other.modeId && this.committedState == other.committedState;
        }
        return isEqualWithOnlyBasicChanges;
    }

    public int hashCode() {
        return 0;
    }

    public void copyFrom(DisplayInfo other) {
        this.layerStack = other.layerStack;
        this.flags = other.flags;
        this.type = other.type;
        this.displayId = other.displayId;
        this.displayGroupId = other.displayGroupId;
        this.address = other.address;
        this.deviceProductInfo = other.deviceProductInfo;
        this.name = other.name;
        this.uniqueId = other.uniqueId;
        this.appWidth = other.appWidth;
        this.appHeight = other.appHeight;
        this.smallestNominalAppWidth = other.smallestNominalAppWidth;
        this.smallestNominalAppHeight = other.smallestNominalAppHeight;
        this.largestNominalAppWidth = other.largestNominalAppWidth;
        this.largestNominalAppHeight = other.largestNominalAppHeight;
        this.logicalWidth = other.logicalWidth;
        this.logicalHeight = other.logicalHeight;
        this.displayCutout = other.displayCutout;
        this.rotation = other.rotation;
        this.modeId = other.modeId;
        this.renderFrameRate = other.renderFrameRate;
        this.hasArrSupport = other.hasArrSupport;
        this.frameRateCategoryRate = other.frameRateCategoryRate;
        this.supportedRefreshRates = Arrays.copyOf(other.supportedRefreshRates, other.supportedRefreshRates.length);
        this.defaultModeId = other.defaultModeId;
        this.userPreferredModeId = other.userPreferredModeId;
        this.supportedModes = Arrays.copyOf(other.supportedModes, other.supportedModes.length);
        this.appsSupportedModes = Arrays.copyOf(other.appsSupportedModes, other.appsSupportedModes.length);
        this.colorMode = other.colorMode;
        this.supportedColorModes = Arrays.copyOf(other.supportedColorModes, other.supportedColorModes.length);
        this.hdrCapabilities = other.hdrCapabilities;
        this.isForceSdr = other.isForceSdr;
        this.userDisabledHdrTypes = other.userDisabledHdrTypes;
        this.minimalPostProcessingSupported = other.minimalPostProcessingSupported;
        this.logicalDensityDpi = other.logicalDensityDpi;
        this.physicalXDpi = other.physicalXDpi;
        this.physicalYDpi = other.physicalYDpi;
        this.appVsyncOffsetNanos = other.appVsyncOffsetNanos;
        this.presentationDeadlineNanos = other.presentationDeadlineNanos;
        this.state = other.state;
        this.committedState = other.committedState;
        this.ownerUid = other.ownerUid;
        this.ownerPackageName = other.ownerPackageName;
        this.removeMode = other.removeMode;
        this.refreshRateOverride = other.refreshRateOverride;
        this.brightnessMinimum = other.brightnessMinimum;
        this.brightnessMaximum = other.brightnessMaximum;
        this.brightnessDefault = other.brightnessDefault;
        this.brightnessDim = other.brightnessDim;
        this.roundedCorners = other.roundedCorners;
        this.installOrientation = other.installOrientation;
        this.displayShape = other.displayShape;
        this.layoutLimitedRefreshRate = other.layoutLimitedRefreshRate;
        this.hdrSdrRatio = other.hdrSdrRatio;
        this.thermalRefreshRateThrottling = other.thermalRefreshRateThrottling;
        this.thermalBrightnessThrottlingDataId = other.thermalBrightnessThrottlingDataId;
        this.canHostTasks = other.canHostTasks;
    }

    public void readFromParcel(Parcel source) {
        this.layerStack = source.readInt();
        this.flags = source.readInt();
        this.type = source.readInt();
        this.displayId = source.readInt();
        this.displayGroupId = source.readInt();
        this.address = source.readParcelable(null, DisplayAddress.class);
        this.deviceProductInfo = source.readParcelable(null, DeviceProductInfo.class);
        this.name = source.readString8();
        this.appWidth = source.readInt();
        this.appHeight = source.readInt();
        this.smallestNominalAppWidth = source.readInt();
        this.smallestNominalAppHeight = source.readInt();
        this.largestNominalAppWidth = source.readInt();
        this.largestNominalAppHeight = source.readInt();
        this.logicalWidth = source.readInt();
        this.logicalHeight = source.readInt();
        this.displayCutout = DisplayCutout.ParcelableWrapper.readCutoutFromParcel(source);
        this.rotation = source.readInt();
        this.modeId = source.readInt();
        this.renderFrameRate = source.readFloat();
        this.hasArrSupport = source.readBoolean();
        this.frameRateCategoryRate = source.readParcelable(null, FrameRateCategoryRate.class);
        int numOfSupportedRefreshRates = source.readInt();
        this.supportedRefreshRates = new float[numOfSupportedRefreshRates];
        for (int i = 0; i < numOfSupportedRefreshRates; ++i) {
            this.supportedRefreshRates[i] = source.readFloat();
        }
        this.defaultModeId = source.readInt();
        this.userPreferredModeId = source.readInt();
        int nModes = source.readInt();
        this.supportedModes = new Display.Mode[nModes];
        for (int i = 0; i < nModes; ++i) {
            this.supportedModes[i] = Display.Mode.CREATOR.createFromParcel(source);
        }
        int nAppModes = source.readInt();
        this.appsSupportedModes = new Display.Mode[nAppModes];
        for (int i = 0; i < nAppModes; ++i) {
            this.appsSupportedModes[i] = Display.Mode.CREATOR.createFromParcel(source);
        }
        this.colorMode = source.readInt();
        int nColorModes = source.readInt();
        this.supportedColorModes = new int[nColorModes];
        for (int i = 0; i < nColorModes; ++i) {
            this.supportedColorModes[i] = source.readInt();
        }
        this.hdrCapabilities = source.readParcelable(null, Display.HdrCapabilities.class);
        this.isForceSdr = source.readBoolean();
        this.minimalPostProcessingSupported = source.readBoolean();
        this.logicalDensityDpi = source.readInt();
        this.physicalXDpi = source.readFloat();
        this.physicalYDpi = source.readFloat();
        this.appVsyncOffsetNanos = source.readLong();
        this.presentationDeadlineNanos = source.readLong();
        this.state = source.readInt();
        this.committedState = source.readInt();
        this.ownerUid = source.readInt();
        this.ownerPackageName = source.readString8();
        this.uniqueId = source.readString8();
        this.removeMode = source.readInt();
        this.refreshRateOverride = source.readFloat();
        this.brightnessMinimum = source.readFloat();
        this.brightnessMaximum = source.readFloat();
        this.brightnessDefault = source.readFloat();
        this.brightnessDim = source.readFloat();
        this.roundedCorners = source.readTypedObject(RoundedCorners.CREATOR);
        int numUserDisabledFormats = source.readInt();
        this.userDisabledHdrTypes = new int[numUserDisabledFormats];
        for (int i = 0; i < numUserDisabledFormats; ++i) {
            this.userDisabledHdrTypes[i] = source.readInt();
        }
        this.installOrientation = source.readInt();
        this.displayShape = source.readTypedObject(DisplayShape.CREATOR);
        this.layoutLimitedRefreshRate = source.readTypedObject(SurfaceControl.RefreshRateRange.CREATOR);
        this.hdrSdrRatio = source.readFloat();
        this.thermalRefreshRateThrottling = source.readSparseArray(null, SurfaceControl.RefreshRateRange.class);
        this.thermalBrightnessThrottlingDataId = source.readString8();
        this.canHostTasks = source.readBoolean();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        int i;
        dest.writeInt(this.layerStack);
        dest.writeInt(this.flags);
        dest.writeInt(this.type);
        dest.writeInt(this.displayId);
        dest.writeInt(this.displayGroupId);
        dest.writeParcelable(this.address, flags);
        dest.writeParcelable(this.deviceProductInfo, flags);
        dest.writeString8(this.name);
        dest.writeInt(this.appWidth);
        dest.writeInt(this.appHeight);
        dest.writeInt(this.smallestNominalAppWidth);
        dest.writeInt(this.smallestNominalAppHeight);
        dest.writeInt(this.largestNominalAppWidth);
        dest.writeInt(this.largestNominalAppHeight);
        dest.writeInt(this.logicalWidth);
        dest.writeInt(this.logicalHeight);
        DisplayCutout.ParcelableWrapper.writeCutoutToParcel(this.displayCutout, dest, flags);
        dest.writeInt(this.rotation);
        dest.writeInt(this.modeId);
        dest.writeFloat(this.renderFrameRate);
        dest.writeBoolean(this.hasArrSupport);
        dest.writeParcelable(this.frameRateCategoryRate, flags);
        dest.writeInt(this.supportedRefreshRates.length);
        for (float supportedRefreshRate : this.supportedRefreshRates) {
            dest.writeFloat(supportedRefreshRate);
        }
        dest.writeInt(this.defaultModeId);
        dest.writeInt(this.userPreferredModeId);
        dest.writeInt(this.supportedModes.length);
        for (i = 0; i < this.supportedModes.length; ++i) {
            this.supportedModes[i].writeToParcel(dest, flags);
        }
        dest.writeInt(this.appsSupportedModes.length);
        for (i = 0; i < this.appsSupportedModes.length; ++i) {
            this.appsSupportedModes[i].writeToParcel(dest, flags);
        }
        dest.writeInt(this.colorMode);
        dest.writeInt(this.supportedColorModes.length);
        for (i = 0; i < this.supportedColorModes.length; ++i) {
            dest.writeInt(this.supportedColorModes[i]);
        }
        dest.writeParcelable(this.hdrCapabilities, flags);
        dest.writeBoolean(this.isForceSdr);
        dest.writeBoolean(this.minimalPostProcessingSupported);
        dest.writeInt(this.logicalDensityDpi);
        dest.writeFloat(this.physicalXDpi);
        dest.writeFloat(this.physicalYDpi);
        dest.writeLong(this.appVsyncOffsetNanos);
        dest.writeLong(this.presentationDeadlineNanos);
        dest.writeInt(this.state);
        dest.writeInt(this.committedState);
        dest.writeInt(this.ownerUid);
        dest.writeString8(this.ownerPackageName);
        dest.writeString8(this.uniqueId);
        dest.writeInt(this.removeMode);
        dest.writeFloat(this.refreshRateOverride);
        dest.writeFloat(this.brightnessMinimum);
        dest.writeFloat(this.brightnessMaximum);
        dest.writeFloat(this.brightnessDefault);
        dest.writeFloat(this.brightnessDim);
        dest.writeTypedObject(this.roundedCorners, flags);
        dest.writeInt(this.userDisabledHdrTypes.length);
        for (i = 0; i < this.userDisabledHdrTypes.length; ++i) {
            dest.writeInt(this.userDisabledHdrTypes[i]);
        }
        dest.writeInt(this.installOrientation);
        dest.writeTypedObject(this.displayShape, flags);
        dest.writeTypedObject(this.layoutLimitedRefreshRate, flags);
        dest.writeFloat(this.hdrSdrRatio);
        dest.writeSparseArray(this.thermalRefreshRateThrottling);
        dest.writeString8(this.thermalBrightnessThrottlingDataId);
        dest.writeBoolean(this.canHostTasks);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public float getRefreshRate() {
        if (this.refreshRateOverride > 0.0f) {
            return this.refreshRateOverride;
        }
        if (this.renderFrameRate > 0.0f) {
            return this.renderFrameRate;
        }
        if (this.supportedModes.length == 0) {
            return 0.0f;
        }
        return this.getMode().getRefreshRate();
    }

    public Display.Mode getMode() {
        return this.findMode(this.modeId);
    }

    public Display.Mode getDefaultMode() {
        return this.findMode(this.defaultModeId);
    }

    private Display.Mode findMode(int id2) {
        for (int i = 0; i < this.supportedModes.length; ++i) {
            if (this.supportedModes[i].getModeId() != id2) continue;
            return this.supportedModes[i];
        }
        throw new IllegalStateException("Unable to locate mode id=" + id2 + ",supportedModes=" + Arrays.toString(this.supportedModes));
    }

    @Nullable
    public Display.Mode findDefaultModeByRefreshRate(float refreshRate) {
        Display.Mode[] modes = this.appsSupportedModes;
        Display.Mode defaultMode = this.getDefaultMode();
        for (int i = 0; i < modes.length; ++i) {
            if (!modes[i].matches(defaultMode.getPhysicalWidth(), defaultMode.getPhysicalHeight(), refreshRate)) continue;
            return modes[i];
        }
        return null;
    }

    public float[] getDefaultRefreshRates() {
        if (this.supportedRefreshRates.length == 0) {
            return this.getDefaultRefreshRatesLegacy();
        }
        return Arrays.copyOf(this.supportedRefreshRates, this.supportedRefreshRates.length);
    }

    public float[] getDefaultRefreshRatesLegacy() {
        Display.Mode[] modes = this.appsSupportedModes;
        ArraySet<Float> rates = new ArraySet<Float>();
        Display.Mode defaultMode = this.getDefaultMode();
        for (int i = 0; i < modes.length; ++i) {
            Display.Mode mode = modes[i];
            if (mode.getPhysicalWidth() != defaultMode.getPhysicalWidth() || mode.getPhysicalHeight() != defaultMode.getPhysicalHeight()) continue;
            rates.add(Float.valueOf(mode.getRefreshRate()));
        }
        float[] result = new float[rates.size()];
        int i = 0;
        for (Float rate : rates) {
            result[i++] = rate.floatValue();
        }
        return result;
    }

    public void getAppMetrics(DisplayMetrics outMetrics) {
        this.getAppMetrics(outMetrics, CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO, null);
    }

    public void getAppMetrics(DisplayMetrics outMetrics, DisplayAdjustments displayAdjustments) {
        this.getMetricsWithSize(outMetrics, displayAdjustments.getCompatibilityInfo(), displayAdjustments.getConfiguration(), this.appWidth, this.appHeight);
    }

    public void getAppMetrics(DisplayMetrics outMetrics, CompatibilityInfo ci, Configuration configuration) {
        this.getMetricsWithSize(outMetrics, ci, configuration, this.appWidth, this.appHeight);
    }

    public void getLogicalMetrics(DisplayMetrics outMetrics, CompatibilityInfo compatInfo, Configuration configuration) {
        this.getMetricsWithSize(outMetrics, compatInfo, configuration, this.logicalWidth, this.logicalHeight);
    }

    public void getMaxBoundsMetrics(DisplayMetrics outMetrics, CompatibilityInfo compatInfo, Configuration configuration) {
        Rect bounds = configuration.windowConfiguration.getMaxBounds();
        this.getMetricsWithSize(outMetrics, compatInfo, null, bounds.width(), bounds.height());
    }

    public int getNaturalWidth() {
        return this.rotation == 0 || this.rotation == 2 ? this.logicalWidth : this.logicalHeight;
    }

    public int getNaturalHeight() {
        return this.rotation == 0 || this.rotation == 2 ? this.logicalHeight : this.logicalWidth;
    }

    public boolean isHdr() {
        int[] types = this.hdrCapabilities != null ? this.hdrCapabilities.getSupportedHdrTypes() : null;
        return types != null && types.length > 0;
    }

    public boolean isWideColorGamut() {
        for (int colorMode : this.supportedColorModes) {
            if (colorMode != 6 && colorMode <= 7) continue;
            return true;
        }
        return false;
    }

    public boolean hasAccess(int uid) {
        return Display.hasAccess(uid, this.flags, this.ownerUid, this.displayId);
    }

    private void getMetricsWithSize(DisplayMetrics outMetrics, CompatibilityInfo compatInfo, Configuration configuration, int width, int height) {
        outMetrics.densityDpi = outMetrics.noncompatDensityDpi = this.logicalDensityDpi;
        outMetrics.scaledDensity = outMetrics.noncompatScaledDensity = (outMetrics.density = (outMetrics.noncompatDensity = (float)this.logicalDensityDpi * 0.00625f));
        outMetrics.xdpi = outMetrics.noncompatXdpi = this.physicalXDpi;
        outMetrics.ydpi = outMetrics.noncompatYdpi = this.physicalYDpi;
        Rect appBounds = configuration != null ? configuration.windowConfiguration.getAppBounds() : null;
        width = appBounds != null ? appBounds.width() : width;
        height = appBounds != null ? appBounds.height() : height;
        outMetrics.noncompatWidthPixels = outMetrics.widthPixels = width;
        outMetrics.noncompatHeightPixels = outMetrics.heightPixels = height;
        boolean applyToSize = configuration != null && appBounds == null;
        compatInfo.applyDisplayMetricsIfNeeded(outMetrics, applyToSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DisplayInfo{\"");
        sb.append(this.name);
        sb.append("\", displayId ");
        sb.append(this.displayId);
        sb.append(", displayGroupId ");
        sb.append(this.displayGroupId);
        sb.append(DisplayInfo.flagsToString(this.flags));
        sb.append(", real ");
        sb.append(this.logicalWidth);
        sb.append(" x ");
        sb.append(this.logicalHeight);
        sb.append(", largest app ");
        sb.append(this.largestNominalAppWidth);
        sb.append(" x ");
        sb.append(this.largestNominalAppHeight);
        sb.append(", smallest app ");
        sb.append(this.smallestNominalAppWidth);
        sb.append(" x ");
        sb.append(this.smallestNominalAppHeight);
        sb.append(", appVsyncOff ");
        sb.append(this.appVsyncOffsetNanos);
        sb.append(", presDeadline ");
        sb.append(this.presentationDeadlineNanos);
        sb.append(", mode ");
        sb.append(this.modeId);
        sb.append(", renderFrameRate ");
        sb.append(this.renderFrameRate);
        sb.append(", hasArrSupport ");
        sb.append(this.hasArrSupport);
        sb.append(", frameRateCategoryRate ");
        sb.append(this.frameRateCategoryRate);
        sb.append(", supportedRefreshRates ");
        sb.append(Arrays.toString(this.supportedRefreshRates));
        sb.append(", defaultMode ");
        sb.append(this.defaultModeId);
        sb.append(", userPreferredModeId ");
        sb.append(this.userPreferredModeId);
        sb.append(", supportedModes ");
        sb.append(Arrays.toString(this.supportedModes));
        sb.append(", appsSupportedModes ");
        sb.append(Arrays.toString(this.appsSupportedModes));
        sb.append(", hdrCapabilities ");
        sb.append(this.hdrCapabilities);
        sb.append(", isForceSdr ");
        sb.append(this.isForceSdr);
        sb.append(", userDisabledHdrTypes ");
        sb.append(Arrays.toString(this.userDisabledHdrTypes));
        sb.append(", minimalPostProcessingSupported ");
        sb.append(this.minimalPostProcessingSupported);
        sb.append(", rotation ");
        sb.append(this.rotation);
        sb.append(", state ");
        sb.append(Display.stateToString(this.state));
        sb.append(", committedState ");
        sb.append(Display.stateToString(this.committedState));
        if (Process.myUid() != 1000) {
            sb.append("}");
            return sb.toString();
        }
        sb.append(", type ");
        sb.append(Display.typeToString(this.type));
        sb.append(", uniqueId \"");
        sb.append(this.uniqueId);
        sb.append("\", app ");
        sb.append(this.appWidth);
        sb.append(" x ");
        sb.append(this.appHeight);
        sb.append(", density ");
        sb.append(this.logicalDensityDpi);
        sb.append(" (");
        sb.append(this.physicalXDpi);
        sb.append(" x ");
        sb.append(this.physicalYDpi);
        sb.append(") dpi, layerStack ");
        sb.append(this.layerStack);
        sb.append(", colorMode ");
        sb.append(this.colorMode);
        sb.append(", supportedColorModes ");
        sb.append(Arrays.toString(this.supportedColorModes));
        if (this.address != null) {
            sb.append(", address ").append(this.address);
        }
        sb.append(", deviceProductInfo ");
        sb.append(this.deviceProductInfo);
        if (this.ownerUid != 0 || this.ownerPackageName != null) {
            sb.append(", owner ").append(this.ownerPackageName);
            sb.append(" (uid ").append(this.ownerUid).append(")");
        }
        sb.append(", removeMode ");
        sb.append(this.removeMode);
        sb.append(", refreshRateOverride ");
        sb.append(this.refreshRateOverride);
        sb.append(", brightnessMinimum ");
        sb.append(this.brightnessMinimum);
        sb.append(", brightnessMaximum ");
        sb.append(this.brightnessMaximum);
        sb.append(", brightnessDefault ");
        sb.append(this.brightnessDefault);
        sb.append(", brightnessDim ");
        sb.append(this.brightnessDim);
        sb.append(", installOrientation ");
        sb.append(Surface.rotationToString(this.installOrientation));
        sb.append(", layoutLimitedRefreshRate ");
        sb.append(this.layoutLimitedRefreshRate);
        sb.append(", hdrSdrRatio ");
        if (Float.isNaN(this.hdrSdrRatio)) {
            sb.append("not_available");
        } else {
            sb.append(this.hdrSdrRatio);
        }
        sb.append(", thermalRefreshRateThrottling ");
        sb.append(this.thermalRefreshRateThrottling);
        sb.append(", thermalBrightnessThrottlingDataId ");
        sb.append(this.thermalBrightnessThrottlingDataId);
        sb.append(", canHostTasks ");
        sb.append(this.canHostTasks);
        sb.append("}");
        return sb.toString();
    }

    public void dumpDebug(ProtoOutputStream protoOutputStream, long fieldId) {
        long token = protoOutputStream.start(fieldId);
        protoOutputStream.write(0x10500000001L, this.logicalWidth);
        protoOutputStream.write(1120986464258L, this.logicalHeight);
        protoOutputStream.write(1120986464259L, this.appWidth);
        protoOutputStream.write(1120986464260L, this.appHeight);
        protoOutputStream.write(1138166333445L, this.name);
        protoOutputStream.write(1120986464262L, this.flags);
        protoOutputStream.write(1120986464264L, this.type);
        if (this.displayCutout != null) {
            this.displayCutout.dumpDebug(protoOutputStream, 1146756268039L);
        }
        protoOutputStream.end(token);
    }

    private static String flagsToString(int flags) {
        StringBuilder result = new StringBuilder();
        if ((flags & 2) != 0) {
            result.append(", FLAG_SECURE");
        }
        if ((flags & 1) != 0) {
            result.append(", FLAG_SUPPORTS_PROTECTED_BUFFERS");
        }
        if ((flags & 4) != 0) {
            result.append(", FLAG_PRIVATE");
        }
        if ((flags & 8) != 0) {
            result.append(", FLAG_PRESENTATION");
        }
        if ((flags & 0x40000000) != 0) {
            result.append(", FLAG_SCALING_DISABLED");
        }
        if ((flags & 0x10) != 0) {
            result.append(", FLAG_ROUND");
        }
        if ((flags & 0x20) != 0) {
            result.append(", FLAG_CAN_SHOW_WITH_INSECURE_KEYGUARD");
        }
        if ((flags & 0x40) != 0) {
            result.append(", FLAG_SHOULD_SHOW_SYSTEM_DECORATIONS");
        }
        if ((flags & 0x80) != 0) {
            result.append(", FLAG_TRUSTED");
        }
        if ((flags & 0x100) != 0) {
            result.append(", FLAG_OWN_DISPLAY_GROUP");
        }
        if ((flags & 0x200) != 0) {
            result.append(", FLAG_ALWAYS_UNLOCKED");
        }
        if ((flags & 0x400) != 0) {
            result.append(", FLAG_TOUCH_FEEDBACK_DISABLED");
        }
        if ((flags & 0x2000) != 0) {
            result.append(", FLAG_REAR_DISPLAY");
        }
        if ((flags & 0x8000) != 0) {
            result.append(", FLAG_ALLOWS_CONTENT_MODE_SWITCH");
        }
        return result.toString();
    }
}

