/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Insets;
import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.DisplayUtils;
import android.util.Pair;
import android.util.RotationUtils;
import android.util.proto.ProtoOutputStream;
import android.view.CutoutSpecification;
import android.view.Surface;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DisplayCutout {
    private static final String TAG = "DisplayCutout";
    public static final String EMULATION_OVERLAY_CATEGORY = "com.android.internal.display_cutout_emulation";
    private static final Rect ZERO_RECT = new Rect();
    private static final CutoutPathParserInfo EMPTY_PARSER_INFO = new CutoutPathParserInfo(0, 0, 0, 0, 0.0f, "", 0, 0.0f, 0.0f);
    public static final DisplayCutout NO_CUTOUT = new DisplayCutout(ZERO_RECT, Insets.NONE, ZERO_RECT, ZERO_RECT, ZERO_RECT, ZERO_RECT, EMPTY_PARSER_INFO, false);
    private static final Pair<Path, DisplayCutout> NULL_PAIR = new Pair<Object, Object>(null, null);
    private static final Object CACHE_LOCK = new Object();
    @GuardedBy(value={"CACHE_LOCK"})
    private static String sCachedSpec;
    @GuardedBy(value={"CACHE_LOCK"})
    private static int sCachedDisplayWidth;
    @GuardedBy(value={"CACHE_LOCK"})
    private static int sCachedDisplayHeight;
    @GuardedBy(value={"CACHE_LOCK"})
    private static float sCachedDensity;
    @GuardedBy(value={"CACHE_LOCK"})
    private static Pair<Path, DisplayCutout> sCachedCutout;
    @GuardedBy(value={"CACHE_LOCK"})
    private static Insets sCachedWaterfallInsets;
    @GuardedBy(value={"CACHE_LOCK"})
    private static float sCachedPhysicalPixelDisplaySizeRatio;
    @GuardedBy(value={"CACHE_LOCK"})
    private static int[] sCachedSideOverrides;
    @GuardedBy(value={"CACHE_LOCK"})
    private static CutoutPathParserInfo sCachedCutoutPathParserInfo;
    @GuardedBy(value={"CACHE_LOCK"})
    private static Path sCachedCutoutPath;
    private final Rect mSafeInsets;
    @NonNull
    private final Insets mWaterfallInsets;
    public static final int BOUNDS_POSITION_LEFT = 0;
    public static final int BOUNDS_POSITION_TOP = 1;
    public static final int BOUNDS_POSITION_RIGHT = 2;
    public static final int BOUNDS_POSITION_BOTTOM = 3;
    public static final int BOUNDS_POSITION_LENGTH = 4;
    private static final int INVALID_SIDE_OVERRIDE = -1;
    private static final String SIDE_STRING_TOP = "top";
    private static final String SIDE_STRING_BOTTOM = "bottom";
    private static final String SIDE_STRING_RIGHT = "right";
    private static final String SIDE_STRING_LEFT = "left";
    private int[] mSideOverrides;
    static final int[] INVALID_OVERRIDES;
    private final Bounds mBounds;
    @NonNull
    private final CutoutPathParserInfo mCutoutPathParserInfo;

    public DisplayCutout(@NonNull Insets safeInsets, @Nullable Rect boundLeft, @Nullable Rect boundTop, @Nullable Rect boundRight, @Nullable Rect boundBottom) {
        this(DisplayCutout.getCopyOrRef(safeInsets.toRect(), true), Insets.NONE, new Bounds(boundLeft, boundTop, boundRight, boundBottom, true), null, null);
    }

    @VisibleForTesting
    public DisplayCutout(@NonNull Insets safeInsets, @Nullable Rect boundLeft, @Nullable Rect boundTop, @Nullable Rect boundRight, @Nullable Rect boundBottom, @NonNull Insets waterfallInsets, @Nullable CutoutPathParserInfo info) {
        this(DisplayCutout.getCopyOrRef(safeInsets.toRect(), true), waterfallInsets, new Bounds(boundLeft, boundTop, boundRight, boundBottom, true), info, null);
    }

    public DisplayCutout(@NonNull Insets safeInsets, @Nullable Rect boundLeft, @Nullable Rect boundTop, @Nullable Rect boundRight, @Nullable Rect boundBottom, @NonNull Insets waterfallInsets, @Nullable CutoutPathParserInfo info, @Nullable int[] sideOverrides) {
        this(safeInsets.toRect(), waterfallInsets, new Bounds(boundLeft, boundTop, boundRight, boundBottom, true), info, sideOverrides);
    }

    public DisplayCutout(@NonNull Insets safeInsets, @Nullable Rect boundLeft, @Nullable Rect boundTop, @Nullable Rect boundRight, @Nullable Rect boundBottom, @NonNull Insets waterfallInsets) {
        this(DisplayCutout.getCopyOrRef(safeInsets.toRect(), true), waterfallInsets, new Bounds(boundLeft, boundTop, boundRight, boundBottom, true), null, null);
    }

    @Deprecated
    public DisplayCutout(@Nullable Rect safeInsets, @Nullable List<Rect> boundingRects) {
        this(DisplayCutout.getCopyOrRef(safeInsets, true), Insets.NONE, new Bounds(DisplayCutout.extractBoundsFromList(safeInsets, boundingRects), true), null, null);
    }

    private DisplayCutout(Rect safeInsets, Insets waterfallInsets, Rect boundLeft, Rect boundTop, Rect boundRight, Rect boundBottom, CutoutPathParserInfo info, boolean copyArguments) {
        this(DisplayCutout.getCopyOrRef(safeInsets, copyArguments), waterfallInsets, new Bounds(boundLeft, boundTop, boundRight, boundBottom, copyArguments), info, null);
    }

    private DisplayCutout(Rect safeInsets, Insets waterfallInsets, Rect[] bounds, CutoutPathParserInfo info, boolean copyArguments) {
        this(DisplayCutout.getCopyOrRef(safeInsets, copyArguments), waterfallInsets, new Bounds(bounds, copyArguments), info, null);
    }

    private DisplayCutout(Rect safeInsets, Insets waterfallInsets, Bounds bounds, CutoutPathParserInfo info) {
        this(safeInsets, waterfallInsets, bounds, info, null);
    }

    private DisplayCutout(Rect safeInsets, Insets waterfallInsets, Bounds bounds, CutoutPathParserInfo info, int[] sideOverrides) {
        this.mSafeInsets = safeInsets;
        this.mWaterfallInsets = waterfallInsets == null ? Insets.NONE : waterfallInsets;
        this.mBounds = bounds;
        this.mCutoutPathParserInfo = info == null ? EMPTY_PARSER_INFO : info;
        this.mSideOverrides = sideOverrides;
    }

    private static Rect getCopyOrRef(Rect r, boolean copyArguments) {
        if (r == null) {
            return ZERO_RECT;
        }
        if (copyArguments) {
            return new Rect(r);
        }
        return r;
    }

    @NonNull
    public Insets getWaterfallInsets() {
        return this.mWaterfallInsets;
    }

    public static Rect[] extractBoundsFromList(Rect safeInsets, List<Rect> boundingRects) {
        Rect[] sortedBounds = new Rect[4];
        for (int i = 0; i < sortedBounds.length; ++i) {
            sortedBounds[i] = ZERO_RECT;
        }
        if (safeInsets != null && boundingRects != null) {
            boolean topBottomInset = safeInsets.top > 0 || safeInsets.bottom > 0;
            for (Rect bound : boundingRects) {
                if (topBottomInset) {
                    if (bound.top == 0) {
                        sortedBounds[1] = bound;
                        continue;
                    }
                    sortedBounds[3] = bound;
                    continue;
                }
                if (bound.left == 0) {
                    sortedBounds[0] = bound;
                    continue;
                }
                sortedBounds[2] = bound;
            }
        }
        return sortedBounds;
    }

    public boolean isBoundsEmpty() {
        return this.mBounds.isEmpty();
    }

    public boolean isEmpty() {
        return this.mSafeInsets.equals(ZERO_RECT);
    }

    public int getSafeInsetTop() {
        return this.mSafeInsets.top;
    }

    public int getSafeInsetBottom() {
        return this.mSafeInsets.bottom;
    }

    public int getSafeInsetLeft() {
        return this.mSafeInsets.left;
    }

    public int getSafeInsetRight() {
        return this.mSafeInsets.right;
    }

    public Rect getSafeInsets() {
        return new Rect(this.mSafeInsets);
    }

    @NonNull
    public List<Rect> getBoundingRects() {
        ArrayList<Rect> result = new ArrayList<Rect>();
        for (Rect bound : this.getBoundingRectsAll()) {
            if (bound.isEmpty()) continue;
            result.add(new Rect(bound));
        }
        return result;
    }

    public Rect[] getBoundingRectsAll() {
        return this.mBounds.getRects();
    }

    @NonNull
    public Rect getBoundingRectLeft() {
        return this.mBounds.getRect(0);
    }

    @NonNull
    public Rect getBoundingRectTop() {
        return this.mBounds.getRect(1);
    }

    @NonNull
    public Rect getBoundingRectRight() {
        return this.mBounds.getRect(2);
    }

    @NonNull
    public Rect getBoundingRectBottom() {
        return this.mBounds.getRect(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Path getCutoutPath() {
        if (!this.mCutoutPathParserInfo.hasCutout()) {
            return null;
        }
        Object object = CACHE_LOCK;
        synchronized (object) {
            if (this.mCutoutPathParserInfo.equals(sCachedCutoutPathParserInfo)) {
                return sCachedCutoutPath;
            }
        }
        CutoutSpecification cutoutSpec = new CutoutSpecification.Parser(this.mCutoutPathParserInfo.getDensity(), this.mCutoutPathParserInfo.getPhysicalDisplayWidth(), this.mCutoutPathParserInfo.getPhysicalDisplayHeight(), this.mCutoutPathParserInfo.getPhysicalPixelDisplaySizeRatio()).parse(this.mCutoutPathParserInfo.getCutoutSpec());
        Path cutoutPath = cutoutSpec.getPath();
        if (cutoutPath == null || cutoutPath.isEmpty()) {
            return null;
        }
        Matrix matrix = new Matrix();
        if (this.mCutoutPathParserInfo.getRotation() != 0) {
            RotationUtils.transformPhysicalToLogicalCoordinates(this.mCutoutPathParserInfo.getRotation(), this.mCutoutPathParserInfo.getDisplayWidth(), this.mCutoutPathParserInfo.getDisplayHeight(), matrix);
        }
        matrix.postScale(this.mCutoutPathParserInfo.getScale(), this.mCutoutPathParserInfo.getScale());
        cutoutPath.transform(matrix);
        Object object2 = CACHE_LOCK;
        synchronized (object2) {
            sCachedCutoutPathParserInfo = new CutoutPathParserInfo(this.mCutoutPathParserInfo);
            sCachedCutoutPath = cutoutPath;
        }
        return cutoutPath;
    }

    public CutoutPathParserInfo getCutoutPathParserInfo() {
        return this.mCutoutPathParserInfo;
    }

    public int hashCode() {
        int result = 0;
        result = 48271 * result + this.mSafeInsets.hashCode();
        result = 48271 * result + this.mBounds.hashCode();
        result = 48271 * result + this.mWaterfallInsets.hashCode();
        result = 48271 * result + this.mCutoutPathParserInfo.hashCode();
        result = 48271 * result + Arrays.hashCode(this.mSideOverrides);
        return result;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DisplayCutout) {
            DisplayCutout c = (DisplayCutout)o;
            return this.mSafeInsets.equals(c.mSafeInsets) && this.mBounds.equals(c.mBounds) && this.mWaterfallInsets.equals(c.mWaterfallInsets) && this.mCutoutPathParserInfo.equals(c.mCutoutPathParserInfo) && Arrays.equals(this.mSideOverrides, c.mSideOverrides);
        }
        return false;
    }

    public String toString() {
        return "DisplayCutout{insets=" + this.mSafeInsets + " waterfall=" + this.mWaterfallInsets + " boundingRect={" + this.mBounds + "} cutoutPathParserInfo={" + this.mCutoutPathParserInfo + "} sideOverrides=" + DisplayCutout.sideOverridesToString(this.mSideOverrides) + "}";
    }

    private static String sideOverridesToString(int[] sideOverrides) {
        if (sideOverrides == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        int length = sideOverrides.length;
        if (length != 4) {
            sb.append("length=").append(sideOverrides.length).append(". ");
        }
        boolean hasContent = false;
        for (int i = 0; i < length; ++i) {
            int override = sideOverrides[i];
            if (override == -1) continue;
            if (hasContent) {
                sb.append(", ");
            }
            sb.append(Surface.rotationToString(i)).append(": ");
            switch (override) {
                case 0: {
                    sb.append(SIDE_STRING_LEFT);
                    break;
                }
                case 1: {
                    sb.append(SIDE_STRING_TOP);
                    break;
                }
                case 2: {
                    sb.append(SIDE_STRING_RIGHT);
                    break;
                }
                case 3: {
                    sb.append(SIDE_STRING_BOTTOM);
                }
            }
            hasContent = true;
        }
        return sb.append("}").toString();
    }

    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        this.mSafeInsets.dumpDebug(proto, 0x10B00000001L);
        this.mBounds.getRect(0).dumpDebug(proto, 1146756268035L);
        this.mBounds.getRect(1).dumpDebug(proto, 1146756268036L);
        this.mBounds.getRect(2).dumpDebug(proto, 1146756268037L);
        this.mBounds.getRect(3).dumpDebug(proto, 1146756268038L);
        this.mWaterfallInsets.toRect().dumpDebug(proto, 1146756268039L);
        if (this.mSideOverrides != null) {
            for (int sideOverride : this.mSideOverrides) {
                proto.write(2220498092040L, sideOverride);
            }
        }
        proto.end(token);
    }

    public DisplayCutout inset(int insetLeft, int insetTop, int insetRight, int insetBottom) {
        if (insetLeft == 0 && insetTop == 0 && insetRight == 0 && insetBottom == 0 || this.isBoundsEmpty() && this.mWaterfallInsets.equals(Insets.NONE)) {
            return this;
        }
        Rect safeInsets = this.insetInsets(insetLeft, insetTop, insetRight, insetBottom, new Rect(this.mSafeInsets));
        if (insetLeft == 0 && insetTop == 0 && this.mSafeInsets.equals(safeInsets)) {
            return this;
        }
        Rect waterfallInsets = this.insetInsets(insetLeft, insetTop, insetRight, insetBottom, this.mWaterfallInsets.toRect());
        Rect[] bounds = this.mBounds.getRects();
        for (int i = 0; i < bounds.length; ++i) {
            if (bounds[i].equals(ZERO_RECT)) continue;
            bounds[i].offset(-insetLeft, -insetTop);
        }
        return new DisplayCutout(safeInsets, Insets.of(waterfallInsets), bounds, this.mCutoutPathParserInfo, false);
    }

    private Rect insetInsets(int insetLeft, int insetTop, int insetRight, int insetBottom, Rect insets) {
        if (insetTop > 0 || insets.top > 0) {
            insets.top = DisplayCutout.atLeastZero(insets.top - insetTop);
        }
        if (insetBottom > 0 || insets.bottom > 0) {
            insets.bottom = DisplayCutout.atLeastZero(insets.bottom - insetBottom);
        }
        if (insetLeft > 0 || insets.left > 0) {
            insets.left = DisplayCutout.atLeastZero(insets.left - insetLeft);
        }
        if (insetRight > 0 || insets.right > 0) {
            insets.right = DisplayCutout.atLeastZero(insets.right - insetRight);
        }
        return insets;
    }

    public DisplayCutout replaceSafeInsets(Rect safeInsets) {
        return new DisplayCutout(new Rect(safeInsets), this.mWaterfallInsets, this.mBounds, this.mCutoutPathParserInfo, this.mSideOverrides);
    }

    private static int atLeastZero(int value) {
        return value < 0 ? 0 : value;
    }

    @VisibleForTesting
    public static DisplayCutout fromBoundingRect(int left, int top, int right, int bottom, int pos) {
        Rect[] bounds = new Rect[4];
        for (int i = 0; i < 4; ++i) {
            bounds[i] = pos == i ? new Rect(left, top, right, bottom) : new Rect();
        }
        return new DisplayCutout(ZERO_RECT, Insets.NONE, bounds, null, false);
    }

    public static DisplayCutout constructDisplayCutout(Rect[] bounds, Insets waterfallInsets, CutoutPathParserInfo info) {
        return new DisplayCutout(ZERO_RECT, waterfallInsets, bounds, info, false);
    }

    public static DisplayCutout fromBounds(Rect[] bounds) {
        return new DisplayCutout(ZERO_RECT, Insets.NONE, bounds, null, false);
    }

    private static String getDisplayCutoutPath(Resources res, String displayUniqueId) {
        int index = DisplayUtils.getDisplayUniqueIdConfigIndex(res, displayUniqueId);
        String[] array2 = res.getStringArray(17236049);
        if (index >= 0 && index < array2.length) {
            return array2[index];
        }
        return res.getString(17040018);
    }

    private static String getDisplayCutoutApproximationRect(Resources res, String displayUniqueId) {
        int index = DisplayUtils.getDisplayUniqueIdConfigIndex(res, displayUniqueId);
        String[] array2 = res.getStringArray(17236048);
        if (index >= 0 && index < array2.length) {
            return array2[index];
        }
        return res.getString(17040019);
    }

    public static boolean getMaskBuiltInDisplayCutout(Resources res, String displayUniqueId) {
        int index = DisplayUtils.getDisplayUniqueIdConfigIndex(res, displayUniqueId);
        TypedArray array2 = res.obtainTypedArray(17236116);
        boolean maskCutout = index >= 0 && index < array2.length() ? array2.getBoolean(index, false) : res.getBoolean(17891823);
        array2.recycle();
        return maskCutout;
    }

    public static boolean getFillBuiltInDisplayCutout(Resources res, String displayUniqueId) {
        int index = DisplayUtils.getDisplayUniqueIdConfigIndex(res, displayUniqueId);
        TypedArray array2 = res.obtainTypedArray(0x1070077);
        boolean fillCutout = index >= 0 && index < array2.length() ? array2.getBoolean(index, false) : res.getBoolean(17891753);
        array2.recycle();
        return fillCutout;
    }

    private static Insets getWaterfallInsets(Resources res, String displayUniqueId) {
        Insets insets;
        int resourceId;
        int index = DisplayUtils.getDisplayUniqueIdConfigIndex(res, displayUniqueId);
        TypedArray array2 = res.obtainTypedArray(17236200);
        int n = resourceId = index >= 0 && index < array2.length() ? array2.getResourceId(index, 0) : 0;
        if (resourceId != 0) {
            TypedArray waterfall = res.obtainTypedArray(resourceId);
            insets = Insets.of(waterfall.getDimensionPixelSize(0, 0), waterfall.getDimensionPixelSize(1, 0), waterfall.getDimensionPixelSize(2, 0), waterfall.getDimensionPixelSize(3, 0));
            waterfall.recycle();
        } else {
            insets = DisplayCutout.loadWaterfallInset(res);
        }
        array2.recycle();
        return insets;
    }

    private static int[] getDisplayCutoutSideOverrides(Resources res, String displayUniqueId) throws IllegalArgumentException {
        if (!Flags.movableCutoutConfiguration()) {
            return null;
        }
        int index = DisplayUtils.getDisplayUniqueIdConfigIndex(res, displayUniqueId);
        TypedArray array2 = res.obtainTypedArray(17236050);
        int resourceId = index >= 0 && index < array2.length() ? array2.getResourceId(index, 0) : 0;
        int[] rawOverrides = resourceId != 0 ? array2.getResources().getIntArray(resourceId) : res.getIntArray(17236113);
        array2.recycle();
        if (rawOverrides.length == 0) {
            return INVALID_OVERRIDES;
        }
        if (rawOverrides.length != 4) {
            throw new IllegalArgumentException("Invalid side override definition, exact 4 overrides required: " + Arrays.toString(rawOverrides));
        }
        for (int rotation = 0; rotation <= 3; ++rotation) {
            if (rawOverrides[rotation] >= 0 && rawOverrides[rotation] < 4) continue;
            throw new IllegalArgumentException("Invalid side override definition: " + Arrays.toString(rawOverrides));
        }
        return rawOverrides;
    }

    public static DisplayCutout fromResourcesRectApproximation(Resources res, String displayUniqueId, int physicalDisplayWidth, int physicalDisplayHeight, int displayWidth, int displayHeight) {
        return (DisplayCutout)DisplayCutout.pathAndDisplayCutoutFromSpec((String)DisplayCutout.getDisplayCutoutPath((Resources)res, (String)displayUniqueId), (String)DisplayCutout.getDisplayCutoutApproximationRect((Resources)res, (String)displayUniqueId), (int)physicalDisplayWidth, (int)physicalDisplayHeight, (int)displayWidth, (int)displayHeight, (float)((float)DisplayMetrics.DENSITY_DEVICE_STABLE / 160.0f), (Insets)DisplayCutout.getWaterfallInsets((Resources)res, (String)displayUniqueId), (int[])DisplayCutout.getDisplayCutoutSideOverrides((Resources)res, (String)displayUniqueId)).second;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public static DisplayCutout fromSpec(String pathSpec, int displayWidth, int displayHeight, float density, Insets waterfallInsets, int[] sideOverrides) {
        return (DisplayCutout)DisplayCutout.pathAndDisplayCutoutFromSpec((String)pathSpec, null, (int)displayWidth, (int)displayHeight, (int)displayWidth, (int)displayHeight, (float)density, (Insets)waterfallInsets, (int[])sideOverrides).second;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pair<Path, DisplayCutout> pathAndDisplayCutoutFromSpec(String pathSpec, String rectSpec, int physicalDisplayWidth, int physicalDisplayHeight, int displayWidth, int displayHeight, float density, Insets waterfallInsets, int[] sideOverrides) {
        Rect[] bounds;
        String spec;
        String string2 = spec = rectSpec != null ? rectSpec : pathSpec;
        if (TextUtils.isEmpty(spec) && waterfallInsets.equals(Insets.NONE)) {
            return NULL_PAIR;
        }
        float physicalPixelDisplaySizeRatio = DisplayUtils.getPhysicalPixelDisplaySizeRatio(physicalDisplayWidth, physicalDisplayHeight, displayWidth, displayHeight);
        Object object = CACHE_LOCK;
        synchronized (object) {
            if (spec.equals(sCachedSpec) && sCachedDisplayWidth == displayWidth && sCachedDisplayHeight == displayHeight && sCachedDensity == density && waterfallInsets.equals(sCachedWaterfallInsets) && sCachedPhysicalPixelDisplaySizeRatio == physicalPixelDisplaySizeRatio && Arrays.equals(sCachedSideOverrides, sideOverrides)) {
                return sCachedCutout;
            }
        }
        spec = spec.trim();
        CutoutSpecification cutoutSpec = new CutoutSpecification.Parser(density, physicalDisplayWidth, physicalDisplayHeight, physicalPixelDisplaySizeRatio).parse(spec);
        Rect safeInset = cutoutSpec.getSafeInset();
        Rect boundLeft = cutoutSpec.getLeftBound();
        Rect boundTop = cutoutSpec.getTopBound();
        Rect boundRight = cutoutSpec.getRightBound();
        Rect boundBottom = cutoutSpec.getBottomBound();
        if (!waterfallInsets.equals(Insets.NONE)) {
            safeInset.set(Math.max(waterfallInsets.left, safeInset.left), Math.max(waterfallInsets.top, safeInset.top), Math.max(waterfallInsets.right, safeInset.right), Math.max(waterfallInsets.bottom, safeInset.bottom));
        }
        CutoutPathParserInfo cutoutPathParserInfo = new CutoutPathParserInfo(displayWidth, displayHeight, physicalDisplayWidth, physicalDisplayHeight, density, pathSpec.trim(), 0, 1.0f, physicalPixelDisplaySizeRatio);
        int sideOverride = DisplayCutout.getSideOverride(sideOverrides, 0);
        int rotateDistance = DisplayCutout.getRotationToOverride(sideOverride, bounds = new Bounds(boundLeft, boundTop, boundRight, boundBottom, false).getRects(), 0);
        if (rotateDistance != 0) {
            Collections.rotate(Arrays.asList(bounds), rotateDistance);
        }
        Rect safeInsets = DisplayCutout.computeSafeInsets(displayWidth, displayHeight, waterfallInsets, bounds);
        DisplayCutout cutout = new DisplayCutout(safeInsets, waterfallInsets, new Bounds(bounds[0], bounds[1], bounds[2], bounds[3], false), cutoutPathParserInfo, sideOverrides);
        Pair<Path, DisplayCutout> result = new Pair<Path, DisplayCutout>(cutoutSpec.getPath(), cutout);
        Object object2 = CACHE_LOCK;
        synchronized (object2) {
            sCachedSpec = spec;
            sCachedDisplayWidth = displayWidth;
            sCachedDisplayHeight = displayHeight;
            sCachedDensity = density;
            sCachedCutout = result;
            sCachedWaterfallInsets = waterfallInsets;
            sCachedPhysicalPixelDisplaySizeRatio = physicalPixelDisplaySizeRatio;
            sCachedSideOverrides = sideOverrides;
        }
        return result;
    }

    private static Insets loadWaterfallInset(Resources res) {
        return Insets.of(res.getDimensionPixelSize(17105844), res.getDimensionPixelSize(17105846), res.getDimensionPixelSize(17105845), res.getDimensionPixelSize(17105843));
    }

    public DisplayCutout getRotated(int startWidth, int startHeight, int fromRotation, int toRotation) {
        if (this == NO_CUTOUT) {
            return NO_CUTOUT;
        }
        int rotation = RotationUtils.deltaRotation(fromRotation, toRotation);
        if (rotation == 0) {
            return this;
        }
        Insets waterfallInsets = RotationUtils.rotateInsets(this.getWaterfallInsets(), rotation);
        Rect[] newBounds = this.getBoundingRectsAll();
        Rect displayBounds = new Rect(0, 0, startWidth, startHeight);
        for (int i = 0; i < newBounds.length; ++i) {
            if (newBounds[i].isEmpty()) continue;
            RotationUtils.rotateBounds(newBounds[i], displayBounds, rotation);
        }
        int defaultRotation = -rotation;
        int override = DisplayCutout.getSideOverride(this.mSideOverrides, toRotation);
        Collections.rotate(Arrays.asList(newBounds), DisplayCutout.getRotationToOverride(override, newBounds, defaultRotation));
        CutoutPathParserInfo info = this.getCutoutPathParserInfo();
        CutoutPathParserInfo newInfo = new CutoutPathParserInfo(info.getDisplayWidth(), info.getDisplayHeight(), info.getPhysicalDisplayWidth(), info.getPhysicalDisplayHeight(), info.getDensity(), info.getCutoutSpec(), toRotation, info.getScale(), info.getPhysicalPixelDisplaySizeRatio());
        boolean swapAspect = rotation % 2 != 0;
        int endWidth = swapAspect ? startHeight : startWidth;
        int endHeight = swapAspect ? startWidth : startHeight;
        DisplayCutout tmp = DisplayCutout.constructDisplayCutout(newBounds, waterfallInsets, newInfo);
        Rect safeInsets = DisplayCutout.computeSafeInsets(endWidth, endHeight, tmp);
        tmp.mSideOverrides = this.mSideOverrides;
        return tmp.replaceSafeInsets(safeInsets);
    }

    private static int getSideOverride(int[] sideOverrides, int rotation) {
        if (sideOverrides == null || sideOverrides.length != 4) {
            return -1;
        }
        return sideOverrides[rotation];
    }

    private static int getRotationToOverride(int sideOverride, Rect[] bounds, int defaultRotation) {
        if (sideOverride == -1) {
            return defaultRotation;
        }
        int side = -1;
        for (int i = 0; i <= 3; ++i) {
            if (bounds[i].isEmpty()) continue;
            if (side != -1) {
                return defaultRotation;
            }
            side = i;
        }
        if (side == -1) {
            return defaultRotation;
        }
        int rotation = sideOverride - side;
        if (rotation < 0) {
            rotation += 4;
        }
        return rotation;
    }

    public static Rect computeSafeInsets(int displayW, int displayH, DisplayCutout cutout) {
        return DisplayCutout.computeSafeInsets(displayW, displayH, cutout.getWaterfallInsets(), cutout.getBoundingRectsAll());
    }

    private static Rect computeSafeInsets(int displayW, int displayH, Insets waterFallInsets, Rect[] bounds) {
        int leftInset = Math.max(waterFallInsets.left, DisplayCutout.findCutoutInsetForSide(displayW, displayH, bounds[0], 3));
        int topInset = Math.max(waterFallInsets.top, DisplayCutout.findCutoutInsetForSide(displayW, displayH, bounds[1], 48));
        int rightInset = Math.max(waterFallInsets.right, DisplayCutout.findCutoutInsetForSide(displayW, displayH, bounds[2], 5));
        int bottomInset = Math.max(waterFallInsets.bottom, DisplayCutout.findCutoutInsetForSide(displayW, displayH, bounds[3], 80));
        return new Rect(leftInset, topInset, rightInset, bottomInset);
    }

    private static int findCutoutInsetForSide(int displayW, int displayH, @NonNull Rect boundingRect, int gravity) {
        int n;
        if (boundingRect.isEmpty()) {
            return 0;
        }
        int inset = 0;
        switch (gravity) {
            case 48: {
                n = Math.max(inset, boundingRect.bottom);
                break;
            }
            case 80: {
                n = Math.max(inset, displayH - boundingRect.top);
                break;
            }
            case 3: {
                n = Math.max(inset, boundingRect.right);
                break;
            }
            case 5: {
                n = Math.max(inset, displayW - boundingRect.left);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown gravity: " + gravity);
            }
        }
        return n;
    }

    static {
        sCachedCutout = NULL_PAIR;
        INVALID_OVERRIDES = new int[]{-1, -1, -1, -1};
    }

    private static class Bounds {
        private final Rect[] mRects;

        private Bounds(Rect left, Rect top, Rect right, Rect bottom, boolean copyArguments) {
            this.mRects = new Rect[4];
            this.mRects[0] = DisplayCutout.getCopyOrRef(left, copyArguments);
            this.mRects[1] = DisplayCutout.getCopyOrRef(top, copyArguments);
            this.mRects[2] = DisplayCutout.getCopyOrRef(right, copyArguments);
            this.mRects[3] = DisplayCutout.getCopyOrRef(bottom, copyArguments);
        }

        private Bounds(Rect[] rects, boolean copyArguments) {
            if (rects.length != 4) {
                throw new IllegalArgumentException("rects must have exactly 4 elements: rects=" + Arrays.toString(rects));
            }
            if (copyArguments) {
                this.mRects = new Rect[4];
                for (int i = 0; i < 4; ++i) {
                    this.mRects[i] = new Rect(rects[i]);
                }
            } else {
                for (Rect rect : rects) {
                    if (rect != null) continue;
                    throw new IllegalArgumentException("rects must have non-null elements: rects=" + Arrays.toString(rects));
                }
                this.mRects = rects;
            }
        }

        private boolean isEmpty() {
            for (Rect rect : this.mRects) {
                if (rect.isEmpty()) continue;
                return false;
            }
            return true;
        }

        private Rect getRect(int pos) {
            return new Rect(this.mRects[pos]);
        }

        private Rect[] getRects() {
            Rect[] rects = new Rect[4];
            for (int i = 0; i < 4; ++i) {
                rects[i] = new Rect(this.mRects[i]);
            }
            return rects;
        }

        private void scale(float scale) {
            for (int i = 0; i < 4; ++i) {
                this.mRects[i].scale(scale);
            }
        }

        public int hashCode() {
            int result = 0;
            for (Rect rect : this.mRects) {
                result = result * 48271 + rect.hashCode();
            }
            return result;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Bounds) {
                Bounds b = (Bounds)o;
                return Arrays.deepEquals(this.mRects, b.mRects);
            }
            return false;
        }

        public String toString() {
            return "Bounds=" + Arrays.toString(this.mRects);
        }
    }

    public static class CutoutPathParserInfo {
        private final int mDisplayWidth;
        private final int mDisplayHeight;
        private final int mPhysicalDisplayWidth;
        private final int mPhysicalDisplayHeight;
        private final float mDensity;
        private final String mCutoutSpec;
        private final int mRotation;
        private final float mScale;
        private final float mPhysicalPixelDisplaySizeRatio;

        public CutoutPathParserInfo(int displayWidth, int displayHeight, int physicalDisplayWidth, int physicalDisplayHeight, float density, @Nullable String cutoutSpec, int rotation, float scale, float physicalPixelDisplaySizeRatio) {
            this.mDisplayWidth = displayWidth;
            this.mDisplayHeight = displayHeight;
            this.mPhysicalDisplayWidth = physicalDisplayWidth;
            this.mPhysicalDisplayHeight = physicalDisplayHeight;
            this.mDensity = density;
            this.mCutoutSpec = cutoutSpec == null ? "" : cutoutSpec;
            this.mRotation = rotation;
            this.mScale = scale;
            this.mPhysicalPixelDisplaySizeRatio = physicalPixelDisplaySizeRatio;
        }

        public CutoutPathParserInfo(@NonNull CutoutPathParserInfo cutoutPathParserInfo) {
            this.mDisplayWidth = cutoutPathParserInfo.mDisplayWidth;
            this.mDisplayHeight = cutoutPathParserInfo.mDisplayHeight;
            this.mPhysicalDisplayWidth = cutoutPathParserInfo.mPhysicalDisplayWidth;
            this.mPhysicalDisplayHeight = cutoutPathParserInfo.mPhysicalDisplayHeight;
            this.mDensity = cutoutPathParserInfo.mDensity;
            this.mCutoutSpec = cutoutPathParserInfo.mCutoutSpec;
            this.mRotation = cutoutPathParserInfo.mRotation;
            this.mScale = cutoutPathParserInfo.mScale;
            this.mPhysicalPixelDisplaySizeRatio = cutoutPathParserInfo.mPhysicalPixelDisplaySizeRatio;
        }

        public int getDisplayWidth() {
            return this.mDisplayWidth;
        }

        public int getDisplayHeight() {
            return this.mDisplayHeight;
        }

        public int getPhysicalDisplayWidth() {
            return this.mPhysicalDisplayWidth;
        }

        public int getPhysicalDisplayHeight() {
            return this.mPhysicalDisplayHeight;
        }

        public float getDensity() {
            return this.mDensity;
        }

        @NonNull
        public String getCutoutSpec() {
            return this.mCutoutSpec;
        }

        public int getRotation() {
            return this.mRotation;
        }

        public float getScale() {
            return this.mScale;
        }

        public float getPhysicalPixelDisplaySizeRatio() {
            return this.mPhysicalPixelDisplaySizeRatio;
        }

        private boolean hasCutout() {
            return !this.mCutoutSpec.isEmpty();
        }

        public int hashCode() {
            int result = 0;
            result = result * 48271 + Integer.hashCode(this.mDisplayWidth);
            result = result * 48271 + Integer.hashCode(this.mDisplayHeight);
            result = result * 48271 + Float.hashCode(this.mDensity);
            result = result * 48271 + this.mCutoutSpec.hashCode();
            result = result * 48271 + Integer.hashCode(this.mRotation);
            result = result * 48271 + Float.hashCode(this.mScale);
            result = result * 48271 + Float.hashCode(this.mPhysicalPixelDisplaySizeRatio);
            result = result * 48271 + Integer.hashCode(this.mPhysicalDisplayWidth);
            result = result * 48271 + Integer.hashCode(this.mPhysicalDisplayHeight);
            return result;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof CutoutPathParserInfo) {
                CutoutPathParserInfo c = (CutoutPathParserInfo)o;
                return this.mDisplayWidth == c.mDisplayWidth && this.mDisplayHeight == c.mDisplayHeight && this.mPhysicalDisplayWidth == c.mPhysicalDisplayWidth && this.mPhysicalDisplayHeight == c.mPhysicalDisplayHeight && this.mDensity == c.mDensity && this.mCutoutSpec.equals(c.mCutoutSpec) && this.mRotation == c.mRotation && this.mScale == c.mScale && this.mPhysicalPixelDisplaySizeRatio == c.mPhysicalPixelDisplaySizeRatio;
            }
            return false;
        }

        public String toString() {
            return "CutoutPathParserInfo{displayWidth=" + this.mDisplayWidth + " displayHeight=" + this.mDisplayHeight + " physicalDisplayWidth=" + this.mPhysicalDisplayWidth + " physicalDisplayHeight=" + this.mPhysicalDisplayHeight + " density={" + this.mDensity + "} cutoutSpec={" + this.mCutoutSpec + "} rotation={" + this.mRotation + "} scale={" + this.mScale + "} physicalPixelDisplaySizeRatio={" + this.mPhysicalPixelDisplaySizeRatio + "}}";
        }
    }

    public static class Builder {
        private Insets mSafeInsets = Insets.NONE;
        private Insets mWaterfallInsets = Insets.NONE;
        private Path mCutoutPath;
        private final Rect mBoundingRectLeft = new Rect();
        private final Rect mBoundingRectTop = new Rect();
        private final Rect mBoundingRectRight = new Rect();
        private final Rect mBoundingRectBottom = new Rect();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        public DisplayCutout build() {
            CutoutPathParserInfo info;
            if (this.mCutoutPath != null) {
                info = new CutoutPathParserInfo(0, 0, 0, 0, 0.0f, "test", 0, 1.0f, 1.0f);
                Object object = CACHE_LOCK;
                synchronized (object) {
                    sCachedCutoutPathParserInfo = info;
                    sCachedCutoutPath = this.mCutoutPath;
                }
            } else {
                info = null;
            }
            return new DisplayCutout(this.mSafeInsets.toRect(), this.mWaterfallInsets, this.mBoundingRectLeft, this.mBoundingRectTop, this.mBoundingRectRight, this.mBoundingRectBottom, info, false);
        }

        @NonNull
        public Builder setSafeInsets(@NonNull Insets safeInsets) {
            this.mSafeInsets = safeInsets;
            return this;
        }

        @NonNull
        public Builder setWaterfallInsets(@NonNull Insets waterfallInsets) {
            this.mWaterfallInsets = waterfallInsets;
            return this;
        }

        @NonNull
        public Builder setBoundingRectLeft(@NonNull Rect boundingRectLeft) {
            this.mBoundingRectLeft.set(boundingRectLeft);
            return this;
        }

        @NonNull
        public Builder setBoundingRectTop(@NonNull Rect boundingRectTop) {
            this.mBoundingRectTop.set(boundingRectTop);
            return this;
        }

        @NonNull
        public Builder setBoundingRectRight(@NonNull Rect boundingRectRight) {
            this.mBoundingRectRight.set(boundingRectRight);
            return this;
        }

        @NonNull
        public Builder setBoundingRectBottom(@NonNull Rect boundingRectBottom) {
            this.mBoundingRectBottom.set(boundingRectBottom);
            return this;
        }

        @NonNull
        public Builder setCutoutPath(@NonNull Path cutoutPath) {
            this.mCutoutPath = cutoutPath;
            return this;
        }
    }

    public static class ParcelableWrapper
    implements Parcelable {
        private DisplayCutout mInner;
        @NonNull
        public static final Parcelable.Creator<ParcelableWrapper> CREATOR = new Parcelable.Creator<ParcelableWrapper>(){

            @Override
            public ParcelableWrapper createFromParcel(Parcel in) {
                return new ParcelableWrapper(ParcelableWrapper.readCutoutFromParcel(in));
            }

            public ParcelableWrapper[] newArray(int size) {
                return new ParcelableWrapper[size];
            }
        };

        public ParcelableWrapper() {
            this(NO_CUTOUT);
        }

        public ParcelableWrapper(DisplayCutout cutout) {
            this.mInner = cutout;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            ParcelableWrapper.writeCutoutToParcel(this.mInner, out, flags);
        }

        public static void writeCutoutToParcel(DisplayCutout cutout, Parcel out, int flags) {
            if (cutout == null) {
                out.writeInt(-1);
            } else if (cutout == NO_CUTOUT) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                out.writeTypedObject(cutout.mSafeInsets, flags);
                out.writeTypedArray(cutout.mBounds.getRects(), flags);
                out.writeTypedObject(cutout.mWaterfallInsets, flags);
                out.writeInt(cutout.mCutoutPathParserInfo.getDisplayWidth());
                out.writeInt(cutout.mCutoutPathParserInfo.getDisplayHeight());
                out.writeInt(cutout.mCutoutPathParserInfo.getPhysicalDisplayWidth());
                out.writeInt(cutout.mCutoutPathParserInfo.getPhysicalDisplayHeight());
                out.writeFloat(cutout.mCutoutPathParserInfo.getDensity());
                out.writeString(cutout.mCutoutPathParserInfo.getCutoutSpec());
                out.writeInt(cutout.mCutoutPathParserInfo.getRotation());
                out.writeFloat(cutout.mCutoutPathParserInfo.getScale());
                out.writeFloat(cutout.mCutoutPathParserInfo.getPhysicalPixelDisplaySizeRatio());
                out.writeIntArray(cutout.mSideOverrides);
            }
        }

        public void readFromParcel(Parcel in) {
            this.mInner = ParcelableWrapper.readCutoutFromParcel(in);
        }

        public static DisplayCutout readCutoutFromParcel(Parcel in) {
            int variant = in.readInt();
            if (variant == -1) {
                return null;
            }
            if (variant == 0) {
                return NO_CUTOUT;
            }
            Rect safeInsets = in.readTypedObject(Rect.CREATOR);
            Rect[] bounds = new Rect[4];
            in.readTypedArray(bounds, Rect.CREATOR);
            Insets waterfallInsets = in.readTypedObject(Insets.CREATOR);
            int displayWidth = in.readInt();
            int displayHeight = in.readInt();
            int physicalDisplayWidth = in.readInt();
            int physicalDisplayHeight = in.readInt();
            float density = in.readFloat();
            String cutoutSpec = in.readString();
            int rotation = in.readInt();
            float scale = in.readFloat();
            float physicalPixelDisplaySizeRatio = in.readFloat();
            CutoutPathParserInfo info = new CutoutPathParserInfo(displayWidth, displayHeight, physicalDisplayWidth, physicalDisplayHeight, density, cutoutSpec, rotation, scale, physicalPixelDisplaySizeRatio);
            int[] sideOverrides = in.createIntArray();
            return new DisplayCutout(safeInsets, waterfallInsets, new Bounds(bounds, false), info, sideOverrides);
        }

        public DisplayCutout get() {
            return this.mInner;
        }

        public void set(ParcelableWrapper cutout) {
            this.mInner = cutout.get();
        }

        public void set(DisplayCutout cutout) {
            this.mInner = cutout;
        }

        public void scale(float scale) {
            Rect safeInsets = this.mInner.getSafeInsets();
            safeInsets.scale(scale);
            Bounds bounds = new Bounds(this.mInner.mBounds.mRects, true);
            bounds.scale(scale);
            Rect waterfallInsets = this.mInner.mWaterfallInsets.toRect();
            waterfallInsets.scale(scale);
            CutoutPathParserInfo info = new CutoutPathParserInfo(this.mInner.mCutoutPathParserInfo.getDisplayWidth(), this.mInner.mCutoutPathParserInfo.getDisplayHeight(), this.mInner.mCutoutPathParserInfo.getPhysicalDisplayWidth(), this.mInner.mCutoutPathParserInfo.getPhysicalDisplayHeight(), this.mInner.mCutoutPathParserInfo.getDensity(), this.mInner.mCutoutPathParserInfo.getCutoutSpec(), this.mInner.mCutoutPathParserInfo.getRotation(), scale, this.mInner.mCutoutPathParserInfo.getPhysicalPixelDisplaySizeRatio());
            int[] sideOverrides = this.mInner.mSideOverrides;
            this.mInner = new DisplayCutout(safeInsets, Insets.of(waterfallInsets), bounds, info, sideOverrides);
        }

        public int hashCode() {
            return this.mInner.hashCode();
        }

        public boolean equals(@Nullable Object o) {
            return o instanceof ParcelableWrapper && this.mInner.equals(((ParcelableWrapper)o).mInner);
        }

        public String toString() {
            return String.valueOf(this.mInner);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BoundsPosition {
    }
}

