/*
 * Decompiled with CFR 0.152.
 */
package android.uwb;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.content.Context;
import android.os.Binder;
import android.os.CancellationSignal;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.util.Log;
import android.uwb.AdapterStateListener;
import android.uwb.IOnUwbActivityEnergyInfoListener;
import android.uwb.IUwbAdapter;
import android.uwb.IUwbAdfProvisionStateCallbacks;
import android.uwb.RangingManager;
import android.uwb.RangingReport;
import android.uwb.RangingSession;
import android.uwb.UwbActivityEnergyInfo;
import android.uwb.UwbOemExtensionCallbackListener;
import android.uwb.UwbVendorUciCallbackListener;
import com.android.internal.annotations.GuardedBy;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import com.android.x.uwb.com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

@SystemApi
public class UwbManager {
    private static final String TAG = "UwbManager";
    private final Context mContext;
    private final IUwbAdapter mUwbAdapter;
    private final AdapterStateListener mAdapterStateListener;
    private final RangingManager mRangingManager;
    private final UwbVendorUciCallbackListener mUwbVendorUciCallbackListener;
    private final UwbOemExtensionCallbackListener mUwbOemExtensionCallbackListener;
    public static final int VENDOR_SET_SESSION_CONFIGURATION_SUCCESS = 0;
    public static final int VENDOR_SET_SESSION_CONFIGURATION_FAILURE = 1;
    public static final int REMOVE_SERVICE_PROFILE_SUCCESS = 0;
    public static final int REMOVE_SERVICE_PROFILE_ERROR_UNKNOWN_SERVICE = 1;
    public static final int REMOVE_SERVICE_PROFILE_ERROR_INTERNAL = 2;
    public static final int REMOVE_PROFILE_ADF_SUCCESS = 0;
    public static final int REMOVE_PROFILE_ADF_ERROR_UNKNOWN_SERVICE = 1;
    public static final int REMOVE_PROFILE_ADF_ERROR_INTERNAL = 2;
    public static final int SEND_VENDOR_UCI_SUCCESS = 0;
    public static final int SEND_VENDOR_UCI_ERROR_HW = 1;
    public static final int SEND_VENDOR_UCI_ERROR_OFF = 2;
    public static final int SEND_VENDOR_UCI_ERROR_INVALID_ARGS = 3;
    public static final int SEND_VENDOR_UCI_ERROR_INVALID_GID = 4;
    public static final int MESSAGE_TYPE_COMMAND = 1;
    public static final int MESSAGE_TYPE_TEST_1 = 4;
    public static final int MESSAGE_TYPE_TEST_2 = 5;

    public UwbManager(@NonNull Context ctx, @NonNull IUwbAdapter adapter) {
        this.mContext = ctx;
        this.mUwbAdapter = adapter;
        this.mAdapterStateListener = new AdapterStateListener(adapter);
        this.mRangingManager = new RangingManager(adapter);
        this.mUwbVendorUciCallbackListener = new UwbVendorUciCallbackListener(adapter);
        this.mUwbOemExtensionCallbackListener = new UwbOemExtensionCallbackListener(adapter);
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void registerAdapterStateCallback(@NonNull Executor executor, @NonNull AdapterStateCallback callback) {
        this.mAdapterStateListener.register(executor, callback);
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void unregisterAdapterStateCallback(@NonNull AdapterStateCallback callback) {
        this.mAdapterStateListener.unregister(callback);
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void registerUwbVendorUciCallback(@NonNull Executor executor, @NonNull UwbVendorUciCallback callback) {
        this.mUwbVendorUciCallbackListener.register(executor, callback);
    }

    public void unregisterUwbVendorUciCallback(@NonNull UwbVendorUciCallback callback) {
        this.mUwbVendorUciCallbackListener.unregister(callback);
    }

    @RequiresApi(value=34)
    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void registerUwbOemExtensionCallback(@NonNull Executor executor, @NonNull UwbOemExtensionCallback callback) {
        this.mUwbOemExtensionCallbackListener.register(executor, callback);
    }

    @RequiresApi(value=34)
    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void unregisterUwbOemExtensionCallback(@NonNull UwbOemExtensionCallback callback) {
        this.mUwbOemExtensionCallbackListener.unregister(callback);
    }

    @NonNull
    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public PersistableBundle getSpecificationInfo() {
        return this.getSpecificationInfoInternal(null);
    }

    @NonNull
    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public PersistableBundle getSpecificationInfo(@NonNull String chipId) {
        Preconditions.checkNotNull(chipId);
        return this.getSpecificationInfoInternal(chipId);
    }

    private PersistableBundle getSpecificationInfoInternal(String chipId) {
        try {
            return this.mUwbAdapter.getSpecificationInfo(chipId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    @FlaggedApi(value="com.android.x.uwb.com.android.uwb.flags.query_timestamp_micros")
    public long queryUwbsTimestampMicros() {
        try {
            return this.mUwbAdapter.queryUwbsTimestampMicros();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"MethodNameUnits"})
    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public long elapsedRealtimeResolutionNanos() {
        return this.elapsedRealtimeResolutionNanosInternal(null);
    }

    @SuppressLint(value={"MethodNameUnits"})
    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public long elapsedRealtimeResolutionNanos(@NonNull String chipId) {
        Preconditions.checkNotNull(chipId);
        return this.elapsedRealtimeResolutionNanosInternal(chipId);
    }

    private long elapsedRealtimeResolutionNanosInternal(String chipId) {
        try {
            return this.mUwbAdapter.getTimestampResolutionNanos(chipId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    @RequiresPermission(allOf={"android.permission.UWB_PRIVILEGED", "android.permission.UWB_RANGING"})
    public CancellationSignal openRangingSession(@NonNull PersistableBundle parameters, @NonNull Executor executor, @NonNull RangingSession.Callback callbacks) {
        return this.openRangingSessionInternal(parameters, executor, callbacks, null);
    }

    @NonNull
    @RequiresPermission(allOf={"android.permission.UWB_PRIVILEGED", "android.permission.UWB_RANGING"})
    public CancellationSignal openRangingSession(@NonNull PersistableBundle parameters, @NonNull Executor executor, @NonNull RangingSession.Callback callbacks, @SuppressLint(value={"ListenerLast"}) @NonNull String chipId) {
        Preconditions.checkNotNull(chipId);
        return this.openRangingSessionInternal(parameters, executor, callbacks, chipId);
    }

    private CancellationSignal openRangingSessionInternal(PersistableBundle parameters, Executor executor, RangingSession.Callback callbacks, String chipId) {
        return this.mRangingManager.openSession(this.mContext.getAttributionSource(), parameters, executor, callbacks, chipId);
    }

    public int getAdapterState() {
        return this.mAdapterStateListener.getAdapterState();
    }

    public boolean isUwbEnabled() {
        int adapterState = this.getAdapterState();
        return adapterState != 0;
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void setUwbEnabled(boolean enabled) {
        this.mAdapterStateListener.setEnabled(enabled);
    }

    @FlaggedApi(value="com.android.x.uwb.com.android.uwb.flags.hw_state")
    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public boolean isUwbHwIdleTurnOffEnabled() {
        try {
            return this.mUwbAdapter.isHwIdleTurnOffEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="com.android.x.uwb.com.android.uwb.flags.hw_state")
    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public boolean isUwbHwEnableRequested() {
        try {
            return this.mUwbAdapter.isHwEnableRequested(this.mContext.getAttributionSource());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="com.android.x.uwb.com.android.uwb.flags.hw_state")
    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void requestUwbHwEnabled(boolean enabled) {
        try {
            this.mUwbAdapter.requestHwEnabled(enabled, this.mContext.getAttributionSource(), new Binder(this.mContext.getPackageName()));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    @NonNull
    public List<PersistableBundle> getChipInfos() {
        try {
            return this.mUwbAdapter.getChipInfos();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    @NonNull
    public String getDefaultChipId() {
        try {
            return this.mUwbAdapter.getDefaultChipId();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    @NonNull
    public PersistableBundle addServiceProfile(@NonNull PersistableBundle parameters) {
        try {
            return this.mUwbAdapter.addServiceProfile(parameters);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public int removeServiceProfile(@NonNull PersistableBundle parameters) {
        try {
            return this.mUwbAdapter.removeServiceProfile(parameters);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    @NonNull
    public PersistableBundle getAllServiceProfiles() {
        try {
            return this.mUwbAdapter.getAllServiceProfiles();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    @NonNull
    public PersistableBundle getAdfProvisioningAuthorities(@NonNull PersistableBundle serviceProfileBundle) {
        try {
            return this.mUwbAdapter.getAdfProvisioningAuthorities(serviceProfileBundle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    @NonNull
    public PersistableBundle getAdfCertificateInfo(@NonNull PersistableBundle serviceProfileBundle) {
        try {
            return this.mUwbAdapter.getAdfCertificateAndInfo(serviceProfileBundle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void provisionProfileAdfByScript(@NonNull PersistableBundle serviceProfileBundle, @NonNull Executor executor, @NonNull AdfProvisionStateCallback callback) {
        if (executor == null) {
            throw new IllegalArgumentException("executor must not be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        AdfProvisionStateCallback.AdfProvisionStateCallbackProxy proxy = callback.getProxy();
        proxy.initProxy(executor, callback);
        try {
            this.mUwbAdapter.provisionProfileAdfByScript(serviceProfileBundle, proxy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public int removeProfileAdf(@NonNull PersistableBundle serviceProfileBundle) {
        try {
            return this.mUwbAdapter.removeProfileAdf(serviceProfileBundle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public int sendVendorUciMessage(int gid, int oid, @NonNull byte[] payload) {
        Objects.requireNonNull(payload, "Payload must not be null");
        try {
            return this.mUwbAdapter.sendVendorUciMessage(1, gid, oid, payload);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    @RequiresApi(value=34)
    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public int sendVendorUciMessage(int mt, int gid, int oid, @NonNull byte[] payload) {
        Objects.requireNonNull(payload, "Payload must not be null");
        try {
            return this.mUwbAdapter.sendVendorUciMessage(mt, gid, oid, payload);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void getUwbActivityEnergyInfoAsync(@NonNull Executor executor, @NonNull Consumer<UwbActivityEnergyInfo> listener) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(listener, "listener cannot be null");
        try {
            this.mUwbAdapter.getUwbActivityEnergyInfoAsync(new OnUwbActivityEnergyInfoProxy(executor, listener));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static interface AdapterStateCallback {
        public static final int STATE_CHANGED_REASON_SESSION_STARTED = 0;
        public static final int STATE_CHANGED_REASON_ALL_SESSIONS_CLOSED = 1;
        public static final int STATE_CHANGED_REASON_SYSTEM_POLICY = 2;
        public static final int STATE_CHANGED_REASON_SYSTEM_BOOT = 3;
        public static final int STATE_CHANGED_REASON_ERROR_UNKNOWN = 4;
        public static final int STATE_CHANGED_REASON_SYSTEM_REGULATION = 5;
        public static final int STATE_DISABLED = 0;
        public static final int STATE_ENABLED_INACTIVE = 1;
        public static final int STATE_ENABLED_ACTIVE = 2;
        @FlaggedApi(value="com.android.x.uwb.com.android.uwb.flags.hw_state")
        public static final int STATE_ENABLED_HW_IDLE = 3;

        public void onStateChanged(int var1, int var2);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface State {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface StateChangedReason {
        }
    }

    public static interface UwbVendorUciCallback {
        public void onVendorUciResponse(int var1, int var2, @NonNull byte[] var3);

        public void onVendorUciNotification(int var1, int var2, @NonNull byte[] var3);
    }

    @RequiresApi(value=34)
    public static interface UwbOemExtensionCallback {
        public void onSessionStatusNotificationReceived(@NonNull PersistableBundle var1);

        public void onDeviceStatusNotificationReceived(@NonNull PersistableBundle var1);

        @NonNull
        public int onSessionConfigurationComplete(@NonNull PersistableBundle var1);

        @NonNull
        public RangingReport onRangingReportReceived(@NonNull RangingReport var1);

        public boolean onCheckPointedTarget(@NonNull PersistableBundle var1);
    }

    public static abstract class AdfProvisionStateCallback {
        private final AdfProvisionStateCallbackProxy mAdfProvisionStateCallbackProxy = new AdfProvisionStateCallbackProxy();
        public static final int REASON_INVALID_OID = 1;
        public static final int REASON_SE_FAILURE = 2;
        public static final int REASON_UNKNOWN = 3;

        public abstract void onProfileAdfsProvisioned(@NonNull PersistableBundle var1);

        public abstract void onProfileAdfsProvisionFailed(int var1, @NonNull PersistableBundle var2);

        @NonNull
        AdfProvisionStateCallbackProxy getProxy() {
            return this.mAdfProvisionStateCallbackProxy;
        }

        private static class AdfProvisionStateCallbackProxy
        extends IUwbAdfProvisionStateCallbacks.Stub {
            private final Object mLock = new Object();
            @Nullable
            @GuardedBy(value={"mLock"})
            private Executor mExecutor = null;
            @Nullable
            @GuardedBy(value={"mLock"})
            private AdfProvisionStateCallback mCallback = null;

            AdfProvisionStateCallbackProxy() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void initProxy(@NonNull Executor executor, @NonNull AdfProvisionStateCallback callback) {
                Object object = this.mLock;
                synchronized (object) {
                    this.mExecutor = executor;
                    this.mCallback = callback;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void cleanUpProxy() {
                Object object = this.mLock;
                synchronized (object) {
                    this.mExecutor = null;
                    this.mCallback = null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onProfileAdfsProvisioned(@NonNull PersistableBundle params) {
                AdfProvisionStateCallback callback;
                Executor executor;
                Log.v(UwbManager.TAG, "AdfProvisionStateCallbackProxy: onProfileAdfsProvisioned : " + params);
                Object object = this.mLock;
                synchronized (object) {
                    executor = this.mExecutor;
                    callback = this.mCallback;
                }
                if (callback == null || executor == null) {
                    return;
                }
                Binder.clearCallingIdentity();
                executor.execute(() -> callback.onProfileAdfsProvisioned(params));
                this.cleanUpProxy();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onProfileAdfsProvisionFailed(int reason, @NonNull PersistableBundle params) {
                AdfProvisionStateCallback callback;
                Executor executor;
                Log.v(UwbManager.TAG, "AdfProvisionStateCallbackProxy: onProfileAdfsProvisionFailed : " + reason + ", " + params);
                Object object = this.mLock;
                synchronized (object) {
                    executor = this.mExecutor;
                    callback = this.mCallback;
                }
                if (callback == null || executor == null) {
                    return;
                }
                Binder.clearCallingIdentity();
                executor.execute(() -> callback.onProfileAdfsProvisionFailed(reason, params));
                this.cleanUpProxy();
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        static @interface Reason {
        }
    }

    private static class OnUwbActivityEnergyInfoProxy
    extends IOnUwbActivityEnergyInfoListener.Stub {
        private final Object mLock = new Object();
        @Nullable
        @GuardedBy(value={"mLock"})
        private Executor mExecutor;
        @Nullable
        @GuardedBy(value={"mLock"})
        private Consumer<UwbActivityEnergyInfo> mListener;

        OnUwbActivityEnergyInfoProxy(Executor executor, Consumer<UwbActivityEnergyInfo> listener) {
            this.mExecutor = executor;
            this.mListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUwbActivityEnergyInfo(UwbActivityEnergyInfo info) {
            Consumer<UwbActivityEnergyInfo> listener;
            Executor executor;
            Object object = this.mLock;
            synchronized (object) {
                if (this.mExecutor == null || this.mListener == null) {
                    return;
                }
                executor = this.mExecutor;
                listener = this.mListener;
                this.mExecutor = null;
                this.mListener = null;
            }
            Binder.clearCallingIdentity();
            executor.execute(() -> listener.accept(info));
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface MessageType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface SendVendorUciStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface RemoveProfileAdf {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface RemoveServiceProfile {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface VendorConfigStatus {
    }
}

