/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.SystemProperties;

public class SystemPropertySetter {
    public static final int PROPERTY_FAILURE_RETRY_DELAY_MILLIS = 200;
    public static final int PROPERTY_FAILURE_RETRY_LIMIT = 5;

    public static void setWithRetry(@NonNull String key, @Nullable String val) {
        SystemPropertySetter.setWithRetry(key, val, 200, 5L);
    }

    public static void setWithRetry(@NonNull String key, @Nullable String val, int maxRetry, long retryDelayMs) {
        if (maxRetry < 0) {
            throw new IllegalArgumentException("invalid retry count: " + maxRetry);
        }
        if (retryDelayMs <= 0L) {
            throw new IllegalArgumentException("invalid retry delay: " + retryDelayMs);
        }
        RuntimeException failure = null;
        for (int attempt = 0; attempt < maxRetry; ++attempt) {
            try {
                SystemProperties.set(key, val);
                return;
            }
            catch (RuntimeException e) {
                if (failure == null) {
                    failure = e;
                }
                try {
                    Thread.sleep(retryDelayMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        throw failure;
    }
}

