/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.SystemClock;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.logging.EventLogTags;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class SystemConfigFileCommitEventLogger {
    private final String mName;
    private long mStartTime;

    public SystemConfigFileCommitEventLogger(@NonNull String name) {
        this.mName = name;
    }

    public void setStartTime(long startTime) {
        this.mStartTime = startTime;
    }

    public void onStartWrite() {
        if (this.mStartTime == 0L) {
            this.mStartTime = SystemClock.uptimeMillis();
        }
    }

    public void onFinishWrite() {
        this.writeLogRecord(SystemClock.uptimeMillis() - this.mStartTime);
    }

    @VisibleForTesting
    public void writeLogRecord(long durationMs) {
        EventLogTags.writeCommitSysConfigFile(this.mName, durationMs);
    }
}

