/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.content.ContentResolver;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.util.KeyValueListParser;
import android.util.Slog;

public abstract class KeyValueSettingObserver {
    private static final String TAG = "KeyValueSettingObserver";
    private final KeyValueListParser mParser = new KeyValueListParser(',');
    private final ContentObserver mObserver;
    private final ContentResolver mResolver;
    private final Uri mSettingUri;

    public KeyValueSettingObserver(Handler handler, ContentResolver resolver, Uri uri) {
        this.mObserver = new SettingObserver(handler);
        this.mResolver = resolver;
        this.mSettingUri = uri;
    }

    public void start() {
        this.mResolver.registerContentObserver(this.mSettingUri, false, this.mObserver);
        this.setParserValue();
        this.update(this.mParser);
    }

    public void stop() {
        this.mResolver.unregisterContentObserver(this.mObserver);
    }

    public abstract String getSettingValue(ContentResolver var1);

    private void setParserValue() {
        String setting = this.getSettingValue(this.mResolver);
        try {
            this.mParser.setString(setting);
        }
        catch (IllegalArgumentException e) {
            Slog.e(TAG, "Malformed setting: " + setting);
        }
    }

    public abstract void update(KeyValueListParser var1);

    private class SettingObserver
    extends ContentObserver {
        private SettingObserver(Handler handler) {
            super(handler);
        }

        @Override
        public void onChange(boolean selfChange) {
            KeyValueSettingObserver.this.setParserValue();
            KeyValueSettingObserver.this.update(KeyValueSettingObserver.this.mParser);
        }
    }
}

