/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.ravenwood.annotation.RavenwoodRedirect;
import android.ravenwood.annotation.RavenwoodRedirectionClass;
import android.ravenwood.annotation.RavenwoodReplace;
import android.ravenwood.annotation.RavenwoodThrow;
import android.util.Log;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@RavenwoodKeepWholeClass
@RavenwoodRedirectionClass(value="EventLog_host")
public class EventLog {
    private static final String TAG = "EventLog";
    private static final String TAGS_FILE = "/system/etc/event-log-tags";
    private static final String COMMENT_PATTERN = "^\\s*(#.*)?$";
    private static final String TAG_PATTERN = "^\\s*(\\d+)\\s+(\\w+)\\s*(\\(.*\\))?\\s*$";
    private static HashMap<String, Integer> sTagCodes = null;
    private static HashMap<Integer, String> sTagNames = null;

    @RavenwoodRedirect
    public static native int writeEvent(int var0, int var1);

    @RavenwoodRedirect
    public static native int writeEvent(int var0, long var1);

    @RavenwoodRedirect
    public static native int writeEvent(int var0, float var1);

    @RavenwoodRedirect
    public static native int writeEvent(int var0, String var1);

    @RavenwoodRedirect
    public static native int writeEvent(int var0, Object ... var1);

    @RavenwoodThrow
    public static native void readEvents(int[] var0, Collection<Event> var1) throws IOException;

    @SystemApi
    @RavenwoodThrow
    public static native void readEventsOnWrapping(int[] var0, long var1, Collection<Event> var3) throws IOException;

    public static String getTagName(int tag) {
        EventLog.readTagsFile();
        return sTagNames.get(tag);
    }

    public static int getTagCode(String name) {
        EventLog.readTagsFile();
        Integer code = sTagCodes.get(name);
        return code != null ? code : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RavenwoodReplace
    private static synchronized void readTagsFile() {
        if (sTagCodes != null && sTagNames != null) {
            return;
        }
        sTagCodes = new HashMap();
        sTagNames = new HashMap();
        Pattern comment = Pattern.compile(COMMENT_PATTERN);
        Pattern tag = Pattern.compile(TAG_PATTERN);
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(TAGS_FILE), 256);
            while ((line = reader.readLine()) != null) {
                if (comment.matcher(line).matches()) continue;
                Matcher m = tag.matcher(line);
                if (!m.matches()) {
                    Log.wtf(TAG, "Bad entry in /system/etc/event-log-tags: " + line);
                    continue;
                }
                try {
                    int num = Integer.parseInt(m.group(1));
                    String name = m.group(2);
                    EventLog.registerTagLocked(num, name);
                }
                catch (NumberFormatException e) {
                    Log.wtf(TAG, "Error in /system/etc/event-log-tags: " + line, e);
                }
            }
        }
        catch (IOException e) {
            Log.wtf(TAG, "Error reading /system/etc/event-log-tags", e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static void registerTagLocked(int num, String name) {
        sTagCodes.put(name, num);
        sTagNames.put(num, name);
    }

    private static synchronized void readTagsFile$ravenwood() {
        sTagCodes = new HashMap();
        sTagNames = new HashMap();
        EventLog.registerTagLocked(524288, "sysui_action");
        EventLog.registerTagLocked(524290, "sysui_count");
        EventLog.registerTagLocked(524291, "sysui_histogram");
    }

    public static class Event {
        private final ByteBuffer mBuffer;
        private Exception mLastWtf;
        private static final int LENGTH_OFFSET = 0;
        private static final int HEADER_SIZE_OFFSET = 2;
        private static final int PROCESS_OFFSET = 4;
        private static final int THREAD_OFFSET = 8;
        private static final int SECONDS_OFFSET = 12;
        private static final int NANOSECONDS_OFFSET = 16;
        private static final int UID_OFFSET = 24;
        private static final int V1_PAYLOAD_START = 20;
        private static final int TAG_LENGTH = 4;
        private static final byte INT_TYPE = 0;
        private static final byte LONG_TYPE = 1;
        private static final byte STRING_TYPE = 2;
        private static final byte LIST_TYPE = 3;
        private static final byte FLOAT_TYPE = 4;

        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        Event(byte[] data) {
            this.mBuffer = ByteBuffer.wrap(data);
            this.mBuffer.order(ByteOrder.nativeOrder());
        }

        public int getProcessId() {
            return this.mBuffer.getInt(4);
        }

        @SystemApi
        public int getUid() {
            try {
                return this.mBuffer.getInt(24);
            }
            catch (IndexOutOfBoundsException e) {
                return -1;
            }
        }

        public int getThreadId() {
            return this.mBuffer.getInt(8);
        }

        public long getTimeNanos() {
            return (long)this.mBuffer.getInt(12) * 1000000000L + (long)this.mBuffer.getInt(16);
        }

        public int getTag() {
            return this.mBuffer.getInt(this.getHeaderSize());
        }

        private int getHeaderSize() {
            short length = this.mBuffer.getShort(2);
            if (length != 0) {
                return length;
            }
            return 20;
        }

        public synchronized Object getData() {
            try {
                int offset = this.getHeaderSize();
                this.mBuffer.limit(offset + this.mBuffer.getShort(0));
                if (offset + 4 >= this.mBuffer.limit()) {
                    return null;
                }
                this.mBuffer.position(offset + 4);
                return this.decodeObject();
            }
            catch (IllegalArgumentException e) {
                Log.wtf(EventLog.TAG, "Illegal entry payload: tag=" + this.getTag(), e);
                this.mLastWtf = e;
                return null;
            }
            catch (BufferUnderflowException e) {
                Log.wtf(EventLog.TAG, "Truncated entry payload: tag=" + this.getTag(), e);
                this.mLastWtf = e;
                return null;
            }
        }

        public Event withNewData(@Nullable Object object) {
            byte[] payload = Event.encodeObject(object);
            if (payload.length > 65531) {
                throw new IllegalArgumentException("Payload too long");
            }
            int headerLength = this.getHeaderSize();
            byte[] newBytes = new byte[headerLength + 4 + payload.length];
            System.arraycopy(this.mBuffer.array(), 0, newBytes, 0, headerLength + 4);
            System.arraycopy(payload, 0, newBytes, headerLength + 4, payload.length);
            Event result = new Event(newBytes);
            result.mBuffer.putShort(0, (short)(payload.length + 4));
            return result;
        }

        private Object decodeObject() {
            byte type = this.mBuffer.get();
            switch (type) {
                case 0: {
                    return this.mBuffer.getInt();
                }
                case 1: {
                    return this.mBuffer.getLong();
                }
                case 4: {
                    return Float.valueOf(this.mBuffer.getFloat());
                }
                case 2: {
                    try {
                        int length = this.mBuffer.getInt();
                        int start = this.mBuffer.position();
                        this.mBuffer.position(start + length);
                        return new String(this.mBuffer.array(), start, length, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        Log.wtf(EventLog.TAG, "UTF-8 is not supported", e);
                        this.mLastWtf = e;
                        return null;
                    }
                }
                case 3: {
                    int length = this.mBuffer.get();
                    if (length < 0) {
                        length += 256;
                    }
                    Object[] array2 = new Object[length];
                    for (int i = 0; i < length; ++i) {
                        array2[i] = this.decodeObject();
                    }
                    return array2;
                }
            }
            throw new IllegalArgumentException("Unknown entry type: " + type);
        }

        @NonNull
        private static byte[] encodeObject(@Nullable Object object) {
            if (object == null) {
                return new byte[0];
            }
            if (object instanceof Integer) {
                return ByteBuffer.allocate(5).order(ByteOrder.nativeOrder()).put((byte)0).putInt((Integer)object).array();
            }
            if (object instanceof Long) {
                return ByteBuffer.allocate(9).order(ByteOrder.nativeOrder()).put((byte)1).putLong((Long)object).array();
            }
            if (object instanceof Float) {
                return ByteBuffer.allocate(5).order(ByteOrder.nativeOrder()).put((byte)4).putFloat(((Float)object).floatValue()).array();
            }
            if (object instanceof String) {
                byte[] bytes;
                String string2 = (String)object;
                try {
                    bytes = string2.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    bytes = new byte[]{};
                }
                return ByteBuffer.allocate(5 + bytes.length).order(ByteOrder.nativeOrder()).put((byte)2).putInt(bytes.length).put(bytes).array();
            }
            if (object instanceof Object[]) {
                Object[] objects = (Object[])object;
                if (objects.length > 255) {
                    throw new IllegalArgumentException("Object array too long");
                }
                byte[][] bytes = new byte[objects.length][];
                int totalLength = 0;
                for (int i = 0; i < objects.length; ++i) {
                    bytes[i] = Event.encodeObject(objects[i]);
                    totalLength += bytes[i].length;
                }
                ByteBuffer buffer = ByteBuffer.allocate(2 + totalLength).order(ByteOrder.nativeOrder()).put((byte)3).put((byte)objects.length);
                for (int i = 0; i < objects.length; ++i) {
                    buffer.put(bytes[i]);
                }
                return buffer.array();
            }
            throw new IllegalArgumentException("Unknown object type " + object);
        }

        public static Event fromBytes(byte[] data) {
            return new Event(data);
        }

        public byte[] getBytes() {
            byte[] bytes = this.mBuffer.array();
            return Arrays.copyOf(bytes, bytes.length);
        }

        public Exception getLastError() {
            return this.mLastWtf;
        }

        public void clearError() {
            this.mLastWtf = null;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Event other = (Event)o;
            return Arrays.equals(this.mBuffer.array(), other.mBuffer.array());
        }

        public int hashCode() {
            return Arrays.hashCode(this.mBuffer.array());
        }
    }
}

