/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.MonthDisplayHelper;

@RavenwoodKeepWholeClass
public class DayOfMonthCursor
extends MonthDisplayHelper {
    private int mRow;
    private int mColumn;

    public DayOfMonthCursor(int year, int month, int dayOfMonth, int weekStartDay) {
        super(year, month, weekStartDay);
        this.mRow = this.getRowOf(dayOfMonth);
        this.mColumn = this.getColumnOf(dayOfMonth);
    }

    public int getSelectedRow() {
        return this.mRow;
    }

    public int getSelectedColumn() {
        return this.mColumn;
    }

    public void setSelectedRowColumn(int row, int col) {
        this.mRow = row;
        this.mColumn = col;
    }

    public int getSelectedDayOfMonth() {
        return this.getDayAt(this.mRow, this.mColumn);
    }

    public int getSelectedMonthOffset() {
        if (this.isWithinCurrentMonth(this.mRow, this.mColumn)) {
            return 0;
        }
        if (this.mRow == 0) {
            return -1;
        }
        return 1;
    }

    public void setSelectedDayOfMonth(int dayOfMonth) {
        this.mRow = this.getRowOf(dayOfMonth);
        this.mColumn = this.getColumnOf(dayOfMonth);
    }

    public boolean isSelected(int row, int column) {
        return this.mRow == row && this.mColumn == column;
    }

    public boolean up() {
        if (this.isWithinCurrentMonth(this.mRow - 1, this.mColumn)) {
            --this.mRow;
            return false;
        }
        this.previousMonth();
        this.mRow = 5;
        while (!this.isWithinCurrentMonth(this.mRow, this.mColumn)) {
            --this.mRow;
        }
        return true;
    }

    public boolean down() {
        if (this.isWithinCurrentMonth(this.mRow + 1, this.mColumn)) {
            ++this.mRow;
            return false;
        }
        this.nextMonth();
        this.mRow = 0;
        while (!this.isWithinCurrentMonth(this.mRow, this.mColumn)) {
            ++this.mRow;
        }
        return true;
    }

    public boolean left() {
        if (this.mColumn == 0) {
            --this.mRow;
            this.mColumn = 6;
        } else {
            --this.mColumn;
        }
        if (this.isWithinCurrentMonth(this.mRow, this.mColumn)) {
            return false;
        }
        this.previousMonth();
        int lastDay = this.getNumberOfDaysInMonth();
        this.mRow = this.getRowOf(lastDay);
        this.mColumn = this.getColumnOf(lastDay);
        return true;
    }

    public boolean right() {
        if (this.mColumn == 6) {
            ++this.mRow;
            this.mColumn = 0;
        } else {
            ++this.mColumn;
        }
        if (this.isWithinCurrentMonth(this.mRow, this.mColumn)) {
            return false;
        }
        this.nextMonth();
        this.mRow = 0;
        this.mColumn = 0;
        while (!this.isWithinCurrentMonth(this.mRow, this.mColumn)) {
            ++this.mColumn;
        }
        return true;
    }
}

