/*
 * Decompiled with CFR 0.152.
 */
package android.tracing.perfetto;

import android.tracing.perfetto.CreateIncrementalStateArgs;
import android.tracing.perfetto.CreateTlsStateArgs;
import android.tracing.perfetto.DataSource;
import android.tracing.perfetto.DataSourceInstance;
import android.util.proto.ProtoOutputStream;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.ArrayList;
import java.util.List;

public class TracingContext<DataSourceInstanceType extends DataSourceInstance, TlsStateType, IncrementalStateType> {
    private final DataSource<DataSourceInstanceType, TlsStateType, IncrementalStateType> mDataSource;
    private final int mInstanceIndex;
    private final List<ProtoOutputStream> mTracePackets = new ArrayList<ProtoOutputStream>();

    TracingContext(DataSource<DataSourceInstanceType, TlsStateType, IncrementalStateType> dataSource, int instanceIndex) {
        this.mDataSource = dataSource;
        this.mInstanceIndex = instanceIndex;
    }

    public ProtoOutputStream newTracePacket() {
        ProtoOutputStream os = new ProtoOutputStream(0);
        this.mTracePackets.add(os);
        return os;
    }

    public TlsStateType getCustomTlsState() {
        Object tlsState = TracingContext.nativeGetCustomTls(this.mDataSource.mNativeObj);
        if (tlsState == null) {
            CreateTlsStateArgs args = new CreateTlsStateArgs(this.mDataSource, this.mInstanceIndex);
            tlsState = this.mDataSource.createTlsState(args);
            TracingContext.nativeSetCustomTls(this.mDataSource.mNativeObj, tlsState);
        }
        return (TlsStateType)tlsState;
    }

    public IncrementalStateType getIncrementalState() {
        Object incrementalState = TracingContext.nativeGetIncrementalState(this.mDataSource.mNativeObj);
        if (incrementalState == null) {
            CreateIncrementalStateArgs args = new CreateIncrementalStateArgs(this.mDataSource, this.mInstanceIndex);
            incrementalState = this.mDataSource.createIncrementalState(args);
            TracingContext.nativeSetIncrementalState(this.mDataSource.mNativeObj, incrementalState);
        }
        return (IncrementalStateType)incrementalState;
    }

    protected byte[][] getAndClearAllPendingTracePackets() {
        byte[][] res = new byte[this.mTracePackets.size()][];
        for (int i = 0; i < this.mTracePackets.size(); ++i) {
            ProtoOutputStream tracePacket = this.mTracePackets.get(i);
            res[i] = tracePacket.getBytes();
        }
        this.mTracePackets.clear();
        return res;
    }

    private static Object nativeGetCustomTls(long l) {
        return OverrideMethod.invokeA("android.tracing.perfetto.TracingContext#nativeGetCustomTls(J)Ljava/lang/Object;", true, null);
    }

    private static void nativeSetCustomTls(long l, Object object) {
        OverrideMethod.invokeV("android.tracing.perfetto.TracingContext#nativeSetCustomTls(JLjava/lang/Object;)V", true, null);
    }

    private static Object nativeGetIncrementalState(long l) {
        return OverrideMethod.invokeA("android.tracing.perfetto.TracingContext#nativeGetIncrementalState(J)Ljava/lang/Object;", true, null);
    }

    private static void nativeSetIncrementalState(long l, Object object) {
        OverrideMethod.invokeV("android.tracing.perfetto.TracingContext#nativeSetIncrementalState(JLjava/lang/Object;)V", true, null);
    }
}

