/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.text.ParcelableSpan;
import android.text.TextPaint;
import android.text.style.CharacterStyle;
import android.util.Log;
import com.android.internal.R;
import java.util.Arrays;
import java.util.Locale;

@RavenwoodKeepWholeClass
public class SuggestionSpan
extends CharacterStyle
implements ParcelableSpan {
    private static final String TAG = "SuggestionSpan";
    public static final int FLAG_EASY_CORRECT = 1;
    public static final int FLAG_MISSPELLED = 2;
    public static final int FLAG_AUTO_CORRECTION = 4;
    public static final int FLAG_GRAMMAR_ERROR = 8;
    @Deprecated
    public static final String ACTION_SUGGESTION_PICKED = "android.text.style.SUGGESTION_PICKED";
    @Deprecated
    public static final String SUGGESTION_SPAN_PICKED_AFTER = "after";
    @Deprecated
    public static final String SUGGESTION_SPAN_PICKED_BEFORE = "before";
    @Deprecated
    public static final String SUGGESTION_SPAN_PICKED_HASHCODE = "hashcode";
    public static final int SUGGESTIONS_MAX_SIZE = 5;
    private int mFlags;
    private final String[] mSuggestions;
    @NonNull
    private final String mLocaleStringForCompatibility;
    @NonNull
    private final String mLanguageTag;
    private final int mHashCode;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private float mEasyCorrectUnderlineThickness;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private int mEasyCorrectUnderlineColor;
    private float mMisspelledUnderlineThickness;
    private int mMisspelledUnderlineColor;
    private float mAutoCorrectionUnderlineThickness;
    private int mAutoCorrectionUnderlineColor;
    private float mGrammarErrorUnderlineThickness;
    private int mGrammarErrorUnderlineColor;
    @NonNull
    public static final Parcelable.Creator<SuggestionSpan> CREATOR = new Parcelable.Creator<SuggestionSpan>(){

        @Override
        public SuggestionSpan createFromParcel(Parcel source) {
            return new SuggestionSpan(source);
        }

        public SuggestionSpan[] newArray(int size) {
            return new SuggestionSpan[size];
        }
    };

    public SuggestionSpan(Context context, String[] suggestions, int flags) {
        this(context, null, suggestions, flags, null);
    }

    public SuggestionSpan(Locale locale, String[] suggestions, int flags) {
        this(null, locale, suggestions, flags, null);
    }

    public SuggestionSpan(Context context, Locale locale, String[] suggestions, int flags, Class<?> notificationTargetClass) {
        Locale sourceLocale;
        int N2 = Math.min(5, suggestions.length);
        this.mSuggestions = Arrays.copyOf(suggestions, N2);
        this.mFlags = flags;
        if (locale != null) {
            sourceLocale = locale;
        } else if (context != null) {
            sourceLocale = context.getResources().getConfiguration().locale;
        } else {
            Log.e(TAG, "No locale or context specified in SuggestionSpan constructor");
            sourceLocale = null;
        }
        this.mLocaleStringForCompatibility = sourceLocale == null ? "" : ((Object)sourceLocale).toString();
        this.mLanguageTag = sourceLocale == null ? "" : sourceLocale.toLanguageTag();
        this.mHashCode = SuggestionSpan.hashCodeInternal(this.mSuggestions, this.mLanguageTag, this.mLocaleStringForCompatibility);
        this.initStyle(context);
    }

    private void initStyle(Context context) {
        if (context == null) {
            this.mMisspelledUnderlineThickness = 0.0f;
            this.mGrammarErrorUnderlineThickness = 0.0f;
            this.mEasyCorrectUnderlineThickness = 0.0f;
            this.mAutoCorrectionUnderlineThickness = 0.0f;
            this.mMisspelledUnderlineColor = -16777216;
            this.mGrammarErrorUnderlineColor = -16777216;
            this.mEasyCorrectUnderlineColor = -16777216;
            this.mAutoCorrectionUnderlineColor = -16777216;
            return;
        }
        int defStyleAttr = 17957124;
        TypedArray typedArray = context.obtainStyledAttributes(null, R.styleable.SuggestionSpan, defStyleAttr, 0);
        this.mMisspelledUnderlineThickness = typedArray.getDimension(1, 0.0f);
        this.mMisspelledUnderlineColor = typedArray.getColor(0, -16777216);
        typedArray.recycle();
        defStyleAttr = 17957123;
        typedArray = context.obtainStyledAttributes(null, R.styleable.SuggestionSpan, defStyleAttr, 0);
        this.mGrammarErrorUnderlineThickness = typedArray.getDimension(1, 0.0f);
        this.mGrammarErrorUnderlineColor = typedArray.getColor(0, -16777216);
        typedArray.recycle();
        defStyleAttr = 0x1120102;
        typedArray = context.obtainStyledAttributes(null, R.styleable.SuggestionSpan, defStyleAttr, 0);
        this.mEasyCorrectUnderlineThickness = typedArray.getDimension(1, 0.0f);
        this.mEasyCorrectUnderlineColor = typedArray.getColor(0, -16777216);
        typedArray.recycle();
        defStyleAttr = 0x1120101;
        typedArray = context.obtainStyledAttributes(null, R.styleable.SuggestionSpan, defStyleAttr, 0);
        this.mAutoCorrectionUnderlineThickness = typedArray.getDimension(1, 0.0f);
        this.mAutoCorrectionUnderlineColor = typedArray.getColor(0, -16777216);
        typedArray.recycle();
    }

    public SuggestionSpan(Parcel src) {
        this(src.readStringArray(), src.readInt(), src.readString(), src.readString(), src.readInt(), src.readInt(), src.readFloat(), src.readInt(), src.readFloat(), src.readInt(), src.readFloat(), src.readInt(), src.readFloat());
    }

    public SuggestionSpan(String[] suggestions, int flags, String localeStringForCompatibility, String languageTag, int hashCode, int easyCorrectUnderlineColor, float easyCorrectUnderlineThickness, int misspelledUnderlineColor, float misspelledUnderlineThickness, int autoCorrectionUnderlineColor, float autoCorrectionUnderlineThickness, int grammarErrorUnderlineColor, float grammarErrorUnderlineThickness) {
        this.mSuggestions = suggestions;
        this.mFlags = flags;
        this.mLocaleStringForCompatibility = localeStringForCompatibility;
        this.mLanguageTag = languageTag;
        this.mHashCode = hashCode;
        this.mEasyCorrectUnderlineColor = easyCorrectUnderlineColor;
        this.mEasyCorrectUnderlineThickness = easyCorrectUnderlineThickness;
        this.mMisspelledUnderlineColor = misspelledUnderlineColor;
        this.mMisspelledUnderlineThickness = misspelledUnderlineThickness;
        this.mAutoCorrectionUnderlineColor = autoCorrectionUnderlineColor;
        this.mAutoCorrectionUnderlineThickness = autoCorrectionUnderlineThickness;
        this.mGrammarErrorUnderlineColor = grammarErrorUnderlineColor;
        this.mGrammarErrorUnderlineThickness = grammarErrorUnderlineThickness;
    }

    public String[] getSuggestions() {
        return this.mSuggestions;
    }

    @Deprecated
    @NonNull
    public String getLocale() {
        return this.mLocaleStringForCompatibility;
    }

    @Nullable
    public Locale getLocaleObject() {
        return this.mLanguageTag.isEmpty() ? null : Locale.forLanguageTag(this.mLanguageTag);
    }

    @Deprecated
    @UnsupportedAppUsage
    public String getNotificationTargetClassName() {
        return null;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public void setFlags(int flags) {
        this.mFlags = flags;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.writeToParcelInternal(dest, flags);
    }

    @Override
    public void writeToParcelInternal(Parcel dest, int flags) {
        dest.writeStringArray(this.mSuggestions);
        dest.writeInt(this.mFlags);
        dest.writeString(this.mLocaleStringForCompatibility);
        dest.writeString(this.mLanguageTag);
        dest.writeInt(this.mHashCode);
        dest.writeInt(this.mEasyCorrectUnderlineColor);
        dest.writeFloat(this.mEasyCorrectUnderlineThickness);
        dest.writeInt(this.mMisspelledUnderlineColor);
        dest.writeFloat(this.mMisspelledUnderlineThickness);
        dest.writeInt(this.mAutoCorrectionUnderlineColor);
        dest.writeFloat(this.mAutoCorrectionUnderlineThickness);
        dest.writeInt(this.mGrammarErrorUnderlineColor);
        dest.writeFloat(this.mGrammarErrorUnderlineThickness);
    }

    @Override
    public int getSpanTypeId() {
        return this.getSpanTypeIdInternal();
    }

    @Override
    public int getSpanTypeIdInternal() {
        return 19;
    }

    public boolean equals(@Nullable Object o) {
        if (o instanceof SuggestionSpan) {
            return ((SuggestionSpan)o).hashCode() == this.mHashCode;
        }
        return false;
    }

    public int hashCode() {
        return this.mHashCode;
    }

    private static int hashCodeInternal(String[] suggestions, @NonNull String languageTag, @NonNull String localeStringForCompatibility) {
        return Arrays.hashCode(new Object[]{SystemClock.uptimeMillis(), suggestions, languageTag, localeStringForCompatibility});
    }

    @Override
    public void updateDrawState(TextPaint tp) {
        boolean grammarError;
        boolean misspelled = (this.mFlags & 2) != 0;
        boolean easy = (this.mFlags & 1) != 0;
        boolean autoCorrection = (this.mFlags & 4) != 0;
        boolean bl = grammarError = (this.mFlags & 8) != 0;
        if (easy) {
            if (!misspelled && !grammarError) {
                tp.setUnderlineText(this.mEasyCorrectUnderlineColor, this.mEasyCorrectUnderlineThickness);
            } else if (tp.underlineColor == 0) {
                if (grammarError) {
                    tp.setUnderlineText(this.mGrammarErrorUnderlineColor, this.mGrammarErrorUnderlineThickness);
                } else {
                    tp.setUnderlineText(this.mMisspelledUnderlineColor, this.mMisspelledUnderlineThickness);
                }
            }
        } else if (autoCorrection) {
            tp.setUnderlineText(this.mAutoCorrectionUnderlineColor, this.mAutoCorrectionUnderlineThickness);
        } else if (misspelled) {
            tp.setUnderlineText(this.mMisspelledUnderlineColor, this.mMisspelledUnderlineThickness);
        } else if (grammarError) {
            tp.setUnderlineText(this.mGrammarErrorUnderlineColor, this.mGrammarErrorUnderlineThickness);
        }
    }

    public int getUnderlineColor() {
        boolean grammarError;
        boolean misspelled = (this.mFlags & 2) != 0;
        boolean easy = (this.mFlags & 1) != 0;
        boolean autoCorrection = (this.mFlags & 4) != 0;
        boolean bl = grammarError = (this.mFlags & 8) != 0;
        if (easy) {
            if (grammarError) {
                return this.mGrammarErrorUnderlineColor;
            }
            if (misspelled) {
                return this.mMisspelledUnderlineColor;
            }
            return this.mEasyCorrectUnderlineColor;
        }
        if (autoCorrection) {
            return this.mAutoCorrectionUnderlineColor;
        }
        if (misspelled) {
            return this.mMisspelledUnderlineColor;
        }
        if (grammarError) {
            return this.mGrammarErrorUnderlineColor;
        }
        return 0;
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void notifySelection(Context context, String original, int index) {
        Log.w(TAG, "notifySelection() is deprecated.  Does nothing.");
    }

    public float getEasyCorrectUnderlineThickness() {
        return this.mEasyCorrectUnderlineThickness;
    }

    public int getEasyCorrectUnderlineColor() {
        return this.mEasyCorrectUnderlineColor;
    }

    public float getMisspelledUnderlineThickness() {
        return this.mMisspelledUnderlineThickness;
    }

    public int getMisspelledUnderlineColor() {
        return this.mMisspelledUnderlineColor;
    }

    public float getAutoCorrectionUnderlineThickness() {
        return this.mAutoCorrectionUnderlineThickness;
    }

    public int getAutoCorrectionUnderlineColor() {
        return this.mAutoCorrectionUnderlineColor;
    }

    public float getGrammarErrorUnderlineThickness() {
        return this.mGrammarErrorUnderlineThickness;
    }

    public int getGrammarErrorUnderlineColor() {
        return this.mGrammarErrorUnderlineColor;
    }
}

