/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.icu.text.DecimalFormatSymbols;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.format.DateFormat;
import android.text.method.BaseKeyListener;
import android.view.KeyEvent;
import android.view.View;
import java.util.Collection;
import java.util.Locale;

@RavenwoodKeepWholeClass
public abstract class NumberKeyListener
extends BaseKeyListener
implements InputFilter {
    private static final String DATE_TIME_FORMAT_SYMBOLS = "GyYuUrQqMLlwWdDFgEecabBhHKkjJCmsSAzZOvVXx";
    private static final char SINGLE_QUOTE = '\'';

    @NonNull
    protected abstract char[] getAcceptedChars();

    protected int lookup(KeyEvent event, Spannable content) {
        return event.getMatch(this.getAcceptedChars(), NumberKeyListener.getMetaState((CharSequence)content, event));
    }

    @Override
    public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
        int i;
        char[] accept = this.getAcceptedChars();
        boolean filter = false;
        for (i = start; i < end && NumberKeyListener.ok(accept, source.charAt(i)); ++i) {
        }
        if (i == end) {
            return null;
        }
        if (end - start == 1) {
            return "";
        }
        SpannableStringBuilder filtered = new SpannableStringBuilder(source, start, end);
        i -= start;
        int len = (end -= start) - start;
        for (int j = end - 1; j >= i; --j) {
            if (NumberKeyListener.ok(accept, source.charAt(j))) continue;
            filtered.delete(j, j + 1);
        }
        return filtered;
    }

    protected static boolean ok(char[] accept, char c) {
        for (int i = accept.length - 1; i >= 0; --i) {
            if (accept[i] != c) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onKeyDown(View view, Editable content, int keyCode, KeyEvent event) {
        int repeatCount;
        int a = Selection.getSelectionStart(content);
        int b = Selection.getSelectionEnd(content);
        int selStart = Math.min(a, b);
        int selEnd = Math.max(a, b);
        if (selStart < 0 || selEnd < 0) {
            selEnd = 0;
            selStart = 0;
            Selection.setSelection(content, 0);
        }
        int i = event != null ? this.lookup(event, content) : 0;
        int n = repeatCount = event != null ? event.getRepeatCount() : 0;
        if (repeatCount == 0) {
            if (i != 0) {
                if (selStart != selEnd) {
                    Selection.setSelection(content, selEnd);
                }
                content.replace(selStart, selEnd, String.valueOf((char)i));
                NumberKeyListener.adjustMetaAfterKeypress(content);
                return true;
            }
        } else if (i == 48 && repeatCount == 1 && selStart == selEnd && selEnd > 0 && content.charAt(selStart - 1) == '0') {
            content.replace(selStart - 1, selEnd, String.valueOf('+'));
            NumberKeyListener.adjustMetaAfterKeypress(content);
            return true;
        }
        NumberKeyListener.adjustMetaAfterKeypress(content);
        return super.onKeyDown(view, content, keyCode, event);
    }

    @Nullable
    static boolean addDigits(@NonNull Collection<Character> collection, @Nullable Locale locale) {
        if (locale == null) {
            return false;
        }
        String[] digits = DecimalFormatSymbols.getInstance(locale).getDigitStrings();
        for (int i = 0; i < 10; ++i) {
            if (digits[i].length() > 1) {
                return false;
            }
            collection.add(Character.valueOf(digits[i].charAt(0)));
        }
        return true;
    }

    static boolean addFormatCharsFromSkeleton(@NonNull Collection<Character> collection, @Nullable Locale locale, @NonNull String skeleton, @NonNull String symbolsToIgnore) {
        if (locale == null) {
            return false;
        }
        String pattern = DateFormat.getBestDateTimePattern(locale, skeleton);
        boolean outsideQuotes = true;
        for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            if (Character.isSurrogate(ch)) {
                return false;
            }
            if (ch == '\'') {
                boolean bl = outsideQuotes = !outsideQuotes;
                if (i == 0 || pattern.charAt(i - 1) != '\'') continue;
            }
            if (outsideQuotes) {
                if (symbolsToIgnore.indexOf(ch) != -1) continue;
                if (DATE_TIME_FORMAT_SYMBOLS.indexOf(ch) != -1) {
                    return false;
                }
            }
            collection.add(Character.valueOf(ch));
        }
        return true;
    }

    static boolean addFormatCharsFromSkeletons(@NonNull Collection<Character> collection, @Nullable Locale locale, @NonNull String[] skeletons, @NonNull String symbolsToIgnore) {
        for (int i = 0; i < skeletons.length; ++i) {
            boolean success = NumberKeyListener.addFormatCharsFromSkeleton(collection, locale, skeletons[i], symbolsToIgnore);
            if (success) continue;
            return false;
        }
        return true;
    }

    static boolean addAmPmChars(@NonNull Collection<Character> collection, @Nullable Locale locale) {
        if (locale == null) {
            return false;
        }
        String[] amPm = DateFormat.getIcuDateFormatSymbols(locale).getAmPmStrings();
        for (int i = 0; i < amPm.length; ++i) {
            for (int j = 0; j < amPm[i].length(); ++j) {
                char ch = amPm[i].charAt(j);
                if (!Character.isBmpCodePoint(ch)) {
                    return false;
                }
                collection.add(Character.valueOf(ch));
            }
        }
        return true;
    }

    @NonNull
    static char[] collectionToArray(@NonNull Collection<Character> chars) {
        char[] result = new char[chars.size()];
        int i = 0;
        for (Character ch : chars) {
            result[i++] = ch.charValue();
        }
        return result;
    }
}

