/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.text.Editable;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.OffsetMapping;
import android.text.method.TransformationMethod;
import android.text.style.ReplacementSpan;
import android.util.DisplayMetrics;
import android.util.MathUtils;
import android.util.TypedValue;
import android.view.View;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import com.android.text.flags.Flags;
import java.lang.reflect.Array;

@RavenwoodKeepWholeClass
public class InsertModeTransformationMethod
implements TransformationMethod,
TextWatcher {
    private int mStart;
    private int mEnd;
    private final TransformationMethod mOldTransformationMethod;
    private final boolean mSingleLine;

    public InsertModeTransformationMethod(int offset, boolean singleLine, @NonNull TransformationMethod oldTransformationMethod) {
        this(offset, offset, singleLine, oldTransformationMethod);
    }

    private InsertModeTransformationMethod(int start, int end, boolean singleLine, @NonNull TransformationMethod oldTransformationMethod) {
        this.mStart = start;
        this.mEnd = end;
        this.mSingleLine = singleLine;
        this.mOldTransformationMethod = oldTransformationMethod;
    }

    public InsertModeTransformationMethod update(TransformationMethod oldTransformationMethod, boolean singleLine) {
        return new InsertModeTransformationMethod(this.mStart, this.mEnd, singleLine, oldTransformationMethod);
    }

    public TransformationMethod getOldTransformationMethod() {
        return this.mOldTransformationMethod;
    }

    private CharSequence getPlaceholderText(View view) {
        if (!this.mSingleLine) {
            return "\n\n";
        }
        SpannableString singleLinePlaceholder = new SpannableString("\ufffd");
        DisplayMetrics displayMetrics = view.getResources().getDisplayMetrics();
        int widthPx = (int)Math.ceil(TypedValue.applyDimension(1, 108.0f, displayMetrics));
        singleLinePlaceholder.setSpan(new SingleLinePlaceholderSpan(widthPx), 0, 1, 33);
        return singleLinePlaceholder;
    }

    @Override
    public CharSequence getTransformation(CharSequence source, View view) {
        CharSequence charSequence;
        if (this.mOldTransformationMethod != null) {
            charSequence = this.mOldTransformationMethod.getTransformation(source, view);
            if (source instanceof Spannable) {
                Spannable spannable = (Spannable)source;
                spannable.setSpan(this.mOldTransformationMethod, 0, spannable.length(), 18);
            }
        } else {
            charSequence = source;
        }
        CharSequence placeholderText = this.getPlaceholderText(view);
        return new TransformedText(charSequence, placeholderText);
    }

    @Override
    public void onFocusChanged(View view, CharSequence sourceText, boolean focused, int direction, Rect previouslyFocusedRect) {
        if (this.mOldTransformationMethod != null) {
            this.mOldTransformationMethod.onFocusChanged(view, sourceText, focused, direction, previouslyFocusedRect);
        }
    }

    @Override
    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    @Override
    public void onTextChanged(CharSequence s, int start, int before, int count) {
        if (start > this.mEnd) {
            return;
        }
        int diff = count - before;
        if (start < this.mStart) {
            this.mStart = start + before <= this.mStart ? (this.mStart += diff) : (Flags.insertModeHighlightRange() ? Math.min(this.mStart, s.length()) : start);
        }
        if (start + before <= this.mEnd) {
            this.mEnd += diff;
        } else if (start < this.mEnd) {
            this.mEnd = Flags.insertModeHighlightRange() ? Math.min(this.mEnd, s.length()) : start + count;
        }
    }

    @Override
    public void afterTextChanged(Editable s) {
    }

    private static boolean intersect(int s1, int e1, int s2, int e2) {
        if (s1 > e2) {
            return false;
        }
        if (e1 < s2) {
            return false;
        }
        if (s1 != e1 && s2 != e2) {
            if (s1 == e2) {
                return false;
            }
            if (e1 == s2) {
                return false;
            }
        }
        return true;
    }

    public static class SingleLinePlaceholderSpan
    extends ReplacementSpan {
        private final int mWidth;

        SingleLinePlaceholderSpan(int width) {
            this.mWidth = width;
        }

        @Override
        public int getSize(@NonNull Paint paint, CharSequence text, int start, int end, @Nullable Paint.FontMetricsInt fm) {
            return this.mWidth;
        }

        @Override
        public void draw(@NonNull Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
        }
    }

    public class TransformedText
    implements OffsetMapping,
    Spanned {
        private final CharSequence mOriginal;
        private final CharSequence mPlaceholder;
        private final Spanned mSpannedOriginal;
        private final Spanned mSpannedPlaceholder;

        TransformedText(CharSequence original, CharSequence placeholder) {
            this.mOriginal = original;
            this.mSpannedOriginal = original instanceof Spanned ? (Spanned)original : null;
            this.mPlaceholder = placeholder;
            this.mSpannedPlaceholder = placeholder instanceof Spanned ? (Spanned)placeholder : null;
        }

        @Override
        public int originalToTransformed(int offset, int strategy) {
            if (offset < 0) {
                return offset;
            }
            Preconditions.checkArgumentInRange(offset, 0, this.mOriginal.length(), "offset");
            if (offset == InsertModeTransformationMethod.this.mEnd && strategy == 1) {
                return offset;
            }
            if (offset < InsertModeTransformationMethod.this.mEnd) {
                return offset;
            }
            return offset + this.mPlaceholder.length();
        }

        @Override
        public int transformedToOriginal(int offset, int strategy) {
            if (offset < 0) {
                return offset;
            }
            Preconditions.checkArgumentInRange(offset, 0, this.length(), "offset");
            if (offset < InsertModeTransformationMethod.this.mEnd) {
                return offset;
            }
            if (offset < InsertModeTransformationMethod.this.mEnd + this.mPlaceholder.length()) {
                return InsertModeTransformationMethod.this.mEnd;
            }
            return offset - this.mPlaceholder.length();
        }

        @Override
        public void originalToTransformed(OffsetMapping.TextUpdate textUpdate) {
            if (textUpdate.where > InsertModeTransformationMethod.this.mEnd) {
                textUpdate.where += this.mPlaceholder.length();
            } else if (textUpdate.where + textUpdate.before > InsertModeTransformationMethod.this.mEnd) {
                textUpdate.before += this.mPlaceholder.length();
                textUpdate.after += this.mPlaceholder.length();
            }
        }

        @Override
        public int length() {
            return this.mOriginal.length() + this.mPlaceholder.length();
        }

        @Override
        public char charAt(int index) {
            Preconditions.checkArgumentInRange(index, 0, this.length() - 1, "index");
            if (index < InsertModeTransformationMethod.this.mEnd) {
                return this.mOriginal.charAt(index);
            }
            if (index < InsertModeTransformationMethod.this.mEnd + this.mPlaceholder.length()) {
                return this.mPlaceholder.charAt(index - InsertModeTransformationMethod.this.mEnd);
            }
            return this.mOriginal.charAt(index - this.mPlaceholder.length());
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            if (end < start || start < 0 || end > this.length()) {
                throw new IndexOutOfBoundsException();
            }
            if (start == end) {
                return "";
            }
            int placeholderLength = this.mPlaceholder.length();
            int seg1Start = Math.min(start, InsertModeTransformationMethod.this.mEnd);
            int seg1End = Math.min(end, InsertModeTransformationMethod.this.mEnd);
            int seg2Start = MathUtils.constrain(start - InsertModeTransformationMethod.this.mEnd, 0, placeholderLength);
            int seg2End = MathUtils.constrain(end - InsertModeTransformationMethod.this.mEnd, 0, placeholderLength);
            int seg3Start = Math.max(start - placeholderLength, InsertModeTransformationMethod.this.mEnd);
            int seg3End = Math.max(end - placeholderLength, InsertModeTransformationMethod.this.mEnd);
            return TextUtils.concat(this.mOriginal.subSequence(seg1Start, seg1End), this.mPlaceholder.subSequence(seg2Start, seg2End), this.mOriginal.subSequence(seg3Start, seg3End));
        }

        @Override
        public String toString() {
            return String.valueOf(this.mOriginal.subSequence(0, InsertModeTransformationMethod.this.mEnd)) + this.mPlaceholder + this.mOriginal.subSequence(InsertModeTransformationMethod.this.mEnd, this.mOriginal.length());
        }

        @Override
        public <T> T[] getSpans(int start, int end, Class<T> type) {
            if (end < start) {
                return ArrayUtils.emptyArray(type);
            }
            Object[] spansOriginal = null;
            if (this.mSpannedOriginal != null) {
                int originalStart = this.transformedToOriginal(start, 1);
                int originalEnd = this.transformedToOriginal(end, 1);
                spansOriginal = this.mSpannedOriginal.getSpans(originalStart, originalEnd, type);
                spansOriginal = ArrayUtils.filter(spansOriginal, size -> (Object[])Array.newInstance(type, size), span -> InsertModeTransformationMethod.intersect(this.getSpanStart(span), this.getSpanEnd(span), start, end));
            }
            T[] spansPlaceholder = null;
            if (this.mSpannedPlaceholder != null && InsertModeTransformationMethod.intersect(start, end, InsertModeTransformationMethod.this.mEnd, InsertModeTransformationMethod.this.mEnd + this.mPlaceholder.length())) {
                int placeholderStart = Math.max(start - InsertModeTransformationMethod.this.mEnd, 0);
                int placeholderEnd = Math.min(end - InsertModeTransformationMethod.this.mEnd, this.mPlaceholder.length());
                spansPlaceholder = this.mSpannedPlaceholder.getSpans(placeholderStart, placeholderEnd, type);
            }
            return ArrayUtils.concat(type, spansOriginal, spansPlaceholder);
        }

        @Override
        public int getSpanStart(Object tag) {
            int index;
            if (this.mSpannedOriginal != null && (index = this.mSpannedOriginal.getSpanStart(tag)) >= 0) {
                if (index < InsertModeTransformationMethod.this.mEnd || index == InsertModeTransformationMethod.this.mEnd && this.mSpannedOriginal.getSpanEnd(tag) == index) {
                    return index;
                }
                return index + this.mPlaceholder.length();
            }
            if (this.mSpannedPlaceholder != null && (index = this.mSpannedPlaceholder.getSpanStart(tag)) >= 0) {
                return index + InsertModeTransformationMethod.this.mEnd;
            }
            return -1;
        }

        @Override
        public int getSpanEnd(Object tag) {
            int index;
            if (this.mSpannedOriginal != null && (index = this.mSpannedOriginal.getSpanEnd(tag)) >= 0) {
                if (index <= InsertModeTransformationMethod.this.mEnd) {
                    return index;
                }
                return index + this.mPlaceholder.length();
            }
            if (this.mSpannedPlaceholder != null && (index = this.mSpannedPlaceholder.getSpanEnd(tag)) >= 0) {
                return index + InsertModeTransformationMethod.this.mEnd;
            }
            return -1;
        }

        @Override
        public int getSpanFlags(Object tag) {
            int flags;
            if (this.mSpannedOriginal != null && (flags = this.mSpannedOriginal.getSpanFlags(tag)) != 0) {
                return flags;
            }
            if (this.mSpannedPlaceholder != null) {
                return this.mSpannedPlaceholder.getSpanFlags(tag);
            }
            return 0;
        }

        @Override
        public int nextSpanTransition(int start, int limit, Class type) {
            if (limit <= start) {
                return limit;
            }
            T[] spans = this.getSpans(start, limit, type);
            for (int i = 0; i < spans.length; ++i) {
                int spanStart = this.getSpanStart(spans[i]);
                int spanEnd = this.getSpanEnd(spans[i]);
                if (start < spanStart && spanStart < limit) {
                    limit = spanStart;
                }
                if (start >= spanEnd || spanEnd >= limit) continue;
                limit = spanEnd;
            }
            return limit;
        }

        public int getHighlightStart() {
            return InsertModeTransformationMethod.this.mStart;
        }

        public int getHighlightEnd() {
            return InsertModeTransformationMethod.this.mEnd + this.mPlaceholder.length();
        }
    }
}

