/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.satellite;

import android.annotation.FlaggedApi;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.satellite.SatelliteInfo;
import com.android.layoutlib.androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
public class SatelliteAccessConfiguration
implements Parcelable {
    @NonNull
    private List<SatelliteInfo> mSatelliteInfoList;
    @NonNull
    private List<Integer> mTagIdList;
    @NonNull
    public static final Parcelable.Creator<SatelliteAccessConfiguration> CREATOR = new Parcelable.Creator<SatelliteAccessConfiguration>(){

        @Override
        public SatelliteAccessConfiguration createFromParcel(Parcel in) {
            return new SatelliteAccessConfiguration(in);
        }

        public SatelliteAccessConfiguration[] newArray(int size) {
            return new SatelliteAccessConfiguration[size];
        }
    };

    public SatelliteAccessConfiguration(@NonNull List<SatelliteInfo> satelliteInfos, @NonNull List<Integer> tagIdList) {
        this.mSatelliteInfoList = satelliteInfos;
        this.mTagIdList = tagIdList;
    }

    public SatelliteAccessConfiguration(Parcel in) {
        this.mSatelliteInfoList = in.createTypedArrayList(SatelliteInfo.CREATOR);
        this.mTagIdList = new ArrayList<Integer>();
        in.readList(this.mTagIdList, Integer.class.getClassLoader(), Integer.class);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeTypedList(this.mSatelliteInfoList);
        dest.writeList(this.mTagIdList);
    }

    @NonNull
    public List<SatelliteInfo> getSatelliteInfos() {
        return this.mSatelliteInfoList;
    }

    @NonNull
    public List<Integer> getTagIds() {
        return this.mTagIdList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SatelliteAccessConfiguration)) {
            return false;
        }
        SatelliteAccessConfiguration that = (SatelliteAccessConfiguration)o;
        return this.mSatelliteInfoList.equals(that.mSatelliteInfoList) && Objects.equals(this.mTagIdList, that.mTagIdList);
    }

    public int hashCode() {
        int result = Objects.hash(this.mSatelliteInfoList);
        result = 31 * result + Objects.hashCode(this.mTagIdList);
        return result;
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SatelliteAccessConfiguration{");
        sb.append("mSatelliteInfoList=").append(this.mSatelliteInfoList);
        sb.append(", mTagIds=").append(this.mTagIdList);
        sb.append('}');
        return sb.toString();
    }
}

