/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.satellite;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.satellite.SatelliteCapabilities;

public interface ISatelliteCapabilitiesCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.telephony.satellite.ISatelliteCapabilitiesCallback";

    public void onSatelliteCapabilitiesChanged(SatelliteCapabilities var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISatelliteCapabilitiesCallback {
        static final int TRANSACTION_onSatelliteCapabilitiesChanged = 1;

        public Stub() {
            this.attachInterface(this, ISatelliteCapabilitiesCallback.DESCRIPTOR);
        }

        public static ISatelliteCapabilitiesCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISatelliteCapabilitiesCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ISatelliteCapabilitiesCallback) {
                return (ISatelliteCapabilitiesCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onSatelliteCapabilitiesChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISatelliteCapabilitiesCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    SatelliteCapabilities _arg0 = data.readTypedObject(SatelliteCapabilities.CREATOR);
                    data.enforceNoDataAvail();
                    this.onSatelliteCapabilitiesChanged(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements ISatelliteCapabilitiesCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISatelliteCapabilitiesCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSatelliteCapabilitiesChanged(SatelliteCapabilities capabilities) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISatelliteCapabilitiesCallback.DESCRIPTOR);
                    _data.writeTypedObject(capabilities, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISatelliteCapabilitiesCallback {
        @Override
        public void onSatelliteCapabilitiesChanged(SatelliteCapabilities capabilities) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

