/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.TelephonyManager;
import android.util.Range;
import android.util.RecurrenceRule;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;

public class SubscriptionPlan
implements Parcelable {
    public static final int LIMIT_BEHAVIOR_UNKNOWN = -1;
    public static final int LIMIT_BEHAVIOR_DISABLED = 0;
    public static final int LIMIT_BEHAVIOR_BILLED = 1;
    public static final int LIMIT_BEHAVIOR_THROTTLED = 2;
    public static final long BYTES_UNKNOWN = -1L;
    public static final long BYTES_UNLIMITED = Long.MAX_VALUE;
    public static final long TIME_UNKNOWN = -1L;
    @FlaggedApi(value="com.android.internal.telephony.flags.subscription_plan_allow_status_and_end_date")
    public static final int SUBSCRIPTION_STATUS_UNKNOWN = 0;
    @FlaggedApi(value="com.android.internal.telephony.flags.subscription_plan_allow_status_and_end_date")
    public static final int SUBSCRIPTION_STATUS_ACTIVE = 1;
    @FlaggedApi(value="com.android.internal.telephony.flags.subscription_plan_allow_status_and_end_date")
    public static final int SUBSCRIPTION_STATUS_INACTIVE = 2;
    @FlaggedApi(value="com.android.internal.telephony.flags.subscription_plan_allow_status_and_end_date")
    public static final int SUBSCRIPTION_STATUS_TRIAL = 3;
    @FlaggedApi(value="com.android.internal.telephony.flags.subscription_plan_allow_status_and_end_date")
    public static final int SUBSCRIPTION_STATUS_SUSPENDED = 4;
    private final RecurrenceRule cycleRule;
    private CharSequence title;
    private CharSequence summary;
    private long dataLimitBytes = -1L;
    private int dataLimitBehavior = -1;
    private long dataUsageBytes = -1L;
    private long dataUsageTime = -1L;
    private int[] networkTypes;
    private int mSubscriptionStatus = 0;
    @NonNull
    public static final Parcelable.Creator<SubscriptionPlan> CREATOR = new Parcelable.Creator<SubscriptionPlan>(){

        @Override
        public SubscriptionPlan createFromParcel(Parcel source) {
            return new SubscriptionPlan(source);
        }

        public SubscriptionPlan[] newArray(int size) {
            return new SubscriptionPlan[size];
        }
    };

    private SubscriptionPlan(RecurrenceRule cycleRule) {
        this.cycleRule = Preconditions.checkNotNull(cycleRule);
        this.networkTypes = Arrays.copyOf(TelephonyManager.getAllNetworkTypes(), TelephonyManager.getAllNetworkTypes().length);
    }

    private SubscriptionPlan(Parcel source) {
        this.cycleRule = source.readParcelable(null, RecurrenceRule.class);
        this.title = source.readCharSequence();
        this.summary = source.readCharSequence();
        this.dataLimitBytes = source.readLong();
        this.dataLimitBehavior = source.readInt();
        this.dataUsageBytes = source.readLong();
        this.dataUsageTime = source.readLong();
        this.networkTypes = source.createIntArray();
        this.mSubscriptionStatus = source.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.cycleRule, flags);
        dest.writeCharSequence(this.title);
        dest.writeCharSequence(this.summary);
        dest.writeLong(this.dataLimitBytes);
        dest.writeInt(this.dataLimitBehavior);
        dest.writeLong(this.dataUsageBytes);
        dest.writeLong(this.dataUsageTime);
        dest.writeIntArray(this.networkTypes);
        dest.writeInt(this.mSubscriptionStatus);
    }

    public String toString() {
        return "SubscriptionPlan{" + "cycleRule=" + this.cycleRule + " title=" + this.title + " summary=" + this.summary + " dataLimitBytes=" + this.dataLimitBytes + " dataLimitBehavior=" + this.dataLimitBehavior + " dataUsageBytes=" + this.dataUsageBytes + " dataUsageTime=" + this.dataUsageTime + " networkTypes=" + Arrays.toString(this.networkTypes) + " subscriptionStatus=" + this.mSubscriptionStatus + "}";
    }

    public int hashCode() {
        return Objects.hash(this.cycleRule, this.title, this.summary, this.dataLimitBytes, this.dataLimitBehavior, this.dataUsageBytes, this.dataUsageTime, Arrays.hashCode(this.networkTypes), this.mSubscriptionStatus);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof SubscriptionPlan) {
            SubscriptionPlan other = (SubscriptionPlan)obj;
            return Objects.equals(this.cycleRule, other.cycleRule) && Objects.equals(this.title, other.title) && Objects.equals(this.summary, other.summary) && this.dataLimitBytes == other.dataLimitBytes && this.dataLimitBehavior == other.dataLimitBehavior && this.dataUsageBytes == other.dataUsageBytes && this.dataUsageTime == other.dataUsageTime && Arrays.equals(this.networkTypes, other.networkTypes) && this.mSubscriptionStatus == other.mSubscriptionStatus;
        }
        return false;
    }

    @NonNull
    public RecurrenceRule getCycleRule() {
        return this.cycleRule;
    }

    @FlaggedApi(value="com.android.internal.telephony.flags.subscription_plan_allow_status_and_end_date")
    @Nullable
    public ZonedDateTime getPlanEndDate() {
        return this.cycleRule.end;
    }

    @Nullable
    public CharSequence getTitle() {
        return this.title;
    }

    @Nullable
    public CharSequence getSummary() {
        return this.summary;
    }

    public long getDataLimitBytes() {
        return this.dataLimitBytes;
    }

    public int getDataLimitBehavior() {
        return this.dataLimitBehavior;
    }

    public long getDataUsageBytes() {
        return this.dataUsageBytes;
    }

    public long getDataUsageTime() {
        return this.dataUsageTime;
    }

    @NonNull
    public int[] getNetworkTypes() {
        return Arrays.copyOf(this.networkTypes, this.networkTypes.length);
    }

    public Iterator<Range<ZonedDateTime>> cycleIterator() {
        return this.cycleRule.cycleIterator();
    }

    @FlaggedApi(value="com.android.internal.telephony.flags.subscription_plan_allow_status_and_end_date")
    public int getSubscriptionStatus() {
        return this.mSubscriptionStatus;
    }

    public static class Builder {
        private final SubscriptionPlan plan;

        public Builder(ZonedDateTime start, ZonedDateTime end, Period period) {
            this.plan = new SubscriptionPlan(new RecurrenceRule(start, end, period));
        }

        public static Builder createNonrecurring(ZonedDateTime start, ZonedDateTime end) {
            if (!end.isAfter(start)) {
                throw new IllegalArgumentException("End " + end + " isn't after start " + start);
            }
            return new Builder(start, end, null);
        }

        public static Builder createRecurring(ZonedDateTime start, Period period) {
            if (period.isZero() || period.isNegative()) {
                throw new IllegalArgumentException("Period " + period + " must be positive");
            }
            return new Builder(start, null, period);
        }

        @SystemApi
        @Deprecated
        public static Builder createRecurringMonthly(ZonedDateTime start) {
            return new Builder(start, null, Period.ofMonths(1));
        }

        @SystemApi
        @Deprecated
        public static Builder createRecurringWeekly(ZonedDateTime start) {
            return new Builder(start, null, Period.ofDays(7));
        }

        @SystemApi
        @Deprecated
        public static Builder createRecurringDaily(ZonedDateTime start) {
            return new Builder(start, null, Period.ofDays(1));
        }

        public SubscriptionPlan build() {
            return this.plan;
        }

        public Builder setTitle(@Nullable CharSequence title) {
            this.plan.title = title;
            return this;
        }

        public Builder setSummary(@Nullable CharSequence summary) {
            this.plan.summary = summary;
            return this;
        }

        public Builder setDataLimit(long dataLimitBytes, int dataLimitBehavior) {
            if (dataLimitBytes < 0L) {
                throw new IllegalArgumentException("Limit bytes must be positive");
            }
            if (dataLimitBehavior < 0) {
                throw new IllegalArgumentException("Limit behavior must be defined");
            }
            this.plan.dataLimitBytes = dataLimitBytes;
            this.plan.dataLimitBehavior = dataLimitBehavior;
            return this;
        }

        public Builder setDataUsage(long dataUsageBytes, long dataUsageTime) {
            if (dataUsageBytes < 0L) {
                throw new IllegalArgumentException("Usage bytes must be positive");
            }
            if (dataUsageTime < 0L) {
                throw new IllegalArgumentException("Usage time must be positive");
            }
            this.plan.dataUsageBytes = dataUsageBytes;
            this.plan.dataUsageTime = dataUsageTime;
            return this;
        }

        @NonNull
        public Builder setNetworkTypes(@NonNull int[] networkTypes) {
            this.plan.networkTypes = Arrays.copyOf(networkTypes, networkTypes.length);
            return this;
        }

        @NonNull
        public Builder resetNetworkTypes() {
            this.plan.networkTypes = Arrays.copyOf(TelephonyManager.getAllNetworkTypes(), TelephonyManager.getAllNetworkTypes().length);
            return this;
        }

        @FlaggedApi(value="com.android.internal.telephony.flags.subscription_plan_allow_status_and_end_date")
        @NonNull
        public Builder setSubscriptionStatus(int subscriptionStatus) {
            if (subscriptionStatus < 0 || subscriptionStatus > 4) {
                throw new IllegalArgumentException("Subscription status must be defined with a valid value");
            }
            this.plan.mSubscriptionStatus = subscriptionStatus;
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SubscriptionStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LimitBehavior {
    }
}

