/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.compat.Compatibility;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.LinkProperties;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.AccessNetworkConstants;
import android.telephony.DataFailCause;
import android.telephony.TelephonyManager;
import android.telephony.data.ApnSetting;
import android.telephony.data.Qos;
import com.android.internal.telephony.util.TelephonyUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class PreciseDataConnectionState
implements Parcelable {
    private final int mTransportType;
    private final int mId;
    private final int mNetId;
    private final int mState;
    private final int mNetworkType;
    private final int mFailCause;
    private final LinkProperties mLinkProperties;
    private final ApnSetting mApnSetting;
    private final Qos mDefaultQos;
    private final int mNetworkValidationStatus;
    public static final int NETWORK_VALIDATION_UNSUPPORTED = 0;
    public static final int NETWORK_VALIDATION_NOT_REQUESTED = 1;
    public static final int NETWORK_VALIDATION_IN_PROGRESS = 2;
    public static final int NETWORK_VALIDATION_SUCCESS = 3;
    public static final int NETWORK_VALIDATION_FAILURE = 4;
    private static final long GET_DATA_CONNECTION_STATE_R_VERSION = 148535736L;
    @NonNull
    public static final Parcelable.Creator<PreciseDataConnectionState> CREATOR = new Parcelable.Creator<PreciseDataConnectionState>(){

        @Override
        public PreciseDataConnectionState createFromParcel(Parcel in) {
            return new PreciseDataConnectionState(in);
        }

        public PreciseDataConnectionState[] newArray(int size) {
            return new PreciseDataConnectionState[size];
        }
    };

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public PreciseDataConnectionState(int state, int networkType, int apnTypes, @NonNull String apn, @Nullable LinkProperties linkProperties, int failCause) {
        this(-1, -1, -1, state, networkType, linkProperties, failCause, new ApnSetting.Builder().setApnTypeBitmask(apnTypes).setApnName(apn).setEntryName(apn).build(), null, 0);
    }

    private PreciseDataConnectionState(int transportType, int id2, int netId, int state, int networkType, @Nullable LinkProperties linkProperties, int failCause, @Nullable ApnSetting apnSetting, @Nullable Qos defaultQos, int networkValidationStatus) {
        this.mTransportType = transportType;
        this.mId = id2;
        this.mNetId = netId;
        this.mState = state;
        this.mNetworkType = networkType;
        this.mLinkProperties = linkProperties;
        this.mFailCause = failCause;
        this.mApnSetting = apnSetting;
        this.mDefaultQos = defaultQos;
        this.mNetworkValidationStatus = networkValidationStatus;
    }

    private PreciseDataConnectionState(Parcel in) {
        this.mTransportType = in.readInt();
        this.mId = in.readInt();
        this.mNetId = in.readInt();
        this.mState = in.readInt();
        this.mNetworkType = in.readInt();
        this.mLinkProperties = in.readParcelable(LinkProperties.class.getClassLoader(), LinkProperties.class);
        this.mFailCause = in.readInt();
        this.mApnSetting = in.readParcelable(ApnSetting.class.getClassLoader(), ApnSetting.class);
        this.mDefaultQos = in.readParcelable(Qos.class.getClassLoader(), Qos.class);
        this.mNetworkValidationStatus = in.readInt();
    }

    @Deprecated
    @SystemApi
    public int getDataConnectionState() {
        if (this.mState == 4 && !Compatibility.isChangeEnabled(148535736L)) {
            return 2;
        }
        return this.mState;
    }

    public int getTransportType() {
        return this.mTransportType;
    }

    public int getId() {
        return this.mId;
    }

    public int getNetId() {
        return this.mNetId;
    }

    public int getState() {
        return this.mState;
    }

    public int getNetworkType() {
        return this.mNetworkType;
    }

    @Deprecated
    @SystemApi
    public int getDataConnectionApnTypeBitMask() {
        return this.mApnSetting != null ? this.mApnSetting.getApnTypeBitmask() : 0;
    }

    @SystemApi
    @Deprecated
    @NonNull
    public String getDataConnectionApn() {
        return this.mApnSetting != null ? this.mApnSetting.getApnName() : "";
    }

    @Nullable
    public LinkProperties getLinkProperties() {
        return this.mLinkProperties;
    }

    @Deprecated
    @SystemApi
    public int getDataConnectionFailCause() {
        return this.mFailCause;
    }

    public int getLastCauseCode() {
        return this.mFailCause;
    }

    @Nullable
    public ApnSetting getApnSetting() {
        return this.mApnSetting;
    }

    @Nullable
    public Qos getDefaultQos() {
        return this.mDefaultQos;
    }

    public int getNetworkValidationStatus() {
        return this.mNetworkValidationStatus;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeInt(this.mTransportType);
        out.writeInt(this.mId);
        out.writeInt(this.mNetId);
        out.writeInt(this.mState);
        out.writeInt(this.mNetworkType);
        out.writeParcelable(this.mLinkProperties, flags);
        out.writeInt(this.mFailCause);
        out.writeParcelable(this.mApnSetting, flags);
        out.writeParcelable(this.mDefaultQos, flags);
        out.writeInt(this.mNetworkValidationStatus);
    }

    public int hashCode() {
        return Objects.hash(this.mTransportType, this.mId, this.mNetId, this.mState, this.mNetworkType, this.mFailCause, this.mLinkProperties, this.mApnSetting, this.mDefaultQos, this.mNetworkValidationStatus);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreciseDataConnectionState that = (PreciseDataConnectionState)o;
        return this.mTransportType == that.mTransportType && this.mId == that.mId && this.mNetId == that.mNetId && this.mState == that.mState && this.mNetworkType == that.mNetworkType && this.mFailCause == that.mFailCause && Objects.equals(this.mLinkProperties, that.mLinkProperties) && Objects.equals(this.mApnSetting, that.mApnSetting) && Objects.equals(this.mDefaultQos, that.mDefaultQos) && this.mNetworkValidationStatus == that.mNetworkValidationStatus;
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" state: ").append(TelephonyUtils.dataStateToString(this.mState));
        sb.append(", transport: ").append(AccessNetworkConstants.transportTypeToString(this.mTransportType));
        sb.append(", id: ").append(this.mId);
        sb.append(", netId: ").append(this.mNetId);
        sb.append(", network type: ").append(TelephonyManager.getNetworkTypeName(this.mNetworkType));
        sb.append(", APN Setting: ").append(this.mApnSetting);
        sb.append(", link properties: ").append(this.mLinkProperties);
        sb.append(", default QoS: ").append(this.mDefaultQos);
        sb.append(", fail cause: ").append(DataFailCause.toString(this.mFailCause));
        sb.append(", network validation status: ").append(PreciseDataConnectionState.networkValidationStatusToString(this.mNetworkValidationStatus));
        return sb.toString();
    }

    @NonNull
    public static String networkValidationStatusToString(int networkValidationStatus) {
        switch (networkValidationStatus) {
            case 0: {
                return "unsupported";
            }
            case 1: {
                return "not requested";
            }
            case 2: {
                return "in progress";
            }
            case 3: {
                return "success";
            }
            case 4: {
                return "failure";
            }
        }
        return Integer.toString(networkValidationStatus);
    }

    public static class Builder {
        private int mTransportType = -1;
        private int mId = -1;
        private int mNetworkAgentId = -1;
        private int mState = -1;
        private int mNetworkType = 0;
        @Nullable
        private LinkProperties mLinkProperties;
        private int mFailCause = 0;
        @Nullable
        private ApnSetting mApnSetting;
        @Nullable
        private Qos mDefaultQos;
        private int mNetworkValidationStatus = 0;

        @NonNull
        public Builder setTransportType(int transportType) {
            this.mTransportType = transportType;
            return this;
        }

        @NonNull
        public Builder setId(int id2) {
            this.mId = id2;
            return this;
        }

        @NonNull
        public Builder setNetworkAgentId(int agentId) {
            this.mNetworkAgentId = agentId;
            return this;
        }

        @NonNull
        public Builder setState(int state) {
            this.mState = state;
            return this;
        }

        @NonNull
        public Builder setNetworkType(int networkType) {
            this.mNetworkType = networkType;
            return this;
        }

        @NonNull
        public Builder setLinkProperties(LinkProperties linkProperties) {
            this.mLinkProperties = linkProperties;
            return this;
        }

        @NonNull
        public Builder setFailCause(int failCause) {
            this.mFailCause = failCause;
            return this;
        }

        @NonNull
        public Builder setApnSetting(@NonNull ApnSetting apnSetting) {
            this.mApnSetting = apnSetting;
            return this;
        }

        @NonNull
        public Builder setDefaultQos(@Nullable Qos qos) {
            this.mDefaultQos = qos;
            return this;
        }

        @NonNull
        public Builder setNetworkValidationStatus(int networkValidationStatus) {
            this.mNetworkValidationStatus = networkValidationStatus;
            return this;
        }

        public PreciseDataConnectionState build() {
            return new PreciseDataConnectionState(this.mTransportType, this.mId, this.mNetworkAgentId, this.mState, this.mNetworkType, this.mLinkProperties, this.mFailCause, this.mApnSetting, this.mDefaultQos, this.mNetworkValidationStatus);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NetworkValidationStatus {
    }
}

