/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.OutcomeReceiver;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.telecom.CallAttributes;
import android.telecom.CallControl;
import android.telecom.CallControlCallback;
import android.telecom.CallEventCallback;
import android.telecom.CallException;
import android.telecom.PhoneAccount;
import android.telecom.PhoneAccountHandle;
import android.telecom.TelecomAnalytics;
import android.telephony.SubscriptionManager;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.telecom.ClientTransactionalServiceRepository;
import com.android.internal.telecom.ClientTransactionalServiceWrapper;
import com.android.internal.telecom.ITelecomService;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

public class TelecomManager {
    public static final String ACTION_INCOMING_CALL = "android.telecom.action.INCOMING_CALL";
    public static final String ACTION_NEW_UNKNOWN_CALL = "android.telecom.action.NEW_UNKNOWN_CALL";
    public static final String ACTION_CONFIGURE_PHONE_ACCOUNT = "android.telecom.action.CONFIGURE_PHONE_ACCOUNT";
    public static final String ACTION_SHOW_CALL_ACCESSIBILITY_SETTINGS = "android.telecom.action.SHOW_CALL_ACCESSIBILITY_SETTINGS";
    public static final String ACTION_SHOW_CALL_SETTINGS = "android.telecom.action.SHOW_CALL_SETTINGS";
    public static final String ACTION_SHOW_RESPOND_VIA_SMS_SETTINGS = "android.telecom.action.SHOW_RESPOND_VIA_SMS_SETTINGS";
    public static final String ACTION_CHANGE_PHONE_ACCOUNTS = "android.telecom.action.CHANGE_PHONE_ACCOUNTS";
    public static final String ACTION_PHONE_ACCOUNT_REGISTERED = "android.telecom.action.PHONE_ACCOUNT_REGISTERED";
    public static final String ACTION_PHONE_ACCOUNT_UNREGISTERED = "android.telecom.action.PHONE_ACCOUNT_UNREGISTERED";
    public static final String ACTION_CHANGE_DEFAULT_DIALER = "android.telecom.action.CHANGE_DEFAULT_DIALER";
    public static final String ACTION_DEFAULT_DIALER_CHANGED = "android.telecom.action.DEFAULT_DIALER_CHANGED";
    public static final String EXTRA_CHANGE_DEFAULT_DIALER_PACKAGE_NAME = "android.telecom.extra.CHANGE_DEFAULT_DIALER_PACKAGE_NAME";
    public static final String ACTION_DEFAULT_CALL_SCREENING_APP_CHANGED = "android.telecom.action.DEFAULT_CALL_SCREENING_APP_CHANGED";
    public static final String EXTRA_DEFAULT_CALL_SCREENING_APP_COMPONENT_NAME = "android.telecom.extra.DEFAULT_CALL_SCREENING_APP_COMPONENT_NAME";
    public static final String EXTRA_DO_NOT_LOG_CALL = "android.telecom.extra.DO_NOT_LOG_CALL";
    public static final String EXTRA_IS_DEFAULT_CALL_SCREENING_APP = "android.telecom.extra.IS_DEFAULT_CALL_SCREENING_APP";
    public static final String EXTRA_START_CALL_WITH_SPEAKERPHONE = "android.telecom.extra.START_CALL_WITH_SPEAKERPHONE";
    public static final String EXTRA_START_CALL_WITH_VIDEO_STATE = "android.telecom.extra.START_CALL_WITH_VIDEO_STATE";
    public static final String EXTRA_INCOMING_VIDEO_STATE = "android.telecom.extra.INCOMING_VIDEO_STATE";
    public static final String EXTRA_PHONE_ACCOUNT_HANDLE = "android.telecom.extra.PHONE_ACCOUNT_HANDLE";
    public static final String EXTRA_CALL_SUBJECT = "android.telecom.extra.CALL_SUBJECT";
    public static final int PRIORITY_NORMAL = 0;
    public static final int PRIORITY_URGENT = 1;
    public static final String EXTRA_PRIORITY = "android.telecom.extra.PRIORITY";
    public static final String EXTRA_LOCATION = "android.telecom.extra.LOCATION";
    public static final String EXTRA_HAS_PICTURE = "android.telecom.extra.HAS_PICTURE";
    public static final String EXTRA_PICTURE_URI = "android.telecom.extra.PICTURE_URI";
    public static final String EXTRA_OUTGOING_PICTURE = "android.telecom.extra.OUTGOING_PICTURE";
    public static final String EXTRA_INCOMING_CALL_ADDRESS = "android.telecom.extra.INCOMING_CALL_ADDRESS";
    public static final String EXTRA_INCOMING_CALL_EXTRAS = "android.telecom.extra.INCOMING_CALL_EXTRAS";
    @SystemApi
    public static final String EXTRA_CALL_HAS_IN_BAND_RINGTONE = "android.telecom.extra.CALL_HAS_IN_BAND_RINGTONE";
    public static final String EXTRA_OUTGOING_CALL_EXTRAS = "android.telecom.extra.OUTGOING_CALL_EXTRAS";
    @SystemApi
    public static final String EXTRA_IS_USER_INTENT_EMERGENCY_CALL = "android.telecom.extra.IS_USER_INTENT_EMERGENCY_CALL";
    @SystemApi
    public static final String EXTRA_UNKNOWN_CALL_HANDLE = "android.telecom.extra.UNKNOWN_CALL_HANDLE";
    public static final String EXTRA_CALL_CREATED_TIME_MILLIS = "android.telecom.extra.CALL_CREATED_TIME_MILLIS";
    @FlaggedApi(value="com.android.server.telecom.flags.add_call_uri_for_missed_calls")
    public static final String EXTRA_CALL_LOG_URI = "android.telecom.extra.CALL_LOG_URI";
    public static final String EXTRA_CALL_ANSWERED_TIME_MILLIS = "android.telecom.extra.CALL_ANSWERED_TIME_MILLIS";
    public static final String EXTRA_CALL_CREATED_EPOCH_TIME_MILLIS = "android.telecom.extra.CALL_CREATED_EPOCH_TIME_MILLIS";
    public static final String EXTRA_CALL_TELECOM_ROUTING_START_TIME_MILLIS = "android.telecom.extra.CALL_TELECOM_ROUTING_START_TIME_MILLIS";
    public static final String EXTRA_CALL_TELECOM_ROUTING_END_TIME_MILLIS = "android.telecom.extra.CALL_TELECOM_ROUTING_END_TIME_MILLIS";
    public static final String EXTRA_CALL_DISCONNECT_CAUSE = "android.telecom.extra.CALL_DISCONNECT_CAUSE";
    public static final String EXTRA_CALL_DISCONNECT_MESSAGE = "android.telecom.extra.CALL_DISCONNECT_MESSAGE";
    public static final String CALL_AUTO_DISCONNECT_MESSAGE_STRING = "Call dropped by lower layers";
    @SystemApi
    public static final String EXTRA_CONNECTION_SERVICE = "android.telecom.extra.CONNECTION_SERVICE";
    @SystemApi
    public static final String EXTRA_CALL_TECHNOLOGY_TYPE = "android.telecom.extra.CALL_TECHNOLOGY_TYPE";
    public static final String EXTRA_CALL_NETWORK_TYPE = "android.telecom.extra.CALL_NETWORK_TYPE";
    public static final String GATEWAY_PROVIDER_PACKAGE = "android.telecom.extra.GATEWAY_PROVIDER_PACKAGE";
    public static final String GATEWAY_ORIGINAL_ADDRESS = "android.telecom.extra.GATEWAY_ORIGINAL_ADDRESS";
    public static final String EXTRA_CALL_BACK_NUMBER = "android.telecom.extra.CALL_BACK_NUMBER";
    public static final String EXTRA_NEW_OUTGOING_CALL_CANCEL_TIMEOUT = "android.telecom.extra.NEW_OUTGOING_CALL_CANCEL_TIMEOUT";
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=119305590L)
    public static final String EXTRA_IS_HANDOVER = "android.telecom.extra.IS_HANDOVER";
    public static final String EXTRA_IS_HANDOVER_CONNECTION = "android.telecom.extra.IS_HANDOVER_CONNECTION";
    public static final String EXTRA_HANDOVER_FROM_PHONE_ACCOUNT = "android.telecom.extra.HANDOVER_FROM_PHONE_ACCOUNT";
    public static final String EXTRA_CALL_AUDIO_STATE = "android.telecom.extra.CALL_AUDIO_STATE";
    public static final String EXTRA_START_CALL_WITH_RTT = "android.telecom.extra.START_CALL_WITH_RTT";
    public static final String ACTION_POST_CALL = "android.telecom.action.POST_CALL";
    public static final String EXTRA_HANDLE = "android.telecom.extra.HANDLE";
    public static final String EXTRA_DISCONNECT_CAUSE = "android.telecom.extra.DISCONNECT_CAUSE";
    public static final String EXTRA_CALL_DURATION = "android.telecom.extra.CALL_DURATION";
    public static final int DURATION_VERY_SHORT = 0;
    public static final int DURATION_SHORT = 1;
    public static final int DURATION_MEDIUM = 2;
    public static final int DURATION_LONG = 3;
    public static final long VERY_SHORT_CALL_TIME_MS = 3000L;
    public static final long SHORT_CALL_TIME_MS = 60000L;
    public static final long MEDIUM_CALL_TIME_MS = 120000L;
    public static final String METADATA_IN_CALL_SERVICE_UI = "android.telecom.IN_CALL_SERVICE_UI";
    public static final String METADATA_IN_CALL_SERVICE_CAR_MODE_UI = "android.telecom.IN_CALL_SERVICE_CAR_MODE_UI";
    public static final String METADATA_IN_CALL_SERVICE_RINGING = "android.telecom.IN_CALL_SERVICE_RINGING";
    public static final String METADATA_INCLUDE_EXTERNAL_CALLS = "android.telecom.INCLUDE_EXTERNAL_CALLS";
    public static final String METADATA_INCLUDE_SELF_MANAGED_CALLS = "android.telecom.INCLUDE_SELF_MANAGED_CALLS";
    public static final char DTMF_CHARACTER_PAUSE = ',';
    public static final char DTMF_CHARACTER_WAIT = ';';
    @SystemApi
    public static final int TTY_MODE_OFF = 0;
    @SystemApi
    public static final int TTY_MODE_FULL = 1;
    @SystemApi
    public static final int TTY_MODE_HCO = 2;
    @SystemApi
    public static final int TTY_MODE_VCO = 3;
    @SystemApi
    public static final String ACTION_CURRENT_TTY_MODE_CHANGED = "android.telecom.action.CURRENT_TTY_MODE_CHANGED";
    @SystemApi
    public static final String EXTRA_CURRENT_TTY_MODE = "android.telecom.extra.CURRENT_TTY_MODE";
    @SystemApi
    public static final String ACTION_TTY_PREFERRED_MODE_CHANGED = "android.telecom.action.TTY_PREFERRED_MODE_CHANGED";
    @SystemApi
    public static final String EXTRA_TTY_PREFERRED_MODE = "android.telecom.extra.TTY_PREFERRED_MODE";
    public static final String ACTION_SHOW_MISSED_CALLS_NOTIFICATION = "android.telecom.action.SHOW_MISSED_CALLS_NOTIFICATION";
    public static final String EXTRA_NOTIFICATION_COUNT = "android.telecom.extra.NOTIFICATION_COUNT";
    public static final String EXTRA_NOTIFICATION_PHONE_NUMBER = "android.telecom.extra.NOTIFICATION_PHONE_NUMBER";
    @Deprecated
    @SystemApi
    public static final String EXTRA_CLEAR_MISSED_CALLS_INTENT = "android.telecom.extra.CLEAR_MISSED_CALLS_INTENT";
    @SystemApi
    public static final String EXTRA_CALL_BACK_INTENT = "android.telecom.extra.CALL_BACK_INTENT";
    public static final ComponentName EMERGENCY_DIALER_COMPONENT = ComponentName.createRelative("com.android.phone", ".EmergencyDialer");
    public static final String EXTRA_USE_ASSISTED_DIALING = "android.telecom.extra.USE_ASSISTED_DIALING";
    @SystemApi
    public static final String EXTRA_CALL_SOURCE = "android.telecom.extra.CALL_SOURCE";
    public static final String ACTION_SHOW_SWITCH_TO_WORK_PROFILE_FOR_CALL_DIALOG = "android.telecom.action.SHOW_SWITCH_TO_WORK_PROFILE_FOR_CALL_DIALOG";
    public static final String EXTRA_MANAGED_PROFILE_USER_ID = "android.telecom.extra.MANAGED_PROFILE_USER_ID";
    @SystemApi
    public static final int CALL_SOURCE_EMERGENCY_SHORTCUT = 2;
    @SystemApi
    public static final int CALL_SOURCE_EMERGENCY_DIALPAD = 1;
    @SystemApi
    public static final int CALL_SOURCE_UNSPECIFIED = 0;
    public static final int PRESENTATION_ALLOWED = 1;
    public static final int PRESENTATION_RESTRICTED = 2;
    public static final int PRESENTATION_UNKNOWN = 3;
    public static final int PRESENTATION_PAYPHONE = 4;
    public static final int PRESENTATION_UNAVAILABLE = 5;
    public static final String PROPERTY_VIDEOCALL_AUDIO_OUTPUT = "persist.radio.call.audio.output";
    public static final int AUDIO_OUTPUT_ENABLE_SPEAKER = 0;
    public static final int AUDIO_OUTPUT_DISABLE_SPEAKER = 1;
    public static final int AUDIO_OUTPUT_DEFAULT = 0;
    public static final long ENABLE_GET_CALL_STATE_PERMISSION_PROTECTION = 157233955L;
    public static final long ENABLE_GET_PHONE_ACCOUNT_PERMISSION_PROTECTION = 183407956L;
    private static final String TAG = "TelecomManager";
    private static final Object CACHE_LOCK = new Object();
    @GuardedBy(value={"CACHE_LOCK"})
    private static ITelecomService sTelecomService;
    @GuardedBy(value={"CACHE_LOCK"})
    private static final DeathRecipient SERVICE_DEATH;
    private final Context mContext;
    private final ITelecomService mTelecomServiceOverride;
    private final ClientTransactionalServiceRepository mTransactionalServiceRepository = new ClientTransactionalServiceRepository();
    public static final int TELECOM_TRANSACTION_SUCCESS = 0;
    public static final String TRANSACTION_CALL_ID_KEY = "TelecomCallId";

    @UnsupportedAppUsage(maxTargetSdk=28)
    public static TelecomManager from(Context context) {
        return (TelecomManager)context.getSystemService("telecom");
    }

    public TelecomManager(Context context) {
        this(context, null);
    }

    public TelecomManager(Context context, ITelecomService telecomServiceImpl) {
        Context appContext = context.getApplicationContext();
        this.mContext = appContext != null && Objects.equals(context.getAttributionTag(), appContext.getAttributionTag()) ? appContext : context;
        this.mTelecomServiceOverride = telecomServiceImpl;
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public PhoneAccountHandle getDefaultOutgoingPhoneAccount(String uriScheme) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.getDefaultOutgoingPhoneAccount(uriScheme, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#getDefaultOutgoingPhoneAccount", e);
            }
        }
        return null;
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    @Nullable
    public PhoneAccountHandle getUserSelectedOutgoingPhoneAccount() {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.getUserSelectedOutgoingPhoneAccount(this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#getUserSelectedOutgoingPhoneAccount", e);
            }
        }
        return null;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void setUserSelectedOutgoingPhoneAccount(@Nullable PhoneAccountHandle accountHandle) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                service.setUserSelectedOutgoingPhoneAccount(accountHandle);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#setUserSelectedOutgoingPhoneAccount");
            }
        }
    }

    public PhoneAccountHandle getSimCallManager() {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.getSimCallManager(SubscriptionManager.getDefaultSubscriptionId(), this.mContext.getPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#getSimCallManager");
            }
        }
        return null;
    }

    @Nullable
    public PhoneAccountHandle getSimCallManagerForSubscription(int subscriptionId) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.getSimCallManager(subscriptionId, this.mContext.getPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#getSimCallManager");
            }
        }
        return null;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=119305590L)
    public PhoneAccountHandle getSimCallManager(int userId) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.getSimCallManagerForUser(userId, this.mContext.getPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#getSimCallManagerForUser");
            }
        }
        return null;
    }

    @SystemApi
    public PhoneAccountHandle getConnectionManager() {
        return this.getSimCallManager();
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.READ_PHONE_STATE"})
    public List<PhoneAccountHandle> getPhoneAccountsSupportingScheme(String uriScheme) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.getPhoneAccountsSupportingScheme(uriScheme, this.mContext.getOpPackageName()).getList();
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#getPhoneAccountsSupportingScheme", e);
            }
        }
        return new ArrayList<PhoneAccountHandle>();
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public List<PhoneAccountHandle> getCallCapablePhoneAccounts() {
        return this.getCallCapablePhoneAccounts(false);
    }

    @FlaggedApi(value="com.android.internal.telephony.flags.work_profile_api_split")
    @RequiresPermission(allOf={"android.permission.READ_PHONE_STATE", "android.permission.INTERACT_ACROSS_PROFILES"})
    @NonNull
    public List<PhoneAccountHandle> getCallCapablePhoneAccountsAcrossProfiles() {
        return this.getCallCapablePhoneAccountsAcrossProfiles(false);
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    @NonNull
    public List<PhoneAccountHandle> getSelfManagedPhoneAccounts() {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.getSelfManagedPhoneAccounts(this.mContext.getOpPackageName(), this.mContext.getAttributionTag()).getList();
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#getSelfManagedPhoneAccounts()", e);
            }
        }
        return new ArrayList<PhoneAccountHandle>();
    }

    @RequiresPermission(value="android.permission.MANAGE_OWN_CALLS")
    @NonNull
    public List<PhoneAccountHandle> getOwnSelfManagedPhoneAccounts() {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.getOwnSelfManagedPhoneAccounts(this.mContext.getOpPackageName(), this.mContext.getAttributionTag()).getList();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        throw new IllegalStateException("Telecom is not available");
    }

    @SuppressLint(value={"RequiresPermission"})
    @FlaggedApi(value="com.android.server.telecom.flags.get_registered_phone_accounts")
    @NonNull
    public List<PhoneAccount> getRegisteredPhoneAccounts() {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.getRegisteredPhoneAccounts(this.mContext.getOpPackageName(), this.mContext.getAttributionTag()).getList();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        throw new IllegalStateException("Telecom is not available");
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    @NonNull
    public List<PhoneAccountHandle> getCallCapablePhoneAccounts(boolean includeDisabledAccounts) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.getCallCapablePhoneAccounts(includeDisabledAccounts, this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), false).getList();
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#getCallCapablePhoneAccounts(" + includeDisabledAccounts + ")", e);
            }
        }
        return new ArrayList<PhoneAccountHandle>();
    }

    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.work_profile_api_split")
    @RequiresPermission(allOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.INTERACT_ACROSS_PROFILES"})
    @NonNull
    public List<PhoneAccountHandle> getCallCapablePhoneAccountsAcrossProfiles(boolean includeDisabledAccounts) {
        ITelecomService service = this.getTelecomService();
        if (service == null) {
            throw new IllegalStateException("telecom service is null.");
        }
        try {
            return service.getCallCapablePhoneAccounts(includeDisabledAccounts, this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), true).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @Deprecated
    @SuppressLint(value={"RequiresPermission"})
    public List<PhoneAccountHandle> getPhoneAccountsForPackage() {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.getPhoneAccountsForPackage(this.mContext.getPackageName()).getList();
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#getPhoneAccountsForPackage", e);
            }
        }
        return null;
    }

    public PhoneAccount getPhoneAccount(PhoneAccountHandle account) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.getPhoneAccount(account, this.mContext.getPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#getPhoneAccount", e);
            }
        }
        return null;
    }

    @SystemApi
    public int getAllPhoneAccountsCount() {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.getAllPhoneAccountsCount();
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#getAllPhoneAccountsCount", e);
            }
        }
        return 0;
    }

    @SystemApi
    public List<PhoneAccount> getAllPhoneAccounts() {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.getAllPhoneAccounts().getList();
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#getAllPhoneAccounts", e);
            }
        }
        return Collections.EMPTY_LIST;
    }

    @SystemApi
    public List<PhoneAccountHandle> getAllPhoneAccountHandles() {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.getAllPhoneAccountHandles().getList();
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#getAllPhoneAccountHandles", e);
            }
        }
        return Collections.EMPTY_LIST;
    }

    public void registerPhoneAccount(PhoneAccount account) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                service.registerPhoneAccount(account, this.mContext.getPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#registerPhoneAccount", e);
            }
        }
    }

    public void unregisterPhoneAccount(PhoneAccountHandle accountHandle) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                service.unregisterPhoneAccount(accountHandle, this.mContext.getPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#unregisterPhoneAccount", e);
            }
        }
    }

    @SystemApi
    @SuppressLint(value={"RequiresPermission"})
    public void clearPhoneAccounts() {
        this.clearAccounts();
    }

    @SystemApi
    @SuppressLint(value={"RequiresPermission"})
    public void clearAccounts() {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                service.clearAccounts(this.mContext.getPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#clearAccounts", e);
            }
        }
    }

    public void clearAccountsForPackage(String packageName) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                if (!TextUtils.isEmpty(packageName)) {
                    service.clearAccounts(packageName);
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#clearAccountsForPackage", e);
            }
        }
    }

    @SystemApi
    @SuppressLint(value={"RequiresPermission"})
    public ComponentName getDefaultPhoneApp() {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.getDefaultPhoneApp();
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException attempting to get the default phone app.", e);
            }
        }
        return null;
    }

    public String getDefaultDialerPackage() {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.getDefaultDialerPackage(this.mContext.getPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException attempting to get the default dialer package name.", e);
            }
        }
        return null;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    @Nullable
    public String getDefaultDialerPackage(@NonNull UserHandle userHandle) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.getDefaultDialerPackageForUser(userHandle.getIdentifier());
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException attempting to get the default dialer package name.", e);
            }
        }
        return null;
    }

    @SystemApi
    @Deprecated
    @RequiresPermission(allOf={"android.permission.MODIFY_PHONE_STATE", "android.permission.WRITE_SECURE_SETTINGS"})
    public boolean setDefaultDialer(@Nullable String packageName) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.setDefaultDialer(packageName);
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException attempting to set the default dialer.", e);
            }
        }
        return false;
    }

    @Nullable
    public String getSystemDialerPackage() {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.getSystemDialerPackage(this.mContext.getPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException attempting to get the system dialer package name.", e);
            }
        }
        return null;
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public boolean isVoiceMailNumber(PhoneAccountHandle accountHandle, String number) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.isVoiceMailNumber(accountHandle, number, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException calling ITelecomService#isVoiceMailNumber.", e);
            }
        }
        return false;
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public String getVoiceMailNumber(PhoneAccountHandle accountHandle) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.getVoiceMailNumber(accountHandle, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException calling ITelecomService#hasVoiceMailNumber.", e);
            }
        }
        return null;
    }

    @FlaggedApi(value="com.android.server.telecom.flags.voip_call_monitor_refactor")
    public boolean hasForegroundServiceDelegation(@Nullable PhoneAccountHandle handle) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.hasForegroundServiceDelegation(handle, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException calling ITelecomService#hasForegroundServiceDelegation.", e);
            }
        }
        return false;
    }

    @Deprecated
    @RequiresPermission(anyOf={"android.permission.READ_PHONE_STATE", "android.permission.READ_SMS", "android.permission.READ_PHONE_NUMBERS"}, conditional=true)
    public String getLine1Number(PhoneAccountHandle accountHandle) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.getLine1Number(accountHandle, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException calling ITelecomService#getLine1Number.", e);
            }
        }
        return null;
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public boolean isInCall() {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.isInCall(this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException calling isInCall().", e);
            }
        }
        return false;
    }

    public boolean hasManageOngoingCallsPermission() {
        block3: {
            ITelecomService service = this.getTelecomService();
            if (service != null) {
                try {
                    return service.hasManageOngoingCallsPermission(this.mContext.getOpPackageName());
                }
                catch (RemoteException e) {
                    Log.e(TAG, "RemoteException calling hasManageOngoingCallsPermission().", e);
                    if (this.isSystemProcess()) break block3;
                    e.rethrowAsRuntimeException();
                }
            }
        }
        return false;
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public boolean isInManagedCall() {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.isInManagedCall(this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException calling isInManagedCall().", e);
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.READ_PHONE_STATE"}, conditional=true)
    public int getCallState() {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.getCallStateUsingPackage(this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
            catch (RemoteException e) {
                Log.d(TAG, "RemoteException calling getCallState().", e);
            }
        }
        return 0;
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.READ_PHONE_STATE"})
    public boolean isRinging() {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.isRinging(this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException attempting to get ringing state of phone app.", e);
            }
        }
        return false;
    }

    @Deprecated
    @RequiresPermission(value="android.permission.ANSWER_PHONE_CALLS")
    public boolean endCall() {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.endCall(this.mContext.getPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#endCall", e);
            }
        }
        return false;
    }

    @Deprecated
    @RequiresPermission(anyOf={"android.permission.ANSWER_PHONE_CALLS", "android.permission.MODIFY_PHONE_STATE"})
    public void acceptRingingCall() {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                service.acceptRingingCall(this.mContext.getPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#acceptRingingCall", e);
            }
        }
    }

    @Deprecated
    @RequiresPermission(anyOf={"android.permission.ANSWER_PHONE_CALLS", "android.permission.MODIFY_PHONE_STATE"})
    public void acceptRingingCall(int videoState) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                service.acceptRingingCallWithVideoState(this.mContext.getPackageName(), videoState);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#acceptRingingCallWithVideoState", e);
            }
        }
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void silenceRinger() {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                service.silenceRinger(this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#silenceRinger", e);
            }
        }
    }

    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.READ_PHONE_STATE"})
    public boolean isTtySupported() {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.isTtySupported(this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException attempting to get TTY supported state.", e);
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public int getCurrentTtyMode() {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.getCurrentTtyMode(this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException attempting to get the current TTY mode.", e);
            }
        }
        return 0;
    }

    public void addNewIncomingCall(PhoneAccountHandle phoneAccount, Bundle extras) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                if (extras != null && extras.getBoolean(EXTRA_IS_HANDOVER) && this.mContext.getApplicationContext().getApplicationInfo().targetSdkVersion > 27) {
                    Log.e("TAG", "addNewIncomingCall failed. Use public api acceptHandover for API > O-MR1");
                    return;
                }
                service.addNewIncomingCall(phoneAccount, extras == null ? new Bundle() : extras, this.mContext.getPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException adding a new incoming call: " + phoneAccount, e);
            }
        }
    }

    public void addNewIncomingConference(@NonNull PhoneAccountHandle phoneAccount, @NonNull Bundle extras) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                service.addNewIncomingConference(phoneAccount, extras == null ? new Bundle() : extras, this.mContext.getPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException adding a new incoming conference: " + phoneAccount, e);
            }
        }
    }

    @SystemApi
    public void addNewUnknownCall(PhoneAccountHandle phoneAccount, Bundle extras) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                service.addNewUnknownCall(phoneAccount, extras == null ? new Bundle() : extras);
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException adding a new unknown call: " + phoneAccount, e);
            }
        }
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public boolean handleMmi(String dialString) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.handlePinMmi(dialString, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#handlePinMmi", e);
            }
        }
        return false;
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public boolean handleMmi(String dialString, PhoneAccountHandle accountHandle) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.handlePinMmiForPhoneAccount(accountHandle, dialString, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#handlePinMmi", e);
            }
        }
        return false;
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public Uri getAdnUriForPhoneAccount(PhoneAccountHandle accountHandle) {
        ITelecomService service = this.getTelecomService();
        if (service != null && accountHandle != null) {
            try {
                return service.getAdnUriForPhoneAccount(accountHandle, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#getAdnUriForPhoneAccount", e);
            }
        }
        return Uri.parse("content://icc/adn");
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void cancelMissedCallsNotification() {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                service.cancelMissedCallsNotification(this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#cancelMissedCallsNotification", e);
            }
        }
    }

    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public void showInCallScreen(boolean showDialpad) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                service.showInCallScreen(showDialpad, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#showCallScreen", e);
            }
        }
    }

    @RequiresPermission(anyOf={"android.permission.CALL_PHONE", "android.permission.MANAGE_OWN_CALLS"})
    public void placeCall(Uri address, Bundle extras) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            if (address == null) {
                Log.w(TAG, "Cannot place call to empty address.");
            }
            try {
                service.placeCall(address, extras == null ? new Bundle() : extras, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#placeCall", e);
            }
        }
    }

    @RequiresPermission(value="android.permission.CALL_PHONE")
    public void startConference(@NonNull List<Uri> participants, @NonNull Bundle extras) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                service.startConference(participants, extras, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#placeCall", e);
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void enablePhoneAccount(PhoneAccountHandle handle, boolean isEnabled) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                service.enablePhoneAccount(handle, isEnabled);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error enablePhoneAbbount", e);
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.DUMP")
    public TelecomAnalytics dumpAnalytics() {
        ITelecomService service = this.getTelecomService();
        TelecomAnalytics result = null;
        if (service != null) {
            try {
                result = service.dumpCallAnalytics();
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error dumping call analytics", e);
            }
        }
        return result;
    }

    public Intent createManageBlockedNumbersIntent() {
        ITelecomService service = this.getTelecomService();
        Intent result = null;
        if (service != null) {
            try {
                result = service.createManageBlockedNumbersIntent(this.mContext.getPackageName());
                if (result != null) {
                    result.prepareToEnterProcess(32, this.mContext.getAttributionSource());
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error calling ITelecomService#createManageBlockedNumbersIntent", e);
            }
        }
        return result;
    }

    @SystemApi
    @NonNull
    public Intent createLaunchEmergencyDialerIntent(@Nullable String number) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                Intent result = service.createLaunchEmergencyDialerIntent(number);
                if (result != null) {
                    result.prepareToEnterProcess(32, this.mContext.getAttributionSource());
                }
                return result;
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error createLaunchEmergencyDialerIntent", e);
            }
        } else {
            Log.w(TAG, "createLaunchEmergencyDialerIntent - Telecom service not available.");
        }
        Intent intent = new Intent("android.intent.action.DIAL_EMERGENCY");
        if (!TextUtils.isEmpty(number) && TextUtils.isDigitsOnly(number)) {
            intent.setData(Uri.fromParts("tel", number, null));
        }
        return intent;
    }

    public boolean isIncomingCallPermitted(PhoneAccountHandle phoneAccountHandle) {
        if (phoneAccountHandle == null) {
            return false;
        }
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.isIncomingCallPermitted(phoneAccountHandle, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error isIncomingCallPermitted", e);
            }
        }
        return false;
    }

    public boolean isOutgoingCallPermitted(PhoneAccountHandle phoneAccountHandle) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.isOutgoingCallPermitted(phoneAccountHandle, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error isOutgoingCallPermitted", e);
            }
        }
        return false;
    }

    public void acceptHandover(Uri srcAddr, int videoState, PhoneAccountHandle destAcct) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                service.acceptHandover(srcAddr, videoState, destAcct, this.mContext.getPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException acceptHandover: " + e);
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public boolean isInEmergencyCall() {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.isInEmergencyCall();
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException isInEmergencyCall: " + e);
                return false;
            }
        }
        return false;
    }

    @SystemApi
    @FlaggedApi(value="com.android.server.telecom.flags.telecom_resolve_hidden_dependencies")
    @RequiresPermission(allOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.INTERACT_ACROSS_USERS"}, conditional=true)
    public boolean isInSelfManagedCall(@NonNull String packageName, @NonNull UserHandle userHandle) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                return service.isInSelfManagedCall(packageName, userHandle, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException isInSelfManagedCall: " + e);
                e.rethrowFromSystemServer();
                return false;
            }
        }
        throw new IllegalStateException("Telecom service is not present");
    }

    @RequiresPermission(value="android.permission.MANAGE_OWN_CALLS")
    @SuppressLint(value={"SamShouldBeLast"})
    public void addCall(@NonNull CallAttributes callAttributes, @NonNull Executor executor, @NonNull OutcomeReceiver<CallControl, CallException> pendingControl, @NonNull CallControlCallback handshakes, @NonNull CallEventCallback events) {
        Objects.requireNonNull(callAttributes);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(pendingControl);
        Objects.requireNonNull(handshakes);
        Objects.requireNonNull(events);
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                ClientTransactionalServiceWrapper transactionalServiceWrapper = this.mTransactionalServiceRepository.addNewCallForTransactionalServiceWrapper(callAttributes.getPhoneAccountHandle());
                String newCallId = transactionalServiceWrapper.trackCall(callAttributes, executor, pendingControl, handshakes, events);
                service.addCall(callAttributes, transactionalServiceWrapper.getCallEventCallback(), newCallId, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException addCall: " + e);
                e.rethrowFromSystemServer();
            }
        } else {
            throw new IllegalStateException("Telecom service is not present");
        }
    }

    public void handleCallIntent(Intent intent, String callingPackageProxy) {
        ITelecomService service = this.getTelecomService();
        if (service != null) {
            try {
                service.handleCallIntent(intent, callingPackageProxy);
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException handleCallIntent: " + e);
            }
        }
    }

    private boolean isSystemProcess() {
        return Process.myUid() == 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITelecomService getTelecomService() {
        if (this.mTelecomServiceOverride != null) {
            return this.mTelecomServiceOverride;
        }
        if (sTelecomService == null) {
            ITelecomService temp = ITelecomService.Stub.asInterface(ServiceManager.getService("telecom"));
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (sTelecomService == null && temp != null) {
                    try {
                        sTelecomService = temp;
                        sTelecomService.asBinder().linkToDeath(SERVICE_DEATH, 0);
                    }
                    catch (Exception e) {
                        sTelecomService = null;
                    }
                }
            }
        }
        return sTelecomService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resetServiceCache() {
        Object object = CACHE_LOCK;
        synchronized (object) {
            if (sTelecomService != null) {
                sTelecomService.asBinder().unlinkToDeath(SERVICE_DEATH, 0);
                sTelecomService = null;
            }
        }
    }

    static {
        SERVICE_DEATH = new DeathRecipient();
    }

    private static class DeathRecipient
    implements IBinder.DeathRecipient {
        private DeathRecipient() {
        }

        @Override
        public void binderDied() {
            TelecomManager.resetServiceCache();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Presentation {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TtyMode {
    }
}

