/*
 * Decompiled with CFR 0.152.
 */
package android.service.timezone;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@SystemApi
public class TimeZoneProviderStatus
implements Parcelable {
    public static final int DEPENDENCY_STATUS_UNKNOWN = 0;
    public static final int DEPENDENCY_STATUS_NOT_APPLICABLE = 1;
    public static final int DEPENDENCY_STATUS_OK = 2;
    public static final int DEPENDENCY_STATUS_TEMPORARILY_UNAVAILABLE = 3;
    public static final int DEPENDENCY_STATUS_BLOCKED_BY_ENVIRONMENT = 4;
    public static final int DEPENDENCY_STATUS_DEGRADED_BY_SETTINGS = 5;
    public static final int DEPENDENCY_STATUS_BLOCKED_BY_SETTINGS = 6;
    public static final int OPERATION_STATUS_UNKNOWN = 0;
    public static final int OPERATION_STATUS_NOT_APPLICABLE = 1;
    public static final int OPERATION_STATUS_OK = 2;
    public static final int OPERATION_STATUS_FAILED = 3;
    private final int mLocationDetectionDependencyStatus;
    private final int mConnectivityDependencyStatus;
    private final int mTimeZoneResolutionOperationStatus;
    @NonNull
    public static final Parcelable.Creator<TimeZoneProviderStatus> CREATOR = new Parcelable.Creator<TimeZoneProviderStatus>(){

        @Override
        public TimeZoneProviderStatus createFromParcel(Parcel in) {
            int locationDetectionStatus = in.readInt();
            int connectivityStatus = in.readInt();
            int timeZoneResolutionStatus = in.readInt();
            return new TimeZoneProviderStatus(locationDetectionStatus, connectivityStatus, timeZoneResolutionStatus);
        }

        public TimeZoneProviderStatus[] newArray(int size) {
            return new TimeZoneProviderStatus[size];
        }
    };

    private TimeZoneProviderStatus(int locationDetectionStatus, int connectivityStatus, int timeZoneResolutionStatus) {
        this.mLocationDetectionDependencyStatus = locationDetectionStatus;
        this.mConnectivityDependencyStatus = connectivityStatus;
        this.mTimeZoneResolutionOperationStatus = timeZoneResolutionStatus;
    }

    public int getLocationDetectionDependencyStatus() {
        return this.mLocationDetectionDependencyStatus;
    }

    public int getConnectivityDependencyStatus() {
        return this.mConnectivityDependencyStatus;
    }

    public int getTimeZoneResolutionOperationStatus() {
        return this.mTimeZoneResolutionOperationStatus;
    }

    public String toString() {
        return "TimeZoneProviderStatus{mLocationDetectionDependencyStatus=" + TimeZoneProviderStatus.dependencyStatusToString(this.mLocationDetectionDependencyStatus) + ", mConnectivityDependencyStatus=" + TimeZoneProviderStatus.dependencyStatusToString(this.mConnectivityDependencyStatus) + ", mTimeZoneResolutionOperationStatus=" + TimeZoneProviderStatus.operationStatusToString(this.mTimeZoneResolutionOperationStatus) + '}';
    }

    @NonNull
    public static TimeZoneProviderStatus parseProviderStatus(@NonNull String arg) {
        Pattern pattern = Pattern.compile("TimeZoneProviderStatus\\{mLocationDetectionDependencyStatus=([^,]+), mConnectivityDependencyStatus=([^,]+), mTimeZoneResolutionOperationStatus=([^\\}]+)\\}");
        Matcher matcher = pattern.matcher(arg);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Unable to parse provider status: " + arg);
        }
        int locationDependencyStatus = TimeZoneProviderStatus.dependencyStatusFromString(matcher.group(1));
        int connectivityDependencyStatus = TimeZoneProviderStatus.dependencyStatusFromString(matcher.group(2));
        int timeZoneResolutionOperationStatus = TimeZoneProviderStatus.operationStatusFromString(matcher.group(3));
        return new TimeZoneProviderStatus(locationDependencyStatus, connectivityDependencyStatus, timeZoneResolutionOperationStatus);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        parcel.writeInt(this.mLocationDetectionDependencyStatus);
        parcel.writeInt(this.mConnectivityDependencyStatus);
        parcel.writeInt(this.mTimeZoneResolutionOperationStatus);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeZoneProviderStatus that = (TimeZoneProviderStatus)o;
        return this.mLocationDetectionDependencyStatus == that.mLocationDetectionDependencyStatus && this.mConnectivityDependencyStatus == that.mConnectivityDependencyStatus && this.mTimeZoneResolutionOperationStatus == that.mTimeZoneResolutionOperationStatus;
    }

    public int hashCode() {
        return Objects.hash(this.mLocationDetectionDependencyStatus, this.mConnectivityDependencyStatus, this.mTimeZoneResolutionOperationStatus);
    }

    public boolean couldEnableTelephonyFallback() {
        return this.mLocationDetectionDependencyStatus == 4 || this.mLocationDetectionDependencyStatus == 6 || this.mConnectivityDependencyStatus == 4 || this.mConnectivityDependencyStatus == 6;
    }

    private static int requireValidOperationStatus(int operationStatus) {
        if (operationStatus < 0 || operationStatus > 3) {
            throw new IllegalArgumentException(Integer.toString(operationStatus));
        }
        return operationStatus;
    }

    @NonNull
    public static String operationStatusToString(int operationStatus) {
        switch (operationStatus) {
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "NOT_APPLICABLE";
            }
            case 2: {
                return "OK";
            }
            case 3: {
                return "FAILED";
            }
        }
        throw new IllegalArgumentException("Unknown status: " + operationStatus);
    }

    public static int operationStatusFromString(@Nullable String operationStatusString) {
        if (TextUtils.isEmpty(operationStatusString)) {
            throw new IllegalArgumentException("Empty status: " + operationStatusString);
        }
        switch (operationStatusString) {
            case "UNKNOWN": {
                return 0;
            }
            case "NOT_APPLICABLE": {
                return 1;
            }
            case "OK": {
                return 2;
            }
            case "FAILED": {
                return 3;
            }
        }
        throw new IllegalArgumentException("Unknown status: " + operationStatusString);
    }

    private static int requireValidDependencyStatus(int dependencyStatus) {
        if (dependencyStatus < 0 || dependencyStatus > 6) {
            throw new IllegalArgumentException(Integer.toString(dependencyStatus));
        }
        return dependencyStatus;
    }

    @NonNull
    public static String dependencyStatusToString(int dependencyStatus) {
        switch (dependencyStatus) {
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "NOT_APPLICABLE";
            }
            case 2: {
                return "OK";
            }
            case 3: {
                return "TEMPORARILY_UNAVAILABLE";
            }
            case 4: {
                return "BLOCKED_BY_ENVIRONMENT";
            }
            case 5: {
                return "DEGRADED_BY_SETTINGS";
            }
            case 6: {
                return "BLOCKED_BY_SETTINGS";
            }
        }
        throw new IllegalArgumentException("Unknown status: " + dependencyStatus);
    }

    public static int dependencyStatusFromString(@Nullable String dependencyStatusString) {
        if (TextUtils.isEmpty(dependencyStatusString)) {
            throw new IllegalArgumentException("Empty status: " + dependencyStatusString);
        }
        switch (dependencyStatusString) {
            case "UNKNOWN": {
                return 0;
            }
            case "NOT_APPLICABLE": {
                return 1;
            }
            case "OK": {
                return 2;
            }
            case "TEMPORARILY_UNAVAILABLE": {
                return 3;
            }
            case "BLOCKED_BY_ENVIRONMENT": {
                return 4;
            }
            case "DEGRADED_BY_SETTINGS": {
                return 5;
            }
            case "BLOCKED_BY_SETTINGS": {
                return 6;
            }
        }
        throw new IllegalArgumentException("Unknown status: " + dependencyStatusString);
    }

    public static class Builder {
        private int mLocationDetectionDependencyStatus = 0;
        private int mConnectivityDependencyStatus = 0;
        private int mTimeZoneResolutionOperationStatus = 0;

        public Builder() {
        }

        public Builder(TimeZoneProviderStatus toCopy) {
            this.mLocationDetectionDependencyStatus = toCopy.mLocationDetectionDependencyStatus;
            this.mConnectivityDependencyStatus = toCopy.mConnectivityDependencyStatus;
            this.mTimeZoneResolutionOperationStatus = toCopy.mTimeZoneResolutionOperationStatus;
        }

        @NonNull
        public Builder setLocationDetectionDependencyStatus(int locationDetectionStatus) {
            this.mLocationDetectionDependencyStatus = locationDetectionStatus;
            return this;
        }

        @NonNull
        public Builder setConnectivityDependencyStatus(int connectivityStatus) {
            this.mConnectivityDependencyStatus = connectivityStatus;
            return this;
        }

        @NonNull
        public Builder setTimeZoneResolutionOperationStatus(int timeZoneResolutionStatus) {
            this.mTimeZoneResolutionOperationStatus = timeZoneResolutionStatus;
            return this;
        }

        @NonNull
        public TimeZoneProviderStatus build() {
            return new TimeZoneProviderStatus(TimeZoneProviderStatus.requireValidDependencyStatus(this.mLocationDetectionDependencyStatus), TimeZoneProviderStatus.requireValidDependencyStatus(this.mConnectivityDependencyStatus), TimeZoneProviderStatus.requireValidOperationStatus(this.mTimeZoneResolutionOperationStatus));
        }
    }

    @Target(value={ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OperationStatus {
    }

    @Target(value={ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DependencyStatus {
    }
}

