/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SharedMemory;
import android.service.notification.NotificationListenerService;
import android.system.ErrnoException;
import android.system.OsConstants;
import com.android.internal.hidden_from_bootclasspath.android.service.notification.Flags;
import com.android.layoutlib.androidx.annotation.NonNull;
import com.android.layoutlib.androidx.annotation.Nullable;
import com.android.layoutlib.androidx.annotation.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

@SuppressLint(value={"ParcelNotFinal", "ParcelCreator"})
public class NotificationRankingUpdate
implements Parcelable {
    private final NotificationListenerService.RankingMap mRankingMap;
    private SharedMemory mRankingMapFd = null;
    private final String mSharedMemoryName = "NotificationRankingUpdatedSharedMemory";
    @NonNull
    public static final Parcelable.Creator<NotificationRankingUpdate> CREATOR = new Parcelable.Creator<NotificationRankingUpdate>(){

        @Override
        public NotificationRankingUpdate createFromParcel(Parcel parcel) {
            return new NotificationRankingUpdate(parcel);
        }

        public NotificationRankingUpdate[] newArray(int size) {
            return new NotificationRankingUpdate[size];
        }
    };

    public NotificationRankingUpdate(NotificationListenerService.Ranking[] rankings) {
        this.mRankingMap = new NotificationListenerService.RankingMap(rankings);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NotificationRankingUpdate(Parcel in) {
        if (Flags.rankingUpdateAshmem()) {
            Bundle smartActionsBundle;
            ByteBuffer buffer;
            Parcel mapParcel;
            block6: {
                mapParcel = Parcel.obtain();
                buffer = null;
                this.mRankingMapFd = in.readParcelable(this.getClass().getClassLoader(), SharedMemory.class);
                smartActionsBundle = in.readBundle(this.getClass().getClassLoader());
                if (this.mRankingMapFd != null) break block6;
                this.mRankingMap = null;
                mapParcel.recycle();
                if (buffer == null || this.mRankingMapFd == null) return;
                SharedMemory.unmap(buffer);
                this.mRankingMapFd.close();
                return;
            }
            try {
                buffer = this.mRankingMapFd.mapReadOnly();
                byte[] payload = new byte[buffer.remaining()];
                buffer.get(payload);
                mapParcel.unmarshall(payload, 0, payload.length);
                mapParcel.setDataPosition(0);
                this.mRankingMap = mapParcel.readParcelable(this.getClass().getClassLoader(), NotificationListenerService.RankingMap.class);
                this.addSmartActionsFromBundleToRankingMap(smartActionsBundle);
                mapParcel.recycle();
                if (buffer == null || this.mRankingMapFd == null) return;
            }
            catch (ErrnoException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    mapParcel.recycle();
                    if (buffer == null || this.mRankingMapFd == null) throw throwable;
                    SharedMemory.unmap(buffer);
                    this.mRankingMapFd.close();
                    throw throwable;
                }
            }
            SharedMemory.unmap(buffer);
            this.mRankingMapFd.close();
            return;
        }
        this.mRankingMap = in.readParcelable(this.getClass().getClassLoader(), NotificationListenerService.RankingMap.class);
    }

    private void addSmartActionsFromBundleToRankingMap(Bundle smartActionsBundle) {
        if (smartActionsBundle == null) {
            return;
        }
        String[] rankingMapKeys = this.mRankingMap.getOrderedKeys();
        for (int i = 0; i < rankingMapKeys.length; ++i) {
            String key = rankingMapKeys[i];
            ArrayList<Notification.Action> smartActions = smartActionsBundle.getParcelableArrayList(key, Notification.Action.class);
            NotificationListenerService.Ranking ranking = this.mRankingMap.getRawRankingObject(key);
            ranking.setSmartActions(smartActions);
        }
    }

    @VisibleForTesting(otherwise=5)
    public boolean isFdNotNullAndClosed() {
        return this.mRankingMapFd != null && this.mRankingMapFd.getFd() == -1;
    }

    public NotificationListenerService.RankingMap getRankingMap() {
        return this.mRankingMap;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationRankingUpdate other = (NotificationRankingUpdate)o;
        return this.mRankingMap.equals(other.mRankingMap);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        if (Flags.rankingUpdateAshmem()) {
            Parcel mapParcel = Parcel.obtain();
            ArrayList<NotificationListenerService.Ranking> marshalableRankings = new ArrayList<NotificationListenerService.Ranking>();
            Bundle smartActionsBundle = new Bundle();
            String[] rankingMapKeys = this.mRankingMap.getOrderedKeys();
            for (int i = 0; i < rankingMapKeys.length; ++i) {
                String key = rankingMapKeys[i];
                NotificationListenerService.Ranking ranking = this.mRankingMap.getRawRankingObject(key);
                List<Notification.Action> smartActions = ranking.getSmartActions();
                if (!smartActions.isEmpty()) {
                    smartActionsBundle.putParcelableList(key, smartActions);
                }
                NotificationListenerService.Ranking rankingCopy = new NotificationListenerService.Ranking();
                rankingCopy.populate(ranking);
                rankingCopy.setSmartActions(null);
                marshalableRankings.add(rankingCopy);
            }
            NotificationListenerService.RankingMap marshalableRankingMap = new NotificationListenerService.RankingMap(marshalableRankings.toArray(new NotificationListenerService.Ranking[0]));
            ByteBuffer buffer = null;
            try {
                mapParcel.writeParcelable(marshalableRankingMap, flags);
                int mapSize = mapParcel.dataSize();
                this.mRankingMapFd = SharedMemory.create("NotificationRankingUpdatedSharedMemory", mapSize);
                buffer = this.mRankingMapFd.mapReadWrite();
                mapParcel.marshall(buffer);
                this.mRankingMapFd.setProtect(OsConstants.PROT_READ);
                out.writeParcelable(this.mRankingMapFd, flags);
                out.writeBundle(smartActionsBundle);
                mapParcel.recycle();
                if (buffer == null || this.mRankingMapFd == null) return;
            }
            catch (ErrnoException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    mapParcel.recycle();
                    if (buffer == null || this.mRankingMapFd == null) throw throwable;
                    SharedMemory.unmap(buffer);
                    this.mRankingMapFd.close();
                    throw throwable;
                }
            }
            SharedMemory.unmap(buffer);
            this.mRankingMapFd.close();
            return;
        }
        out.writeParcelable(this.mRankingMap, flags);
    }
}

