/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.service.autofill.FieldClassification;
import android.service.autofill.Flags;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.view.autofill.AutofillId;
import android.view.autofill.Helper;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FillEventHistory
implements Parcelable {
    private static final String TAG = "FillEventHistory";
    private final int mSessionId;
    @Nullable
    private final Bundle mClientState;
    @Nullable
    List<Event> mEvents;
    @NonNull
    public static final Parcelable.Creator<FillEventHistory> CREATOR = new Parcelable.Creator<FillEventHistory>(){

        @Override
        public FillEventHistory createFromParcel(Parcel parcel) {
            FillEventHistory selection = new FillEventHistory(0, parcel.readBundle());
            int numEvents = parcel.readInt();
            for (int i = 0; i < numEvents; ++i) {
                AutofillId[] detectedFieldIds;
                ArrayList<ArrayList<String>> manuallyFilledDatasetIds;
                int eventType = parcel.readInt();
                String datasetId = parcel.readString();
                Bundle clientState = parcel.readBundle();
                ArrayList<String> selectedDatasetIds = parcel.createStringArrayList();
                ArraySet<? extends Object> ignoredDatasets = parcel.readArraySet(null);
                ArrayList<AutofillId> changedFieldIds = parcel.createTypedArrayList(AutofillId.CREATOR);
                ArrayList<String> changedDatasetIds = parcel.createStringArrayList();
                ArrayList<AutofillId> manuallyFilledFieldIds = parcel.createTypedArrayList(AutofillId.CREATOR);
                if (manuallyFilledFieldIds != null) {
                    int size = manuallyFilledFieldIds.size();
                    manuallyFilledDatasetIds = new ArrayList<ArrayList<String>>(size);
                    for (int j = 0; j < size; ++j) {
                        manuallyFilledDatasetIds.add(parcel.createStringArrayList());
                    }
                } else {
                    manuallyFilledDatasetIds = null;
                }
                FieldClassification[] detectedFieldClassifications = (detectedFieldIds = parcel.readParcelableArray(null, AutofillId.class)) != null ? FieldClassification.readArrayFromParcel(parcel) : null;
                int saveDialogNotShowReason = parcel.readInt();
                int uiType = parcel.readInt();
                AutofillId focusedId = null;
                if (Flags.addLastFocusedIdToFillEventHistory()) {
                    focusedId = parcel.readParcelable(null, AutofillId.class);
                }
                selection.addEvent(new Event(eventType, datasetId, clientState, selectedDatasetIds, ignoredDatasets, changedFieldIds, changedDatasetIds, manuallyFilledFieldIds, manuallyFilledDatasetIds, detectedFieldIds, detectedFieldClassifications, saveDialogNotShowReason, uiType, focusedId));
            }
            return selection;
        }

        public FillEventHistory[] newArray(int size) {
            return new FillEventHistory[size];
        }
    };

    @FlaggedApi(value="android.service.autofill.autofill_w_metrics")
    public int getSessionId() {
        return this.mSessionId;
    }

    @Deprecated
    @Nullable
    public Bundle getClientState() {
        return this.mClientState;
    }

    @Nullable
    public List<Event> getEvents() {
        return this.mEvents;
    }

    public void addEvent(Event event) {
        if (this.mEvents == null) {
            this.mEvents = new ArrayList<Event>(1);
        }
        this.mEvents.add(event);
    }

    public FillEventHistory(int sessionId, @Nullable Bundle clientState) {
        this.mClientState = clientState;
        this.mSessionId = sessionId;
    }

    public String toString() {
        return this.mEvents == null ? "no events" : this.mEvents.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeBundle(this.mClientState);
        if (this.mEvents == null) {
            parcel.writeInt(0);
        } else {
            parcel.writeInt(this.mEvents.size());
            int numEvents = this.mEvents.size();
            for (int i = 0; i < numEvents; ++i) {
                Event event = this.mEvents.get(i);
                parcel.writeInt(event.mEventType);
                parcel.writeString(event.mDatasetId);
                parcel.writeBundle(event.mClientState);
                parcel.writeStringList(event.mSelectedDatasetIds);
                parcel.writeArraySet(event.mIgnoredDatasetIds);
                parcel.writeTypedList(event.mChangedFieldIds);
                parcel.writeStringList(event.mChangedDatasetIds);
                parcel.writeTypedList(event.mManuallyFilledFieldIds);
                if (event.mManuallyFilledFieldIds != null) {
                    int size = event.mManuallyFilledFieldIds.size();
                    for (int j = 0; j < size; ++j) {
                        parcel.writeStringList((List<String>)event.mManuallyFilledDatasetIds.get(j));
                    }
                }
                Parcelable[] detectedFields = event.mDetectedFieldIds;
                parcel.writeParcelableArray(detectedFields, flags);
                if (detectedFields != null) {
                    FieldClassification.writeArrayToParcel(parcel, event.mDetectedFieldClassifications);
                }
                parcel.writeInt(event.mSaveDialogNotShowReason);
                parcel.writeInt(event.mUiType);
                if (!Flags.addLastFocusedIdToFillEventHistory()) continue;
                parcel.writeParcelable(event.mFocusedId, 0);
            }
        }
    }

    public static class Event {
        public static final int TYPE_DATASET_SELECTED = 0;
        public static final int TYPE_DATASET_AUTHENTICATION_SELECTED = 1;
        public static final int TYPE_AUTHENTICATION_SELECTED = 2;
        public static final int TYPE_SAVE_SHOWN = 3;
        public static final int TYPE_CONTEXT_COMMITTED = 4;
        public static final int TYPE_DATASETS_SHOWN = 5;
        public static final int TYPE_VIEW_REQUESTED_AUTOFILL = 6;
        public static final int NO_SAVE_UI_REASON_NONE = 0;
        public static final int NO_SAVE_UI_REASON_NO_SAVE_INFO = 1;
        public static final int NO_SAVE_UI_REASON_WITH_DELAY_SAVE_FLAG = 2;
        public static final int NO_SAVE_UI_REASON_HAS_EMPTY_REQUIRED = 3;
        public static final int NO_SAVE_UI_REASON_NO_VALUE_CHANGED = 4;
        public static final int NO_SAVE_UI_REASON_FIELD_VALIDATION_FAILED = 5;
        public static final int NO_SAVE_UI_REASON_DATASET_MATCH = 6;
        @FlaggedApi(value="android.service.autofill.autofill_w_metrics")
        public static final int NO_SAVE_UI_REASON_USING_CREDMAN = 7;
        public static final int UI_TYPE_UNKNOWN = 0;
        public static final int UI_TYPE_MENU = 1;
        public static final int UI_TYPE_INLINE = 2;
        public static final int UI_TYPE_DIALOG = 3;
        public static final int UI_TYPE_CREDMAN_BOTTOM_SHEET = 4;
        @FlaggedApi(value="android.service.autofill.autofill_w_metrics")
        public static final int UI_TYPE_CREDENTIAL_MANAGER = 4;
        private final int mEventType;
        @Nullable
        private final String mDatasetId;
        @Nullable
        private final Bundle mClientState;
        @Nullable
        private final List<String> mSelectedDatasetIds;
        @Nullable
        private final ArraySet<String> mIgnoredDatasetIds;
        @Nullable
        private final ArrayList<AutofillId> mChangedFieldIds;
        @Nullable
        private final ArrayList<String> mChangedDatasetIds;
        @Nullable
        private final ArrayList<AutofillId> mManuallyFilledFieldIds;
        @Nullable
        private final ArrayList<ArrayList<String>> mManuallyFilledDatasetIds;
        @Nullable
        private final AutofillId[] mDetectedFieldIds;
        @Nullable
        private final FieldClassification[] mDetectedFieldClassifications;
        private final int mSaveDialogNotShowReason;
        private final int mUiType;
        @Nullable
        private final AutofillId mFocusedId;

        public int getType() {
            return this.mEventType;
        }

        @FlaggedApi(value="android.service.autofill.autofill_w_metrics")
        @Nullable
        public AutofillId getFocusedId() {
            return this.mFocusedId;
        }

        @Nullable
        public String getDatasetId() {
            return this.mDatasetId;
        }

        @Nullable
        public Bundle getClientState() {
            return this.mClientState;
        }

        @NonNull
        public Set<String> getSelectedDatasetIds() {
            return this.mSelectedDatasetIds == null ? Collections.emptySet() : new ArraySet<String>(this.mSelectedDatasetIds);
        }

        @FlaggedApi(value="android.service.autofill.autofill_w_metrics")
        @NonNull
        public Set<String> getShownDatasetIds() {
            return Collections.emptySet();
        }

        @NonNull
        public Set<String> getIgnoredDatasetIds() {
            return this.mIgnoredDatasetIds == null ? Collections.emptySet() : this.mIgnoredDatasetIds;
        }

        @NonNull
        public Map<AutofillId, String> getChangedFields() {
            if (this.mChangedFieldIds == null || this.mChangedDatasetIds == null) {
                return Collections.emptyMap();
            }
            int size = this.mChangedFieldIds.size();
            ArrayMap<AutofillId, String> changedFields = new ArrayMap<AutofillId, String>(size);
            for (int i = 0; i < size; ++i) {
                changedFields.put(this.mChangedFieldIds.get(i), this.mChangedDatasetIds.get(i));
            }
            return changedFields;
        }

        @NonNull
        public Map<AutofillId, FieldClassification> getFieldsClassification() {
            if (this.mDetectedFieldIds == null) {
                return Collections.emptyMap();
            }
            int size = this.mDetectedFieldIds.length;
            ArrayMap<AutofillId, FieldClassification> map = new ArrayMap<AutofillId, FieldClassification>(size);
            for (int i = 0; i < size; ++i) {
                AutofillId id2 = this.mDetectedFieldIds[i];
                FieldClassification fc = this.mDetectedFieldClassifications[i];
                if (Helper.sVerbose) {
                    Log.v(FillEventHistory.TAG, "getFieldsClassification[" + i + "]: id=" + id2 + ", fc=" + fc);
                }
                map.put(id2, fc);
            }
            return map;
        }

        @NonNull
        public Map<AutofillId, Set<String>> getManuallyEnteredField() {
            if (this.mManuallyFilledFieldIds == null || this.mManuallyFilledDatasetIds == null) {
                return Collections.emptyMap();
            }
            int size = this.mManuallyFilledFieldIds.size();
            ArrayMap<AutofillId, Set<String>> manuallyFilledFields = new ArrayMap<AutofillId, Set<String>>(size);
            for (int i = 0; i < size; ++i) {
                AutofillId fieldId = this.mManuallyFilledFieldIds.get(i);
                ArrayList<String> datasetIds = this.mManuallyFilledDatasetIds.get(i);
                manuallyFilledFields.put(fieldId, new ArraySet<String>(datasetIds));
            }
            return manuallyFilledFields;
        }

        public int getNoSaveUiReason() {
            return this.mSaveDialogNotShowReason;
        }

        public int getUiType() {
            return this.mUiType;
        }

        public Event(int eventType, @Nullable String datasetId, @Nullable Bundle clientState, @Nullable List<String> selectedDatasetIds, @Nullable ArraySet<String> ignoredDatasetIds, @Nullable ArrayList<AutofillId> changedFieldIds, @Nullable ArrayList<String> changedDatasetIds, @Nullable ArrayList<AutofillId> manuallyFilledFieldIds, @Nullable ArrayList<ArrayList<String>> manuallyFilledDatasetIds, @Nullable AutofillId[] detectedFieldIds, @Nullable FieldClassification[] detectedFieldClassifications, @Nullable AutofillId focusedId) {
            this(eventType, datasetId, clientState, selectedDatasetIds, ignoredDatasetIds, changedFieldIds, changedDatasetIds, manuallyFilledFieldIds, manuallyFilledDatasetIds, detectedFieldIds, detectedFieldClassifications, 0, focusedId);
        }

        public Event(int eventType, @Nullable String datasetId, @Nullable Bundle clientState, @Nullable List<String> selectedDatasetIds, @Nullable ArraySet<String> ignoredDatasetIds, @Nullable ArrayList<AutofillId> changedFieldIds, @Nullable ArrayList<String> changedDatasetIds, @Nullable ArrayList<AutofillId> manuallyFilledFieldIds, @Nullable ArrayList<ArrayList<String>> manuallyFilledDatasetIds, @Nullable AutofillId[] detectedFieldIds, @Nullable FieldClassification[] detectedFieldClassifications, int saveDialogNotShowReason, @Nullable AutofillId focusedId) {
            this(eventType, datasetId, clientState, selectedDatasetIds, ignoredDatasetIds, changedFieldIds, changedDatasetIds, manuallyFilledFieldIds, manuallyFilledDatasetIds, detectedFieldIds, detectedFieldClassifications, saveDialogNotShowReason, 0, focusedId);
        }

        public Event(int eventType, @Nullable String datasetId, @Nullable Bundle clientState, @Nullable List<String> selectedDatasetIds, @Nullable ArraySet<String> ignoredDatasetIds, @Nullable ArrayList<AutofillId> changedFieldIds, @Nullable ArrayList<String> changedDatasetIds, @Nullable ArrayList<AutofillId> manuallyFilledFieldIds, @Nullable ArrayList<ArrayList<String>> manuallyFilledDatasetIds, @Nullable AutofillId[] detectedFieldIds, @Nullable FieldClassification[] detectedFieldClassifications, int saveDialogNotShowReason, int uiType, @Nullable AutofillId focusedId) {
            this.mEventType = Preconditions.checkArgumentInRange(eventType, 0, 6, "eventType");
            this.mDatasetId = datasetId;
            this.mClientState = clientState;
            this.mSelectedDatasetIds = selectedDatasetIds;
            this.mIgnoredDatasetIds = ignoredDatasetIds;
            if (changedFieldIds != null) {
                Preconditions.checkArgument(!ArrayUtils.isEmpty(changedFieldIds) && changedDatasetIds != null && changedFieldIds.size() == changedDatasetIds.size(), "changed ids must have same length and not be empty");
            }
            this.mChangedFieldIds = changedFieldIds;
            this.mChangedDatasetIds = changedDatasetIds;
            if (manuallyFilledFieldIds != null) {
                Preconditions.checkArgument(!ArrayUtils.isEmpty(manuallyFilledFieldIds) && manuallyFilledDatasetIds != null && manuallyFilledFieldIds.size() == manuallyFilledDatasetIds.size(), "manually filled ids must have same length and not be empty");
            }
            this.mManuallyFilledFieldIds = manuallyFilledFieldIds;
            this.mManuallyFilledDatasetIds = manuallyFilledDatasetIds;
            this.mDetectedFieldIds = detectedFieldIds;
            this.mDetectedFieldClassifications = detectedFieldClassifications;
            this.mSaveDialogNotShowReason = Preconditions.checkArgumentInRange(saveDialogNotShowReason, 0, 6, "saveDialogNotShowReason");
            this.mUiType = uiType;
            this.mFocusedId = focusedId;
        }

        public String toString() {
            return "FillEvent [datasetId=" + this.mDatasetId + ", type=" + Event.eventToString(this.mEventType) + ", uiType=" + Event.uiTypeToString(this.mUiType) + ", selectedDatasets=" + this.mSelectedDatasetIds + ", ignoredDatasetIds=" + this.mIgnoredDatasetIds + ", changedFieldIds=" + this.mChangedFieldIds + ", changedDatasetsIds=" + this.mChangedDatasetIds + ", manuallyFilledFieldIds=" + this.mManuallyFilledFieldIds + ", manuallyFilledDatasetIds=" + this.mManuallyFilledDatasetIds + ", detectedFieldIds=" + Arrays.toString(this.mDetectedFieldIds) + ", detectedFieldClassifications =" + Arrays.toString(this.mDetectedFieldClassifications) + ", saveDialogNotShowReason=" + this.mSaveDialogNotShowReason + "]";
        }

        private static String eventToString(int eventType) {
            switch (eventType) {
                case 0: {
                    return "TYPE_DATASET_SELECTED";
                }
                case 1: {
                    return "TYPE_DATASET_AUTHENTICATION_SELECTED";
                }
                case 2: {
                    return "TYPE_AUTHENTICATION_SELECTED";
                }
                case 3: {
                    return "TYPE_SAVE_SHOWN";
                }
                case 4: {
                    return "TYPE_CONTEXT_COMMITTED";
                }
                case 5: {
                    return "TYPE_DATASETS_SHOWN";
                }
                case 6: {
                    return "TYPE_VIEW_REQUESTED_AUTOFILL";
                }
            }
            return "TYPE_UNKNOWN";
        }

        private static String uiTypeToString(int uiType) {
            switch (uiType) {
                case 1: {
                    return "UI_TYPE_MENU";
                }
                case 2: {
                    return "UI_TYPE_INLINE";
                }
                case 3: {
                    return "UI_TYPE_FILL_DIALOG";
                }
                case 4: {
                    return "UI_TYPE_CREDMAN_BOTTOM_SHEET";
                }
            }
            return "UI_TYPE_UNKNOWN";
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface UiType {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface NoSaveReason {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        static @interface EventIds {
        }
    }
}

