/*
 * Decompiled with CFR 0.152.
 */
package android.security.authenticationpolicy;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.os.RemoteException;
import android.security.authenticationpolicy.DisableSecureLockDeviceParams;
import android.security.authenticationpolicy.EnableSecureLockDeviceParams;
import android.security.authenticationpolicy.IAuthenticationPolicyService;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SystemApi
@FlaggedApi(value="android.security.secure_lockdown")
public class AuthenticationPolicyManager {
    private static final String TAG = "AuthenticationPolicyManager";
    @NonNull
    private final IAuthenticationPolicyService mAuthenticationPolicyService;
    @NonNull
    private final Context mContext;
    @SystemApi
    @FlaggedApi(value="android.security.secure_lockdown")
    public static final int ERROR_UNKNOWN = 0;
    @SystemApi
    @FlaggedApi(value="android.security.secure_lockdown")
    public static final int SUCCESS = 1;
    @SystemApi
    @FlaggedApi(value="android.security.secure_lockdown")
    public static final int ERROR_UNSUPPORTED = 2;
    @SystemApi
    @FlaggedApi(value="android.security.secure_lockdown")
    public static final int ERROR_INVALID_PARAMS = 3;
    @SystemApi
    @FlaggedApi(value="android.security.secure_lockdown")
    public static final int ERROR_NO_BIOMETRICS_ENROLLED = 4;
    @SystemApi
    @FlaggedApi(value="android.security.secure_lockdown")
    public static final int ERROR_INSUFFICIENT_BIOMETRICS = 5;
    @SystemApi
    @FlaggedApi(value="android.security.secure_lockdown")
    public static final int ERROR_ALREADY_ENABLED = 6;

    public AuthenticationPolicyManager(@NonNull Context context, @NonNull IAuthenticationPolicyService authenticationPolicyService) {
        this.mContext = context;
        this.mAuthenticationPolicyService = authenticationPolicyService;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_SECURE_LOCK_DEVICE")
    @FlaggedApi(value="android.security.secure_lockdown")
    public int enableSecureLockDevice(@NonNull EnableSecureLockDeviceParams params) {
        try {
            return this.mAuthenticationPolicyService.enableSecureLockDevice(params);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_SECURE_LOCK_DEVICE")
    @FlaggedApi(value="android.security.secure_lockdown")
    public int disableSecureLockDevice(@NonNull DisableSecureLockDeviceParams params) {
        try {
            return this.mAuthenticationPolicyService.disableSecureLockDevice(params);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DisableSecureLockDeviceRequestStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EnableSecureLockDeviceRequestStatus {
    }
}

