/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.annotation.NonNull;
import android.os.Binder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.ServiceSpecificException;
import android.os.StrictMode;
import android.security.KeyStore2HalVersion;
import android.security.KeyStoreException;
import android.security.KeyStoreSecurityLevel;
import android.security.keymaster.KeymasterDefs;
import android.system.keystore2.IKeystoreService;
import android.system.keystore2.KeyDescriptor;
import android.system.keystore2.KeyEntryResponse;
import android.util.Log;
import java.util.Calendar;

public class KeyStore2 {
    private static final String TAG = "KeyStore";
    private static final int RECOVERY_GRACE_PERIOD_MS = 50;
    static final long KEYSTORE_OPERATION_CREATION_MAY_FAIL = 169897160L;
    private IKeystoreService mBinder = null;
    private static final String KEYSTORE2_SERVICE_NAME = "android.system.keystore2.IKeystoreService/default";
    private static final String KEYSTORE_ENGINE_GRANT_ALIAS_PREFIX = "ks2_keystore-engine_grant_id:0x";

    <R> R handleRemoteExceptionWithRetry(@NonNull CheckedRemoteRequest<R> request) throws KeyStoreException {
        IKeystoreService service = this.getService(false);
        boolean firstTry = true;
        while (true) {
            try {
                return request.execute(service);
            }
            catch (ServiceSpecificException e) {
                throw KeyStore2.getKeyStoreException(e.errorCode, e.getMessage());
            }
            catch (RemoteException e) {
                if (firstTry) {
                    Log.w(TAG, "Looks like we may have lost connection to the Keystore daemon.");
                    Log.w(TAG, "Retrying after giving Keystore 50ms to recover.");
                    KeyStore2.interruptedPreservingSleep(50L);
                    service = this.getService(true);
                    firstTry = false;
                    continue;
                }
                Log.e(TAG, "Cannot connect to Keystore daemon.", e);
                throw new KeyStoreException(4, "", e.getMessage());
            }
            break;
        }
    }

    private KeyStore2() {
    }

    public static KeyStore2 getInstance() {
        return new KeyStore2();
    }

    @NonNull
    private synchronized IKeystoreService getService(boolean retryLookup) {
        if (this.mBinder == null || retryLookup) {
            this.mBinder = IKeystoreService.Stub.asInterface(ServiceManager.getService(KEYSTORE2_SERVICE_NAME));
        }
        if (this.mBinder == null) {
            throw new IllegalStateException("Could not connect to Keystore service. Keystore may have crashed or not been initialized");
        }
        Binder.allowBlocking(this.mBinder.asBinder());
        return this.mBinder;
    }

    void delete(KeyDescriptor descriptor) throws KeyStoreException {
        StrictMode.noteDiskWrite();
        this.handleRemoteExceptionWithRetry(service -> {
            service.deleteKey(descriptor);
            return 0;
        });
    }

    public KeyDescriptor[] list(int domain, long namespace) throws KeyStoreException {
        StrictMode.noteDiskRead();
        return this.handleRemoteExceptionWithRetry(service -> service.listEntries(domain, namespace));
    }

    public KeyDescriptor[] listBatch(int domain, long namespace, String startPastAlias) throws KeyStoreException {
        StrictMode.noteDiskRead();
        return this.handleRemoteExceptionWithRetry(service -> service.listEntriesBatched(domain, namespace, startPastAlias));
    }

    public static String makeKeystoreEngineGrantString(long grantId) {
        return String.format("%s%016X", KEYSTORE_ENGINE_GRANT_ALIAS_PREFIX, grantId);
    }

    public static KeyDescriptor keystoreEngineGrantString2KeyDescriptor(String grantString) {
        KeyDescriptor key = new KeyDescriptor();
        key.domain = 1;
        key.nspace = Long.parseUnsignedLong(grantString.substring(KEYSTORE_ENGINE_GRANT_ALIAS_PREFIX.length()), 16);
        key.alias = null;
        key.blob = null;
        return key;
    }

    public KeyDescriptor grant(KeyDescriptor descriptor, int granteeUid, int accessVector) throws KeyStoreException {
        StrictMode.noteDiskWrite();
        return this.handleRemoteExceptionWithRetry(service -> service.grant(descriptor, granteeUid, accessVector));
    }

    public void ungrant(KeyDescriptor descriptor, int granteeUid) throws KeyStoreException {
        StrictMode.noteDiskWrite();
        this.handleRemoteExceptionWithRetry(service -> {
            service.ungrant(descriptor, granteeUid);
            return 0;
        });
    }

    public KeyEntryResponse getKeyEntry(@NonNull KeyDescriptor descriptor) throws KeyStoreException {
        StrictMode.noteDiskRead();
        return this.handleRemoteExceptionWithRetry(service -> service.getKeyEntry(descriptor));
    }

    public KeyStoreSecurityLevel getSecurityLevel(int securityLevel) throws KeyStoreException {
        return this.handleRemoteExceptionWithRetry(service -> new KeyStoreSecurityLevel(service.getSecurityLevel(securityLevel)));
    }

    public void updateSubcomponents(@NonNull KeyDescriptor key, byte[] publicCert, byte[] publicCertChain) throws KeyStoreException {
        StrictMode.noteDiskWrite();
        this.handleRemoteExceptionWithRetry(service -> {
            service.updateSubcomponent(key, publicCert, publicCertChain);
            return 0;
        });
    }

    public void deleteKey(@NonNull KeyDescriptor descriptor) throws KeyStoreException {
        StrictMode.noteDiskWrite();
        this.handleRemoteExceptionWithRetry(service -> {
            service.deleteKey(descriptor);
            return 0;
        });
    }

    public int getNumberOfEntries(int domain, long namespace) throws KeyStoreException {
        StrictMode.noteDiskRead();
        return this.handleRemoteExceptionWithRetry(service -> service.getNumberOfEntries(domain, namespace));
    }

    protected static void interruptedPreservingSleep(long millis) {
        boolean wasInterrupted = false;
        Calendar calendar = Calendar.getInstance();
        long target = calendar.getTimeInMillis() + millis;
        while (true) {
            try {
                Thread.sleep(target - calendar.getTimeInMillis());
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
                continue;
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            break;
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public byte[] getSupplementaryAttestationInfo(int tag) throws KeyStoreException {
        return KeyStore2HalVersion.getSupplementaryAttestationInfoHelper(tag, this);
    }

    static KeyStoreException getKeyStoreException(int errorCode, String serviceErrorMessage) {
        if (errorCode > 0) {
            switch (errorCode) {
                case 2: {
                    return new KeyStoreException(errorCode, "User authentication required", serviceErrorMessage);
                }
                case 3: {
                    return new KeyStoreException(errorCode, "Keystore not initialized", serviceErrorMessage);
                }
                case 4: {
                    return new KeyStoreException(errorCode, "System error", serviceErrorMessage);
                }
                case 6: {
                    return new KeyStoreException(errorCode, "Permission denied", serviceErrorMessage);
                }
                case 7: {
                    return new KeyStoreException(errorCode, "Key not found", serviceErrorMessage);
                }
                case 8: {
                    return new KeyStoreException(errorCode, "Key blob corrupted", serviceErrorMessage);
                }
                case 17: {
                    return new KeyStoreException(errorCode, "Key permanently invalidated", serviceErrorMessage);
                }
                case 22: {
                    return new KeyStoreException(errorCode, serviceErrorMessage, 1);
                }
            }
            return new KeyStoreException(errorCode, String.valueOf(errorCode), serviceErrorMessage);
        }
        switch (errorCode) {
            case -16: {
                return new KeyStoreException(errorCode, "Invalid user authentication validity duration", serviceErrorMessage);
            }
        }
        return new KeyStoreException(errorCode, KeymasterDefs.getErrorMessage(errorCode), serviceErrorMessage);
    }

    @FunctionalInterface
    static interface CheckedRemoteRequest<R> {
        public R execute(IKeystoreService var1) throws RemoteException;
    }
}

