/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.annotation.EnforcePermission;
import android.app.ActivityThread;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInstalld;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.PermissionEnforcer;
import android.os.RemoteException;

public interface IFileIntegrityService
extends IInterface {
    public static final String DESCRIPTOR = "android.security.IFileIntegrityService";

    public IInstalld.IFsveritySetupAuthToken createAuthToken(ParcelFileDescriptor var1) throws RemoteException;

    @EnforcePermission(value="android.permission.SETUP_FSVERITY")
    public int setupFsverity(IInstalld.IFsveritySetupAuthToken var1, String var2, String var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IFileIntegrityService {
        private final PermissionEnforcer mEnforcer;
        static final int TRANSACTION_createAuthToken = 1;
        static final int TRANSACTION_setupFsverity = 2;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, IFileIntegrityService.DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentActivityThread().getSystemContext()));
        }

        public static IFileIntegrityService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IFileIntegrityService.DESCRIPTOR);
            if (iin != null && iin instanceof IFileIntegrityService) {
                return (IFileIntegrityService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "createAuthToken";
                }
                case 2: {
                    return "setupFsverity";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IFileIntegrityService.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    ParcelFileDescriptor _arg0 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    data.enforceNoDataAvail();
                    IInstalld.IFsveritySetupAuthToken _result = this.createAuthToken(_arg0);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 2: {
                    IInstalld.IFsveritySetupAuthToken _arg0 = IInstalld.IFsveritySetupAuthToken.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.setupFsverity(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void setupFsverity_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.SETUP_FSVERITY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IFileIntegrityService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IFileIntegrityService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IInstalld.IFsveritySetupAuthToken createAuthToken(ParcelFileDescriptor authFd) throws RemoteException {
                IInstalld.IFsveritySetupAuthToken _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileIntegrityService.DESCRIPTOR);
                    _data.writeTypedObject(authFd, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = IInstalld.IFsveritySetupAuthToken.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setupFsverity(IInstalld.IFsveritySetupAuthToken authToken, String filePath, String packageName) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IFileIntegrityService.DESCRIPTOR);
                    _data.writeStrongInterface(authToken);
                    _data.writeString(filePath);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IFileIntegrityService {
        @Override
        public IInstalld.IFsveritySetupAuthToken createAuthToken(ParcelFileDescriptor authFd) throws RemoteException {
            return null;
        }

        @Override
        public int setupFsverity(IInstalld.IFsveritySetupAuthToken authToken, String filePath, String packageName) throws RemoteException {
            return 0;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

