/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.compat.annotation.UnsupportedAppUsage;
import com.android.internal.org.bouncycastle.util.io.pem.PemObject;
import com.android.internal.org.bouncycastle.util.io.pem.PemReader;
import com.android.internal.org.bouncycastle.util.io.pem.PemWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

public class Credentials {
    private static final String LOGTAG = "Credentials";
    public static final String INSTALL_ACTION = "android.credentials.INSTALL";
    public static final String INSTALL_AS_USER_ACTION = "android.credentials.INSTALL_AS_USER";
    public static final String ACTION_MANAGE_CREDENTIALS = "android.security.MANAGE_CREDENTIALS";
    @Deprecated
    public static final String CA_CERTIFICATE = "CACERT_";
    @Deprecated
    public static final String USER_CERTIFICATE = "USRCERT_";
    @Deprecated
    public static final String USER_PRIVATE_KEY = "USRPKEY_";
    @Deprecated
    public static final String USER_SECRET_KEY = "USRSKEY_";
    public static final String VPN = "VPN_";
    public static final String PLATFORM_VPN = "PLATFORM_VPN_";
    public static final String WIFI = "WIFI_";
    @Deprecated
    public static final String APP_SOURCE_CERTIFICATE = "FSV_";
    public static final String LOCKDOWN_VPN = "LOCKDOWN_VPN";
    public static final String CERTIFICATE_USAGE_CA = "ca";
    public static final String CERTIFICATE_USAGE_USER = "user";
    public static final String CERTIFICATE_USAGE_WIFI = "wifi";
    public static final String CERTIFICATE_USAGE_APP_SOURCE = "appsrc";
    public static final String EXTRA_PUBLIC_KEY = "KEY";
    public static final String EXTRA_PRIVATE_KEY = "PKEY";
    public static final String EXTENSION_CRT = ".crt";
    public static final String EXTENSION_P12 = ".p12";
    public static final String EXTENSION_CER = ".cer";
    public static final String EXTENSION_PFX = ".pfx";
    public static final String EXTRA_INSTALL_AS_UID = "install_as_uid";
    public static final String EXTRA_CERTIFICATE_USAGE = "certificate_install_usage";
    public static final String EXTRA_USER_KEY_ALIAS = "user_key_pair_name";
    public static final String EXTRA_USER_PRIVATE_KEY_DATA = "user_private_key_data";
    public static final String EXTRA_USER_CERTIFICATE_DATA = "user_certificate_data";
    public static final String EXTRA_CA_CERTIFICATES_DATA = "ca_certificates_data";

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static byte[] convertToPem(Certificate ... objects) throws IOException, CertificateEncodingException {
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bao, StandardCharsets.US_ASCII);
        PemWriter pw = new PemWriter(writer);
        for (Certificate o : objects) {
            pw.writeObject(new PemObject("CERTIFICATE", o.getEncoded()));
        }
        pw.close();
        return bao.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<X509Certificate> convertFromPem(byte[] bytes) throws IOException, CertificateException {
        ByteArrayInputStream bai = new ByteArrayInputStream(bytes);
        InputStreamReader reader = new InputStreamReader((InputStream)bai, StandardCharsets.US_ASCII);
        try (PemReader pr = new PemReader(reader);){
            PemObject o;
            CertificateFactory cf = CertificateFactory.getInstance("X509");
            ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
            while ((o = pr.readPemObject()) != null) {
                if (o.getType().equals("CERTIFICATE")) {
                    Certificate c = cf.generateCertificate(new ByteArrayInputStream(o.getContent()));
                    result.add((X509Certificate)c);
                    continue;
                }
                throw new IllegalArgumentException("Unknown type " + o.getType());
            }
            ArrayList<X509Certificate> arrayList = result;
            return arrayList;
        }
    }
}

