/*
 * Decompiled with CFR 0.152.
 */
package android.safetycenter;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.permission.jarjar.com.android.internal.util.Preconditions;
import android.permission.jarjar.com.android.modules.utils.build.SdkLevel;
import android.safetycenter.SafetySourceIssue;
import android.safetycenter.SafetySourceStatus;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

@SystemApi
@RequiresApi(value=33)
public class SafetySourceData
implements Parcelable {
    public static final int SEVERITY_LEVEL_UNSPECIFIED = 100;
    public static final int SEVERITY_LEVEL_INFORMATION = 200;
    public static final int SEVERITY_LEVEL_RECOMMENDATION = 300;
    public static final int SEVERITY_LEVEL_CRITICAL_WARNING = 400;
    @NonNull
    public static final Parcelable.Creator<SafetySourceData> CREATOR = new Parcelable.Creator<SafetySourceData>(){

        @Override
        public SafetySourceData createFromParcel(Parcel in) {
            Bundle extras;
            SafetySourceStatus status = in.readTypedObject(SafetySourceStatus.CREATOR);
            List issues = Objects.requireNonNull(in.createTypedArrayList(SafetySourceIssue.CREATOR));
            Builder builder = new Builder().setStatus(status);
            for (int i = 0; i < issues.size(); ++i) {
                builder.addIssue((SafetySourceIssue)issues.get(i));
            }
            if (SdkLevel.isAtLeastU() && (extras = in.readBundle(this.getClass().getClassLoader())) != null) {
                builder.setExtras(extras);
            }
            return builder.build();
        }

        public SafetySourceData[] newArray(int size) {
            return new SafetySourceData[size];
        }
    };
    @Nullable
    private final SafetySourceStatus mStatus;
    @NonNull
    private final List<SafetySourceIssue> mIssues;
    @NonNull
    private final Bundle mExtras;

    private SafetySourceData(@Nullable SafetySourceStatus status, @NonNull List<SafetySourceIssue> issues, @NonNull Bundle extras) {
        this.mStatus = status;
        this.mIssues = issues;
        this.mExtras = extras;
    }

    @Nullable
    public SafetySourceStatus getStatus() {
        return this.mStatus;
    }

    @NonNull
    public List<SafetySourceIssue> getIssues() {
        return this.mIssues;
    }

    @NonNull
    @RequiresApi(value=34)
    public Bundle getExtras() {
        if (!SdkLevel.isAtLeastU()) {
            throw new UnsupportedOperationException("Method not supported on versions lower than UPSIDE_DOWN_CAKE");
        }
        return this.mExtras;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeTypedObject(this.mStatus, flags);
        dest.writeTypedList(this.mIssues);
        if (SdkLevel.isAtLeastU()) {
            dest.writeBundle(this.mExtras);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SafetySourceData)) {
            return false;
        }
        SafetySourceData that = (SafetySourceData)o;
        return Objects.equals(this.mStatus, that.mStatus) && this.mIssues.equals(that.mIssues);
    }

    public int hashCode() {
        return Objects.hash(this.mStatus, this.mIssues);
    }

    public String toString() {
        return "SafetySourceData{mStatus=" + this.mStatus + ", mIssues=" + this.mIssues + (!this.mExtras.isEmpty() ? ", (has extras)" : "") + '}';
    }

    public static class Builder {
        @NonNull
        private final List<SafetySourceIssue> mIssues = new ArrayList<SafetySourceIssue>();
        @Nullable
        private SafetySourceStatus mStatus;
        @NonNull
        private Bundle mExtras = Bundle.EMPTY;

        public Builder() {
        }

        @RequiresApi(value=34)
        public Builder(@NonNull SafetySourceData safetySourceData) {
            if (!SdkLevel.isAtLeastU()) {
                throw new UnsupportedOperationException("Method not supported on versions lower than UPSIDE_DOWN_CAKE");
            }
            Objects.requireNonNull(safetySourceData);
            this.mIssues.addAll(safetySourceData.mIssues);
            this.mStatus = safetySourceData.mStatus;
            this.mExtras = safetySourceData.mExtras.deepCopy();
        }

        @NonNull
        public Builder setStatus(@Nullable SafetySourceStatus status) {
            this.mStatus = status;
            return this;
        }

        @NonNull
        public Builder addIssue(@NonNull SafetySourceIssue safetySourceIssue) {
            this.mIssues.add(Objects.requireNonNull(safetySourceIssue));
            return this;
        }

        @NonNull
        @RequiresApi(value=34)
        public Builder setExtras(@NonNull Bundle extras) {
            if (!SdkLevel.isAtLeastU()) {
                throw new UnsupportedOperationException("Method not supported on versions lower than UPSIDE_DOWN_CAKE");
            }
            this.mExtras = Objects.requireNonNull(extras);
            return this;
        }

        @NonNull
        @RequiresApi(value=34)
        public Builder clearExtras() {
            if (!SdkLevel.isAtLeastU()) {
                throw new UnsupportedOperationException("Method not supported on versions lower than UPSIDE_DOWN_CAKE");
            }
            this.mExtras = Bundle.EMPTY;
            return this;
        }

        @NonNull
        public Builder clearIssues() {
            this.mIssues.clear();
            return this;
        }

        @NonNull
        public SafetySourceData build() {
            boolean requiresAttention;
            List<SafetySourceIssue> issues = Collections.unmodifiableList(new ArrayList<SafetySourceIssue>(this.mIssues));
            int issuesMaxSeverityLevel = Builder.getIssuesMaxSeverityLevelEnforcingUniqueIds(issues);
            if (this.mStatus == null) {
                return new SafetySourceData(null, issues, this.mExtras);
            }
            int statusSeverityLevel = this.mStatus.getSeverityLevel();
            boolean bl = requiresAttention = issuesMaxSeverityLevel > 200;
            if (requiresAttention) {
                Preconditions.checkArgument(statusSeverityLevel >= issuesMaxSeverityLevel, "Safety source data cannot have issues that are more severe than its status");
            }
            return new SafetySourceData(this.mStatus, issues, this.mExtras);
        }

        private static int getIssuesMaxSeverityLevelEnforcingUniqueIds(@NonNull List<SafetySourceIssue> issues) {
            int max = Integer.MIN_VALUE;
            HashSet<String> issueIds = new HashSet<String>();
            for (int i = 0; i < issues.size(); ++i) {
                SafetySourceIssue safetySourceIssue = issues.get(i);
                String issueId = safetySourceIssue.getId();
                Preconditions.checkArgument(!issueIds.contains(issueId), "Safety source data cannot have duplicate issue ids");
                max = Math.max(max, safetySourceIssue.getSeverityLevel());
                issueIds.add(issueId);
            }
            return max;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SeverityLevel {
    }
}

