/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.compat.annotation.UnsupportedAppUsage;
import android.renderscript.BaseObj;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RenderScript;

@Deprecated
public class Element
extends BaseObj {
    int mSize;
    Element[] mElements;
    String[] mElementNames;
    int[] mArraySizes;
    int[] mOffsetInBytes;
    int[] mVisibleElementMap;
    DataType mType;
    DataKind mKind;
    boolean mNormalized;
    int mVectorSize;

    private void updateVisibleSubElements() {
        int ct;
        if (this.mElements == null) {
            return;
        }
        int noPaddingFieldCount = 0;
        int fieldCount = this.mElementNames.length;
        for (ct = 0; ct < fieldCount; ++ct) {
            if (this.mElementNames[ct].charAt(0) == '#') continue;
            ++noPaddingFieldCount;
        }
        this.mVisibleElementMap = new int[noPaddingFieldCount];
        int ctNoPadding = 0;
        for (ct = 0; ct < fieldCount; ++ct) {
            if (this.mElementNames[ct].charAt(0) == '#') continue;
            this.mVisibleElementMap[ctNoPadding++] = ct;
        }
    }

    public int getBytesSize() {
        return this.mSize;
    }

    public int getVectorSize() {
        return this.mVectorSize;
    }

    public boolean isComplex() {
        if (this.mElements == null) {
            return false;
        }
        for (int ct = 0; ct < this.mElements.length; ++ct) {
            if (this.mElements[ct].mElements == null) continue;
            return true;
        }
        return false;
    }

    public int getSubElementCount() {
        if (this.mVisibleElementMap == null) {
            return 0;
        }
        return this.mVisibleElementMap.length;
    }

    public Element getSubElement(int index) {
        if (this.mVisibleElementMap == null) {
            throw new RSIllegalArgumentException("Element contains no sub-elements");
        }
        if (index < 0 || index >= this.mVisibleElementMap.length) {
            throw new RSIllegalArgumentException("Illegal sub-element index");
        }
        return this.mElements[this.mVisibleElementMap[index]];
    }

    public String getSubElementName(int index) {
        if (this.mVisibleElementMap == null) {
            throw new RSIllegalArgumentException("Element contains no sub-elements");
        }
        if (index < 0 || index >= this.mVisibleElementMap.length) {
            throw new RSIllegalArgumentException("Illegal sub-element index");
        }
        return this.mElementNames[this.mVisibleElementMap[index]];
    }

    public int getSubElementArraySize(int index) {
        if (this.mVisibleElementMap == null) {
            throw new RSIllegalArgumentException("Element contains no sub-elements");
        }
        if (index < 0 || index >= this.mVisibleElementMap.length) {
            throw new RSIllegalArgumentException("Illegal sub-element index");
        }
        return this.mArraySizes[this.mVisibleElementMap[index]];
    }

    public int getSubElementOffsetBytes(int index) {
        if (this.mVisibleElementMap == null) {
            throw new RSIllegalArgumentException("Element contains no sub-elements");
        }
        if (index < 0 || index >= this.mVisibleElementMap.length) {
            throw new RSIllegalArgumentException("Illegal sub-element index");
        }
        return this.mOffsetInBytes[this.mVisibleElementMap[index]];
    }

    public DataType getDataType() {
        return this.mType;
    }

    public DataKind getDataKind() {
        return this.mKind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element BOOLEAN(RenderScript rs) {
        if (rs.mElement_BOOLEAN == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_BOOLEAN == null) {
                    rs.mElement_BOOLEAN = Element.createUser(rs, DataType.BOOLEAN);
                }
            }
        }
        return rs.mElement_BOOLEAN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element U8(RenderScript rs) {
        if (rs.mElement_U8 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_U8 == null) {
                    rs.mElement_U8 = Element.createUser(rs, DataType.UNSIGNED_8);
                }
            }
        }
        return rs.mElement_U8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element I8(RenderScript rs) {
        if (rs.mElement_I8 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_I8 == null) {
                    rs.mElement_I8 = Element.createUser(rs, DataType.SIGNED_8);
                }
            }
        }
        return rs.mElement_I8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element U16(RenderScript rs) {
        if (rs.mElement_U16 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_U16 == null) {
                    rs.mElement_U16 = Element.createUser(rs, DataType.UNSIGNED_16);
                }
            }
        }
        return rs.mElement_U16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element I16(RenderScript rs) {
        if (rs.mElement_I16 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_I16 == null) {
                    rs.mElement_I16 = Element.createUser(rs, DataType.SIGNED_16);
                }
            }
        }
        return rs.mElement_I16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element U32(RenderScript rs) {
        if (rs.mElement_U32 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_U32 == null) {
                    rs.mElement_U32 = Element.createUser(rs, DataType.UNSIGNED_32);
                }
            }
        }
        return rs.mElement_U32;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element I32(RenderScript rs) {
        if (rs.mElement_I32 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_I32 == null) {
                    rs.mElement_I32 = Element.createUser(rs, DataType.SIGNED_32);
                }
            }
        }
        return rs.mElement_I32;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element U64(RenderScript rs) {
        if (rs.mElement_U64 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_U64 == null) {
                    rs.mElement_U64 = Element.createUser(rs, DataType.UNSIGNED_64);
                }
            }
        }
        return rs.mElement_U64;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element I64(RenderScript rs) {
        if (rs.mElement_I64 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_I64 == null) {
                    rs.mElement_I64 = Element.createUser(rs, DataType.SIGNED_64);
                }
            }
        }
        return rs.mElement_I64;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element F16(RenderScript rs) {
        if (rs.mElement_F16 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_F16 == null) {
                    rs.mElement_F16 = Element.createUser(rs, DataType.FLOAT_16);
                }
            }
        }
        return rs.mElement_F16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element F32(RenderScript rs) {
        if (rs.mElement_F32 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_F32 == null) {
                    rs.mElement_F32 = Element.createUser(rs, DataType.FLOAT_32);
                }
            }
        }
        return rs.mElement_F32;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element F64(RenderScript rs) {
        if (rs.mElement_F64 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_F64 == null) {
                    rs.mElement_F64 = Element.createUser(rs, DataType.FLOAT_64);
                }
            }
        }
        return rs.mElement_F64;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element ELEMENT(RenderScript rs) {
        if (rs.mElement_ELEMENT == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_ELEMENT == null) {
                    rs.mElement_ELEMENT = Element.createUser(rs, DataType.RS_ELEMENT);
                }
            }
        }
        return rs.mElement_ELEMENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element TYPE(RenderScript rs) {
        if (rs.mElement_TYPE == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_TYPE == null) {
                    rs.mElement_TYPE = Element.createUser(rs, DataType.RS_TYPE);
                }
            }
        }
        return rs.mElement_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element ALLOCATION(RenderScript rs) {
        if (rs.mElement_ALLOCATION == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_ALLOCATION == null) {
                    rs.mElement_ALLOCATION = Element.createUser(rs, DataType.RS_ALLOCATION);
                }
            }
        }
        return rs.mElement_ALLOCATION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element SAMPLER(RenderScript rs) {
        if (rs.mElement_SAMPLER == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_SAMPLER == null) {
                    rs.mElement_SAMPLER = Element.createUser(rs, DataType.RS_SAMPLER);
                }
            }
        }
        return rs.mElement_SAMPLER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element SCRIPT(RenderScript rs) {
        if (rs.mElement_SCRIPT == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_SCRIPT == null) {
                    rs.mElement_SCRIPT = Element.createUser(rs, DataType.RS_SCRIPT);
                }
            }
        }
        return rs.mElement_SCRIPT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element MESH(RenderScript rs) {
        if (rs.mElement_MESH == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_MESH == null) {
                    rs.mElement_MESH = Element.createUser(rs, DataType.RS_MESH);
                }
            }
        }
        return rs.mElement_MESH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element PROGRAM_FRAGMENT(RenderScript rs) {
        if (rs.mElement_PROGRAM_FRAGMENT == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_PROGRAM_FRAGMENT == null) {
                    rs.mElement_PROGRAM_FRAGMENT = Element.createUser(rs, DataType.RS_PROGRAM_FRAGMENT);
                }
            }
        }
        return rs.mElement_PROGRAM_FRAGMENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element PROGRAM_VERTEX(RenderScript rs) {
        if (rs.mElement_PROGRAM_VERTEX == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_PROGRAM_VERTEX == null) {
                    rs.mElement_PROGRAM_VERTEX = Element.createUser(rs, DataType.RS_PROGRAM_VERTEX);
                }
            }
        }
        return rs.mElement_PROGRAM_VERTEX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element PROGRAM_RASTER(RenderScript rs) {
        if (rs.mElement_PROGRAM_RASTER == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_PROGRAM_RASTER == null) {
                    rs.mElement_PROGRAM_RASTER = Element.createUser(rs, DataType.RS_PROGRAM_RASTER);
                }
            }
        }
        return rs.mElement_PROGRAM_RASTER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element PROGRAM_STORE(RenderScript rs) {
        if (rs.mElement_PROGRAM_STORE == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_PROGRAM_STORE == null) {
                    rs.mElement_PROGRAM_STORE = Element.createUser(rs, DataType.RS_PROGRAM_STORE);
                }
            }
        }
        return rs.mElement_PROGRAM_STORE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element FONT(RenderScript rs) {
        if (rs.mElement_FONT == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_FONT == null) {
                    rs.mElement_FONT = Element.createUser(rs, DataType.RS_FONT);
                }
            }
        }
        return rs.mElement_FONT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element A_8(RenderScript rs) {
        if (rs.mElement_A_8 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_A_8 == null) {
                    rs.mElement_A_8 = Element.createPixel(rs, DataType.UNSIGNED_8, DataKind.PIXEL_A);
                }
            }
        }
        return rs.mElement_A_8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element RGB_565(RenderScript rs) {
        if (rs.mElement_RGB_565 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_RGB_565 == null) {
                    rs.mElement_RGB_565 = Element.createPixel(rs, DataType.UNSIGNED_5_6_5, DataKind.PIXEL_RGB);
                }
            }
        }
        return rs.mElement_RGB_565;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element RGB_888(RenderScript rs) {
        if (rs.mElement_RGB_888 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_RGB_888 == null) {
                    rs.mElement_RGB_888 = Element.createPixel(rs, DataType.UNSIGNED_8, DataKind.PIXEL_RGB);
                }
            }
        }
        return rs.mElement_RGB_888;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element RGBA_5551(RenderScript rs) {
        if (rs.mElement_RGBA_5551 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_RGBA_5551 == null) {
                    rs.mElement_RGBA_5551 = Element.createPixel(rs, DataType.UNSIGNED_5_5_5_1, DataKind.PIXEL_RGBA);
                }
            }
        }
        return rs.mElement_RGBA_5551;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element RGBA_4444(RenderScript rs) {
        if (rs.mElement_RGBA_4444 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_RGBA_4444 == null) {
                    rs.mElement_RGBA_4444 = Element.createPixel(rs, DataType.UNSIGNED_4_4_4_4, DataKind.PIXEL_RGBA);
                }
            }
        }
        return rs.mElement_RGBA_4444;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element RGBA_8888(RenderScript rs) {
        if (rs.mElement_RGBA_8888 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_RGBA_8888 == null) {
                    rs.mElement_RGBA_8888 = Element.createPixel(rs, DataType.UNSIGNED_8, DataKind.PIXEL_RGBA);
                }
            }
        }
        return rs.mElement_RGBA_8888;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element F16_2(RenderScript rs) {
        if (rs.mElement_HALF_2 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_HALF_2 == null) {
                    rs.mElement_HALF_2 = Element.createVector(rs, DataType.FLOAT_16, 2);
                }
            }
        }
        return rs.mElement_HALF_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element F16_3(RenderScript rs) {
        if (rs.mElement_HALF_3 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_HALF_3 == null) {
                    rs.mElement_HALF_3 = Element.createVector(rs, DataType.FLOAT_16, 3);
                }
            }
        }
        return rs.mElement_HALF_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element F16_4(RenderScript rs) {
        if (rs.mElement_HALF_4 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_HALF_4 == null) {
                    rs.mElement_HALF_4 = Element.createVector(rs, DataType.FLOAT_16, 4);
                }
            }
        }
        return rs.mElement_HALF_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element F32_2(RenderScript rs) {
        if (rs.mElement_FLOAT_2 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_FLOAT_2 == null) {
                    rs.mElement_FLOAT_2 = Element.createVector(rs, DataType.FLOAT_32, 2);
                }
            }
        }
        return rs.mElement_FLOAT_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element F32_3(RenderScript rs) {
        if (rs.mElement_FLOAT_3 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_FLOAT_3 == null) {
                    rs.mElement_FLOAT_3 = Element.createVector(rs, DataType.FLOAT_32, 3);
                }
            }
        }
        return rs.mElement_FLOAT_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element F32_4(RenderScript rs) {
        if (rs.mElement_FLOAT_4 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_FLOAT_4 == null) {
                    rs.mElement_FLOAT_4 = Element.createVector(rs, DataType.FLOAT_32, 4);
                }
            }
        }
        return rs.mElement_FLOAT_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element F64_2(RenderScript rs) {
        if (rs.mElement_DOUBLE_2 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_DOUBLE_2 == null) {
                    rs.mElement_DOUBLE_2 = Element.createVector(rs, DataType.FLOAT_64, 2);
                }
            }
        }
        return rs.mElement_DOUBLE_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element F64_3(RenderScript rs) {
        if (rs.mElement_DOUBLE_3 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_DOUBLE_3 == null) {
                    rs.mElement_DOUBLE_3 = Element.createVector(rs, DataType.FLOAT_64, 3);
                }
            }
        }
        return rs.mElement_DOUBLE_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element F64_4(RenderScript rs) {
        if (rs.mElement_DOUBLE_4 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_DOUBLE_4 == null) {
                    rs.mElement_DOUBLE_4 = Element.createVector(rs, DataType.FLOAT_64, 4);
                }
            }
        }
        return rs.mElement_DOUBLE_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element U8_2(RenderScript rs) {
        if (rs.mElement_UCHAR_2 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_UCHAR_2 == null) {
                    rs.mElement_UCHAR_2 = Element.createVector(rs, DataType.UNSIGNED_8, 2);
                }
            }
        }
        return rs.mElement_UCHAR_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element U8_3(RenderScript rs) {
        if (rs.mElement_UCHAR_3 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_UCHAR_3 == null) {
                    rs.mElement_UCHAR_3 = Element.createVector(rs, DataType.UNSIGNED_8, 3);
                }
            }
        }
        return rs.mElement_UCHAR_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element U8_4(RenderScript rs) {
        if (rs.mElement_UCHAR_4 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_UCHAR_4 == null) {
                    rs.mElement_UCHAR_4 = Element.createVector(rs, DataType.UNSIGNED_8, 4);
                }
            }
        }
        return rs.mElement_UCHAR_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element I8_2(RenderScript rs) {
        if (rs.mElement_CHAR_2 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_CHAR_2 == null) {
                    rs.mElement_CHAR_2 = Element.createVector(rs, DataType.SIGNED_8, 2);
                }
            }
        }
        return rs.mElement_CHAR_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element I8_3(RenderScript rs) {
        if (rs.mElement_CHAR_3 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_CHAR_3 == null) {
                    rs.mElement_CHAR_3 = Element.createVector(rs, DataType.SIGNED_8, 3);
                }
            }
        }
        return rs.mElement_CHAR_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element I8_4(RenderScript rs) {
        if (rs.mElement_CHAR_4 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_CHAR_4 == null) {
                    rs.mElement_CHAR_4 = Element.createVector(rs, DataType.SIGNED_8, 4);
                }
            }
        }
        return rs.mElement_CHAR_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element U16_2(RenderScript rs) {
        if (rs.mElement_USHORT_2 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_USHORT_2 == null) {
                    rs.mElement_USHORT_2 = Element.createVector(rs, DataType.UNSIGNED_16, 2);
                }
            }
        }
        return rs.mElement_USHORT_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element U16_3(RenderScript rs) {
        if (rs.mElement_USHORT_3 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_USHORT_3 == null) {
                    rs.mElement_USHORT_3 = Element.createVector(rs, DataType.UNSIGNED_16, 3);
                }
            }
        }
        return rs.mElement_USHORT_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element U16_4(RenderScript rs) {
        if (rs.mElement_USHORT_4 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_USHORT_4 == null) {
                    rs.mElement_USHORT_4 = Element.createVector(rs, DataType.UNSIGNED_16, 4);
                }
            }
        }
        return rs.mElement_USHORT_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element I16_2(RenderScript rs) {
        if (rs.mElement_SHORT_2 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_SHORT_2 == null) {
                    rs.mElement_SHORT_2 = Element.createVector(rs, DataType.SIGNED_16, 2);
                }
            }
        }
        return rs.mElement_SHORT_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element I16_3(RenderScript rs) {
        if (rs.mElement_SHORT_3 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_SHORT_3 == null) {
                    rs.mElement_SHORT_3 = Element.createVector(rs, DataType.SIGNED_16, 3);
                }
            }
        }
        return rs.mElement_SHORT_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element I16_4(RenderScript rs) {
        if (rs.mElement_SHORT_4 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_SHORT_4 == null) {
                    rs.mElement_SHORT_4 = Element.createVector(rs, DataType.SIGNED_16, 4);
                }
            }
        }
        return rs.mElement_SHORT_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element U32_2(RenderScript rs) {
        if (rs.mElement_UINT_2 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_UINT_2 == null) {
                    rs.mElement_UINT_2 = Element.createVector(rs, DataType.UNSIGNED_32, 2);
                }
            }
        }
        return rs.mElement_UINT_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element U32_3(RenderScript rs) {
        if (rs.mElement_UINT_3 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_UINT_3 == null) {
                    rs.mElement_UINT_3 = Element.createVector(rs, DataType.UNSIGNED_32, 3);
                }
            }
        }
        return rs.mElement_UINT_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element U32_4(RenderScript rs) {
        if (rs.mElement_UINT_4 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_UINT_4 == null) {
                    rs.mElement_UINT_4 = Element.createVector(rs, DataType.UNSIGNED_32, 4);
                }
            }
        }
        return rs.mElement_UINT_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element I32_2(RenderScript rs) {
        if (rs.mElement_INT_2 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_INT_2 == null) {
                    rs.mElement_INT_2 = Element.createVector(rs, DataType.SIGNED_32, 2);
                }
            }
        }
        return rs.mElement_INT_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element I32_3(RenderScript rs) {
        if (rs.mElement_INT_3 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_INT_3 == null) {
                    rs.mElement_INT_3 = Element.createVector(rs, DataType.SIGNED_32, 3);
                }
            }
        }
        return rs.mElement_INT_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element I32_4(RenderScript rs) {
        if (rs.mElement_INT_4 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_INT_4 == null) {
                    rs.mElement_INT_4 = Element.createVector(rs, DataType.SIGNED_32, 4);
                }
            }
        }
        return rs.mElement_INT_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element U64_2(RenderScript rs) {
        if (rs.mElement_ULONG_2 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_ULONG_2 == null) {
                    rs.mElement_ULONG_2 = Element.createVector(rs, DataType.UNSIGNED_64, 2);
                }
            }
        }
        return rs.mElement_ULONG_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element U64_3(RenderScript rs) {
        if (rs.mElement_ULONG_3 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_ULONG_3 == null) {
                    rs.mElement_ULONG_3 = Element.createVector(rs, DataType.UNSIGNED_64, 3);
                }
            }
        }
        return rs.mElement_ULONG_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element U64_4(RenderScript rs) {
        if (rs.mElement_ULONG_4 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_ULONG_4 == null) {
                    rs.mElement_ULONG_4 = Element.createVector(rs, DataType.UNSIGNED_64, 4);
                }
            }
        }
        return rs.mElement_ULONG_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element I64_2(RenderScript rs) {
        if (rs.mElement_LONG_2 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_LONG_2 == null) {
                    rs.mElement_LONG_2 = Element.createVector(rs, DataType.SIGNED_64, 2);
                }
            }
        }
        return rs.mElement_LONG_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element I64_3(RenderScript rs) {
        if (rs.mElement_LONG_3 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_LONG_3 == null) {
                    rs.mElement_LONG_3 = Element.createVector(rs, DataType.SIGNED_64, 3);
                }
            }
        }
        return rs.mElement_LONG_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element I64_4(RenderScript rs) {
        if (rs.mElement_LONG_4 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_LONG_4 == null) {
                    rs.mElement_LONG_4 = Element.createVector(rs, DataType.SIGNED_64, 4);
                }
            }
        }
        return rs.mElement_LONG_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element YUV(RenderScript rs) {
        if (rs.mElement_YUV == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_YUV == null) {
                    rs.mElement_YUV = Element.createPixel(rs, DataType.UNSIGNED_8, DataKind.PIXEL_YUV);
                }
            }
        }
        return rs.mElement_YUV;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element MATRIX_4X4(RenderScript rs) {
        if (rs.mElement_MATRIX_4X4 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_MATRIX_4X4 == null) {
                    rs.mElement_MATRIX_4X4 = Element.createUser(rs, DataType.MATRIX_4X4);
                }
            }
        }
        return rs.mElement_MATRIX_4X4;
    }

    public static Element MATRIX4X4(RenderScript rs) {
        return Element.MATRIX_4X4(rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element MATRIX_3X3(RenderScript rs) {
        if (rs.mElement_MATRIX_3X3 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_MATRIX_3X3 == null) {
                    rs.mElement_MATRIX_3X3 = Element.createUser(rs, DataType.MATRIX_3X3);
                }
            }
        }
        return rs.mElement_MATRIX_3X3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element MATRIX_2X2(RenderScript rs) {
        if (rs.mElement_MATRIX_2X2 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_MATRIX_2X2 == null) {
                    rs.mElement_MATRIX_2X2 = Element.createUser(rs, DataType.MATRIX_2X2);
                }
            }
        }
        return rs.mElement_MATRIX_2X2;
    }

    Element(long id2, RenderScript rs, Element[] e, String[] n, int[] as) {
        super(id2, rs);
        this.mSize = 0;
        this.mVectorSize = 1;
        this.mElements = e;
        this.mElementNames = n;
        this.mArraySizes = as;
        this.mType = DataType.NONE;
        this.mKind = DataKind.USER;
        this.mOffsetInBytes = new int[this.mElements.length];
        for (int ct = 0; ct < this.mElements.length; ++ct) {
            this.mOffsetInBytes[ct] = this.mSize;
            this.mSize += this.mElements[ct].mSize * this.mArraySizes[ct];
        }
        this.updateVisibleSubElements();
    }

    Element(long id2, RenderScript rs, DataType dt, DataKind dk, boolean norm, int size) {
        super(id2, rs);
        this.mSize = dt != DataType.UNSIGNED_5_6_5 && dt != DataType.UNSIGNED_4_4_4_4 && dt != DataType.UNSIGNED_5_5_5_1 ? (size == 3 ? dt.mSize * 4 : dt.mSize * size) : dt.mSize;
        this.mType = dt;
        this.mKind = dk;
        this.mNormalized = norm;
        this.mVectorSize = size;
    }

    Element(long id2, RenderScript rs) {
        super(id2, rs);
    }

    @Override
    void updateFromNative() {
        super.updateFromNative();
        int[] dataBuffer = new int[5];
        this.mRS.nElementGetNativeData(this.getID(this.mRS), dataBuffer);
        this.mNormalized = dataBuffer[2] == 1;
        this.mVectorSize = dataBuffer[3];
        this.mSize = 0;
        for (DataType dataType : DataType.values()) {
            if (dataType.mID != dataBuffer[0]) continue;
            this.mType = dataType;
            this.mSize = this.mType.mSize * this.mVectorSize;
        }
        for (Enum enum_ : DataKind.values()) {
            if (((DataKind)enum_).mID != dataBuffer[1]) continue;
            this.mKind = enum_;
        }
        int numSubElements = dataBuffer[4];
        if (numSubElements > 0) {
            this.mElements = new Element[numSubElements];
            this.mElementNames = new String[numSubElements];
            this.mArraySizes = new int[numSubElements];
            this.mOffsetInBytes = new int[numSubElements];
            long[] subElementIds = new long[numSubElements];
            this.mRS.nElementGetSubElements(this.getID(this.mRS), subElementIds, this.mElementNames, this.mArraySizes);
            for (int i = 0; i < numSubElements; ++i) {
                this.mElements[i] = new Element(subElementIds[i], this.mRS);
                this.mElements[i].updateFromNative();
                this.mOffsetInBytes[i] = this.mSize;
                this.mSize += this.mElements[i].mSize * this.mArraySizes[i];
            }
        }
        this.updateVisibleSubElements();
    }

    @UnsupportedAppUsage
    static Element createUser(RenderScript rs, DataType dt) {
        DataKind dk = DataKind.USER;
        boolean norm = false;
        int vecSize = 1;
        long id2 = rs.nElementCreate(dt.mID, dk.mID, norm, vecSize);
        return new Element(id2, rs, dt, dk, norm, vecSize);
    }

    public static Element createVector(RenderScript rs, DataType dt, int size) {
        if (size < 2 || size > 4) {
            throw new RSIllegalArgumentException("Vector size out of range 2-4.");
        }
        switch (dt.ordinal()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                DataKind dk = DataKind.USER;
                boolean norm = false;
                long id2 = rs.nElementCreate(dt.mID, dk.mID, norm, size);
                return new Element(id2, rs, dt, dk, norm, size);
            }
        }
        throw new RSIllegalArgumentException("Cannot create vector of non-primitive type.");
    }

    public static Element createPixel(RenderScript rs, DataType dt, DataKind dk) {
        if (dk != DataKind.PIXEL_L && dk != DataKind.PIXEL_A && dk != DataKind.PIXEL_LA && dk != DataKind.PIXEL_RGB && dk != DataKind.PIXEL_RGBA && dk != DataKind.PIXEL_DEPTH && dk != DataKind.PIXEL_YUV) {
            throw new RSIllegalArgumentException("Unsupported DataKind");
        }
        if (dt != DataType.UNSIGNED_8 && dt != DataType.UNSIGNED_16 && dt != DataType.UNSIGNED_5_6_5 && dt != DataType.UNSIGNED_4_4_4_4 && dt != DataType.UNSIGNED_5_5_5_1) {
            throw new RSIllegalArgumentException("Unsupported DataType");
        }
        if (dt == DataType.UNSIGNED_5_6_5 && dk != DataKind.PIXEL_RGB) {
            throw new RSIllegalArgumentException("Bad kind and type combo");
        }
        if (dt == DataType.UNSIGNED_5_5_5_1 && dk != DataKind.PIXEL_RGBA) {
            throw new RSIllegalArgumentException("Bad kind and type combo");
        }
        if (dt == DataType.UNSIGNED_4_4_4_4 && dk != DataKind.PIXEL_RGBA) {
            throw new RSIllegalArgumentException("Bad kind and type combo");
        }
        if (dt == DataType.UNSIGNED_16 && dk != DataKind.PIXEL_DEPTH) {
            throw new RSIllegalArgumentException("Bad kind and type combo");
        }
        int size = 1;
        switch (dk.ordinal()) {
            case 3: {
                size = 2;
                break;
            }
            case 4: {
                size = 3;
                break;
            }
            case 5: {
                size = 4;
                break;
            }
            case 6: {
                size = 2;
            }
        }
        boolean norm = true;
        long id2 = rs.nElementCreate(dt.mID, dk.mID, norm, size);
        return new Element(id2, rs, dt, dk, norm, size);
    }

    public boolean isCompatible(Element e) {
        if (this.equals(e)) {
            return true;
        }
        return this.mSize == e.mSize && this.mType != DataType.NONE && this.mType == e.mType && this.mVectorSize == e.mVectorSize;
    }

    public static enum DataType {
        NONE(0, 0),
        FLOAT_16(1, 2),
        FLOAT_32(2, 4),
        FLOAT_64(3, 8),
        SIGNED_8(4, 1),
        SIGNED_16(5, 2),
        SIGNED_32(6, 4),
        SIGNED_64(7, 8),
        UNSIGNED_8(8, 1),
        UNSIGNED_16(9, 2),
        UNSIGNED_32(10, 4),
        UNSIGNED_64(11, 8),
        BOOLEAN(12, 1),
        UNSIGNED_5_6_5(13, 2),
        UNSIGNED_5_5_5_1(14, 2),
        UNSIGNED_4_4_4_4(15, 2),
        MATRIX_4X4(16, 64),
        MATRIX_3X3(17, 36),
        MATRIX_2X2(18, 16),
        RS_ELEMENT(1000),
        RS_TYPE(1001),
        RS_ALLOCATION(1002),
        RS_SAMPLER(1003),
        RS_SCRIPT(1004),
        RS_MESH(1005),
        RS_PROGRAM_FRAGMENT(1006),
        RS_PROGRAM_VERTEX(1007),
        RS_PROGRAM_RASTER(1008),
        RS_PROGRAM_STORE(1009),
        RS_FONT(1010);

        int mID;
        int mSize;

        private DataType(int id2, int size) {
            this.mID = id2;
            this.mSize = size;
        }

        private DataType(int id2) {
            this.mID = id2;
            this.mSize = 4;
            if (RenderScript.sPointerSize == 8) {
                this.mSize = 32;
            }
        }
    }

    public static enum DataKind {
        USER(0),
        PIXEL_L(7),
        PIXEL_A(8),
        PIXEL_LA(9),
        PIXEL_RGB(10),
        PIXEL_RGBA(11),
        PIXEL_DEPTH(12),
        PIXEL_YUV(13);

        int mID;

        private DataKind(int id2) {
            this.mID = id2;
        }
    }

    public static class Builder {
        RenderScript mRS;
        Element[] mElements;
        String[] mElementNames;
        int[] mArraySizes;
        int mCount;
        int mSkipPadding;

        public Builder(RenderScript rs) {
            this.mRS = rs;
            this.mCount = 0;
            this.mElements = new Element[8];
            this.mElementNames = new String[8];
            this.mArraySizes = new int[8];
        }

        public Builder add(Element element, String name, int arraySize) {
            if (arraySize < 1) {
                throw new RSIllegalArgumentException("Array size cannot be less than 1.");
            }
            if (this.mSkipPadding != 0 && name.startsWith("#padding_")) {
                this.mSkipPadding = 0;
                return this;
            }
            this.mSkipPadding = element.mVectorSize == 3 ? 1 : 0;
            if (this.mCount == this.mElements.length) {
                Element[] e = new Element[this.mCount + 8];
                String[] s = new String[this.mCount + 8];
                int[] as = new int[this.mCount + 8];
                System.arraycopy(this.mElements, 0, e, 0, this.mCount);
                System.arraycopy(this.mElementNames, 0, s, 0, this.mCount);
                System.arraycopy(this.mArraySizes, 0, as, 0, this.mCount);
                this.mElements = e;
                this.mElementNames = s;
                this.mArraySizes = as;
            }
            this.mElements[this.mCount] = element;
            this.mElementNames[this.mCount] = name;
            this.mArraySizes[this.mCount] = arraySize;
            ++this.mCount;
            return this;
        }

        public Builder add(Element element, String name) {
            return this.add(element, name, 1);
        }

        public Element create() {
            this.mRS.validate();
            Element[] ein = new Element[this.mCount];
            String[] sin = new String[this.mCount];
            int[] asin = new int[this.mCount];
            System.arraycopy(this.mElements, 0, ein, 0, this.mCount);
            System.arraycopy(this.mElementNames, 0, sin, 0, this.mCount);
            System.arraycopy(this.mArraySizes, 0, asin, 0, this.mCount);
            long[] ids = new long[ein.length];
            for (int ct = 0; ct < ein.length; ++ct) {
                ids[ct] = ein[ct].getID(this.mRS);
            }
            long id2 = this.mRS.nElementCreate2(ids, sin, asin);
            return new Element(id2, this.mRS, ein, sin, asin);
        }
    }
}

