/*
 * Decompiled with CFR 0.152.
 */
package android.os.incremental;

import android.annotation.NonNull;
import android.os.PersistableBundle;

public class IncrementalMetrics {
    @NonNull
    private final PersistableBundle mData;

    public IncrementalMetrics(@NonNull PersistableBundle data) {
        this.mData = data;
    }

    public long getMillisSinceOldestPendingRead() {
        return this.mData.getLong("millisSinceOldestPendingRead", -1L);
    }

    public boolean getReadLogsEnabled() {
        return this.mData.getBoolean("readLogsEnabled", false);
    }

    public int getStorageHealthStatusCode() {
        return this.mData.getInt("storageHealthStatusCode", -1);
    }

    public int getDataLoaderStatusCode() {
        return this.mData.getInt("dataLoaderStatusCode", -1);
    }

    public long getMillisSinceLastDataLoaderBind() {
        return this.mData.getLong("millisSinceLastDataLoaderBind", -1L);
    }

    public long getDataLoaderBindDelayMillis() {
        return this.mData.getLong("dataLoaderBindDelayMillis", -1L);
    }

    public int getTotalDelayedReads() {
        return this.mData.getInt("totalDelayedReads", -1);
    }

    public int getTotalFailedReads() {
        return this.mData.getInt("totalFailedReads", -1);
    }

    public long getTotalDelayedReadsDurationMillis() {
        return this.mData.getLong("totalDelayedReadsMillis", -1L);
    }

    public int getLastReadErrorUid() {
        return this.mData.getInt("lastReadErrorUid", -1);
    }

    public long getMillisSinceLastReadError() {
        return this.mData.getLong("millisSinceLastReadError", -1L);
    }

    public int getLastReadErrorNumber() {
        return this.mData.getInt("lastReadErrorNo", -1);
    }
}

