/*
 * Decompiled with CFR 0.152.
 */
package android.os.flagging;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.provider.internal.aconfig.storage.android.util.proto.ProtoInputStream;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AconfigdProtoStreamer {
    private static final String SYSTEM_SOCKET_ADDRESS = "aconfigd_system";
    private static final String MAINLINE_SOCKET_ADDRESS = "aconfigd_mainline";
    private static final String TAG = "FlagManager";

    public void sendClearFlagOverrideRequests(@NonNull Set<String> flags, long removeType) throws IOException {
        ProtoOutputStream requestOutputStream = new ProtoOutputStream();
        for (Flag flag : Flag.buildFlagsWithoutValues(flags)) {
            long msgsToken = requestOutputStream.start(2246267895809L);
            long msgToken = requestOutputStream.start(1146756268037L);
            requestOutputStream.write(1138166333442L, flag.packageName);
            requestOutputStream.write(1138166333443L, flag.flagName);
            requestOutputStream.write(0x10800000001L, false);
            requestOutputStream.write(1159641169924L, removeType);
            requestOutputStream.end(msgToken);
            requestOutputStream.end(msgsToken);
        }
        this.sendBytesAndParseResponse(requestOutputStream.getBytes(), 1146756268037L);
    }

    public void sendOtaFlagOverrideRequests(@NonNull Map<String, Boolean> flags, @NonNull String buildFingerprint) throws IOException {
        ProtoOutputStream requestOutputStream = new ProtoOutputStream();
        long msgsToken = requestOutputStream.start(2246267895809L);
        long msgToken = requestOutputStream.start(1146756268035L);
        requestOutputStream.write(0x10900000001L, buildFingerprint);
        for (Flag flag : Flag.buildFlags(flags)) {
            long flagOverrideMsgToken = requestOutputStream.start(1146756268034L);
            requestOutputStream.write(0x10900000001L, flag.packageName);
            requestOutputStream.write(1138166333442L, flag.flagName);
            requestOutputStream.write(1138166333443L, flag.value);
            requestOutputStream.end(flagOverrideMsgToken);
        }
        requestOutputStream.end(msgToken);
        requestOutputStream.end(msgsToken);
        this.sendBytesAndParseResponse(requestOutputStream.getBytes(), 1146756268035L);
    }

    public void sendFlagOverrideRequests(@NonNull Map<String, Boolean> flags, long overrideType) throws IOException {
        ProtoOutputStream requestOutputStream = new ProtoOutputStream();
        for (Flag flag : Flag.buildFlags(flags)) {
            long msgsToken = requestOutputStream.start(2246267895809L);
            long msgToken = requestOutputStream.start(1146756268034L);
            requestOutputStream.write(0x10900000001L, flag.packageName);
            requestOutputStream.write(1138166333442L, flag.flagName);
            requestOutputStream.write(1138166333443L, flag.value);
            requestOutputStream.write(1159641169924L, overrideType);
            requestOutputStream.end(msgToken);
            requestOutputStream.end(msgsToken);
        }
        this.sendBytesAndParseResponse(requestOutputStream.getBytes(), 1146756268034L);
    }

    private void sendBytesAndParseResponse(byte[] requestBytes, long responseMessageToken) throws IOException {
        try {
            LocalSocket systemSocket = new LocalSocket();
            LocalSocketAddress systemAddress = new LocalSocketAddress(SYSTEM_SOCKET_ADDRESS, LocalSocketAddress.Namespace.RESERVED);
            if (!systemSocket.isConnected()) {
                systemSocket.connect(systemAddress);
            }
            InputStream inputStream = this.sendBytesOverSocket(requestBytes, systemSocket);
            this.parseAconfigdResponse(inputStream, responseMessageToken);
            systemSocket.shutdownInput();
            systemSocket.shutdownOutput();
            systemSocket.close();
        }
        catch (IOException systemException) {
            Slog.i(TAG, "failed to send request to system socket; trying mainline socket", systemException);
            LocalSocket mainlineSocket = new LocalSocket();
            LocalSocketAddress mainlineAddress = new LocalSocketAddress(MAINLINE_SOCKET_ADDRESS, LocalSocketAddress.Namespace.RESERVED);
            if (!mainlineSocket.isConnected()) {
                mainlineSocket.connect(mainlineAddress);
            }
            InputStream inputStream = this.sendBytesOverSocket(requestBytes, mainlineSocket);
            this.parseAconfigdResponse(inputStream, responseMessageToken);
            mainlineSocket.shutdownInput();
            mainlineSocket.shutdownOutput();
            mainlineSocket.close();
        }
    }

    private InputStream sendBytesOverSocket(byte[] requestBytes, LocalSocket socket) throws IOException {
        InputStream responseInputStream = null;
        DataInputStream inputStream = new DataInputStream(socket.getInputStream());
        DataOutputStream outputStream = new DataOutputStream(socket.getOutputStream());
        outputStream.writeInt(requestBytes.length);
        outputStream.write(requestBytes);
        responseInputStream = socket.getInputStream();
        return responseInputStream;
    }

    private void parseAconfigdResponse(InputStream inputStream, long responseMessageToken) throws IOException {
        ProtoInputStream proto = new ProtoInputStream(inputStream);
        long currentToken;
        while ((currentToken = (long)proto.nextField()) != -1L) {
            if (currentToken != 1L) continue;
            long msgsToken = proto.start(2246267895809L);
            long nextToken = proto.nextField();
            if (nextToken == (long)((int)responseMessageToken)) {
                long msgToken = proto.start(responseMessageToken);
                proto.end(msgToken);
            } else {
                if (nextToken == 8L) {
                    String errmsg = proto.readString(1138166333448L);
                    throw new IOException("override request failed: " + errmsg);
                }
                if (nextToken != -1L) {
                    throw new IOException("invalid message type, expecting only return message or error message");
                }
            }
            proto.end(msgsToken);
        }
        return;
    }

    private static class Flag {
        public final String packageName;
        public final String flagName;
        public final String value;

        public Flag(@NonNull String packageName, @NonNull String flagName, @Nullable Boolean value) {
            this.packageName = packageName;
            this.flagName = flagName;
            this.value = value != null ? Boolean.toString(value) : null;
        }

        public static Set<Flag> buildFlags(@NonNull Map<String, Boolean> flags) {
            HashSet<Flag> flagSet = new HashSet<Flag>();
            for (Map.Entry<String, Boolean> flagAndValue : flags.entrySet()) {
                String packageName = "";
                String flagName = flagAndValue.getKey();
                int periodIndex = flagName.lastIndexOf(".");
                if (periodIndex != -1) {
                    packageName = flagName.substring(0, flagName.lastIndexOf("."));
                    flagName = flagName.substring(flagName.lastIndexOf(".") + 1);
                }
                flagSet.add(new Flag(packageName, flagName, flagAndValue.getValue()));
            }
            return flagSet;
        }

        public static Set<Flag> buildFlagsWithoutValues(@NonNull Set<String> flags) {
            HashSet<Flag> flagSet = new HashSet<Flag>();
            for (String qualifiedFlagName : flags) {
                String packageName = "";
                String flagName = qualifiedFlagName;
                int periodIndex = qualifiedFlagName.lastIndexOf(".");
                if (periodIndex != -1) {
                    packageName = qualifiedFlagName.substring(0, qualifiedFlagName.lastIndexOf("."));
                    flagName = qualifiedFlagName.substring(qualifiedFlagName.lastIndexOf(".") + 1);
                }
                flagSet.add(new Flag(packageName, flagName, null));
            }
            return flagSet;
        }
    }
}

