/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.FlaggedApi;
import android.annotation.Nullable;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.ArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;

@RavenwoodKeepWholeClass
public class TestLooperManager {
    private static final ArraySet<Looper> sHeldLoopers = new ArraySet();
    private final MessageQueue mQueue;
    private final Looper mLooper;
    private final LinkedBlockingQueue<MessageExecution> mExecuteQueue = new LinkedBlockingQueue();
    private final boolean mLooperIsMyLooper;
    private final CountDownLatch mLooperHolderLatch = new CountDownLatch(1);
    private boolean mReleased;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestLooperManager(Looper looper) {
        ArraySet<Looper> arraySet = sHeldLoopers;
        synchronized (arraySet) {
            if (sHeldLoopers.contains(looper)) {
                throw new RuntimeException("TestLooperManager already held for this looper");
            }
            sHeldLoopers.add(looper);
        }
        this.mLooper = looper;
        this.mQueue = this.mLooper.getQueue();
        boolean bl = this.mLooperIsMyLooper = Looper.myLooper() == looper;
        if (!this.mLooperIsMyLooper) {
            new Handler(looper).post(new LooperHolder());
        } else {
            this.mLooperHolderLatch.countDown();
        }
    }

    public MessageQueue getMessageQueue() {
        this.checkReleased();
        return this.mQueue;
    }

    @Deprecated
    public MessageQueue getQueue() {
        return this.getMessageQueue();
    }

    public Message next() {
        this.checkReleased();
        this.waitForLooperHolder();
        return this.mQueue.next();
    }

    @FlaggedApi(value="android.os.message_queue_testability")
    @Nullable
    public Message poll() {
        this.checkReleased();
        this.waitForLooperHolder();
        return this.mQueue.pollForTest();
    }

    @FlaggedApi(value="android.os.message_queue_testability")
    @Nullable
    public Long peekWhen() {
        this.checkReleased();
        this.waitForLooperHolder();
        return this.mQueue.peekWhenForTest();
    }

    @FlaggedApi(value="android.os.message_queue_testability")
    public boolean isBlockedOnSyncBarrier() {
        this.checkReleased();
        this.waitForLooperHolder();
        return this.mQueue.isBlockedOnSyncBarrier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        ArraySet<Looper> arraySet = sHeldLoopers;
        synchronized (arraySet) {
            sHeldLoopers.remove(this.mLooper);
        }
        this.checkReleased();
        this.mReleased = true;
        this.mExecuteQueue.add(new MessageExecution());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Message message) {
        this.checkReleased();
        if (this.mLooper.isCurrentThread()) {
            message.target.dispatchMessage(message);
        } else {
            if (this.mLooperIsMyLooper) {
                throw new RuntimeException("Cannot call execute from non Looper thread");
            }
            MessageExecution execution = new MessageExecution();
            execution.m = message;
            MessageExecution messageExecution = execution;
            synchronized (messageExecution) {
                this.mExecuteQueue.add(execution);
                try {
                    execution.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (execution.response != null) {
                    throw new RuntimeException(execution.response);
                }
            }
        }
    }

    public void recycle(Message msg) {
        this.checkReleased();
        msg.recycleUnchecked();
    }

    public boolean hasMessages(Handler h, Object object, int what) {
        this.checkReleased();
        return this.mQueue.hasMessages(h, what, object);
    }

    public boolean hasMessages(Handler h, Object object, Runnable r) {
        this.checkReleased();
        return this.mQueue.hasMessages(h, r, object);
    }

    private void checkReleased() {
        if (this.mReleased) {
            throw new RuntimeException("release() has already be called");
        }
    }

    private void waitForLooperHolder() {
        try {
            this.mLooperHolderLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private class LooperHolder
    implements Runnable {
        private LooperHolder() {
        }

        @Override
        public void run() {
            TestLooperManager.this.mLooperHolderLatch.countDown();
            while (!TestLooperManager.this.mReleased) {
                try {
                    MessageExecution take = TestLooperManager.this.mExecuteQueue.take();
                    if (take.m == null) continue;
                    this.processMessage(take);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processMessage(MessageExecution mex) {
            MessageExecution messageExecution = mex;
            synchronized (messageExecution) {
                try {
                    mex.m.target.dispatchMessage(mex.m);
                    mex.response = null;
                }
                catch (Throwable t) {
                    mex.response = t;
                }
                mex.notifyAll();
            }
        }
    }

    private static class MessageExecution {
        private Message m;
        private Throwable response;

        private MessageExecution() {
        }
    }
}

