/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.app.IAlarmManager;
import android.app.time.UnixEpochTime;
import android.app.timedetector.ITimeDetectorService;
import android.compat.annotation.UnsupportedAppUsage;
import android.location.ILocationManager;
import android.location.LocationTime;
import android.os.DeadSystemException;
import android.os.ParcelableException;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SimpleClock;
import android.os.SystemClock_Delegate;
import android.ravenwood.annotation.RavenwoodKeep;
import android.ravenwood.annotation.RavenwoodReplace;
import android.util.Slog;
import com.android.internal.lang.System_Delegate;
import com.android.internal.os.ApplicationSharedMemory;
import com.android.internal.os.Flags;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import dalvik.annotation.optimization.CriticalNative;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.ZoneOffset;

public class SystemClock {
    private static final String TAG = "SystemClock";
    private static volatile IAlarmManager sIAlarmManager;
    private static volatile ITimeDetectorService sITimeDetectorService;
    private static final long sAnchorNanoTime$ravenwood;

    @UnsupportedAppUsage
    private SystemClock() {
    }

    @RavenwoodKeep
    public static void sleep(long ms) {
        long start = SystemClock.uptimeMillis();
        long duration = ms;
        boolean interrupted = false;
        do {
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        } while ((duration = start + ms - SystemClock.uptimeMillis()) > 0L);
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public static boolean setCurrentTimeMillis(long millis) {
        IAlarmManager mgr = SystemClock.getIAlarmManager();
        if (mgr == null) {
            Slog.e(TAG, "Unable to set RTC: mgr == null");
            return false;
        }
        try {
            return mgr.setTime(millis);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Unable to set RTC", e);
        }
        catch (SecurityException e) {
            Slog.e(TAG, "Unable to set RTC", e);
        }
        return false;
    }

    private static IAlarmManager getIAlarmManager() {
        if (sIAlarmManager == null) {
            sIAlarmManager = IAlarmManager.Stub.asInterface(ServiceManager.getService("alarm"));
        }
        return sIAlarmManager;
    }

    private static ITimeDetectorService getITimeDetectorService() {
        if (sITimeDetectorService == null) {
            sITimeDetectorService = ITimeDetectorService.Stub.asInterface(ServiceManager.getService("time_detector"));
        }
        return sITimeDetectorService;
    }

    @LayoutlibDelegate
    @CriticalNative
    @RavenwoodReplace
    public static long uptimeMillis() {
        return SystemClock_Delegate.uptimeMillis();
    }

    public static long uptimeMillis$ravenwood() {
        return SystemClock.uptimeNanos() / 1000000L;
    }

    @LayoutlibDelegate
    @FlaggedApi(value="android.os.adpf_gpu_report_actual_work_duration")
    @CriticalNative
    @RavenwoodReplace
    public static long uptimeNanos() {
        return SystemClock_Delegate.uptimeNanos();
    }

    public static long uptimeNanos$ravenwood() {
        return System_Delegate.nanoTime() - sAnchorNanoTime$ravenwood;
    }

    @NonNull
    public static Clock uptimeClock() {
        return new SimpleClock(ZoneOffset.UTC){

            @Override
            public long millis() {
                return SystemClock.uptimeMillis();
            }
        };
    }

    @LayoutlibDelegate
    @CriticalNative
    @RavenwoodReplace
    public static long elapsedRealtime() {
        return SystemClock_Delegate.elapsedRealtime();
    }

    public static long elapsedRealtime$ravenwood() {
        return SystemClock.elapsedRealtimeNanos() / 1000000L;
    }

    @NonNull
    public static Clock elapsedRealtimeClock() {
        return new SimpleClock(ZoneOffset.UTC){

            @Override
            public long millis() {
                return SystemClock.elapsedRealtime();
            }
        };
    }

    @LayoutlibDelegate
    @CriticalNative
    @RavenwoodReplace
    public static long elapsedRealtimeNanos() {
        return SystemClock_Delegate.elapsedRealtimeNanos();
    }

    public static long elapsedRealtimeNanos$ravenwood() {
        return SystemClock.uptimeNanos() + 3600000000000L;
    }

    @LayoutlibDelegate
    @CriticalNative
    public static long currentThreadTimeMillis() {
        return SystemClock_Delegate.currentThreadTimeMillis();
    }

    @LayoutlibDelegate
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @CriticalNative
    public static long currentThreadTimeMicro() {
        return SystemClock_Delegate.currentThreadTimeMicro();
    }

    @LayoutlibDelegate
    @UnsupportedAppUsage
    @CriticalNative
    @RavenwoodReplace
    public static long currentTimeMicro() {
        return SystemClock_Delegate.currentTimeMicro();
    }

    public static long currentTimeMicro$ravenwood() {
        return System_Delegate.nanoTime() / 1000L;
    }

    public static long currentNetworkTimeMillis() {
        UnixEpochTime time;
        if (Flags.applicationSharedMemoryEnabled() && com.android.internal.hidden_from_bootclasspath.android.os.Flags.networkTimeUsesSharedMemory()) {
            long latestNetworkTimeUnixEpochMillisAtZeroElapsedRealtimeMillis = ApplicationSharedMemory.getInstance().getLatestNetworkTimeUnixEpochMillisAtZeroElapsedRealtimeMillis();
            return latestNetworkTimeUnixEpochMillisAtZeroElapsedRealtimeMillis + SystemClock.elapsedRealtime();
        }
        ITimeDetectorService timeDetectorService = SystemClock.getITimeDetectorService();
        if (timeDetectorService == null) {
            throw new RuntimeException(new DeadSystemException());
        }
        try {
            time = timeDetectorService.latestNetworkTime();
        }
        catch (ParcelableException e) {
            e.maybeRethrow(DateTimeException.class);
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        if (time == null) {
            throw new DateTimeException("Network based time is not available.");
        }
        long currentMillis = SystemClock.elapsedRealtime();
        long deltaMs = currentMillis - time.getElapsedRealtimeMillis();
        return time.getUnixEpochTimeMillis() + deltaMs;
    }

    @NonNull
    public static Clock currentNetworkTimeClock() {
        return new SimpleClock(ZoneOffset.UTC){

            @Override
            public long millis() {
                return SystemClock.currentNetworkTimeMillis();
            }
        };
    }

    @NonNull
    public static Clock currentGnssTimeClock() {
        return new SimpleClock(ZoneOffset.UTC){
            private final ILocationManager mMgr = ILocationManager.Stub.asInterface(ServiceManager.getService("location"));

            @Override
            public long millis() {
                LocationTime time;
                try {
                    time = this.mMgr.getGnssTimeMillis();
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                if (time == null) {
                    throw new DateTimeException("Gnss based time is not available.");
                }
                long currentNanos = SystemClock.elapsedRealtimeNanos();
                long deltaMs = (currentNanos - time.getElapsedRealtimeNanos()) / 1000000L;
                return time.getUnixEpochTimeMillis() + deltaMs;
            }
        };
    }

    static {
        sAnchorNanoTime$ravenwood = System_Delegate.nanoTime();
    }
}

