/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.os.ProfilingTriggerValueParcel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@FlaggedApi(value="android.os.profiling.system_triggered_profiling_new")
public class ProfilingTrigger {
    public static final int TRIGGER_TYPE_NONE = 0;
    public static final int TRIGGER_TYPE_APP_FULLY_DRAWN = 1;
    public static final int TRIGGER_TYPE_ANR = 2;
    private final int mTriggerType;
    private final int mRateLimitingPeriodHours;

    private ProfilingTrigger(int triggerType, int rateLimitingPeriodHours) {
        this.mTriggerType = triggerType;
        this.mRateLimitingPeriodHours = rateLimitingPeriodHours;
    }

    public int getTriggerType() {
        return this.mTriggerType;
    }

    public int getRateLimitingPeriodHours() {
        return this.mRateLimitingPeriodHours;
    }

    public ProfilingTriggerValueParcel toValueParcel() {
        ProfilingTriggerValueParcel valueParcel = new ProfilingTriggerValueParcel();
        valueParcel.triggerType = this.mTriggerType;
        valueParcel.rateLimitingPeriodHours = this.mRateLimitingPeriodHours;
        return valueParcel;
    }

    public static boolean isValidRequestTriggerType(int triggerType) {
        return triggerType == 1 || triggerType == 2;
    }

    @FlaggedApi(value="android.os.profiling.system_triggered_profiling_new")
    public static class Builder {
        private int mBuilderTriggerType;
        private int mBuilderRateLimitingPeriodHours = 0;

        public Builder(int triggerType) {
            if (!ProfilingTrigger.isValidRequestTriggerType(triggerType)) {
                throw new IllegalArgumentException("Invalid trigger type.");
            }
            this.mBuilderTriggerType = triggerType;
        }

        @NonNull
        public ProfilingTrigger build() {
            return new ProfilingTrigger(this.mBuilderTriggerType, this.mBuilderRateLimitingPeriodHours);
        }

        @NonNull
        public Builder setRateLimitingPeriodHours(int rateLimitingPeriodHours) {
            if (rateLimitingPeriodHours < 0) {
                throw new IllegalArgumentException("Hours can't be negative. Try again.");
            }
            this.mBuilderRateLimitingPeriodHours = rateLimitingPeriodHours;
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface TriggerType {
    }
}

