/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.ServiceManager;
import android.os.WorkDuration;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.Closeable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.Reference;
import java.util.Objects;

public class PerformanceHintManager {
    private final long mNativeManagerPtr;

    public static PerformanceHintManager create() throws ServiceManager.ServiceNotFoundException {
        long nativeManagerPtr = PerformanceHintManager.nativeAcquireManager();
        if (nativeManagerPtr == 0L) {
            throw new ServiceManager.ServiceNotFoundException("performance_hint");
        }
        return new PerformanceHintManager(nativeManagerPtr);
    }

    private PerformanceHintManager(long nativeManagerPtr) {
        this.mNativeManagerPtr = nativeManagerPtr;
    }

    public long getPreferredUpdateRateNanos() {
        return PerformanceHintManager.nativeGetPreferredUpdateRateNanos(this.mNativeManagerPtr);
    }

    @Nullable
    public Session createHintSession(@NonNull int[] tids, long initialTargetWorkDurationNanos) {
        Objects.requireNonNull(tids, "tids cannot be null");
        if (tids.length == 0) {
            throw new IllegalArgumentException("thread id list can't be empty.");
        }
        Preconditions.checkArgumentPositive(initialTargetWorkDurationNanos, "the hint target duration should be positive.");
        long nativeSessionPtr = PerformanceHintManager.nativeCreateSession(this.mNativeManagerPtr, tids, initialTargetWorkDurationNanos);
        if (nativeSessionPtr == 0L) {
            return null;
        }
        return new Session(nativeSessionPtr);
    }

    private static long nativeAcquireManager() {
        return OverrideMethod.invokeL("android.os.PerformanceHintManager#nativeAcquireManager()J", true, null);
    }

    private static long nativeGetPreferredUpdateRateNanos(long l) {
        return OverrideMethod.invokeL("android.os.PerformanceHintManager#nativeGetPreferredUpdateRateNanos(J)J", true, null);
    }

    private static long nativeCreateSession(long l, int[] nArray, long l2) {
        return OverrideMethod.invokeL("android.os.PerformanceHintManager#nativeCreateSession(J[IJ)J", true, null);
    }

    private static int[] nativeGetThreadIds(long l) {
        return (int[])OverrideMethod.invokeA("android.os.PerformanceHintManager#nativeGetThreadIds(J)[I", true, null);
    }

    private static void nativeUpdateTargetWorkDuration(long l, long l2) {
        OverrideMethod.invokeV("android.os.PerformanceHintManager#nativeUpdateTargetWorkDuration(JJ)V", true, null);
    }

    private static void nativeReportActualWorkDuration(long l, long l2) {
        OverrideMethod.invokeV("android.os.PerformanceHintManager#nativeReportActualWorkDuration(JJ)V", true, null);
    }

    private static void nativeCloseSession(long l) {
        OverrideMethod.invokeV("android.os.PerformanceHintManager#nativeCloseSession(J)V", true, null);
    }

    private static void nativeSendHint(long l, int n) {
        OverrideMethod.invokeV("android.os.PerformanceHintManager#nativeSendHint(JI)V", true, null);
    }

    private static void nativeSetThreads(long l, int[] nArray) {
        OverrideMethod.invokeV("android.os.PerformanceHintManager#nativeSetThreads(J[I)V", true, null);
    }

    private static void nativeSetPreferPowerEfficiency(long l, boolean bl) {
        OverrideMethod.invokeV("android.os.PerformanceHintManager#nativeSetPreferPowerEfficiency(JZ)V", true, null);
    }

    private static void nativeReportActualWorkDuration(long l, long l2, long l3, long l4, long l5) {
        OverrideMethod.invokeV("android.os.PerformanceHintManager#nativeReportActualWorkDuration(JJJJJ)V", true, null);
    }

    public static class Session
    implements Closeable {
        @UnsupportedAppUsage
        public long mNativeSessionPtr;
        public static final int CPU_LOAD_UP = 0;
        public static final int CPU_LOAD_DOWN = 1;
        public static final int CPU_LOAD_RESET = 2;
        public static final int CPU_LOAD_RESUME = 3;
        @FlaggedApi(value="android.os.adpf_gpu_report_actual_work_duration")
        public static final int GPU_LOAD_UP = 5;
        @FlaggedApi(value="android.os.adpf_gpu_report_actual_work_duration")
        public static final int GPU_LOAD_DOWN = 6;
        @FlaggedApi(value="android.os.adpf_gpu_report_actual_work_duration")
        public static final int GPU_LOAD_RESET = 7;

        public Session(long nativeSessionPtr) {
            this.mNativeSessionPtr = nativeSessionPtr;
        }

        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }

        public void updateTargetWorkDuration(long targetDurationNanos) {
            Preconditions.checkArgumentPositive(targetDurationNanos, "the hint target duration should be positive.");
            PerformanceHintManager.nativeUpdateTargetWorkDuration(this.mNativeSessionPtr, targetDurationNanos);
        }

        public void reportActualWorkDuration(long actualDurationNanos) {
            Preconditions.checkArgumentPositive(actualDurationNanos, "the actual duration should be positive.");
            PerformanceHintManager.nativeReportActualWorkDuration(this.mNativeSessionPtr, actualDurationNanos);
        }

        @Override
        public void close() {
            if (this.mNativeSessionPtr != 0L) {
                PerformanceHintManager.nativeCloseSession(this.mNativeSessionPtr);
                this.mNativeSessionPtr = 0L;
            }
        }

        public void sendHint(int hint) {
            Preconditions.checkArgumentNonNegative(hint, "the hint ID should be at least zero.");
            try {
                PerformanceHintManager.nativeSendHint(this.mNativeSessionPtr, hint);
            }
            finally {
                Reference.reachabilityFence(this);
            }
        }

        @FlaggedApi(value="android.os.adpf_prefer_power_efficiency")
        public void setPreferPowerEfficiency(boolean enabled) {
            PerformanceHintManager.nativeSetPreferPowerEfficiency(this.mNativeSessionPtr, enabled);
        }

        public void setThreads(@NonNull int[] tids) {
            if (this.mNativeSessionPtr == 0L) {
                return;
            }
            Objects.requireNonNull(tids, "tids cannot be null");
            if (tids.length == 0) {
                throw new IllegalArgumentException("Thread id list can't be empty.");
            }
            PerformanceHintManager.nativeSetThreads(this.mNativeSessionPtr, tids);
        }

        @Nullable
        public int[] getThreadIds() {
            return PerformanceHintManager.nativeGetThreadIds(this.mNativeSessionPtr);
        }

        @FlaggedApi(value="android.os.adpf_gpu_report_actual_work_duration")
        public void reportActualWorkDuration(@NonNull WorkDuration workDuration) {
            if (workDuration.mWorkPeriodStartTimestampNanos <= 0L) {
                throw new IllegalArgumentException("the work period start timestamp should be greater than zero.");
            }
            if (workDuration.mActualTotalDurationNanos <= 0L) {
                throw new IllegalArgumentException("the actual total duration should be greater than zero.");
            }
            if (workDuration.mActualCpuDurationNanos < 0L) {
                throw new IllegalArgumentException("the actual CPU duration should be greater than or equal to zero.");
            }
            if (workDuration.mActualGpuDurationNanos < 0L) {
                throw new IllegalArgumentException("the actual GPU duration should be greater than or equal to zero.");
            }
            if (workDuration.mActualCpuDurationNanos + workDuration.mActualGpuDurationNanos <= 0L) {
                throw new IllegalArgumentException("either the actual CPU duration or the actual GPU duration should be greaterthan zero.");
            }
            PerformanceHintManager.nativeReportActualWorkDuration(this.mNativeSessionPtr, workDuration.mWorkPeriodStartTimestampNanos, workDuration.mActualTotalDurationNanos, workDuration.mActualCpuDurationNanos, workDuration.mActualGpuDurationNanos);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Hint {
        }
    }
}

