/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ITradeInMode
extends IInterface {
    public static final String DESCRIPTOR = "android.os.ITradeInMode";

    public boolean start() throws RemoteException;

    public boolean isEvaluationModeAllowed() throws RemoteException;

    public boolean enterEvaluationMode() throws RemoteException;

    public void scheduleWipeForTesting() throws RemoteException;

    public void startTesting() throws RemoteException;

    public void stopTesting() throws RemoteException;

    public boolean isTesting() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITradeInMode {
        static final int TRANSACTION_start = 1;
        static final int TRANSACTION_isEvaluationModeAllowed = 2;
        static final int TRANSACTION_enterEvaluationMode = 3;
        static final int TRANSACTION_scheduleWipeForTesting = 4;
        static final int TRANSACTION_startTesting = 5;
        static final int TRANSACTION_stopTesting = 6;
        static final int TRANSACTION_isTesting = 7;

        public Stub() {
            this.attachInterface(this, ITradeInMode.DESCRIPTOR);
        }

        public static ITradeInMode asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITradeInMode.DESCRIPTOR);
            if (iin != null && iin instanceof ITradeInMode) {
                return (ITradeInMode)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "start";
                }
                case 2: {
                    return "isEvaluationModeAllowed";
                }
                case 3: {
                    return "enterEvaluationMode";
                }
                case 4: {
                    return "scheduleWipeForTesting";
                }
                case 5: {
                    return "startTesting";
                }
                case 6: {
                    return "stopTesting";
                }
                case 7: {
                    return "isTesting";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITradeInMode.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    boolean _result = this.start();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 2: {
                    boolean _result = this.isEvaluationModeAllowed();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 3: {
                    boolean _result = this.enterEvaluationMode();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 4: {
                    this.scheduleWipeForTesting();
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    this.startTesting();
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    this.stopTesting();
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    boolean _result = this.isTesting();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 6;
        }

        private static class Proxy
        implements ITradeInMode {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITradeInMode.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean start() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITradeInMode.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isEvaluationModeAllowed() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITradeInMode.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean enterEvaluationMode() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITradeInMode.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void scheduleWipeForTesting() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITradeInMode.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startTesting() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITradeInMode.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopTesting() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITradeInMode.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isTesting() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITradeInMode.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ITradeInMode {
        @Override
        public boolean start() throws RemoteException {
            return false;
        }

        @Override
        public boolean isEvaluationModeAllowed() throws RemoteException {
            return false;
        }

        @Override
        public boolean enterEvaluationMode() throws RemoteException {
            return false;
        }

        @Override
        public void scheduleWipeForTesting() throws RemoteException {
        }

        @Override
        public void startTesting() throws RemoteException {
        }

        @Override
        public void stopTesting() throws RemoteException {
        }

        @Override
        public boolean isTesting() throws RemoteException {
            return false;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

