/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.IProfilingResultCallback;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.ProfilingTriggerValueParcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IProfilingService
extends IInterface {
    public static final String DESCRIPTOR = "android.os.IProfilingService";

    public void requestProfiling(int var1, Bundle var2, String var3, long var4, long var6, String var8) throws RemoteException;

    public void registerResultsCallback(boolean var1, IProfilingResultCallback var2) throws RemoteException;

    public void generalListenerAdded() throws RemoteException;

    public void requestCancel(long var1, long var3) throws RemoteException;

    public void receiveFileDescriptor(ParcelFileDescriptor var1, long var2, long var4) throws RemoteException;

    public void addProfilingTriggers(List<ProfilingTriggerValueParcel> var1, String var2) throws RemoteException;

    public void removeProfilingTriggers(int[] var1, String var2) throws RemoteException;

    public void clearProfilingTriggers(String var1) throws RemoteException;

    public void processTrigger(int var1, String var2, int var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IProfilingService {
        static final int TRANSACTION_requestProfiling = 1;
        static final int TRANSACTION_registerResultsCallback = 2;
        static final int TRANSACTION_generalListenerAdded = 3;
        static final int TRANSACTION_requestCancel = 4;
        static final int TRANSACTION_receiveFileDescriptor = 5;
        static final int TRANSACTION_addProfilingTriggers = 6;
        static final int TRANSACTION_removeProfilingTriggers = 7;
        static final int TRANSACTION_clearProfilingTriggers = 8;
        static final int TRANSACTION_processTrigger = 9;

        public Stub() {
            this.attachInterface(this, IProfilingService.DESCRIPTOR);
        }

        public static IProfilingService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IProfilingService.DESCRIPTOR);
            if (iin != null && iin instanceof IProfilingService) {
                return (IProfilingService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "requestProfiling";
                }
                case 2: {
                    return "registerResultsCallback";
                }
                case 3: {
                    return "generalListenerAdded";
                }
                case 4: {
                    return "requestCancel";
                }
                case 5: {
                    return "receiveFileDescriptor";
                }
                case 6: {
                    return "addProfilingTriggers";
                }
                case 7: {
                    return "removeProfilingTriggers";
                }
                case 8: {
                    return "clearProfilingTriggers";
                }
                case 9: {
                    return "processTrigger";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IProfilingService.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    String _arg2 = data.readString();
                    long _arg3 = data.readLong();
                    long _arg4 = data.readLong();
                    String _arg5 = data.readString();
                    data.enforceNoDataAvail();
                    this.requestProfiling(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    break;
                }
                case 2: {
                    boolean _arg0 = data.readBoolean();
                    IProfilingResultCallback _arg1 = IProfilingResultCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerResultsCallback(_arg0, _arg1);
                    break;
                }
                case 3: {
                    this.generalListenerAdded();
                    break;
                }
                case 4: {
                    long _arg0 = data.readLong();
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    this.requestCancel(_arg0, _arg1);
                    break;
                }
                case 5: {
                    ParcelFileDescriptor _arg0 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    long _arg1 = data.readLong();
                    long _arg2 = data.readLong();
                    data.enforceNoDataAvail();
                    this.receiveFileDescriptor(_arg0, _arg1, _arg2);
                    break;
                }
                case 6: {
                    ArrayList<ProfilingTriggerValueParcel> _arg0 = data.createTypedArrayList(ProfilingTriggerValueParcel.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.addProfilingTriggers(_arg0, _arg1);
                    break;
                }
                case 7: {
                    int[] _arg0 = data.createIntArray();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.removeProfilingTriggers(_arg0, _arg1);
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.clearProfilingTriggers(_arg0);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.processTrigger(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 8;
        }

        private static class Proxy
        implements IProfilingService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IProfilingService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestProfiling(int profilingType, Bundle params, String tag, long keyMostSigBits, long keyLeastSigBits, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IProfilingService.DESCRIPTOR);
                    _data.writeInt(profilingType);
                    _data.writeTypedObject(params, 0);
                    _data.writeString(tag);
                    _data.writeLong(keyMostSigBits);
                    _data.writeLong(keyLeastSigBits);
                    _data.writeString(packageName);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerResultsCallback(boolean isGeneralCallback, IProfilingResultCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IProfilingService.DESCRIPTOR);
                    _data.writeBoolean(isGeneralCallback);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void generalListenerAdded() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IProfilingService.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestCancel(long keyMostSigBits, long keyLeastSigBits) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IProfilingService.DESCRIPTOR);
                    _data.writeLong(keyMostSigBits);
                    _data.writeLong(keyLeastSigBits);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void receiveFileDescriptor(ParcelFileDescriptor fileDescriptor, long keyMostSigBits, long keyLeastSigBits) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IProfilingService.DESCRIPTOR);
                    _data.writeTypedObject(fileDescriptor, 0);
                    _data.writeLong(keyMostSigBits);
                    _data.writeLong(keyLeastSigBits);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addProfilingTriggers(List<ProfilingTriggerValueParcel> triggers, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IProfilingService.DESCRIPTOR);
                    _data.writeTypedList(triggers, 0);
                    _data.writeString(packageName);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeProfilingTriggers(int[] triggers, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IProfilingService.DESCRIPTOR);
                    _data.writeIntArray(triggers);
                    _data.writeString(packageName);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearProfilingTriggers(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IProfilingService.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processTrigger(int uid, String packageName, int triggerType) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IProfilingService.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeString(packageName);
                    _data.writeInt(triggerType);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IProfilingService {
        @Override
        public void requestProfiling(int profilingType, Bundle params, String tag, long keyMostSigBits, long keyLeastSigBits, String packageName) throws RemoteException {
        }

        @Override
        public void registerResultsCallback(boolean isGeneralCallback, IProfilingResultCallback callback) throws RemoteException {
        }

        @Override
        public void generalListenerAdded() throws RemoteException {
        }

        @Override
        public void requestCancel(long keyMostSigBits, long keyLeastSigBits) throws RemoteException {
        }

        @Override
        public void receiveFileDescriptor(ParcelFileDescriptor fileDescriptor, long keyMostSigBits, long keyLeastSigBits) throws RemoteException {
        }

        @Override
        public void addProfilingTriggers(List<ProfilingTriggerValueParcel> triggers, String packageName) throws RemoteException {
        }

        @Override
        public void removeProfilingTriggers(int[] triggers, String packageName) throws RemoteException {
        }

        @Override
        public void clearProfilingTriggers(String packageName) throws RemoteException {
        }

        @Override
        public void processTrigger(int uid, String packageName, int triggerType) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

