/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.VibrationEffect;
import android.os.VibratorInfo;
import android.os.vibrator.Flags;
import android.util.SparseArray;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;

public abstract class CombinedVibration
implements Parcelable {
    private static final int PARCEL_TOKEN_MONO = 1;
    private static final int PARCEL_TOKEN_STEREO = 2;
    private static final int PARCEL_TOKEN_SEQUENTIAL = 3;
    @NonNull
    public static final Parcelable.Creator<CombinedVibration> CREATOR = new Parcelable.Creator<CombinedVibration>(){

        @Override
        public CombinedVibration createFromParcel(Parcel in) {
            int token = in.readInt();
            if (token == 1) {
                return new Mono(in);
            }
            if (token == 2) {
                return new Stereo(in);
            }
            if (token == 3) {
                return new Sequential(in);
            }
            throw new IllegalStateException("Unexpected combined vibration event type token in parcel.");
        }

        public CombinedVibration[] newArray(int size) {
            return new CombinedVibration[size];
        }
    };

    CombinedVibration() {
    }

    @NonNull
    public static CombinedVibration createParallel(@NonNull VibrationEffect effect) {
        Mono combined = new Mono(effect);
        ((CombinedVibration)combined).validate();
        return combined;
    }

    @NonNull
    public static ParallelCombination startParallel() {
        return new ParallelCombination();
    }

    @NonNull
    public static SequentialCombination startSequential() {
        return new SequentialCombination();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public abstract long getDuration();

    public abstract long getDuration(@Nullable SparseArray<VibratorInfo> var1);

    public boolean isHapticFeedbackCandidate() {
        return false;
    }

    public abstract void validate();

    public abstract <ParamT> CombinedVibration transform(VibrationEffect.Transformation<ParamT> var1, ParamT var2);

    public abstract CombinedVibration adapt(VibratorAdapter var1);

    public abstract boolean hasVibrator(int var1);

    public abstract boolean hasVendorEffects();

    public abstract String toDebugString();

    public static class Mono
    extends CombinedVibration {
        private final VibrationEffect mEffect;
        @NonNull
        public static final Parcelable.Creator<Mono> CREATOR = new Parcelable.Creator<Mono>(){

            @Override
            public Mono createFromParcel(@NonNull Parcel in) {
                in.readInt();
                return new Mono(in);
            }

            @NonNull
            public Mono[] newArray(int size) {
                return new Mono[size];
            }
        };

        Mono(Parcel in) {
            this.mEffect = VibrationEffect.CREATOR.createFromParcel(in);
        }

        Mono(@NonNull VibrationEffect effect) {
            this.mEffect = effect;
        }

        @NonNull
        public VibrationEffect getEffect() {
            return this.mEffect;
        }

        @Override
        public long getDuration() {
            return this.mEffect.getDuration();
        }

        @Override
        public long getDuration(@Nullable SparseArray<VibratorInfo> vibratorInfos) {
            if (vibratorInfos == null) {
                return this.getDuration();
            }
            long maxDuration = 0L;
            for (int i = 0; i < vibratorInfos.size(); ++i) {
                long duration = this.mEffect.getDuration(vibratorInfos.valueAt(i));
                if (duration == Long.MAX_VALUE || duration < 0L) {
                    return duration;
                }
                maxDuration = Math.max(maxDuration, duration);
            }
            return maxDuration;
        }

        @Override
        public boolean isHapticFeedbackCandidate() {
            return this.mEffect.isHapticFeedbackCandidate();
        }

        @Override
        public void validate() {
            this.mEffect.validate();
        }

        @Override
        public <ParamT> CombinedVibration transform(VibrationEffect.Transformation<ParamT> transformation, ParamT param) {
            VibrationEffect newEffect = transformation.transform(this.mEffect, param);
            if (this.mEffect.equals(newEffect)) {
                return this;
            }
            return CombinedVibration.createParallel(newEffect);
        }

        @Override
        public CombinedVibration adapt(VibratorAdapter adapter) {
            ParallelCombination combination = CombinedVibration.startParallel();
            boolean hasSameEffects = true;
            for (int vibratorId : adapter.getAvailableVibratorIds()) {
                VibrationEffect newEffect = adapter.adaptToVibrator(vibratorId, this.mEffect);
                if (newEffect == null) {
                    return null;
                }
                combination.addVibrator(vibratorId, newEffect);
                hasSameEffects &= this.mEffect.equals(newEffect);
            }
            if (hasSameEffects) {
                return this;
            }
            return combination.combine();
        }

        @Override
        public boolean hasVibrator(int vibratorId) {
            return true;
        }

        @Override
        public boolean hasVendorEffects() {
            if (!Flags.vendorVibrationEffects()) {
                return false;
            }
            return this.mEffect instanceof VibrationEffect.VendorEffect;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Mono)) {
                return false;
            }
            Mono other = (Mono)o;
            return this.mEffect.equals(other.mEffect);
        }

        public int hashCode() {
            return Objects.hash(this.mEffect);
        }

        public String toString() {
            return "Mono{mEffect=" + this.mEffect + '}';
        }

        @Override
        public String toDebugString() {
            return this.mEffect.toDebugString();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel out, int flags) {
            out.writeInt(1);
            this.mEffect.writeToParcel(out, flags);
        }
    }

    public static class ParallelCombination {
        private final SparseArray<VibrationEffect> mEffects = new SparseArray();

        ParallelCombination() {
        }

        @NonNull
        public ParallelCombination addVibrator(int vibratorId, @NonNull VibrationEffect effect) {
            this.mEffects.put(vibratorId, effect);
            return this;
        }

        @NonNull
        public CombinedVibration combine() {
            if (this.mEffects.size() == 0) {
                throw new IllegalStateException("Combination must have at least one element to combine.");
            }
            Stereo combined = new Stereo(this.mEffects);
            ((CombinedVibration)combined).validate();
            return combined;
        }
    }

    public static class SequentialCombination {
        private final ArrayList<CombinedVibration> mEffects = new ArrayList();
        private final ArrayList<Integer> mDelays = new ArrayList();

        SequentialCombination() {
        }

        @NonNull
        public SequentialCombination addNext(int vibratorId, @NonNull VibrationEffect effect) {
            return this.addNext(vibratorId, effect, 0);
        }

        @NonNull
        public SequentialCombination addNext(int vibratorId, @NonNull VibrationEffect effect, int delay) {
            return this.addNext(CombinedVibration.startParallel().addVibrator(vibratorId, effect).combine(), delay);
        }

        @NonNull
        public SequentialCombination addNext(@NonNull CombinedVibration effect) {
            return this.addNext(effect, 0);
        }

        @NonNull
        public SequentialCombination addNext(@NonNull CombinedVibration effect, int delay) {
            if (effect instanceof Sequential) {
                Sequential sequentialEffect = (Sequential)effect;
                int firstEffectIndex = this.mDelays.size();
                this.mEffects.addAll(sequentialEffect.getEffects());
                this.mDelays.addAll(sequentialEffect.getDelays());
                this.mDelays.set(firstEffectIndex, delay + this.mDelays.get(firstEffectIndex));
            } else {
                this.mEffects.add(effect);
                this.mDelays.add(delay);
            }
            return this;
        }

        @NonNull
        public CombinedVibration combine() {
            if (this.mEffects.size() == 0) {
                throw new IllegalStateException("Combination must have at least one element to combine.");
            }
            Sequential combined = new Sequential(this.mEffects, this.mDelays);
            ((CombinedVibration)combined).validate();
            return combined;
        }
    }

    public static class Sequential
    extends CombinedVibration {
        private static final long MAX_HAPTIC_FEEDBACK_SEQUENCE_SIZE = 3L;
        private final List<CombinedVibration> mEffects;
        private final List<Integer> mDelays;
        @NonNull
        public static final Parcelable.Creator<Sequential> CREATOR = new Parcelable.Creator<Sequential>(){

            @Override
            public Sequential createFromParcel(@NonNull Parcel in) {
                in.readInt();
                return new Sequential(in);
            }

            @NonNull
            public Sequential[] newArray(int size) {
                return new Sequential[size];
            }
        };

        Sequential(Parcel in) {
            int size = in.readInt();
            this.mEffects = new ArrayList<CombinedVibration>(size);
            this.mDelays = new ArrayList<Integer>(size);
            for (int i = 0; i < size; ++i) {
                this.mDelays.add(in.readInt());
                this.mEffects.add(CREATOR.createFromParcel(in));
            }
        }

        Sequential(@NonNull List<CombinedVibration> effects, @NonNull List<Integer> delays) {
            this.mEffects = new ArrayList<CombinedVibration>(effects);
            this.mDelays = new ArrayList<Integer>(delays);
        }

        @NonNull
        public List<CombinedVibration> getEffects() {
            return this.mEffects;
        }

        @NonNull
        public List<Integer> getDelays() {
            return this.mDelays;
        }

        @Override
        public long getDuration() {
            return this.getDuration(CombinedVibration::getDuration);
        }

        @Override
        public long getDuration(@Nullable SparseArray<VibratorInfo> vibratorInfos) {
            return this.getDuration((CombinedVibration effect) -> effect.getDuration(vibratorInfos));
        }

        private long getDuration(Function<CombinedVibration, Long> durationFn) {
            boolean hasUnknownStep = false;
            long durations = 0L;
            int effectCount = this.mEffects.size();
            for (int i = 0; i < effectCount; ++i) {
                long duration = durationFn.apply(this.mEffects.get(i));
                if (duration == Long.MAX_VALUE) {
                    return duration;
                }
                durations += duration;
                hasUnknownStep |= duration < 0L;
            }
            if (hasUnknownStep) {
                return -1L;
            }
            long delays = 0L;
            for (int i = 0; i < effectCount; ++i) {
                delays += (long)this.mDelays.get(i).intValue();
            }
            return durations + delays;
        }

        @Override
        public boolean isHapticFeedbackCandidate() {
            int effectCount = this.mEffects.size();
            if ((long)effectCount > 3L) {
                return false;
            }
            for (int i = 0; i < effectCount; ++i) {
                if (this.mEffects.get(i).isHapticFeedbackCandidate()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void validate() {
            int i;
            Preconditions.checkArgument(this.mEffects.size() > 0, "There should be at least one effect set for a combined effect");
            Preconditions.checkArgument(this.mEffects.size() == this.mDelays.size(), "Effect and delays should have equal length");
            int effectCount = this.mEffects.size();
            for (i = 0; i < effectCount; ++i) {
                if (this.mDelays.get(i) >= 0) continue;
                throw new IllegalArgumentException("Delays must all be >= 0 (delays=" + this.mDelays + ")");
            }
            for (i = 0; i < effectCount; ++i) {
                CombinedVibration effect = this.mEffects.get(i);
                if (effect instanceof Sequential) {
                    throw new IllegalArgumentException("There should be no nested sequential effects in a combined effect");
                }
                effect.validate();
            }
        }

        @Override
        public <ParamT> CombinedVibration transform(VibrationEffect.Transformation<ParamT> transformation, ParamT param) {
            SequentialCombination combination = CombinedVibration.startSequential();
            boolean hasSameEffects = true;
            for (int i = 0; i < this.mEffects.size(); ++i) {
                CombinedVibration vibration = this.mEffects.get(i);
                CombinedVibration newVibration = vibration.transform(transformation, param);
                combination.addNext(newVibration, this.mDelays.get(i));
                hasSameEffects &= vibration.equals(newVibration);
            }
            if (hasSameEffects) {
                return this;
            }
            return combination.combine();
        }

        @Override
        public CombinedVibration adapt(VibratorAdapter adapter) {
            SequentialCombination combination = CombinedVibration.startSequential();
            boolean hasSameEffects = true;
            for (int i = 0; i < this.mEffects.size(); ++i) {
                CombinedVibration vibration = this.mEffects.get(i);
                CombinedVibration newVibration = vibration.adapt(adapter);
                combination.addNext(newVibration, this.mDelays.get(i));
                hasSameEffects &= vibration.equals(newVibration);
            }
            if (hasSameEffects) {
                return this;
            }
            return combination.combine();
        }

        @Override
        public boolean hasVibrator(int vibratorId) {
            int effectCount = this.mEffects.size();
            for (int i = 0; i < effectCount; ++i) {
                if (!this.mEffects.get(i).hasVibrator(vibratorId)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasVendorEffects() {
            for (int i = 0; i < this.mEffects.size(); ++i) {
                if (!this.mEffects.get(i).hasVendorEffects()) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Sequential)) {
                return false;
            }
            Sequential other = (Sequential)o;
            return this.mDelays.equals(other.mDelays) && this.mEffects.equals(other.mEffects);
        }

        public int hashCode() {
            return Objects.hash(this.mEffects, this.mDelays);
        }

        public String toString() {
            return "Sequential{mEffects=" + this.mEffects + ", mDelays=" + this.mDelays + '}';
        }

        @Override
        public String toDebugString() {
            StringJoiner sj = new StringJoiner(",", "Sequential{", "}");
            for (int i = 0; i < this.mEffects.size(); ++i) {
                sj.add(String.format(Locale.ROOT, "delayMs=%d, effect=%s", this.mDelays.get(i), this.mEffects.get(i).toDebugString()));
            }
            return ((Object)sj).toString();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel out, int flags) {
            out.writeInt(3);
            out.writeInt(this.mEffects.size());
            for (int i = 0; i < this.mEffects.size(); ++i) {
                out.writeInt(this.mDelays.get(i));
                this.mEffects.get(i).writeToParcel(out, flags);
            }
        }
    }

    public static class Stereo
    extends CombinedVibration {
        private final SparseArray<VibrationEffect> mEffects;
        @NonNull
        public static final Parcelable.Creator<Stereo> CREATOR = new Parcelable.Creator<Stereo>(){

            @Override
            public Stereo createFromParcel(@NonNull Parcel in) {
                in.readInt();
                return new Stereo(in);
            }

            @NonNull
            public Stereo[] newArray(int size) {
                return new Stereo[size];
            }
        };

        Stereo(Parcel in) {
            int size = in.readInt();
            this.mEffects = new SparseArray(size);
            for (int i = 0; i < size; ++i) {
                int vibratorId = in.readInt();
                this.mEffects.put(vibratorId, VibrationEffect.CREATOR.createFromParcel(in));
            }
        }

        Stereo(@NonNull SparseArray<VibrationEffect> effects) {
            this.mEffects = new SparseArray(effects.size());
            for (int i = 0; i < effects.size(); ++i) {
                this.mEffects.put(effects.keyAt(i), effects.valueAt(i));
            }
        }

        @NonNull
        public SparseArray<VibrationEffect> getEffects() {
            return this.mEffects;
        }

        @Override
        public long getDuration() {
            return this.getDuration((Integer idx) -> this.mEffects.valueAt((int)idx).getDuration());
        }

        @Override
        public long getDuration(@Nullable SparseArray<VibratorInfo> vibratorInfos) {
            if (vibratorInfos == null) {
                return this.getDuration();
            }
            return this.getDuration((Integer idx) -> {
                VibrationEffect effect = this.mEffects.valueAt((int)idx);
                VibratorInfo info = (VibratorInfo)vibratorInfos.get(this.mEffects.keyAt((int)idx));
                return effect.getDuration(info);
            });
        }

        private long getDuration(Function<Integer, Long> durationFn) {
            long maxDuration = Long.MIN_VALUE;
            boolean hasUnknownStep = false;
            for (int i = 0; i < this.mEffects.size(); ++i) {
                long duration = durationFn.apply(i);
                if (duration == Long.MAX_VALUE) {
                    return duration;
                }
                maxDuration = Math.max(maxDuration, duration);
                hasUnknownStep |= duration < 0L;
            }
            if (hasUnknownStep) {
                return -1L;
            }
            return maxDuration;
        }

        @Override
        public boolean isHapticFeedbackCandidate() {
            for (int i = 0; i < this.mEffects.size(); ++i) {
                if (this.mEffects.valueAt(i).isHapticFeedbackCandidate()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void validate() {
            Preconditions.checkArgument(this.mEffects.size() > 0, "There should be at least one effect set for a combined effect");
            for (int i = 0; i < this.mEffects.size(); ++i) {
                this.mEffects.valueAt(i).validate();
            }
        }

        @Override
        public <ParamT> CombinedVibration transform(VibrationEffect.Transformation<ParamT> transformation, ParamT param) {
            ParallelCombination combination = CombinedVibration.startParallel();
            boolean hasSameEffects = true;
            for (int i = 0; i < this.mEffects.size(); ++i) {
                int vibratorId = this.mEffects.keyAt(i);
                VibrationEffect effect = this.mEffects.valueAt(i);
                VibrationEffect newEffect = transformation.transform(effect, param);
                combination.addVibrator(vibratorId, newEffect);
                hasSameEffects &= effect.equals(newEffect);
            }
            if (hasSameEffects) {
                return this;
            }
            return combination.combine();
        }

        @Override
        public CombinedVibration adapt(VibratorAdapter adapter) {
            ParallelCombination combination = CombinedVibration.startParallel();
            boolean hasSameEffects = true;
            for (int i = 0; i < this.mEffects.size(); ++i) {
                VibrationEffect effect;
                int vibratorId = this.mEffects.keyAt(i);
                VibrationEffect newEffect = adapter.adaptToVibrator(vibratorId, effect = this.mEffects.valueAt(i));
                if (newEffect == null) {
                    return null;
                }
                combination.addVibrator(vibratorId, newEffect);
                hasSameEffects &= effect.equals(newEffect);
            }
            if (hasSameEffects) {
                return this;
            }
            return combination.combine();
        }

        @Override
        public boolean hasVibrator(int vibratorId) {
            return this.mEffects.indexOfKey(vibratorId) >= 0;
        }

        @Override
        public boolean hasVendorEffects() {
            if (!Flags.vendorVibrationEffects()) {
                return false;
            }
            for (int i = 0; i < this.mEffects.size(); ++i) {
                if (!(this.mEffects.get(i) instanceof VibrationEffect.VendorEffect)) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Stereo)) {
                return false;
            }
            Stereo other = (Stereo)o;
            if (this.mEffects.size() != other.mEffects.size()) {
                return false;
            }
            for (int i = 0; i < this.mEffects.size(); ++i) {
                if (this.mEffects.valueAt(i).equals(other.mEffects.get(this.mEffects.keyAt(i)))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.mEffects.contentHashCode();
        }

        public String toString() {
            return "Stereo{mEffects=" + this.mEffects + '}';
        }

        @Override
        public String toDebugString() {
            StringJoiner sj = new StringJoiner(",", "Stereo{", "}");
            for (int i = 0; i < this.mEffects.size(); ++i) {
                sj.add(String.format(Locale.ROOT, "vibrator(id=%d): %s", this.mEffects.keyAt(i), this.mEffects.valueAt(i).toDebugString()));
            }
            return ((Object)sj).toString();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel out, int flags) {
            out.writeInt(2);
            out.writeInt(this.mEffects.size());
            for (int i = 0; i < this.mEffects.size(); ++i) {
                out.writeInt(this.mEffects.keyAt(i));
                this.mEffects.valueAt(i).writeToParcel(out, flags);
            }
        }
    }

    public static interface VibratorAdapter {
        public int[] getAvailableVibratorIds();

        public VibrationEffect adaptToVibrator(int var1, @NonNull VibrationEffect var2);
    }
}

