/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.IBinder;
import android.os.ServiceManager;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class BluetoothServiceManager {
    public static final String BLUETOOTH_MANAGER_SERVICE = "bluetooth_manager";

    @NonNull
    public ServiceRegisterer getBluetoothManagerServiceRegisterer() {
        return new ServiceRegisterer(BLUETOOTH_MANAGER_SERVICE);
    }

    public static class ServiceRegisterer {
        private final String mServiceName;

        public ServiceRegisterer(String serviceName) {
            this.mServiceName = serviceName;
        }

        public void register(@NonNull IBinder service) {
            ServiceManager.addService(this.mServiceName, service);
        }

        @Nullable
        public IBinder get() {
            return ServiceManager.getService(this.mServiceName);
        }

        @NonNull
        public IBinder getOrThrow() throws ServiceNotFoundException {
            try {
                return ServiceManager.getServiceOrThrow(this.mServiceName);
            }
            catch (ServiceManager.ServiceNotFoundException e) {
                throw new ServiceNotFoundException(this.mServiceName);
            }
        }

        @Nullable
        public IBinder tryGet() {
            return ServiceManager.checkService(this.mServiceName);
        }
    }

    public static class ServiceNotFoundException
    extends ServiceManager.ServiceNotFoundException {
        public ServiceNotFoundException(@NonNull String name) {
            super(name);
        }
    }
}

