/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.FlaggedApi;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.os.BatteryProperty;
import android.os.IBatteryPropertiesRegistrar;
import android.os.RemoteException;
import android.os.ServiceManager;
import com.android.internal.app.IBatteryStats;

public class BatteryManager {
    public static final String EXTRA_STATUS = "status";
    public static final String EXTRA_HEALTH = "health";
    public static final String EXTRA_PRESENT = "present";
    public static final String EXTRA_LEVEL = "level";
    public static final String EXTRA_BATTERY_LOW = "battery_low";
    public static final String EXTRA_SCALE = "scale";
    public static final String EXTRA_ICON_SMALL = "icon-small";
    public static final String EXTRA_PLUGGED = "plugged";
    public static final String EXTRA_VOLTAGE = "voltage";
    public static final String EXTRA_TEMPERATURE = "temperature";
    public static final String EXTRA_TECHNOLOGY = "technology";
    @UnsupportedAppUsage
    public static final String EXTRA_INVALID_CHARGER = "invalid_charger";
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final String EXTRA_MAX_CHARGING_CURRENT = "max_charging_current";
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final String EXTRA_MAX_CHARGING_VOLTAGE = "max_charging_voltage";
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final String EXTRA_CHARGE_COUNTER = "charge_counter";
    public static final String EXTRA_SEQUENCE = "seq";
    public static final String EXTRA_CYCLE_COUNT = "android.os.extra.CYCLE_COUNT";
    public static final String EXTRA_CHARGING_STATUS = "android.os.extra.CHARGING_STATUS";
    @FlaggedApi(value="android.os.battery_part_status_api")
    public static final int BATTERY_CAPACITY_LEVEL_UNSUPPORTED = -1;
    @FlaggedApi(value="android.os.battery_part_status_api")
    public static final int BATTERY_CAPACITY_LEVEL_UNKNOWN = 0;
    @FlaggedApi(value="android.os.battery_part_status_api")
    public static final int BATTERY_CAPACITY_LEVEL_CRITICAL = 1;
    @FlaggedApi(value="android.os.battery_part_status_api")
    public static final int BATTERY_CAPACITY_LEVEL_LOW = 2;
    @FlaggedApi(value="android.os.battery_part_status_api")
    public static final int BATTERY_CAPACITY_LEVEL_NORMAL = 3;
    @FlaggedApi(value="android.os.battery_part_status_api")
    public static final int BATTERY_CAPACITY_LEVEL_HIGH = 4;
    @FlaggedApi(value="android.os.battery_part_status_api")
    public static final int BATTERY_CAPACITY_LEVEL_FULL = 5;
    @FlaggedApi(value="android.os.battery_part_status_api")
    public static final String EXTRA_CAPACITY_LEVEL = "android.os.extra.CAPACITY_LEVEL";
    @SystemApi
    public static final String EXTRA_EVENTS = "android.os.extra.EVENTS";
    @SystemApi
    public static final String EXTRA_EVENT_TIMESTAMP = "android.os.extra.EVENT_TIMESTAMP";
    public static final int BATTERY_STATUS_UNKNOWN = 1;
    public static final int BATTERY_STATUS_CHARGING = 2;
    public static final int BATTERY_STATUS_DISCHARGING = 3;
    public static final int BATTERY_STATUS_NOT_CHARGING = 4;
    public static final int BATTERY_STATUS_FULL = 5;
    public static final int BATTERY_HEALTH_UNKNOWN = 1;
    public static final int BATTERY_HEALTH_GOOD = 2;
    public static final int BATTERY_HEALTH_OVERHEAT = 3;
    public static final int BATTERY_HEALTH_DEAD = 4;
    public static final int BATTERY_HEALTH_OVER_VOLTAGE = 5;
    public static final int BATTERY_HEALTH_UNSPECIFIED_FAILURE = 6;
    public static final int BATTERY_HEALTH_COLD = 7;
    public static final int BATTERY_PLUGGED_AC = 1;
    public static final int BATTERY_PLUGGED_USB = 2;
    public static final int BATTERY_PLUGGED_WIRELESS = 4;
    public static final int BATTERY_PLUGGED_DOCK = 8;
    @SystemApi
    public static final int CHARGING_POLICY_DEFAULT = 1;
    @SystemApi
    public static final int CHARGING_POLICY_ADAPTIVE_AON = 2;
    @SystemApi
    public static final int CHARGING_POLICY_ADAPTIVE_AC = 3;
    @SystemApi
    public static final int CHARGING_POLICY_ADAPTIVE_LONGLIFE = 4;
    @SystemApi
    @FlaggedApi(value="android.os.battery_part_status_api")
    public static final int PART_STATUS_UNSUPPORTED = 0;
    @SystemApi
    @FlaggedApi(value="android.os.battery_part_status_api")
    public static final int PART_STATUS_ORIGINAL = 1;
    @SystemApi
    @FlaggedApi(value="android.os.battery_part_status_api")
    public static final int PART_STATUS_REPLACED = 2;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int BATTERY_PLUGGED_ANY = 15;
    public static final String ACTION_CHARGING = "android.os.action.CHARGING";
    public static final String ACTION_DISCHARGING = "android.os.action.DISCHARGING";
    public static final int BATTERY_PROPERTY_CHARGE_COUNTER = 1;
    public static final int BATTERY_PROPERTY_CURRENT_NOW = 2;
    public static final int BATTERY_PROPERTY_CURRENT_AVERAGE = 3;
    public static final int BATTERY_PROPERTY_CAPACITY = 4;
    public static final int BATTERY_PROPERTY_ENERGY_COUNTER = 5;
    public static final int BATTERY_PROPERTY_STATUS = 6;
    @SystemApi
    @RequiresPermission(value="android.permission.BATTERY_STATS")
    public static final int BATTERY_PROPERTY_MANUFACTURING_DATE = 7;
    @SystemApi
    @RequiresPermission(value="android.permission.BATTERY_STATS")
    public static final int BATTERY_PROPERTY_FIRST_USAGE_DATE = 8;
    @SystemApi
    @RequiresPermission(value="android.permission.BATTERY_STATS")
    public static final int BATTERY_PROPERTY_CHARGING_POLICY = 9;
    @FlaggedApi(value="android.os.state_of_health_public")
    public static final int BATTERY_PROPERTY_STATE_OF_HEALTH = 10;
    @SystemApi
    @RequiresPermission(value="android.permission.BATTERY_STATS")
    @FlaggedApi(value="android.os.battery_part_status_api")
    public static final int BATTERY_PROPERTY_SERIAL_NUMBER = 11;
    @SystemApi
    @RequiresPermission(value="android.permission.BATTERY_STATS")
    @FlaggedApi(value="android.os.battery_part_status_api")
    public static final int BATTERY_PROPERTY_PART_STATUS = 12;
    private final Context mContext;
    private final IBatteryStats mBatteryStats;
    private final IBatteryPropertiesRegistrar mBatteryPropertiesRegistrar;

    public static boolean isAdaptiveChargingPolicy(int policy) {
        return policy == 3 || policy == 2 || policy == 4;
    }

    public BatteryManager() {
        this.mContext = null;
        this.mBatteryStats = IBatteryStats.Stub.asInterface(ServiceManager.getService("batterystats"));
        this.mBatteryPropertiesRegistrar = IBatteryPropertiesRegistrar.Stub.asInterface(ServiceManager.getService("batteryproperties"));
    }

    public BatteryManager(Context context, IBatteryStats batteryStats, IBatteryPropertiesRegistrar batteryPropertiesRegistrar) {
        this.mContext = context;
        this.mBatteryStats = batteryStats;
        this.mBatteryPropertiesRegistrar = batteryPropertiesRegistrar;
    }

    public boolean isCharging() {
        try {
            return this.mBatteryStats.isCharging();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private long queryProperty(int id2) {
        long ret;
        if (this.mBatteryPropertiesRegistrar == null) {
            return Long.MIN_VALUE;
        }
        try {
            BatteryProperty prop = new BatteryProperty();
            ret = this.mBatteryPropertiesRegistrar.getProperty(id2, prop) == 0 ? prop.getLong() : Long.MIN_VALUE;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return ret;
    }

    private String queryStringProperty(int id2) {
        if (this.mBatteryPropertiesRegistrar == null) {
            return null;
        }
        try {
            BatteryProperty prop = new BatteryProperty();
            if (this.mBatteryPropertiesRegistrar.getProperty(id2, prop) == 0) {
                return prop.getString();
            }
            return null;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getIntProperty(int id2) {
        long value = this.queryProperty(id2);
        if (value == Long.MIN_VALUE && this.mContext != null && this.mContext.getApplicationInfo().targetSdkVersion >= 28) {
            return Integer.MIN_VALUE;
        }
        return (int)value;
    }

    public long getLongProperty(int id2) {
        return this.queryProperty(id2);
    }

    @Nullable
    @FlaggedApi(value="android.os.battery_part_status_api")
    public String getStringProperty(int id2) {
        return this.queryStringProperty(id2);
    }

    public static boolean isPlugWired(int plugType) {
        return plugType == 2 || plugType == 1;
    }

    public long computeChargeTimeRemaining() {
        try {
            return this.mBatteryStats.computeChargeTimeRemaining();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.POWER_SAVER")
    public boolean setChargingStateUpdateDelayMillis(int delayMillis) {
        try {
            return this.mBatteryStats.setChargingStateUpdateDelayMillis(delayMillis);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

