/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.annotation.FlaggedApi;
import android.annotation.SystemApi;
import android.nfc.NfcRoutingTableEntry;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SystemApi
@FlaggedApi(value="android.nfc.nfc_oem_extension")
public class RoutingTableProtocolEntry
extends NfcRoutingTableEntry {
    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    public static final int PROTOCOL_UNDETERMINED = 0;
    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    public static final int PROTOCOL_T1T = 1;
    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    public static final int PROTOCOL_T2T = 2;
    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    public static final int PROTOCOL_T3T = 3;
    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    public static final int PROTOCOL_ISO_DEP = 4;
    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    public static final int PROTOCOL_NFC_DEP = 5;
    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    public static final int PROTOCOL_T5T = 6;
    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    public static final int PROTOCOL_NDEF = 7;
    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    public static final int PROTOCOL_UNSUPPORTED = -1;
    private final int mValue;

    public RoutingTableProtocolEntry(int nfceeId, int value, int routeType) {
        super(nfceeId, 1, routeType);
        this.mValue = value;
    }

    @FlaggedApi(value="android.nfc.nfc_oem_extension")
    public int getProtocol() {
        return this.mValue;
    }

    public static int protocolStringToInt(String protocolString) {
        int n;
        switch (protocolString) {
            case "PROTOCOL_T1T": {
                n = 1;
                break;
            }
            case "PROTOCOL_T2T": {
                n = 2;
                break;
            }
            case "PROTOCOL_T3T": {
                n = 3;
                break;
            }
            case "PROTOCOL_ISO_DEP": {
                n = 4;
                break;
            }
            case "PROTOCOL_NFC_DEP": {
                n = 5;
                break;
            }
            case "PROTOCOL_T5T": {
                n = 6;
                break;
            }
            case "PROTOCOL_NDEF": {
                n = 7;
                break;
            }
            case "PROTOCOL_UNDETERMINED": {
                n = 0;
                break;
            }
            default: {
                n = -1;
            }
        }
        return n;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProtocolValue {
    }
}

